/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.converter;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.exceptions.BaseIOException;
import com.sap.engine.services.deploy.exceptions.BaseWrongStructureException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ApplicationDocument {
    public static final String APPLICATION_TRANSACTION = "Application";
    public static final String CONTAINER_TRANSACTION = "Container";
    protected Document mainDocument;
    protected Element docElement;
    protected Element clients;
    protected ClassLoader loader;

    public ApplicationClientDescriptor parseXml(BufferedInputStream xmlStream, String xmlName) throws BaseWrongStructureException, BaseIOException, DeploymentException {
        Document document = null;
        try {
            StandardDOMParser domParser = new StandardDOMParser();
            domParser.setSystemId(xmlName);
            document = domParser.parse((InputStream)xmlStream);
            xmlStream.close();
        }
        catch (IOException ioe) {
            throw new BaseIOException("deploy_4404", new String[]{"application client"}, (Throwable)ioe);
        }
        catch (SAXException sax) {
            throw new DeploymentException("deploy_4404", new String[]{"application client"}, sax);
        }
        return this.loadDescriptor(document);
    }

    public Element getDocElement() {
        return this.docElement;
    }

    public Element getClientsElement() {
        return this.clients;
    }

    public void setLoader(ClassLoader _loader) {
        this.loader = _loader;
    }

    public void init() {
        this.mainDocument = StandardDOMParser.createDocument();
        this.clients = this.mainDocument.createElement("application-client");
        this.mainDocument.appendChild(this.clients);
    }

    public ApplicationClientDescriptor loadDescriptor(Document doc) throws BaseWrongStructureException {
        Element elm = doc.getDocumentElement();
        return this.loadApplicationDescriptor(elm);
    }

    public ApplicationClientDescriptor loadApplicationDescriptor(Element element) throws BaseWrongStructureException {
        if (!element.getNodeName().equals("application-client")) {
            throw new BaseWrongStructureException("deploy_4101", new String[]{"application-client", element.getNodeName()});
        }
        ApplicationClientDescriptor descriptor = new ApplicationClientDescriptor();
        NodeList list = element.getChildNodes();
        if (list != null) {
            ArrayObject envEntries = new ArrayObject();
            ArrayObject ejbRefs = new ArrayObject();
            ArrayObject resRefs = new ArrayObject();
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeType() == 1) {
                    Element el = (Element)list.item(i);
                    String tag = el.getNodeName();
                    Element parent = (Element)el.getParentNode();
                    String parentTag = parent.getNodeName();
                    if (tag.equals("description") && parentTag.equals("application-client")) {
                        String description = this.getTextValue(el);
                        if (!description.equals("")) {
                            descriptor.setDescription(description);
                        }
                    } else if (tag.equals("display-name")) {
                        String displayName = this.getTextValue(el);
                        if (!displayName.equals("")) {
                            descriptor.setDisplayName(displayName);
                        }
                    } else if (tag.equals("icon") && parentTag.equals("application-client")) {
                        this.getIcons(el, descriptor);
                    } else if (tag.equals("env-entry")) {
                        EnvironmentEntry envEntry = this.getEnvEntry(el);
                        if (envEntry != null) {
                            envEntries.addElement(envEntry);
                        }
                    } else if (tag.equals("ejb-ref")) {
                        EJBeanReference ejbRef = this.getEjbRef(el);
                        if (ejbRef != null) {
                            ejbRefs.addElement(ejbRef);
                        }
                    } else if (tag.equals("resource-ref")) {
                        ResourceReference resRef = this.getResourceRef(el);
                        if (resRef != null) {
                            resRefs.addElement(resRef);
                        }
                    } else {
                        throw new BaseWrongStructureException("deploy_4103", new String[]{tag});
                    }
                }
                ++i;
            }
            if (envEntries.size() != 0) {
                Object[] entries = new EnvironmentEntry[envEntries.size()];
                envEntries.copyInto(entries);
                descriptor.setEnvironmentProperties((EnvironmentEntry[])entries);
            }
            if (ejbRefs.size() != 0) {
                Object[] EJBeanRefs = new EJBeanReference[ejbRefs.size()];
                ejbRefs.copyInto(EJBeanRefs);
                descriptor.setEJBeanReferences((EJBeanReference[])EJBeanRefs);
            }
            if (resRefs.size() != 0) {
                Object[] resourceRefs = new ResourceReference[resRefs.size()];
                resRefs.copyInto(resourceRefs);
                descriptor.setResourceReferences((ResourceReference[])resourceRefs);
            }
        }
        return descriptor;
    }

    protected String processString(String str, boolean saving) {
        char separator = File.separatorChar;
        String str2 = "";
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (saving) {
                if (ch == separator) {
                    ch = '\\';
                }
            } else if (ch == '\\') {
                ch = separator;
            }
            str2 = str2 + ch;
            ++i;
        }
        return str2;
    }

    private Element getFirstElement(Element parent) {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i) instanceof Element) {
                return (Element)list.item(i);
            }
            ++i;
        }
        return null;
    }

    protected String getTextValue(Element element) {
        if (element == null) {
            return new String();
        }
        Node node = element.getFirstChild();
        if (node != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
            String value = node.getNodeValue();
            return value.trim();
        }
        return new String("");
    }

    protected void getIcons(Element elmnt, ApplicationClientDescriptor descriptor) throws BaseWrongStructureException {
        NodeList entryList = elmnt.getChildNodes();
        if (entryList != null) {
            int k = 0;
            while (k < entryList.getLength()) {
                if (entryList.item(k).getNodeType() == 1) {
                    Element el = (Element)entryList.item(k);
                    String tag = el.getNodeName();
                    if (tag.equals("small-icon")) {
                        String smallIcon = this.getTextValue(el);
                        if (!smallIcon.equals("")) {
                            String smallIconPr = this.processString(smallIcon, false);
                            descriptor.setSmallIcon(new SerializableFile(smallIconPr));
                        }
                    } else if (tag.equals("large-icon")) {
                        String largeIcon = this.getTextValue(el);
                        if (!largeIcon.equals("")) {
                            String largeIconPr = this.processString(largeIcon, false);
                            descriptor.setLargeIcon(new SerializableFile(largeIconPr));
                        }
                    } else {
                        throw new BaseWrongStructureException("deploy_4103", new String[]{tag});
                    }
                }
                ++k;
            }
        }
    }

    protected EnvironmentEntry getEnvEntry(Element elmnt) {
        NodeList entryList = elmnt.getChildNodes();
        if (entryList != null) {
            EnvironmentEntry envEntry = new EnvironmentEntry();
            String entryType = new String("");
            int k = 0;
            while (k < entryList.getLength()) {
                if (entryList.item(k).getNodeType() == 1) {
                    String entryValueStr;
                    Element envEl = (Element)entryList.item(k);
                    String envTag = envEl.getNodeName();
                    if (envTag.equals("description")) {
                        String description = this.getTextValue(envEl);
                        if (!description.equals("")) {
                            envEntry.setEntryDescription(description);
                        }
                    } else if (envTag.equals("env-entry-name")) {
                        String entryName = this.getTextValue(envEl);
                        if (!entryName.equals("")) {
                            envEntry.setEntryName(entryName);
                        }
                    } else if (envTag.equals("env-entry-type")) {
                        entryType = this.getTextValue(envEl);
                        if (!entryType.equals("")) {
                            envEntry.setEntryType(entryType);
                        }
                    } else if (envTag.equals("env-entry-value") && !(entryValueStr = this.getTextValue(envEl)).equals("")) {
                        Object entryValue;
                        if (entryType.equals("java.lang.Double")) {
                            entryValue = new Double(entryValueStr);
                            envEntry.setEntryValue(entryValue);
                        }
                        if (entryType.equals("java.lang.Integer")) {
                            entryValue = new Integer(entryValueStr);
                            envEntry.setEntryValue(entryValue);
                        }
                        if (entryType.equals("java.lang.Boolean")) {
                            entryValue = new Boolean(entryValueStr);
                            envEntry.setEntryValue(entryValue);
                        }
                        if (entryType.equals("java.lang.Float")) {
                            entryValue = new Float(entryValueStr);
                            envEntry.setEntryValue(entryValue);
                        }
                        if (entryType.equals("java.lang.String")) {
                            entryValue = entryValueStr;
                            envEntry.setEntryValue(entryValue);
                        }
                    }
                }
                ++k;
            }
            return envEntry;
        }
        return null;
    }

    protected EJBeanReference getEjbRef(Element elmnt) {
        NodeList refsList = elmnt.getChildNodes();
        if (refsList != null) {
            EJBeanReference ejbRef = new EJBeanReference();
            int k = 0;
            while (k < refsList.getLength()) {
                if (refsList.item(k).getNodeType() == 1) {
                    String link;
                    Element nextEl = (Element)refsList.item(k);
                    String nextElTag = nextEl.getNodeName();
                    if (nextElTag.equals("description")) {
                        String description = this.getTextValue(nextEl);
                        if (!description.equals("")) {
                            ejbRef.setReferenceDescription(description);
                        }
                    } else if (nextElTag.equals("ejb-ref-name")) {
                        String name = this.getTextValue(nextEl);
                        if (!name.equals("")) {
                            ejbRef.setReferenceName(name);
                        }
                    } else if (nextElTag.equals("ejb-ref-type")) {
                        String type = this.getTextValue(nextEl);
                        if (type.equals("Entity")) {
                            ejbRef.setType(1);
                        } else if (type.equals("Session")) {
                            ejbRef.setType(0);
                        }
                    } else if (nextElTag.equals("home")) {
                        String home = this.getTextValue(nextEl);
                        if (!home.equals("")) {
                            ejbRef.setHomeInterfaceName(home);
                        }
                    } else if (nextElTag.equals("remote")) {
                        String remote = this.getTextValue(nextEl);
                        if (!remote.equals("")) {
                            ejbRef.setRemoteInterfaceName(remote);
                        }
                    } else if (nextElTag.equals("ejb-link") && !(link = this.getTextValue(nextEl)).equals("")) {
                        ejbRef.setReferenceEjbLink(link);
                    }
                }
                ++k;
            }
            return ejbRef;
        }
        return null;
    }

    protected ResourceReference getResourceRef(Element elmnt) {
        NodeList resList = elmnt.getChildNodes();
        if (resList != null) {
            ResourceReference resRef = new ResourceReference();
            int k = 0;
            while (k < resList.getLength()) {
                if (resList.item(k).getNodeType() == 1) {
                    String link;
                    Element nextEl = (Element)resList.item(k);
                    String nextElTag = nextEl.getNodeName();
                    if (nextElTag.equals("description")) {
                        String description = this.getTextValue(nextEl);
                        if (!description.equals("")) {
                            resRef.setResourceDescription(description);
                        }
                    } else if (nextElTag.equals("res-ref-name")) {
                        String name = this.getTextValue(nextEl);
                        if (!name.equals("")) {
                            resRef.setResourceName(name);
                        }
                    } else if (nextElTag.equals("res-type")) {
                        String type = this.getTextValue(nextEl);
                        if (!type.equals("")) {
                            resRef.setResourceType(type);
                        }
                    } else if (nextElTag.equals("res-auth")) {
                        String authStr = this.getTextValue(nextEl);
                        if (authStr.equals(APPLICATION_TRANSACTION)) {
                            resRef.setResourceAuthorization(3);
                        } else if (authStr.equals(CONTAINER_TRANSACTION)) {
                            resRef.setResourceAuthorization(2);
                        }
                    } else if (nextElTag.equals("res-link") && !(link = this.getTextValue(nextEl)).equals("")) {
                        resRef.setResourceLink(link);
                    }
                }
                ++k;
            }
            return resRef;
        }
        return null;
    }
}

