/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.container;

import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarComparator {
    protected Vector changedEntries = new Vector();
    protected Vector newEntries = new Vector();
    protected Vector deletedEntries = new Vector();
    protected ZipFile[] newJars;
    protected ZipFile oldJar;

    public JarComparator(ZipFile newJar, ZipFile oldJar) {
        this.newJars = new ZipFile[1];
        this.newJars[0] = newJar;
        this.oldJar = oldJar;
        this.compare();
    }

    public JarComparator(ZipFile[] newJars, ZipFile oldJar) {
        this.newJars = newJars;
        this.oldJar = oldJar;
        this.compare();
    }

    private void compare() {
        this.initDeletedEntries();
        int i = 0;
        while (i < this.newJars.length) {
            Enumeration<? extends ZipEntry> enumeration = this.newJars[i].entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry entry1 = enumeration.nextElement();
                if (entry1.isDirectory()) continue;
                ZipEntry entry2 = this.oldJar.getEntry(entry1.getName());
                if (entry2 != null) {
                    if (entry1.getSize() != entry2.getSize() || entry1.getCrc() != entry2.getCrc()) {
                        this.changedEntries.add(entry1.getName());
                    }
                    this.deletedEntries.remove(entry2.getName());
                    continue;
                }
                this.newEntries.add(entry1.getName());
            }
            ++i;
        }
    }

    public boolean equalJars() {
        return this.changedEntries.size() == 0 && this.newEntries.size() == 0 && this.deletedEntries.size() == 0;
    }

    private void initDeletedEntries() {
        Enumeration<? extends ZipEntry> enumeration = this.oldJar.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            if (entry.isDirectory()) continue;
            this.deletedEntries.add(entry.getName());
        }
    }

    public String[] getChangedEntries() {
        return this.convertVectorToArray(this.changedEntries);
    }

    public Vector getChangedEntriesAsVector() {
        return this.changedEntries;
    }

    public String[] getNewEntries() {
        return this.convertVectorToArray(this.newEntries);
    }

    public Vector getNewEntriesAsVector() {
        return this.newEntries;
    }

    public String[] getDeletedEntries() {
        return this.convertVectorToArray(this.deletedEntries);
    }

    public Vector getDeletedEntriesAsVector() {
        return this.deletedEntries;
    }

    private String[] convertVectorToArray(Vector entries) {
        String[] res = new String[entries.size()];
        entries.toArray(res);
        return res;
    }
}

