/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.container;

import com.sap.engine.services.deploy.container.ExportInfo;
import com.sap.engine.services.deploy.ear.common.ContextParam;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import java.util.Enumeration;
import java.util.Hashtable;

public class ExportDescriptor {
    private String applicationName = null;
    private ExportInfo info = null;
    private Hashtable components = new Hashtable();

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applName) {
        this.applicationName = applName;
    }

    public ExportInfo[] getComponents() {
        ExportInfo[] infos = new ExportInfo[this.components.size()];
        int i = 0;
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            infos[i] = (ExportInfo)enumeration.nextElement();
            ++i;
        }
        return infos;
    }

    public String[] getComponentNames() {
        String[] names = new String[this.components.size()];
        int i = 0;
        Enumeration enumeration = this.components.keys();
        while (enumeration.hasMoreElements()) {
            names[i] = (String)enumeration.nextElement();
            ++i;
        }
        return names;
    }

    public ExportInfo getComponent(String compName) {
        return (ExportInfo)this.components.get(compName);
    }

    public byte getComponentType(String compName) {
        this.info = (ExportInfo)this.components.get(compName);
        return this.info.getType();
    }

    public EnvironmentEntry[] getEnvironmentEntries(String compName) {
        this.info = (ExportInfo)this.components.get(compName);
        return this.info.getEnvironmentEntries();
    }

    public ResourceReference[] getResourceReferences(String compName) {
        this.info = (ExportInfo)this.components.get(compName);
        return this.info.getResourceReferences();
    }

    public EJBeanReference[] getEJBeanReferences(String compName) {
        this.info = (ExportInfo)this.components.get(compName);
        return this.info.getEJBeanReferences();
    }

    public SecurityRoles[] getSecurityRoles(String compName) {
        this.info = (ExportInfo)this.components.get(compName);
        return this.info.getSecurityRoles();
    }

    public ContextParam[] getContextParams(String compName) {
        this.info = (ExportInfo)this.components.get(compName);
        if (this.info.getType() == 2) {
            return this.info.getContextParams();
        }
        return null;
    }

    public void addComponent(ExportInfo info) {
        if (info == null) {
            return;
        }
        if (this.components == null) {
            this.components = new Hashtable();
        }
        this.components.put(info.getComponentName(), info);
    }

    public void setComponents(ExportInfo[] infos) {
        if (infos == null || infos.length == 0) {
            return;
        }
        int i = 0;
        while (i < infos.length) {
            this.addComponent(infos[i]);
            ++i;
        }
    }

    public void setComponentType(String compName, byte compType) {
        this.info = (ExportInfo)this.components.get(compName);
        this.info.setType(compType);
    }

    public void setEnvironmentEntries(String compName, EnvironmentEntry[] envEntries) {
        this.info = (ExportInfo)this.components.get(compName);
        this.info.setEnvironmentEntries(envEntries);
    }

    public void setResourceReferences(String compName, ResourceReference[] resRefs) {
        this.info = (ExportInfo)this.components.get(compName);
        this.info.setResourceReferences(resRefs);
    }

    public void setEJBeanReferences(String compName, EJBeanReference[] ejbRefs) {
        this.info = (ExportInfo)this.components.get(compName);
        this.info.setEJBeanReferences(ejbRefs);
    }

    public void setSecurityRoles(String compName, SecurityRoles[] secRoles) {
        this.info = (ExportInfo)this.components.get(compName);
        this.info.setSecurityRoles(secRoles);
    }

    public void setContextParams(String compName, ContextParam[] contParams) {
        this.info = (ExportInfo)this.components.get(compName);
        if (this.info.getType() == 2) {
            this.info.setContextParams(contParams);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ExportDescriptor)) {
            return false;
        }
        ExportDescriptor temp = (ExportDescriptor)obj;
        if (!this.compareStrings(this.applicationName, temp.applicationName)) {
            return false;
        }
        return this.compareComponents(this.getComponents(), temp.getComponents());
    }

    private boolean compareStrings(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    private boolean compareComponents(ExportInfo[] infos1, ExportInfo[] infos2) {
        if (infos1.length != infos2.length) {
            return false;
        }
        if (infos1.length == 0) {
            return true;
        }
        int i = 0;
        while (i < infos1.length) {
            if (infos1[i] != null || infos2[i] != null) {
                if (infos1[i] == null || infos2[i] == null) {
                    return false;
                }
                if (!infos1[i].equals(infos2[i])) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

