/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.container;

import com.sap.engine.services.deploy.ear.exceptions.BaseIllegalArgumentException;
import java.io.Serializable;

public class AdditionalAppInfo
implements Serializable {
    static final long serialVersionUID = 3529569501964019741L;
    public static final String STR_STARTUP_MANUAL = "manual";
    public static final String STR_STARTUP_LAZY = "lazy";
    public static final String STR_STARTUP_ALWAYS = "always";
    public static final int STARTUP_MANUAL = 1;
    public static final int STARTUP_LAZY = 2;
    public static final int STARTUP_ALWAYS = 3;
    public static final int STARTUP_DEFAULT = 2;
    protected int startUp = 2;
    public static final String FAIL_OVER_DISABLE = "disable";
    public static final String FAIL_OVER_ON_REQUEST = "on_request";
    public static final String FAIL_OVER_ON_ATTRIBUTE = "on_attribute";
    public static final int INT_FAIL_OVER_DISABLE = 0;
    public static final int INT_FAIL_OVER_ON_REQUEST = 1;
    public static final int INT_FAIL_OVER_ON_ATTRIBUTE = 2;
    protected String failOverValue = "disable";
    protected int intFailOver = 0;

    public void setStartUp(int val) {
        this.startUp = val;
    }

    public void setStartUpValue(String val) throws BaseIllegalArgumentException {
        if (val.compareTo(STR_STARTUP_ALWAYS) == 0) {
            this.startUp = 3;
        } else if (val.compareTo(STR_STARTUP_LAZY) == 0) {
            this.startUp = 2;
        } else if (val.compareTo(STR_STARTUP_MANUAL) == 0) {
            this.startUp = 1;
        } else {
            if (val.length() > 0) {
                throw new BaseIllegalArgumentException("deploy_5096", "manual,lazy,always");
            }
            this.startUp = 2;
        }
    }

    public static String getStartUpString(int intStartUp) {
        switch (intStartUp) {
            case 3: {
                return STR_STARTUP_ALWAYS;
            }
            case 1: {
                return STR_STARTUP_MANUAL;
            }
            case 2: {
                return STR_STARTUP_LAZY;
            }
        }
        return "";
    }

    public int getStartUp() {
        return this.startUp;
    }

    public boolean isFailOverEnable() {
        return this.intFailOver > 0;
    }

    public void setFailOverEnable(boolean failOverEnable) {
        this.failOverValue = failOverEnable ? FAIL_OVER_ON_REQUEST : FAIL_OVER_DISABLE;
    }

    public void setFailOverValue(String value) throws BaseIllegalArgumentException {
        if (value == null || value.trim().equals("")) {
            return;
        }
        if (!(FAIL_OVER_DISABLE.equals(value) || FAIL_OVER_ON_REQUEST.equals(value) || FAIL_OVER_ON_ATTRIBUTE.equals(value))) {
            throw new BaseIllegalArgumentException("deploy_5083");
        }
        this.failOverValue = value;
        if (FAIL_OVER_DISABLE.equals(value)) {
            this.intFailOver = 0;
        } else if (FAIL_OVER_ON_REQUEST.equals(value)) {
            this.intFailOver = 1;
        } else if (FAIL_OVER_ON_ATTRIBUTE.equals(value)) {
            this.intFailOver = 2;
        }
    }

    public void setFailOverIntValue(int value) throws BaseIllegalArgumentException {
        if (value < 0 || value > 2) {
            throw new BaseIllegalArgumentException("deploy_5083");
        }
        this.intFailOver = value;
        switch (value) {
            case 0: {
                this.failOverValue = FAIL_OVER_DISABLE;
                break;
            }
            case 2: {
                this.failOverValue = FAIL_OVER_ON_ATTRIBUTE;
                break;
            }
            case 1: {
                this.failOverValue = FAIL_OVER_ON_REQUEST;
            }
        }
    }

    public String getFailOverValue() {
        return this.failOverValue;
    }

    public int getFailOverIntValue() {
        return this.intFailOver;
    }
}

