/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy;

import java.io.Serializable;
import java.util.Hashtable;

public class DeployEvent
implements Serializable {
    static final long serialVersionUID = -2169771414910936940L;
    public static final byte ACTION_START = 0;
    public static final byte ACTION_FINISH = 1;
    public static final byte LOCAL_ACTION_START = 2;
    public static final byte LOCAL_ACTION_FINISH = 3;
    public static final byte DEPLOY_APP = 0;
    public static final byte DEPLOY_LIB = 1;
    public static final byte REMOVE_LIB = 2;
    public static final byte DEPLOY_LANG_LIB = 3;
    public static final byte MAKE_REFS = 4;
    public static final byte REMOVE_REFS = 5;
    public static final byte UPDATE_APP = 6;
    public static final byte REMOVE_APP = 7;
    public static final byte STOP_APP = 8;
    public static final byte START_APP = 9;
    public static final byte RUNTIME_CHANGES = 10;
    public static final byte SINGLE_FILE_UPDATE = 11;
    public static final byte ADD_APP_INFO_CHANGE = 12;
    public static final byte INITIAL_START_APPLICATIONS = 13;
    public static final byte UNKNOWN_STATUS = -1;
    public static final byte STARTED_STATUS = 0;
    public static final byte STOPPED_STATUS = 1;
    public static final byte REMOVED_STATUS = 2;
    public static final byte IMPLICIT_STOPPED_STATUS = 3;
    public static final byte STARTING_STATUS = 4;
    public static final byte STOPPING_STATUS = 5;
    public static final byte UPGRADING_STATUS = 6;
    private byte action;
    private byte actionType;
    private String fromServer;
    private String componentName = null;
    private String message = null;
    private String[] errors = null;
    private String[] warnings = null;
    private byte componentStatus = (byte)-1;
    private Hashtable container_components = null;
    private String whoCausedGroupOperation = null;

    public DeployEvent(String compName, byte action, byte actionType, String fromServer) {
        this.componentName = compName;
        this.action = action;
        this.actionType = actionType;
        this.fromServer = fromServer;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public byte getAction() {
        return this.action;
    }

    public void setAction(byte action) {
        this.action = action;
    }

    public byte getActionType() {
        return this.actionType;
    }

    public String getServer() {
        return this.fromServer;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public String[] getErrors() {
        return this.errors;
    }

    public void setErrors(String[] err) {
        this.errors = err;
    }

    public String[] getWarnings() {
        return this.warnings;
    }

    public void setWarnings(String[] wrn) {
        this.warnings = wrn;
    }

    public String toString() {
        String res = "\tDeploy Event:\nphase : " + this.getActionAsString() + " \n" + "operation : " + this.getActionTypeAsString() + "\n" + "component name : " + this.componentName + "\n" + "from server : " + this.fromServer + "\n" + "message : " + this.message + "\n" + "status " + this.getStatus(this.componentStatus) + "\n" + "application components : " + (this.container_components == null ? "none" : this.container_components.toString()) + "\n" + "errors : " + this.concatStrings(this.errors, "         ") + "warnings : " + this.concatStrings(this.errors, "           ");
        return res;
    }

    private String concatStrings(String[] source, String ballast) {
        String result = "";
        if (source != null) {
            int i = 0;
            while (i < source.length) {
                if (i != 0) {
                    result = result + ballast;
                }
                result = result + source[i] + "\n";
                ++i;
            }
        }
        return result;
    }

    public void setStatus(byte status) {
        this.componentStatus = status;
    }

    public byte getStatus() {
        return this.componentStatus;
    }

    public void setContainer_components(Hashtable cont_comps) {
        this.container_components = cont_comps;
    }

    public Hashtable getContainer_components() {
        return this.container_components;
    }

    public void setWhoCausedGroupOperation(String who) {
        this.whoCausedGroupOperation = who;
    }

    public String whoCausedGroupOperation() {
        return this.whoCausedGroupOperation;
    }

    public String getStatus(byte status) {
        switch (status) {
            case 0: {
                return "started";
            }
            case 1: {
                return "stopped";
            }
            case 4: {
                return "starting";
            }
            case 5: {
                return "stopping";
            }
            case 3: {
                return "implicit stopped";
            }
            case 6: {
                return "upgrading";
            }
            case -1: {
                return "unknown";
            }
        }
        return "unknown";
    }

    private String getActionAsString() {
        switch (this.action) {
            case 0: {
                return "global start";
            }
            case 1: {
                return "global finish";
            }
            case 2: {
                return "local start";
            }
            case 3: {
                return "local finish";
            }
        }
        return "unknown";
    }

    private String getActionTypeAsString() {
        switch (this.actionType) {
            case 0: {
                return "deploy an application";
            }
            case 1: {
                return "deploy a library";
            }
            case 2: {
                return "remove a library";
            }
            case 3: {
                return "deploy a language library";
            }
            case 4: {
                return "make reference(s)";
            }
            case 5: {
                return "remove reference(s)";
            }
            case 6: {
                return "update an application";
            }
            case 7: {
                return "remove an application";
            }
            case 8: {
                return "stop an application";
            }
            case 9: {
                return "start an application";
            }
            case 10: {
                return "runtime changes over an application";
            }
            case 11: {
                return "single file update over an application";
            }
            case 12: {
                return "change of additional information of application";
            }
            case 13: {
                return "initial start of applications during server startup";
            }
        }
        return "unknown";
    }
}

