/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.spi;

import com.sap.engine.services.dbpool.PoolFrame;
import com.sap.engine.services.dbpool.cci.ConnectionHandle;
import com.sap.engine.services.dbpool.exceptions.BaseResourceException;
import com.sap.engine.services.dbpool.spi.JDBCListenerWrapper;
import com.sap.engine.services.dbpool.spi.LocalTXManagedConnectionImpl;
import com.sap.tc.logging.Location;
import java.sql.SQLException;
import java.util.Iterator;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class XAManagedConnectionImpl
extends LocalTXManagedConnectionImpl {
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$dbpool$spi$XAManagedConnectionImpl == null ? (class$com$sap$engine$services$dbpool$spi$XAManagedConnectionImpl = XAManagedConnectionImpl.class$("com.sap.engine.services.dbpool.spi.XAManagedConnectionImpl")) : class$com$sap$engine$services$dbpool$spi$XAManagedConnectionImpl));
    private XAConnection xacon;
    private XAResource xares;
    static /* synthetic */ Class class$com$sap$engine$services$dbpool$spi$XAManagedConnectionImpl;

    public XAManagedConnectionImpl(ManagedConnectionFactory mcf, ConnectionRequestInfo cri, XAConnection xacon, int isolationLevel, long mcid) throws ResourceException {
        super(mcf, cri, xacon, isolationLevel, mcid);
        this.xacon = xacon;
        try {
            this.xares = xacon.getXAResource();
        }
        catch (SQLException ex) {
            this.throwBaseResourceException(ex);
        }
    }

    public void destroy() throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "--> XAManagedConnectionImpl.destroy(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". XAManagedConnectionImpl ID = " + this + ". Full stacktrace: " + PoolFrame.getMessageAndStackTrace(new Exception()));
        }
        if (this.connectionEventListenerList != null && !this.connectionEventListenerList.isEmpty()) {
            Iterator iter = this.clone(this.connectionEventListenerList).iterator();
            while (iter.hasNext()) {
                ConnectionEventListener element = (ConnectionEventListener)iter.next();
                this.removeConnectionEventListener(element);
            }
        }
        super.destroy();
        try {
            this.xacon.close();
        }
        catch (SQLException ex) {
            this.throwBaseResourceException(ex);
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- XAManagedConnectionImpl.destroy(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". XAManagedConnectionImpl ID = " + this);
        }
    }

    public void cleanup() throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "--> XAManagedConnectionImpl.cleanup(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". XAManagedConnectionImpl ID = " + this);
        }
        this.commonCleanup();
        try {
            this.con.close();
            this.con = this.xacon.getConnection();
            if (this.isolationLevel != -1) {
                this.con.setTransactionIsolation(this.isolationLevel);
                this.isolationLevel = -1;
            }
            this.xares = this.xacon.getXAResource();
        }
        catch (SQLException ex) {
            this.throwBaseResourceException(ex);
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- XAManagedConnectionImpl.cleanup(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". XAManagedConnectionImpl ID = " + this);
        }
    }

    public XAResource getXAResource() throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "--> XAManagedConnectionImpl.getXAResource(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". XAManagedConnectionImpl ID = " + this);
        }
        super.checkIfDestroyed();
        if (this.gotLocalTX) {
            throw new BaseResourceException("dbpool_0205");
        }
        this.gotXAResource = true;
        if (location.beLogged(100)) {
            location.logT(100, "<-- XAManagedConnectionImpl.getXAResource(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". XAManagedConnectionImpl ID = " + this);
        }
        return this.xares;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (location.beLogged(100)) {
            location.logT(100, "--> XAManagedConnectionImpl.addConnectionEventListener(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". XAManagedConnectionImpl ID = " + this + ". ConnectionEventListener object: " + listener);
        }
        super.addConnectionEventListener(listener);
        JDBCListenerWrapper jdbcListener = new JDBCListenerWrapper(listener, this);
        this.xacon.addConnectionEventListener(jdbcListener);
        if (location.beLogged(100)) {
            location.logT(100, "<-- XAManagedConnectionImpl.addConnectionEventListener(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". XAManagedConnectionImpl ID = " + this);
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (location.beLogged(100)) {
            location.logT(100, "--> XAManagedConnectionImpl.removeConnectionEventListener(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". XAManagedConnectionImpl ID = " + this + ". ConnectionEventListener object: " + listener);
        }
        if (listener == null) {
            return;
        }
        JDBCListenerWrapper jDBCListenerWrapper = new JDBCListenerWrapper(listener, this);
        this.xacon.removeConnectionEventListener(jDBCListenerWrapper);
        super.removeConnectionEventListener(listener);
        if (location.beLogged(100)) {
            location.logT(100, "<-- XAManagedConnectionImpl.removeConnectionEventListener(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". XAManagedConnectionImpl ID = " + this);
        }
    }

    public void begin() throws ResourceException {
        throw new BaseResourceException("dbpool_0206");
    }

    public void commit() throws ResourceException {
        throw new BaseResourceException("dbpool_0206");
    }

    public void rollback() throws ResourceException {
        throw new BaseResourceException("dbpool_0206");
    }

    public void clientBegin(ConnectionHandle handle) throws ResourceException {
        throw new BaseResourceException("dbpool_0206");
    }

    public void clientCommit(ConnectionHandle handle) throws ResourceException {
        throw new BaseResourceException("dbpool_0206");
    }

    public void clientRollback(ConnectionHandle handle) throws ResourceException {
        throw new BaseResourceException("dbpool_0206");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

