/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.spi;

import com.sap.engine.services.dbpool.PoolFrame;
import com.sap.engine.services.dbpool.cci.ConnectionHandle;
import com.sap.engine.services.dbpool.exceptions.BaseResourceException;
import com.sap.engine.services.dbpool.exceptions.BaseSecurityException;
import com.sap.engine.services.dbpool.spi.ManagedConnectionMetaDataImpl;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class LocalTXManagedConnectionImpl
implements ManagedConnection,
DissociatableManagedConnection,
LocalTransaction {
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$dbpool$spi$LocalTXManagedConnectionImpl == null ? (class$com$sap$engine$services$dbpool$spi$LocalTXManagedConnectionImpl = LocalTXManagedConnectionImpl.class$("com.sap.engine.services.dbpool.spi.LocalTXManagedConnectionImpl")) : class$com$sap$engine$services$dbpool$spi$LocalTXManagedConnectionImpl));
    protected static final int logDebug = 100;
    protected ConnectionRequestInfo cri;
    protected ManagedConnectionFactory mcf;
    private PrintWriter logWriter = null;
    private boolean destroyed;
    private boolean needToCallSetAutoCommit;
    private Set connectionSet;
    protected LinkedList connectionEventListenerList = null;
    protected Connection con;
    protected int isolationLevel;
    protected long hid;
    protected long mcid;
    protected boolean gotLocalTX;
    protected boolean gotXAResource;
    protected boolean spiLocalTXStarted;
    protected boolean cciLocalTXStarted;
    static /* synthetic */ Class class$com$sap$engine$services$dbpool$spi$LocalTXManagedConnectionImpl;

    public LocalTXManagedConnectionImpl(ManagedConnectionFactory mcf, ConnectionRequestInfo cri, Object con, int _isolationLevel, long mcid) throws ResourceException {
        this.mcf = mcf;
        this.cri = cri;
        this.mcid = mcid;
        this.isolationLevel = -1;
        this.gotLocalTX = false;
        this.gotXAResource = false;
        this.spiLocalTXStarted = false;
        this.cciLocalTXStarted = false;
        this.needToCallSetAutoCommit = false;
        this.hid = 0L;
        this.connectionSet = new HashSet();
        try {
            this.con = con instanceof XAConnection ? ((XAConnection)con).getConnection() : (con instanceof PooledConnection ? ((PooledConnection)con).getConnection() : (Connection)con);
            if (_isolationLevel != -1) {
                this.con.setTransactionIsolation(_isolationLevel);
            }
        }
        catch (SQLException ex) {
            this.throwBaseResourceException(ex);
        }
    }

    protected void throwBaseResourceException(SQLException sex) throws ResourceException {
        throw new BaseResourceException("dbpool_0204", sex.toString(), (Throwable)sex);
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "--> LocalTXManagedConnectionImpl.getConnection(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
        }
        this.checkIfDestroyed();
        if (connectionRequestInfo != null && !connectionRequestInfo.equals((Object)this.cri) || connectionRequestInfo == null && this.cri != null) {
            throw new BaseSecurityException("dbpool_0700");
        }
        ConnectionHandle jdbcCon = new ConnectionHandle(this, this.hid++);
        this.addConnectionHandle(jdbcCon);
        if (location.beLogged(100)) {
            location.logT(100, "<-- LocalTXManagedConnectionImpl.getConnection(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this + ". Returned ConnectionHandle object: " + jdbcCon);
        }
        return jdbcCon;
    }

    public void destroy() throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "--> LocalTXManagedConnectionImpl.destroy(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this + ". Full stacktrace: " + PoolFrame.getMessageAndStackTrace(new Exception()));
        }
        try {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            Iterator it = this.connectionSet.iterator();
            while (it.hasNext()) {
                ConnectionHandle jdbcCon = (ConnectionHandle)it.next();
                jdbcCon.invalidate();
            }
            this.connectionSet.clear();
            this.con.close();
        }
        catch (SQLException ex) {
            this.throwBaseResourceException(ex);
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- LocalTXManagedConnectionImpl.destroy(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
        }
    }

    public void cleanup() throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "--> LocalTXManagedConnectionImpl.cleanup(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
        }
        this.commonCleanup();
        this.nonXACleanup();
        if (location.beLogged(100)) {
            location.logT(100, "<-- LocalTXManagedConnectionImpl.cleanup(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void associateConnection(Object connection) throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "--> LocalTXManagedConnectionImpl.associateConnection(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this + ". ConnectionHandle object: " + connection);
        }
        this.checkIfDestroyed();
        if (!(connection instanceof ConnectionHandle)) throw new BaseResourceException("dbpool_0208", connection);
        ConnectionHandle jdbcCon = (ConnectionHandle)connection;
        if (!this.mcf.equals((Object)jdbcCon.getMcf()) || (this.cri == null || !this.cri.equals((Object)jdbcCon.getCri())) && (this.cri != null || jdbcCon.getCri() != null)) throw new BaseResourceException("dbpool_0207", connection);
        try {
            jdbcCon.associateConnection(this);
        }
        catch (SQLException sex) {
            this.throwBaseResourceException(sex);
        }
        if (!location.beLogged(100)) return;
        location.logT(100, "<-- LocalTXManagedConnectionImpl.associateConnection(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (location.beLogged(100)) {
            location.logT(100, "--> LocalTXManagedConnectionImpl.addConnectionEventListener(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this + ". ConnectionEventListener object: " + listener);
        }
        if (this.connectionEventListenerList == null) {
            this.connectionEventListenerList = new LinkedList();
        }
        if (!this.connectionEventListenerList.isEmpty() && location.beLogged(100)) {
            location.logT(100, "LocalTXManagedConnectionImpl.addConnectionEventListener(): Another ConnectionEventListener is about to be added for LocalTX with ID = '" + this + "'. Now they are more than one.");
        }
        this.connectionEventListenerList.add(listener);
        if (location.beLogged(100)) {
            location.logT(100, "<-- LocalTXManagedConnectionImpl.addConnectionEventListener(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        boolean elemFound;
        if (location.beLogged(100)) {
            location.logT(100, "--> LocalTXManagedConnectionImpl.removeConnectionEventListener(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this + ". ConnectionEventListener object: " + listener);
        }
        if (this.connectionEventListenerList != null && (elemFound = this.connectionEventListenerList.remove(listener)) && this.connectionEventListenerList.isEmpty()) {
            this.connectionEventListenerList = null;
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- LocalTXManagedConnectionImpl.removeConnectionEventListener(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
        }
    }

    public XAResource getXAResource() throws ResourceException {
        throw new BaseResourceException("dbpool_0201");
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "--> LocalTXManagedConnectionImpl.getLocalTransaction(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
        }
        this.checkIfDestroyed();
        if (this.gotXAResource) {
            throw new BaseResourceException("dbpool_0202");
        }
        this.gotLocalTX = true;
        if (location.beLogged(100)) {
            location.logT(100, "<-- LocalTXManagedConnectionImpl.getLocalTransaction(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
        }
        return this;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.checkIfDestroyed();
        return new ManagedConnectionMetaDataImpl(this);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        if (this.logWriter == null) {
            return this.mcf.getLogWriter();
        }
        return this.logWriter;
    }

    protected void commonCleanup() throws ResourceException {
        this.checkIfDestroyed();
        this.gotLocalTX = false;
        this.gotXAResource = false;
        this.spiLocalTXStarted = false;
        this.cciLocalTXStarted = false;
        Iterator it = this.connectionSet.iterator();
        while (it.hasNext()) {
            ConnectionHandle jdbcCon = (ConnectionHandle)it.next();
            try {
                this.removeConnectionHandle(jdbcCon);
            }
            catch (SQLException sex) {
                this.throwBaseResourceException(sex);
            }
            jdbcCon.invalidate();
        }
        this.connectionSet.clear();
    }

    public void nonXACleanup() throws ResourceException {
        try {
            if (this.isolationLevel != -1) {
                this.con.setTransactionIsolation(this.isolationLevel);
                this.isolationLevel = -1;
            }
            if (this.needToCallSetAutoCommit) {
                this.con.setAutoCommit(true);
                this.needToCallSetAutoCommit = false;
            }
        }
        catch (SQLException ex) {
            this.throwBaseResourceException(ex);
        }
    }

    public Connection getPhysicalConnection() throws ResourceException {
        this.checkIfDestroyed();
        return this.con;
    }

    boolean isDestroyed() {
        return this.destroyed;
    }

    public ConnectionRequestInfo getConnectionRequestInfo() {
        return this.cri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeConnectionHandle(ConnectionHandle connHandle) throws SQLException {
        Iterator iter2;
        ConnectionEvent event2;
        Throwable throwable2;
        block14: {
            LinkedList cachedEventListenerList = this.connectionEventListenerList;
            try {
                this.connectionSet.remove(connHandle);
                if (this.cciLocalTXStarted) {
                    if (this.needToCallSetAutoCommit) {
                        try {
                            this.clientRollback(connHandle);
                        }
                        catch (ResourceException rex) {
                            throw new SQLException("dbpool_0209");
                        }
                    }
                    this.cciLocalTXStarted = false;
                }
                Object var5_4 = null;
                if (this.connectionEventListenerList == null) return;
                if (this.connectionEventListenerList.isEmpty()) return;
                if (this.connectionEventListenerList != cachedEventListenerList) return;
            }
            catch (Throwable throwable2) {
                Object var5_5 = null;
                if (this.connectionEventListenerList == null) throw throwable2;
                if (this.connectionEventListenerList.isEmpty()) throw throwable2;
                if (this.connectionEventListenerList != cachedEventListenerList) throw throwable2;
                event2 = new ConnectionEvent((ManagedConnection)this, 1);
                event2.setConnectionHandle((Object)connHandle);
                iter2 = this.clone(this.connectionEventListenerList).iterator();
                break block14;
            }
            ConnectionEvent event2 = new ConnectionEvent((ManagedConnection)this, 1);
            event2.setConnectionHandle((Object)connHandle);
            Iterator iter2 = this.clone(this.connectionEventListenerList).iterator();
            while (iter2.hasNext()) {
                ConnectionEventListener element = (ConnectionEventListener)iter2.next();
                try {
                    element.connectionClosed(event2);
                }
                catch (RuntimeException rex) {
                    if (location.beLogged(500)) {
                        location.logT(500, "LocalTXManagedConnectionImpl.addConnectionEventListener():  Error during ConnectionEventListener notification: " + rex.toString());
                    }
                    if (!location.beLogged(100)) continue;
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
                }
            }
            return;
        }
        while (true) {
            if (!iter2.hasNext()) {
                throw throwable2;
            }
            ConnectionEventListener element = (ConnectionEventListener)iter2.next();
            try {}
            catch (RuntimeException rex) {
                if (location.beLogged(500)) {
                    location.logT(500, "LocalTXManagedConnectionImpl.addConnectionEventListener():  Error during ConnectionEventListener notification: " + rex.toString());
                }
                if (!location.beLogged(100)) continue;
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
                continue;
            }
            element.connectionClosed(event2);
            continue;
            break;
        }
    }

    public void addConnectionHandle(ConnectionHandle jdbcCon) {
        this.connectionSet.add(jdbcCon);
    }

    protected void checkIfDestroyed() throws ResourceException {
        if (this.destroyed) {
            throw new BaseResourceException("dbpool_0209");
        }
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    public long getMCID() {
        return this.mcid;
    }

    public synchronized long getAndIncHID() {
        return this.hid++;
    }

    public boolean getGotLocalTX() {
        return this.gotLocalTX;
    }

    public boolean getCciLocalTXStarted() {
        return this.cciLocalTXStarted;
    }

    public boolean getGotXAResource() {
        return this.gotXAResource;
    }

    public Set getConnectionSet() {
        return this.connectionSet;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(int _isolationLevel) {
        this.isolationLevel = _isolationLevel;
    }

    public void setNeedToCallSetAutoCommit(boolean _needToCallSetAutoCommit) {
        this.needToCallSetAutoCommit = _needToCallSetAutoCommit;
    }

    public void begin() throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "--> LocalTXManagedConnectionImpl.begin(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
        }
        if (this.spiLocalTXStarted || this.cciLocalTXStarted || this.needToCallSetAutoCommit) {
            throw new BaseResourceException("dbpool_0203");
        }
        try {
            this.spiLocalTXStarted = true;
            this.getPhysicalConnection().setAutoCommit(false);
            this.needToCallSetAutoCommit = true;
        }
        catch (SQLException sex) {
            this.throwBaseResourceException(sex);
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- LocalTXManagedConnectionImpl.begin(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
        }
    }

    /*
     * Loose catch block
     */
    public void commit() throws ResourceException {
        block13: {
            if (location.beLogged(100)) {
                location.logT(100, "--> LocalTXManagedConnectionImpl.commit(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
            }
            this.getPhysicalConnection().commit();
            Object var3_1 = null;
            try {
                if (this.spiLocalTXStarted) {
                    this.spiLocalTXStarted = false;
                    this.getPhysicalConnection().setAutoCommit(true);
                    this.needToCallSetAutoCommit = false;
                }
                break block13;
            }
            catch (SQLException sex2) {
                this.throwBaseResourceException(sex2);
            }
            break block13;
            {
                catch (SQLException sex) {
                    this.throwBaseResourceException(sex);
                    Object var3_2 = null;
                    try {
                        if (this.spiLocalTXStarted) {
                            this.spiLocalTXStarted = false;
                            this.getPhysicalConnection().setAutoCommit(true);
                            this.needToCallSetAutoCommit = false;
                        }
                        break block13;
                    }
                    catch (SQLException sex2) {
                        this.throwBaseResourceException(sex2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    if (this.spiLocalTXStarted) {
                        this.spiLocalTXStarted = false;
                        this.getPhysicalConnection().setAutoCommit(true);
                        this.needToCallSetAutoCommit = false;
                    }
                }
                catch (SQLException sex2) {
                    this.throwBaseResourceException(sex2);
                }
                throw throwable;
            }
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- LocalTXManagedConnectionImpl.commit(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
        }
    }

    /*
     * Loose catch block
     */
    public void rollback() throws ResourceException {
        block13: {
            if (location.beLogged(100)) {
                location.logT(100, "--> LocalTXManagedConnectionImpl.rollback(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
            }
            this.getPhysicalConnection().rollback();
            Object var3_1 = null;
            try {
                if (this.spiLocalTXStarted) {
                    this.spiLocalTXStarted = false;
                    this.getPhysicalConnection().setAutoCommit(true);
                    this.needToCallSetAutoCommit = false;
                }
                break block13;
            }
            catch (SQLException sex2) {
                this.throwBaseResourceException(sex2);
            }
            break block13;
            {
                catch (SQLException sex) {
                    this.throwBaseResourceException(sex);
                    Object var3_2 = null;
                    try {
                        if (this.spiLocalTXStarted) {
                            this.spiLocalTXStarted = false;
                            this.getPhysicalConnection().setAutoCommit(true);
                            this.needToCallSetAutoCommit = false;
                        }
                        break block13;
                    }
                    catch (SQLException sex2) {
                        this.throwBaseResourceException(sex2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    if (this.spiLocalTXStarted) {
                        this.spiLocalTXStarted = false;
                        this.getPhysicalConnection().setAutoCommit(true);
                        this.needToCallSetAutoCommit = false;
                    }
                }
                catch (SQLException sex2) {
                    this.throwBaseResourceException(sex2);
                }
                throw throwable;
            }
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- LocalTXManagedConnectionImpl.rollback(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void clientBegin(ConnectionHandle handle) throws SQLException, ResourceException {
        block52: {
            block51: {
                block50: {
                    block49: {
                        block48: {
                            block47: {
                                if (LocalTXManagedConnectionImpl.location.beLogged(100)) {
                                    LocalTXManagedConnectionImpl.location.logT(100, "--> LocalTXManagedConnectionImpl.clientBegin(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this + ". ConnectionHandle object: " + handle);
                                }
                                rtex = null;
                                sex = null;
                                rex = null;
                                try {
                                    this.needToCallSetAutoCommit = true;
                                    this.getPhysicalConnection().setAutoCommit(false);
                                    var9_5 = null;
                                    if (this.connectionEventListenerList == null || this.connectionEventListenerList.isEmpty()) break block47;
                                }
                                catch (Throwable var8_33) {
                                    var9_9 = null;
                                    if (this.connectionEventListenerList == null || this.connectionEventListenerList.isEmpty()) break block51;
                                    event = new ConnectionEvent((ManagedConnection)this, 2);
                                    event.setConnectionHandle((Object)handle);
                                    element = null;
                                    iter = this.clone(this.connectionEventListenerList).iterator();
                                    ** while (iter.hasNext())
                                }
                                event = new ConnectionEvent((ManagedConnection)this, 2);
                                event.setConnectionHandle((Object)handle);
                                element = null;
                                iter = this.clone(this.connectionEventListenerList).iterator();
                                while (iter.hasNext()) {
                                    element = (ConnectionEventListener)iter.next();
                                    try {
                                        element.localTransactionStarted(event);
                                    }
                                    catch (RuntimeException _rtex) {
                                        if (sex == null && rex == null && rtex == null) {
                                            rtex = _rtex;
                                        }
                                        if (LocalTXManagedConnectionImpl.location.beLogged(500)) {
                                            LocalTXManagedConnectionImpl.location.logT(500, "LocalTXManagedConnectionImpl.clientBegin(): Error during ConnectionEventListener notification: " + _rtex.toString());
                                        }
                                        if (!LocalTXManagedConnectionImpl.location.beLogged(100)) continue;
                                        LocalTXManagedConnectionImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)_rtex);
                                    }
                                }
                            }
                            this.cciLocalTXStarted = true;
                            if (sex != null) {
                                throw sex;
                            }
                            if (rex != null) {
                                throw rex;
                            }
                            if (rtex != null) {
                                throw rtex;
                            }
                            break block52;
                            {
                                catch (SQLException _sex) {
                                    if (LocalTXManagedConnectionImpl.location.beLogged(100)) {
                                        LocalTXManagedConnectionImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)_sex);
                                    }
                                    sex = _sex;
                                    var9_6 = null;
                                    if (this.connectionEventListenerList == null || this.connectionEventListenerList.isEmpty()) break block48;
                                    event = new ConnectionEvent((ManagedConnection)this, 2);
                                    event.setConnectionHandle((Object)handle);
                                    element = null;
                                    iter = this.clone(this.connectionEventListenerList).iterator();
                                    ** while (iter.hasNext())
                                }
                            }
lbl-1000:
                            // 1 sources

                            {
                                element = (ConnectionEventListener)iter.next();
                                try {
                                    element.localTransactionStarted(event);
                                }
                                catch (RuntimeException _rtex) {
                                    if (sex == null && rex == null && rtex == null) {
                                        rtex = _rtex;
                                    }
                                    if (LocalTXManagedConnectionImpl.location.beLogged(500)) {
                                        LocalTXManagedConnectionImpl.location.logT(500, "LocalTXManagedConnectionImpl.clientBegin(): Error during ConnectionEventListener notification: " + _rtex.toString());
                                    }
                                    if (!LocalTXManagedConnectionImpl.location.beLogged(100)) continue;
                                    LocalTXManagedConnectionImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)_rtex);
                                }
                                continue;
                            }
                        }
                        this.cciLocalTXStarted = true;
                        if (sex != null) {
                            throw sex;
                        }
                        if (rex != null) {
                            throw rex;
                        }
                        if (rtex != null) {
                            throw rtex;
                        }
                        break block52;
                        {
                            catch (ResourceException _rex) {
                                if (LocalTXManagedConnectionImpl.location.beLogged(100)) {
                                    LocalTXManagedConnectionImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)_rex);
                                }
                                rex = _rex;
                                var9_7 = null;
                                if (this.connectionEventListenerList == null || this.connectionEventListenerList.isEmpty()) break block49;
                                event = new ConnectionEvent((ManagedConnection)this, 2);
                                event.setConnectionHandle((Object)handle);
                                element = null;
                                iter = this.clone(this.connectionEventListenerList).iterator();
                                ** while (iter.hasNext())
                            }
                        }
lbl-1000:
                        // 1 sources

                        {
                            element = (ConnectionEventListener)iter.next();
                            try {
                                element.localTransactionStarted(event);
                            }
                            catch (RuntimeException _rtex) {
                                if (sex == null && rex == null && rtex == null) {
                                    rtex = _rtex;
                                }
                                if (LocalTXManagedConnectionImpl.location.beLogged(500)) {
                                    LocalTXManagedConnectionImpl.location.logT(500, "LocalTXManagedConnectionImpl.clientBegin(): Error during ConnectionEventListener notification: " + _rtex.toString());
                                }
                                if (!LocalTXManagedConnectionImpl.location.beLogged(100)) continue;
                                LocalTXManagedConnectionImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)_rtex);
                            }
                            continue;
                        }
                    }
                    this.cciLocalTXStarted = true;
                    if (sex != null) {
                        throw sex;
                    }
                    if (rex != null) {
                        throw rex;
                    }
                    if (rtex != null) {
                        throw rtex;
                    }
                    break block52;
                    {
                        catch (RuntimeException _rtex) {
                            if (LocalTXManagedConnectionImpl.location.beLogged(100)) {
                                LocalTXManagedConnectionImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)_rtex);
                            }
                            rtex = _rtex;
                            var9_8 = null;
                            if (this.connectionEventListenerList == null || this.connectionEventListenerList.isEmpty()) break block50;
                            event = new ConnectionEvent((ManagedConnection)this, 2);
                            event.setConnectionHandle((Object)handle);
                            element = null;
                            iter = this.clone(this.connectionEventListenerList).iterator();
                            ** while (iter.hasNext())
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        element = (ConnectionEventListener)iter.next();
                        try {
                            element.localTransactionStarted(event);
                        }
                        catch (RuntimeException _rtex) {
                            if (sex == null && rex == null && rtex == null) {
                                rtex = _rtex;
                            }
                            if (LocalTXManagedConnectionImpl.location.beLogged(500)) {
                                LocalTXManagedConnectionImpl.location.logT(500, "LocalTXManagedConnectionImpl.clientBegin(): Error during ConnectionEventListener notification: " + _rtex.toString());
                            }
                            if (!LocalTXManagedConnectionImpl.location.beLogged(100)) continue;
                            LocalTXManagedConnectionImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)_rtex);
                        }
                        continue;
                    }
                }
                this.cciLocalTXStarted = true;
                if (sex != null) {
                    throw sex;
                }
                if (rex != null) {
                    throw rex;
                }
                if (rtex != null) {
                    throw rtex;
                }
                break block52;
lbl-1000:
                // 1 sources

                {
                    element = (ConnectionEventListener)iter.next();
                    try {
                        element.localTransactionStarted(event);
                    }
                    catch (RuntimeException _rtex) {
                        if (sex == null && rex == null && rtex == null) {
                            rtex = _rtex;
                        }
                        if (LocalTXManagedConnectionImpl.location.beLogged(500)) {
                            LocalTXManagedConnectionImpl.location.logT(500, "LocalTXManagedConnectionImpl.clientBegin(): Error during ConnectionEventListener notification: " + _rtex.toString());
                        }
                        if (!LocalTXManagedConnectionImpl.location.beLogged(100)) continue;
                        LocalTXManagedConnectionImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)_rtex);
                    }
                    continue;
                }
            }
            this.cciLocalTXStarted = true;
            if (sex != null) {
                throw sex;
            }
            if (rex != null) {
                throw rex;
            }
            if (rtex != null) {
                throw rtex;
            }
            throw var8_33;
        }
        if (LocalTXManagedConnectionImpl.location.beLogged(100)) {
            LocalTXManagedConnectionImpl.location.logT(100, "<-- LocalTXManagedConnectionImpl.clientBegin(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void clientCommit(ConnectionHandle handle) throws SQLException, ResourceException {
        block12: {
            block13: {
                if (LocalTXManagedConnectionImpl.location.beLogged(100)) {
                    LocalTXManagedConnectionImpl.location.logT(100, "--> LocalTXManagedConnectionImpl.clientCommit(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this + ". ConnectionHandle object: " + handle);
                }
                try {
                    this.getPhysicalConnection().commit();
                    var3_2 = null;
                    ** if (this.connectionEventListenerList == null || !this.needToCallSetAutoCommit || this.connectionEventListenerList.isEmpty()) goto lbl-1000
                }
                catch (Throwable var2_12) {
                    var3_3 = null;
                    if (this.connectionEventListenerList == null || !this.needToCallSetAutoCommit || this.connectionEventListenerList.isEmpty()) break block13;
                    event = new ConnectionEvent((ManagedConnection)this, 3);
                    event.setConnectionHandle((Object)handle);
                    element = null;
                    iter = this.clone(this.connectionEventListenerList).iterator();
                    ** while (iter.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    event = new ConnectionEvent((ManagedConnection)this, 3);
                    event.setConnectionHandle((Object)handle);
                    element = null;
                    iter = this.clone(this.connectionEventListenerList).iterator();
                    while (iter.hasNext()) {
                        element = (ConnectionEventListener)iter.next();
                        try {
                            element.localTransactionCommitted(event);
                        }
                        catch (RuntimeException rex) {
                            if (LocalTXManagedConnectionImpl.location.beLogged(500)) {
                                LocalTXManagedConnectionImpl.location.logT(500, "LocalTXManagedConnectionImpl.clientCommit(): Error during ConnectionEventListener notification: " + rex.toString());
                            }
                            if (!LocalTXManagedConnectionImpl.location.beLogged(100)) continue;
                            LocalTXManagedConnectionImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
                        }
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block12;
                }
lbl-1000:
                // 1 sources

                {
                    element = (ConnectionEventListener)iter.next();
                    try {
                        element.localTransactionCommitted(event);
                    }
                    catch (RuntimeException rex) {
                        if (LocalTXManagedConnectionImpl.location.beLogged(500)) {
                            LocalTXManagedConnectionImpl.location.logT(500, "LocalTXManagedConnectionImpl.clientCommit(): Error during ConnectionEventListener notification: " + rex.toString());
                        }
                        if (!LocalTXManagedConnectionImpl.location.beLogged(100)) continue;
                        LocalTXManagedConnectionImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
                    }
                    continue;
                }
            }
            this.cciLocalTXStarted = false;
            throw var2_12;
        }
        this.cciLocalTXStarted = false;
        if (LocalTXManagedConnectionImpl.location.beLogged(100)) {
            LocalTXManagedConnectionImpl.location.logT(100, "<-- LocalTXManagedConnectionImpl.clientCommit(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void clientRollback(ConnectionHandle handle) throws SQLException, ResourceException {
        block12: {
            block13: {
                if (LocalTXManagedConnectionImpl.location.beLogged(100)) {
                    LocalTXManagedConnectionImpl.location.logT(100, "--> LocalTXManagedConnectionImpl.clientRollback(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this + ". ConnectionHandle object: " + handle);
                }
                try {
                    this.getPhysicalConnection().rollback();
                    var3_2 = null;
                    ** if (this.connectionEventListenerList == null || !this.needToCallSetAutoCommit || this.connectionEventListenerList.isEmpty()) goto lbl-1000
                }
                catch (Throwable var2_12) {
                    var3_3 = null;
                    if (this.connectionEventListenerList == null || !this.needToCallSetAutoCommit || this.connectionEventListenerList.isEmpty()) break block13;
                    event = new ConnectionEvent((ManagedConnection)this, 4);
                    event.setConnectionHandle((Object)handle);
                    element = null;
                    iter = this.clone(this.connectionEventListenerList).iterator();
                    ** while (iter.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    event = new ConnectionEvent((ManagedConnection)this, 4);
                    event.setConnectionHandle((Object)handle);
                    element = null;
                    iter = this.clone(this.connectionEventListenerList).iterator();
                    while (iter.hasNext()) {
                        element = (ConnectionEventListener)iter.next();
                        try {
                            element.localTransactionRolledback(event);
                        }
                        catch (RuntimeException rex) {
                            if (LocalTXManagedConnectionImpl.location.beLogged(500)) {
                                LocalTXManagedConnectionImpl.location.logT(500, "LocalTXManagedConnectionImpl.clientRollback(): Error during ConnectionEventListener notification: " + rex.toString());
                            }
                            if (!LocalTXManagedConnectionImpl.location.beLogged(100)) continue;
                            LocalTXManagedConnectionImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
                        }
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block12;
                }
lbl-1000:
                // 1 sources

                {
                    element = (ConnectionEventListener)iter.next();
                    try {
                        element.localTransactionRolledback(event);
                    }
                    catch (RuntimeException rex) {
                        if (LocalTXManagedConnectionImpl.location.beLogged(500)) {
                            LocalTXManagedConnectionImpl.location.logT(500, "LocalTXManagedConnectionImpl.clientRollback(): Error during ConnectionEventListener notification: " + rex.toString());
                        }
                        if (!LocalTXManagedConnectionImpl.location.beLogged(100)) continue;
                        LocalTXManagedConnectionImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
                    }
                    continue;
                }
            }
            this.cciLocalTXStarted = false;
            throw var2_12;
        }
        this.cciLocalTXStarted = false;
        if (LocalTXManagedConnectionImpl.location.beLogged(100)) {
            LocalTXManagedConnectionImpl.location.logT(100, "<-- LocalTXManagedConnectionImpl.clientRollback(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
        }
    }

    public String toString() {
        return String.valueOf(this.mcid);
    }

    public void dissociateConnections() throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "--> LocalTXManagedConnectionImpl.dissociateConnections(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
        }
        Iterator it = this.connectionSet.iterator();
        while (it.hasNext()) {
            ConnectionHandle jdbcCon = (ConnectionHandle)it.next();
            try {
                jdbcCon.dissociateConnection();
            }
            catch (SQLException sex) {
                this.throwBaseResourceException(sex);
            }
        }
        this.connectionSet.clear();
        if (location.beLogged(100)) {
            location.logT(100, "<-- LocalTXManagedConnectionImpl.dissociateConnections(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". LocalTXManagedConnectionImpl ID = " + this);
        }
    }

    protected LinkedList clone(LinkedList src) {
        LinkedList dst = new LinkedList();
        Iterator iter = src.iterator();
        while (iter.hasNext()) {
            dst.add(iter.next());
        }
        return dst;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

