/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.spi;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ResourceLoader;
import com.sap.engine.services.dbpool.PoolFrame;
import com.sap.engine.services.dbpool.cci.ConnectionFactoryImpl;
import com.sap.engine.services.dbpool.deploy.ContainerImpl;
import com.sap.engine.services.dbpool.deploy.JDBCDescriptor;
import com.sap.engine.services.dbpool.exceptions.BaseIOException;
import com.sap.engine.services.dbpool.exceptions.BaseInstantiationException;
import com.sap.engine.services.dbpool.exceptions.BaseResourceException;
import com.sap.engine.services.dbpool.spi.CPManagedConnectionImpl;
import com.sap.engine.services.dbpool.spi.CommonManagedConnectionImpl;
import com.sap.engine.services.dbpool.spi.ConnectionRequestInfoImpl;
import com.sap.engine.services.dbpool.spi.DirectManagedConnectionImpl;
import com.sap.sql.connect.OpenSQLConnectionFactory;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.security.auth.Subject;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class CPManagedConnectionFactoryImpl
implements ManagedConnectionFactory,
Serializable {
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$dbpool$spi$CPManagedConnectionFactoryImpl == null ? (class$com$sap$engine$services$dbpool$spi$CPManagedConnectionFactoryImpl = CPManagedConnectionFactoryImpl.class$("com.sap.engine.services.dbpool.spi.CPManagedConnectionFactoryImpl")) : class$com$sap$engine$services$dbpool$spi$CPManagedConnectionFactoryImpl));
    private static final int logDebug = 100;
    private JDBCDescriptor descr;
    private long mcfid;
    private long mcid;
    private transient ConnectionPoolDataSource cpds;
    static /* synthetic */ Class class$com$sap$engine$services$dbpool$spi$CPManagedConnectionFactoryImpl;

    public CPManagedConnectionFactoryImpl(ContainerImpl container, JDBCDescriptor descr, long mcfid) throws InstantiationException {
        this.descr = descr;
        this.mcfid = mcfid;
        this.mcid = 0L;
        String objectFactoryName = descr.getObjectFactory();
        Properties props20 = descr.getProps20();
        ApplicationServiceContext serviceContext = PoolFrame.getAppContext();
        LoadContext classLoaderContext = serviceContext.getCoreContext().getLoadContext();
        if (objectFactoryName == null || "".equals(objectFactoryName)) {
            try {
                Class cl;
                if ("SYSTEM_DRIVER".equals(descr.getDriverName())) {
                    cl = Class.forName(descr.getCPDSClassName());
                } else {
                    ResourceLoader loader = (ResourceLoader)classLoaderContext.getClassLoader("library:" + descr.getDriverName());
                    container.ensureOpenSqlResForLoader(loader);
                    cl = loader.loadClass(descr.getCPDSClassName());
                }
                this.cpds = (ConnectionPoolDataSource)cl.newInstance();
                Method[] methods = cl.getMethods();
                Enumeration<?> enumeration = props20.propertyNames();
                block4: while (enumeration.hasMoreElements()) {
                    String propName = (String)enumeration.nextElement();
                    String mthName = "set".concat(propName.substring(0, 1).toUpperCase().concat(propName.substring(1)));
                    int i = 0;
                    while (i < methods.length) {
                        Method method = methods[i];
                        if (method.getName().equals(mthName) && method.getParameterTypes().length == 1) {
                            method.invoke((Object)this.cpds, this.getValue(props20.getProperty(propName)));
                            continue block4;
                        }
                        ++i;
                    }
                }
            }
            catch (Exception ex) {
                throw new BaseInstantiationException("dbpool_0800", "CPManagedConnectionFactoryImpl", (Throwable)ex);
            }
        }
        Reference ref = new Reference(descr.getCPDSClassName(), objectFactoryName, "");
        Enumeration<?> enumeration = props20.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propName = (String)enumeration.nextElement();
            ref.add(new StringRefAddr(propName, props20.getProperty(propName)));
        }
        try {
            Class cl;
            if ("SYSTEM_DRIVER".equals(descr.getDriverName())) {
                cl = Class.forName(objectFactoryName);
            } else {
                ResourceLoader loader = (ResourceLoader)classLoaderContext.getClassLoader("library:" + descr.getDriverName());
                container.ensureOpenSqlResForLoader(loader);
                cl = loader.loadClass(objectFactoryName);
            }
            ObjectFactory objectFactory = (ObjectFactory)cl.newInstance();
            this.cpds = (ConnectionPoolDataSource)objectFactory.getObjectInstance(ref, null, null, null);
        }
        catch (Exception ex) {
            throw new BaseInstantiationException("dbpool_0800", "CPManagedConnectionFactoryImpl", (Throwable)ex);
        }
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        return new ConnectionFactoryImpl(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        return new ConnectionFactoryImpl(this, null);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "CPManagedConnectionFactoryImpl.createManagedConnection(): DataSource name = " + this.descr.getDataSourceName() + ". CPManagedConnectionFactoryImpl object: " + this);
        }
        try {
            PooledConnection pooledCon = null;
            ConnectionRequestInfoImpl infoImpl = null;
            Properties dbiProps = new Properties();
            String userName = null;
            String password = null;
            if (info == null) {
                pooledCon = this.cpds.getPooledConnection();
                Properties props20 = this.descr.getProps20();
                userName = props20.getProperty("user");
                password = props20.getProperty("password");
            } else {
                infoImpl = (ConnectionRequestInfoImpl)info;
                userName = infoImpl.getUser();
                password = infoImpl.getPassword();
                pooledCon = this.cpds.getPooledConnection(infoImpl.getUser(), infoImpl.getPassword());
            }
            if (userName != null) {
                dbiProps.setProperty("user", userName);
            }
            if (password != null) {
                dbiProps.setProperty("password", password);
            }
            dbiProps.setProperty("jndiName", this.descr.getDataSourceName());
            dbiProps.setProperty("systemDataSource", new Boolean(this.descr.isDefaultDS()).toString());
            if (PoolFrame.getAppContext() == null) {
                dbiProps.setProperty("clusterId", Integer.toString(-1));
            } else {
                dbiProps.setProperty("clusterId", Integer.toString(PoolFrame.getAppContext().getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId()));
            }
            if (this.descr.isOpenSQL()) {
                return new CommonManagedConnectionImpl((ManagedConnectionFactory)this, (ConnectionRequestInfo)infoImpl, OpenSQLConnectionFactory.createCommonPooledConnection((PooledConnection)pooledCon, (Properties)dbiProps), this.descr.getIsolationLevel(), this.mcid++);
            }
            if (this.descr.isNativeSQL()) {
                return new DirectManagedConnectionImpl((ManagedConnectionFactory)this, (ConnectionRequestInfo)infoImpl, OpenSQLConnectionFactory.createDirectPooledConnection((PooledConnection)pooledCon, (Properties)dbiProps), this.descr.getIsolationLevel(), this.mcid++);
            }
            return new CPManagedConnectionImpl((ManagedConnectionFactory)this, (ConnectionRequestInfo)infoImpl, pooledCon, this.descr.getIsolationLevel(), this.mcid++);
        }
        catch (SQLException sex) {
            if (location.beLogged(500)) {
                location.logT(500, "CPManagedConnectionFactoryImpl.createManagedConnection(): SQLException occured while creating CPManagedConnection: " + sex.toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)sex);
            }
            throw new BaseResourceException("dbpool_0204", sex.toString(), (Throwable)sex);
        }
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "--> CPManagedConnectionFactoryImpl.matchManagedConnections(): DataSource name = " + this.descr.getDataSourceName() + ". CPManagedConnectionFactoryImpl object: " + this);
        }
        Iterator it = connectionSet.iterator();
        while (it.hasNext()) {
            CPManagedConnectionImpl mc;
            ManagedConnectionFactory mcf;
            Object obj = it.next();
            if (!(obj instanceof CPManagedConnectionImpl) || !(mcf = (mc = (CPManagedConnectionImpl)obj).getManagedConnectionFactory()).equals((Object)this) || (info != null || mc.getConnectionRequestInfo() != null) && (info == null || !info.equals((Object)mc.getConnectionRequestInfo()))) continue;
            if (location.beLogged(100)) {
                location.logT(100, "<-- CPManagedConnectionFactoryImpl.matchManagedConnections(): DataSource name = " + this.descr.getDataSourceName() + ". CPManagedConnectionFactoryImpl object: " + this + ". Matched ManagedConnection ID = " + mc);
            }
            return mc;
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- CPManagedConnectionFactoryImpl.matchManagedConnections(): DataSource name = " + this.descr.getDataSourceName() + ". CPManagedConnectionFactoryImpl object: " + this + ". Match not found.");
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        try {
            this.cpds.setLogWriter(out);
        }
        catch (SQLException ex) {
            throw new BaseResourceException("dbpool_0204", ex.toString(), (Throwable)ex);
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        try {
            return this.cpds.getLogWriter();
        }
        catch (SQLException ex) {
            throw new BaseResourceException("dbpool_0204", ex.toString(), (Throwable)ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof CPManagedConnectionFactoryImpl) {
            String objDSName = ((CPManagedConnectionFactoryImpl)obj).descr.getDataSourceName();
            return this.descr.getDataSourceName().equals(objDSName);
        }
        return false;
    }

    public int hashCode() {
        return this.descr.getDataSourceName().hashCode();
    }

    public long getMCFID() {
        return this.mcfid;
    }

    private Object getValue(String propValue) {
        int i = 0;
        while (i < propValue.length()) {
            if (propValue.charAt(i) < '0' || propValue.charAt(i) > '9') {
                return propValue;
            }
            ++i;
        }
        return new Integer(propValue);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Class<?> cl2;
        stream.defaultReadObject();
        ApplicationServiceContext serviceContext = PoolFrame.getAppContext();
        Reference ref = new Reference(this.descr.getCPDSClassName(), this.descr.getObjectFactory(), "");
        Properties props20 = this.descr.getProps20();
        String objectFactoryName = this.descr.getObjectFactory();
        LoadContext classLoaderContext = serviceContext.getCoreContext().getLoadContext();
        String errorMessage = "";
        if (objectFactoryName == null || "".equals(objectFactoryName)) {
            try {
                Class<?> cl2;
                if (serviceContext != null) {
                    errorMessage = "at the server side ";
                    cl2 = "SYSTEM_DRIVER".equals(this.descr.getDriverName()) ? Class.forName(this.descr.getCPDSClassName()) : classLoaderContext.getClassLoader("library:" + this.descr.getDriverName()).loadClass(this.descr.getCPDSClassName());
                } else {
                    errorMessage = "at the client side ";
                    cl2 = Class.forName(this.descr.getCPDSClassName());
                }
                this.cpds = (ConnectionPoolDataSource)cl2.newInstance();
                Method[] methods = cl2.getMethods();
                Enumeration<?> enumeration = props20.propertyNames();
                block4: while (enumeration.hasMoreElements()) {
                    String propName = (String)enumeration.nextElement();
                    String mthName = "set".concat(propName.substring(0, 1).toUpperCase().concat(propName.substring(1)));
                    int i = 0;
                    while (i < methods.length) {
                        Method method = methods[i];
                        if (method.getName().equals(mthName) && method.getParameterTypes().length == 1) {
                            method.invoke((Object)this.cpds, this.getValue(props20.getProperty(propName)));
                            continue block4;
                        }
                        ++i;
                    }
                }
            }
            catch (Exception ex) {
                throw new BaseIOException("dbpool_0502", errorMessage, (Throwable)ex);
            }
        }
        Enumeration<?> enumeration = props20.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propName = (String)enumeration.nextElement();
            ref.add(new StringRefAddr(propName, props20.getProperty(propName)));
        }
        if (serviceContext != null) {
            errorMessage = "at the server side ";
            cl2 = "SYSTEM_DRIVER".equals(this.descr.getDriverName()) ? Class.forName(this.descr.getObjectFactory()) : classLoaderContext.getClassLoader("library:" + this.descr.getDriverName()).loadClass(this.descr.getObjectFactory());
        } else {
            errorMessage = "at the client side ";
            cl2 = Class.forName(this.descr.getObjectFactory());
        }
        try {
            ObjectFactory objectFactory = (ObjectFactory)cl2.newInstance();
            this.cpds = (ConnectionPoolDataSource)objectFactory.getObjectInstance(ref, null, null, null);
        }
        catch (Exception ex) {
            throw new BaseIOException("dbpool_0502", errorMessage, (Throwable)ex);
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return null;
    }

    public void setResourceAdapter(ResourceAdapter arg0) throws ResourceException {
    }

    public JDBCDescriptor getJDBCDescriptor() {
        return this.descr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

