/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.gui;

import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import com.sap.tc.logging.Location;
import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;

public class ResourceTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$dbpool$gui$ResourceTreeCellRenderer == null ? (class$com$sap$engine$services$dbpool$gui$ResourceTreeCellRenderer = ResourceTreeCellRenderer.class$("com.sap.engine.services.dbpool.gui.ResourceTreeCellRenderer")) : class$com$sap$engine$services$dbpool$gui$ResourceTreeCellRenderer));
    private DataSourceManager dsManager;
    private TreeNode root;
    private TreeNode dsNode;
    private TreeNode drvNode;
    private ImageIcon rootIcon;
    private ImageIcon dataSourcesIcon;
    private ImageIcon appStartedStandaloneIcon;
    private ImageIcon appStoppedStandaloneIcon;
    private ImageIcon appStartedIcon;
    private ImageIcon appStoppedIcon;
    private ImageIcon componentIcon;
    private ImageIcon driversIcon;
    private ImageIcon driverIcon;
    private ImageIcon fileIcon;
    private ImageIcon serviceIcon;
    private ImageIcon libraryIcon;
    static /* synthetic */ Class class$com$sap$engine$services$dbpool$gui$ResourceTreeCellRenderer;

    public ResourceTreeCellRenderer(DataSourceManager _dsManager, TreeNode _root, TreeNode _dsNode, TreeNode _drvNode) {
        this.dsManager = _dsManager;
        this.root = _root;
        this.dsNode = _dsNode;
        this.drvNode = _drvNode;
        this.rootIcon = new ImageIcon(this.getClass().getResource("images/root.gif"));
        this.dataSourcesIcon = new ImageIcon(this.getClass().getResource("images/datasources.gif"));
        this.appStartedStandaloneIcon = new ImageIcon(this.getClass().getResource("images/started_standalone.gif"));
        this.appStoppedStandaloneIcon = new ImageIcon(this.getClass().getResource("images/stopped_standalone.gif"));
        this.appStartedIcon = new ImageIcon(this.getClass().getResource("images/started.gif"));
        this.appStoppedIcon = new ImageIcon(this.getClass().getResource("images/stopped.gif"));
        this.componentIcon = new ImageIcon(this.getClass().getResource("images/component.gif"));
        this.driversIcon = new ImageIcon(this.getClass().getResource("images/drivers.gif"));
        this.driverIcon = new ImageIcon(this.getClass().getResource("images/driver.gif"));
        this.fileIcon = new ImageIcon(this.getClass().getResource("images/file.gif"));
        this.serviceIcon = new ImageIcon(this.getClass().getResource("images/service.gif"));
        this.libraryIcon = new ImageIcon(this.getClass().getResource("images/library_admin.gif"));
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        try {
            block25: {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                TreeNode node = (TreeNode)value;
                if (this.root.equals(node)) {
                    this.setIcon(this.rootIcon);
                } else if (this.dsNode.equals(node)) {
                    this.setIcon(this.dataSourcesIcon);
                } else if (this.drvNode.equals(node)) {
                    this.setIcon(this.driversIcon);
                } else if (this.dsNode.equals(node.getParent())) {
                    if (!node.getAllowsChildren()) {
                        this.setIcon(this.componentIcon);
                    } else {
                        String appName = ((DefaultMutableTreeNode)node).getUserObject().toString();
                        try {
                            if (appName.endsWith(" Service")) {
                                this.setIcon(this.serviceIcon);
                                break block25;
                            }
                            if (appName.endsWith(" Library")) {
                                this.setIcon(this.libraryIcon);
                                break block25;
                            }
                            if (this.dsManager.isStandAloneApplication(appName)) {
                                if (this.dsManager.isApplicationStarted(appName)) {
                                    this.setIcon(this.appStartedStandaloneIcon);
                                } else {
                                    this.setIcon(this.appStoppedStandaloneIcon);
                                }
                                break block25;
                            }
                            if (this.dsManager.isApplicationStarted(appName)) {
                                this.setIcon(this.appStartedIcon);
                                break block25;
                            }
                            this.setIcon(this.appStoppedIcon);
                        }
                        catch (RemoteException rex) {
                            LOCATION.traceThrowableT(500, "Unexpected exception", (Throwable)rex);
                        }
                    }
                } else if (this.drvNode.equals(node.getParent())) {
                    this.setIcon(this.driverIcon);
                } else if (this.dsNode.equals(node.getParent().getParent())) {
                    this.setIcon(this.componentIcon);
                } else if (this.drvNode.equals(node.getParent().getParent())) {
                    this.setIcon(this.fileIcon);
                }
            }
            Object var12_11 = null;
            return this;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            return this;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

