/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.gui;

import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.gui.CFileChooser;
import com.sap.engine.gui.TextFieldsDialog;
import com.sap.engine.gui.UserNode;
import com.sap.engine.gui.status.MessageDialog;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.UnsupportedEditorException;
import com.sap.engine.interfaces.visual_administration.VisualRuntimeControl;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import com.sap.engine.services.dbpool.deploy.JDBCDescriptor;
import com.sap.engine.services.dbpool.deploy.StatementEntry;
import com.sap.engine.services.dbpool.deploy.XMLUtils;
import com.sap.engine.services.dbpool.gui.ErrorDialog;
import com.sap.engine.services.dbpool.gui.MonitoringThread;
import com.sap.engine.services.dbpool.gui.PropsEditorView;
import com.sap.engine.services.dbpool.gui.ResourceTreeCellRenderer;
import com.sap.tc.logging.Location;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PropsEditorLogical
extends PropsEditorView
implements VisualRuntimeControl {
    protected static final String RESTART_CLUSTER = "You have to restart the cluster in order your changes to take effect.";
    protected static final String ALIASES_MODIFICATION_CANCELLED = "Aliases will not be modified";
    protected static final String SAVE_CHANGES = "Would you like to save changes?";
    protected static final String REDEPLOY_WARNING = "Warning: Your changes will be lost if you redeploy the application ";
    protected static final String[] ADD_DRIVER_LABELS = new String[]{"DB driver:"};
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$dbpool$gui$PropsEditorLogical == null ? (class$com$sap$engine$services$dbpool$gui$PropsEditorLogical = PropsEditorLogical.class$("com.sap.engine.services.dbpool.gui.PropsEditorLogical")) : class$com$sap$engine$services$dbpool$gui$PropsEditorLogical));
    protected Hashtable datasources;
    protected Hashtable aliases;
    protected Hashtable dbInitStatements;
    protected Hashtable drivers;
    protected Hashtable libraries;
    protected Hashtable appNodes;
    protected Hashtable dsNodes;
    protected Hashtable drvNodes;
    protected Hashtable libNodes;
    protected DefaultMutableTreeNode lastSelectedDSNode = null;
    protected DataSourceManager dsManager;
    private JDBCDescriptor clipbrdDescr;
    private MonitoringThread mt;
    private CFileChooser cfc = new CFileChooser(this.frame);
    private JFileChooser jfc = new JFileChooser();
    private FileFilter filter = new FileFilter(){

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(".xml");
        }

        public String getDescription() {
            return "XML Document";
        }
    };
    static /* synthetic */ Class class$com$sap$engine$services$dbpool$gui$PropsEditorLogical;

    public JComponent getRuntimeControlComponent() {
        return this;
    }

    public JMenu getRuntimeMenu() {
        return null;
    }

    public JButton[] getRuntimeButtons() {
        return new JButton[]{this.importBtn, this.exportBtn, this.newBtn, this.removeBtn, this.saveBtn, this.refreshBtn, this.startBtn, this.stopBtn, this.undefDrvBtn, this.defDrvBtn, this.copyBtn, this.pasteBtn};
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
        this.aliasesPanel.setFrame(frame);
        this.aliasesPanel.setJdbcConnectorGUI(this);
    }

    public void setEnvironment(String editorToolName, Object environment) throws UnsupportedEditorException {
        if (!editorToolName.equals("SAPJ2EEEngineVisualAdministrator")) {
            throw new UnsupportedEditorException("admin_0");
        }
    }

    public void show(ManagementInterface ri) {
        this.disableButtons();
        this.dsManager = (DataSourceManager)ri;
        this.jfc.setFileFilter(this.filter);
        ResourceTreeCellRenderer renderer = new ResourceTreeCellRenderer(this.dsManager, this.resTreeRoot, this.dsNode, this.drvNode);
        this.resTree.setCellRenderer(renderer);
        this.refreshAction();
    }

    public void freeResources() {
        this.saveChanges();
        this.clearAll();
    }

    public void setUserTree(UserNode root) {
    }

    public void setTaskManager(EditorViewManager manager) {
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.newBtn) {
            this.newAction();
        } else if (src == this.startBtn) {
            this.startAppAction();
        } else if (src == this.stopBtn) {
            this.stopAppAction();
        } else if (src == this.saveBtn) {
            this.saveAction(null);
        } else if (src == this.removeBtn) {
            this.removeAction();
        } else if (src == this.importBtn) {
            this.importFromXMLAction(true);
        } else if (src == this.exportBtn) {
            this.exportToXMLAction(true);
        } else if (src == this.refreshBtn) {
            this.refreshAction();
        } else if (src == this.defDrvBtn) {
            this.defDrvAction();
        } else if (src == this.undefDrvBtn) {
            this.undefDrvAction();
        } else if (src == this.copyBtn) {
            this.copyAction();
        } else if (src == this.pasteBtn) {
            this.pasteAction();
        } else if (src == this.statementsPanel.importBtn) {
            this.importFromXMLAction(false);
        } else if (src == this.statementsPanel.exportBtn) {
            this.exportToXMLAction(false);
        } else if (src == this.statementsPanel.modifyBtn) {
            this.modifyStmtAction();
        } else if (src == this.statementsPanel.executeBtn) {
            this.executeStmtAction();
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.saveBtn.setEnabled(true);
        if (e != null && e.getSource() == this.openSQLButton) {
            this.updateIsoCBox();
        }
    }

    public void valueChanged(TreeSelectionEvent tse) {
        DefaultMutableTreeNode node;
        if (tse.getSource() == this.resTree) {
            if (this.saveBtn.isEnabled()) {
                int result = JOptionPane.showConfirmDialog(this.frame, SAVE_CHANGES, "Question", 1);
                if (result == 0) {
                    this.saveAction(this.lastSelectedDSNode);
                } else if (result == 2) {
                    final TreePath path = this.dsNodePath.pathByAddingChild(this.appNodes.get(this.appNameField.getText())).pathByAddingChild(this.lastSelectedDSNode);
                    this.resTree.removeTreeSelectionListener(this);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            PropsEditorLogical.this.resTree.setSelectionPath(path);
                            PropsEditorLogical.this.resTree.addTreeSelectionListener(PropsEditorLogical.this);
                        }
                    });
                    return;
                }
            }
            this.disableButtons();
            node = (DefaultMutableTreeNode)this.resTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            this.libTree.setSelectionPath(null);
            if (node.equals(this.resTreeRoot)) {
                this.clearTabPane();
            } else if (node.equals(this.dsNode)) {
                this.lastSelectedDSNode = node;
                this.clearTabPane();
                this.newBtn.setEnabled(true);
            } else if (node.equals(this.drvNode)) {
                this.loadDriversTabPane();
                this.newBtn.setEnabled(true);
            } else if (node.getParent().equals(this.dsNode)) {
                if (node.equals(this.sysDSNode)) {
                    this.lastSelectedDSNode = node;
                    this.loadDSTabPane();
                    this.refreshDSNode(node);
                    this.disableComponentsForDefaultDS();
                } else {
                    String appName = node.getUserObject().toString();
                    boolean isServOrLibNode = appName.endsWith(" Service") || appName.endsWith(" Library");
                    this.lastSelectedDSNode = node;
                    this.clearTabPane();
                    this.exportBtn.setEnabled(true);
                    if (!isServOrLibNode) {
                        this.newBtn.setEnabled(true);
                    }
                    try {
                        if (!isServOrLibNode && this.dsManager.isStandAloneApplication(appName)) {
                            if (this.dsManager.isApplicationStarted(appName)) {
                                this.stopBtn.setEnabled(true);
                            } else {
                                this.startBtn.setEnabled(true);
                            }
                            this.removeBtn.setEnabled(true);
                        }
                    }
                    catch (RemoteException rex) {
                        ErrorDialog.showErrorDialog(this.frame, "Error occured during check status of application '" + appName + "'", rex);
                    }
                }
            } else if (node.getParent().equals(this.drvNode)) {
                this.loadDriversTabPane();
                if (!"SYSTEM_DRIVER".equals(node.getUserObject())) {
                    this.removeBtn.setEnabled(true);
                    this.undefDrvBtn.setEnabled(true);
                }
            } else if (node.getParent().getParent().equals(this.dsNode)) {
                this.lastSelectedDSNode = node;
                this.loadDSTabPane();
                this.refreshDSNode(node);
            } else if (node.getParent().getParent().equals(this.drvNode)) {
                this.loadDriversTabPane();
            }
        }
        if (tse.getSource() == this.libTree) {
            this.disableButtons();
            node = (DefaultMutableTreeNode)this.libTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            this.resTree.setSelectionPath(null);
            if (node != this.libTreeRoot && node.getParent().equals(this.libTreeRoot)) {
                this.defDrvBtn.setEnabled(true);
            }
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        Object src = ie.getSource();
        if (src == this.isolation) {
            if (this.isolation.getSelectedIndex() == -1) {
                this.isolation.setSelectedItem(this.isoCBoxLastSel);
            } else {
                this.isoCBoxLastSel = this.isolation.getSelectedItem();
            }
        }
        if (src == this.jdbcVerComboBox) {
            if (this.jdbcVerComboBox.getSelectedIndex() == -1) {
                this.jdbcVerComboBox.setSelectedItem(this.verCBoxLastSel);
            } else {
                this.verCBoxLastSel = this.jdbcVerComboBox.getSelectedItem();
                this.updateJDBCPanels();
            }
        }
        if (src == this.cpdsComboBox) {
            if (this.cpdsComboBox.getSelectedIndex() == -1) {
                this.cpdsComboBox.setSelectedItem(this.cpdsCBoxLastSel);
            } else {
                this.cpdsCBoxLastSel = this.cpdsComboBox.getSelectedItem();
                this.updateCPDSPanel();
            }
        }
        if (src == this.expCheckBox) {
            this.expAction();
        }
        this.stateChanged(null);
    }

    public void changedUpdate(DocumentEvent de) {
        this.stateChanged(null);
    }

    public void insertUpdate(DocumentEvent de) {
        this.stateChanged(null);
    }

    public void removeUpdate(DocumentEvent de) {
        this.stateChanged(null);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.stateChanged(null);
    }

    public String addAlias(String alias) throws RemoteException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.resTree.getLastSelectedPathComponent();
        if (node.equals(this.dsNode)) {
            return null;
        }
        if (node.equals(this.sysDSNode)) {
            JDBCDescriptor sysDSDescr = (JDBCDescriptor)this.sysDSNode.getUserObject();
            if (this.checkIfAliasIsInArray(alias, sysDSDescr.getAliases())) {
                return ALIASES_MODIFICATION_CANCELLED;
            }
            sysDSDescr.setAliases(this.addAliasToArray(alias, sysDSDescr.getAliases()));
            this.dsManager.createDataSource(null, sysDSDescr);
            return RESTART_CLUSTER;
        }
        if (node.getParent().equals(this.dsNode)) {
            return null;
        }
        String appName = this.appNameField.getText();
        Vector dsVtr = (Vector)((Vector)this.datasources.get(appName)).clone();
        String dsName = this.nameField.getText();
        Enumeration enumeration = dsVtr.elements();
        while (enumeration.hasMoreElements()) {
            JDBCDescriptor descr = (JDBCDescriptor)enumeration.nextElement();
            if (!descr.getDataSourceName().equals(dsName)) continue;
            if (this.checkIfAliasIsInArray(alias, descr.getAliases())) {
                return ALIASES_MODIFICATION_CANCELLED;
            }
            descr.setAliases(this.addAliasToArray(alias, descr.getAliases()));
            if (appName.endsWith(" Service") || appName.endsWith(" Library")) {
                this.dsManager.updateDataSourceApplication(appName, dsVtr, false);
                return RESTART_CLUSTER;
            }
            if (JOptionPane.showConfirmDialog(this.frame, "Warning: Your changes will be lost if you redeploy the application '" + appName + "'.\nWould you like to continue?", "Question", 0) == 0) {
                this.dsManager.updateDataSourceApplication(appName, dsVtr, true);
                this.datasources.put(appName, dsVtr);
                node.setUserObject(descr);
                break;
            }
            return ALIASES_MODIFICATION_CANCELLED;
        }
        return "";
    }

    public String addAliasToDS(String alias, String dsName, String appNameOfDS, String removeMessage) throws RemoteException {
        if ("".equals(appNameOfDS)) {
            JDBCDescriptor sysDSDescr = (JDBCDescriptor)this.sysDSNode.getUserObject();
            if (!this.checkIfAliasIsInArray(alias, sysDSDescr.getAliases())) {
                sysDSDescr.setAliases(this.addAliasToArray(alias, sysDSDescr.getAliases()));
                this.dsManager.createDataSource(null, sysDSDescr);
                return RESTART_CLUSTER;
            }
        } else {
            Vector dsVtr = (Vector)((Vector)this.datasources.get(appNameOfDS)).clone();
            Enumeration enumeration = dsVtr.elements();
            while (enumeration.hasMoreElements()) {
                JDBCDescriptor descr = (JDBCDescriptor)enumeration.nextElement();
                if (!descr.getDataSourceName().equals(dsName) || this.checkIfAliasIsInArray(alias, descr.getAliases())) continue;
                descr.setAliases(this.addAliasToArray(alias, descr.getAliases()));
                if (appNameOfDS.endsWith(" Service") || appNameOfDS.endsWith(" Library") || RESTART_CLUSTER.equals(removeMessage)) {
                    this.dsManager.updateDataSourceApplication(appNameOfDS, dsVtr, false);
                    return RESTART_CLUSTER;
                }
                this.dsManager.updateDataSourceApplication(appNameOfDS, dsVtr, true);
                this.datasources.put(appNameOfDS, dsVtr);
                break;
            }
        }
        return "";
    }

    public String addAliasToAppLibOrServ(String alias, String newDS, String deployer) throws RemoteException {
        String aliasesAppName = deployer.endsWith(" Application") ? deployer.substring(0, deployer.indexOf(" Application")) : deployer;
        Hashtable<String, String[]> extAliases = (Hashtable<String, String[]>)this.aliases.get(aliasesAppName);
        if (extAliases == null) {
            extAliases = new Hashtable<String, String[]>();
            extAliases.put(newDS, new String[]{alias});
        } else {
            String[] newAliases;
            String[] theseAliases = (String[])extAliases.get(newDS);
            if (theseAliases == null) {
                newAliases = new String[]{alias};
            } else {
                if (this.checkIfAliasIsInArray(alias, theseAliases)) {
                    return "";
                }
                newAliases = this.addAliasToArray(alias, theseAliases);
            }
            extAliases.put(newDS, newAliases);
        }
        this.dsManager.updateAliasesApplication(aliasesAppName, extAliases);
        if (!deployer.endsWith(" Application")) {
            return RESTART_CLUSTER;
        }
        return "";
    }

    public String getAppNameForDS(String dsName) {
        JDBCDescriptor sysDSDescr;
        if (this.sysDSNode != null && dsName.equals((sysDSDescr = (JDBCDescriptor)this.sysDSNode.getUserObject()).getDataSourceName())) {
            return "";
        }
        Enumeration htEnum = this.datasources.keys();
        while (htEnum.hasMoreElements()) {
            String appName = (String)htEnum.nextElement();
            Enumeration vecEnum = ((Vector)this.datasources.get(appName)).elements();
            while (vecEnum.hasMoreElements()) {
                JDBCDescriptor curDescr = (JDBCDescriptor)vecEnum.nextElement();
                if (!dsName.equals(curDescr.getDataSourceName())) continue;
                return appName;
            }
        }
        return null;
    }

    public String removeAlias(String alias, String deployer, boolean redirect) throws RemoteException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.resTree.getLastSelectedPathComponent();
        if (node.equals(this.dsNode)) {
            return null;
        }
        if (node.equals(this.sysDSNode)) {
            if (deployer.endsWith(" DataSource")) {
                if (JOptionPane.showConfirmDialog(this.frame, "WARNING: You are about to remove/redirect the internal alias '" + alias + "' of the Default DataSource.\n" + "If this is a default alias, the server will not be able to continue its work and it will not boot properly when you restart it.\n" + "Would you like to continue?", "Warning", 0) == 0) {
                    JDBCDescriptor sysDSDescr = (JDBCDescriptor)this.sysDSNode.getUserObject();
                    String[] intAliases = sysDSDescr.getAliases();
                    String[] newAliases = this.removeAliasFromArray(alias, intAliases);
                    sysDSDescr.setAliases(newAliases);
                    this.dsManager.createDataSource(null, sysDSDescr);
                    return RESTART_CLUSTER;
                }
                return ALIASES_MODIFICATION_CANCELLED;
            }
            if (deployer.endsWith(" Application") || deployer.endsWith(" Service") || deployer.endsWith(" Library")) {
                return this.removeAliasFromDeployer(alias, deployer, redirect);
            }
        } else {
            if (node.getParent().equals(this.dsNode)) {
                return null;
            }
            String appName = this.appNameField.getText();
            if (deployer.endsWith(" DataSource")) {
                Vector dsVtr = (Vector)((Vector)this.datasources.get(appName)).clone();
                String dsName = this.nameField.getText();
                Enumeration enumeration = dsVtr.elements();
                while (enumeration.hasMoreElements()) {
                    JDBCDescriptor descr = (JDBCDescriptor)enumeration.nextElement();
                    if (!descr.getDataSourceName().equals(dsName)) continue;
                    String[] intAliases = descr.getAliases();
                    String[] newAliases = this.removeAliasFromArray(alias, intAliases);
                    descr.setAliases(newAliases);
                    if (appName.endsWith(" Service") || appName.endsWith(" Library")) {
                        this.dsManager.updateDataSourceApplication(appName, dsVtr, false);
                        return RESTART_CLUSTER;
                    }
                    if (redirect || JOptionPane.showConfirmDialog(this.frame, "Warning: Your changes will be lost if you redeploy the application '" + appName + "'.\nWould you like to continue?", "Question", 0) == 0) {
                        this.dsManager.updateDataSourceApplication(appName, dsVtr, true);
                        this.datasources.put(appName, dsVtr);
                        node.setUserObject(descr);
                        break;
                    }
                    return ALIASES_MODIFICATION_CANCELLED;
                }
            } else if (deployer.endsWith(" Application") || deployer.endsWith(" Service") || deployer.endsWith(" Library")) {
                return this.removeAliasFromDeployer(alias, deployer, redirect);
            }
        }
        return "";
    }

    public String getCurrentDSName() {
        return this.nameField.getText();
    }

    private String removeAliasFromDeployer(String alias, String deployer, boolean redirect) throws RemoteException {
        String aliasesAppName;
        int result = 0;
        if (deployer.endsWith(" Application")) {
            aliasesAppName = deployer.substring(0, deployer.indexOf(" Application"));
            if (!redirect) {
                result = JOptionPane.showConfirmDialog(this.frame, "Warning: Your changes will be lost if you redeploy the application '" + aliasesAppName + "'.\nWould you like to continue?", "Question", 0);
            }
        } else {
            aliasesAppName = deployer;
        }
        if (result == 0) {
            Hashtable extAliases = (Hashtable)this.aliases.get(aliasesAppName);
            Enumeration enumeration = extAliases.keys();
            while (enumeration.hasMoreElements()) {
                String dsName = (String)enumeration.nextElement();
                if (!dsName.equals(this.nameField.getText())) continue;
                String[] theseAliases = (String[])extAliases.get(dsName);
                String[] newAliases = this.removeAliasFromArray(alias, theseAliases);
                if (newAliases.length > 0) {
                    extAliases.put(dsName, newAliases);
                    break;
                }
                extAliases.remove(dsName);
                break;
            }
            this.dsManager.updateAliasesApplication(aliasesAppName, extAliases);
            if (!deployer.endsWith(" Application")) {
                return RESTART_CLUSTER;
            }
            return "";
        }
        return ALIASES_MODIFICATION_CANCELLED;
    }

    private String[] removeAliasFromArray(String alias, String[] array) {
        String[] newArray = new String[array.length - 1];
        int newCounter = 0;
        int i = 0;
        while (i < array.length) {
            if (!array[i].equals(alias)) {
                newArray[newCounter++] = array[i];
            }
            ++i;
        }
        return newArray;
    }

    private String[] addAliasToArray(String alias, String[] array) {
        String[] newArray = new String[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = alias;
        return newArray;
    }

    private boolean checkIfAliasIsInArray(String alias, String[] aliasesArray) {
        int i = 0;
        while (i < aliasesArray.length) {
            if (aliasesArray[i].equals(alias)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void newAction() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.resTree.getLastSelectedPathComponent();
        if (node.equals(this.drvNode)) {
            TextFieldsDialog tfd = new TextFieldsDialog(this.frame, "Add driver", ADD_DRIVER_LABELS);
            tfd.setLocationRelativeTo(this.frame);
            if (tfd.showDialog()) {
                this.addDriver(tfd.getResults()[0]);
            }
        } else {
            this.loadDSTabPane();
            this.enableComponentsForDefaultDS();
            this.copyBtn.setEnabled(true);
            this.pasteBtn.setEnabled(this.clipbrdDescr != null);
            this.exportBtn.setEnabled(true);
            this.updateDriversPanel(null);
            this.updateSettingsPanel(null, false);
            if (node.getParent().equals(this.dsNode)) {
                this.disableListeners();
                this.appNameField.setText(node.toString());
                this.appNameField.setEditable(false);
                this.enableListeners();
            }
            this.updateMonitoringPanel(null);
        }
    }

    private void saveAction(DefaultMutableTreeNode node) {
        block26: {
            this.saveBtn.setEnabled(false);
            if (node == null) {
                node = (DefaultMutableTreeNode)this.resTree.getLastSelectedPathComponent();
            }
            String dsName = this.nameField.getText();
            JDBCDescriptor newDescr = this.getJDBCDescriptorFromGui();
            if (node.equals(this.dsNode)) {
                try {
                    String appName = this.dsManager.createDataSource(this.appNameField.getText(), newDescr);
                    if (appName == null) {
                        JOptionPane.showMessageDialog(this.frame, "Application '" + this.appNameField.getText() + "' is not deployed successfully!", "Error", 0);
                        return;
                    }
                    Vector<JDBCDescriptor> dsVtr = new Vector<JDBCDescriptor>();
                    dsVtr.add(newDescr);
                    this.datasources.put(appName, dsVtr);
                    this.removeAppNode(appName);
                    this.updateDSTree(appName, false);
                    this.resTree.getSelectionModel().setSelectionPath(this.dsNodePath.pathByAddingChild(this.appNodes.get(appName)).pathByAddingChild(this.dsNodes.get(this.nameField.getText())));
                }
                catch (RemoteException re) {
                    if (newDescr.getDriverName() == null) {
                        JOptionPane.showMessageDialog(this.frame, "Data Source '" + dsName + "' can't be created. Reason: no specified driver.", "Error", 0);
                        break block26;
                    }
                    ErrorDialog.showErrorDialog(this.frame, "Data Source '" + dsName + "' can't be created", re);
                }
                catch (IOException ioe) {
                    ErrorDialog.showErrorDialog(this.frame, "Error generating '" + dsName + ".xml' file", ioe);
                }
            } else {
                String appName = this.appNameField.getText();
                Vector dsVtr = (Vector)this.datasources.get(appName);
                try {
                    if (node.getParent().equals(this.dsNode)) {
                        if (node.equals(this.sysDSNode)) {
                            JDBCDescriptor sysDSDescr = (JDBCDescriptor)this.sysDSNode.getUserObject();
                            String dbConnectInfo = sysDSDescr.getDBConnectInfo();
                            if (dbConnectInfo == null) {
                                newDescr.setDriverClassName(sysDSDescr.getDriverClassName());
                                newDescr.setURL(sysDSDescr.getURL());
                                newDescr.setUsername(sysDSDescr.getUsername());
                                newDescr.setPassword(sysDSDescr.getPassword());
                            } else {
                                newDescr.setDBConnectInfo(dbConnectInfo);
                            }
                            newDescr.setDefaultDS(true);
                            this.dsManager.createDataSource(null, newDescr);
                            JOptionPane.showMessageDialog(this.frame, RESTART_CLUSTER, "Info", 1);
                        } else {
                            String nodeName = (String)node.getUserObject();
                            if (nodeName.endsWith(" Service")) {
                                JOptionPane.showMessageDialog(this.frame, "Adding DataSource to a service feature is not implemented yet", "Info", 1);
                            } else if (nodeName.endsWith(" Library")) {
                                JOptionPane.showMessageDialog(this.frame, "Adding DataSource to a library feature is not implemented yet", "Info", 1);
                            } else {
                                dsVtr.add(newDescr);
                                Enumeration enumeration = dsVtr.elements();
                                DefaultMutableTreeNode child = new DefaultMutableTreeNode(newDescr, false);
                                this.resTreeModel.insertNodeInto(child, node, this.getIndex(enumeration, newDescr.getDataSourceName()));
                                this.resTree.getSelectionModel().setSelectionPath(this.dsNodePath.pathByAddingChild(node).pathByAddingChild(child));
                                this.dsManager.updateDataSourceApplication(appName, dsVtr, true);
                            }
                        }
                        break block26;
                    }
                    if (!node.getParent().getParent().equals(this.dsNode)) break block26;
                    String parentName = (String)((DefaultMutableTreeNode)node.getParent()).getUserObject();
                    if (parentName.endsWith(" Service") || parentName.endsWith(" Library")) {
                        Enumeration enumeration = dsVtr.elements();
                        while (enumeration.hasMoreElements()) {
                            JDBCDescriptor descr = (JDBCDescriptor)enumeration.nextElement();
                            if (!descr.getDataSourceName().equals(dsName)) continue;
                            int indexOfDS = dsVtr.indexOf(descr);
                            dsVtr.remove(indexOfDS);
                            dsVtr.add(indexOfDS, newDescr);
                            node.setUserObject(newDescr);
                            this.dsManager.updateDataSourceApplication(appName, dsVtr, false);
                            break;
                        }
                        JOptionPane.showMessageDialog(this.frame, RESTART_CLUSTER, "Info", 1);
                        break block26;
                    }
                    Enumeration enumeration = dsVtr.elements();
                    while (enumeration.hasMoreElements()) {
                        JDBCDescriptor descr = (JDBCDescriptor)enumeration.nextElement();
                        if (!descr.getDataSourceName().equals(dsName)) continue;
                        int result = JOptionPane.showConfirmDialog(this.frame, "Warning: Your changes will be lost if you redeploy the application '" + appName + "'.\nWould you like to continue?", "Question", 1);
                        if (result == 0) {
                            int indexOfDS = dsVtr.indexOf(descr);
                            dsVtr.remove(indexOfDS);
                            dsVtr.add(indexOfDS, newDescr);
                            node.setUserObject(newDescr);
                            this.dsManager.updateDataSourceApplication(appName, dsVtr, true);
                        } else if (result == 1) {
                            this.refreshDSNode(node);
                        } else {
                            this.saveBtn.setEnabled(true);
                        }
                        break;
                    }
                }
                catch (RemoteException rex) {
                    String errorMsg = "Error occured while updating ";
                    errorMsg = appName == null ? errorMsg + "the default DataSource" : (appName.endsWith(" Service") || appName.endsWith(" Library") ? errorMsg + "'" + appName + "'" : errorMsg + "'" + appName.concat(" Application") + "'");
                    ErrorDialog.showErrorDialog(this.frame, errorMsg, rex);
                }
            }
        }
    }

    private void startAppAction() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.resTree.getLastSelectedPathComponent();
        String appName = node.getUserObject().toString();
        try {
            this.dsManager.startApplication(appName);
            this.startBtn.setEnabled(false);
            this.stopBtn.setEnabled(true);
            this.resTree.repaint();
        }
        catch (RemoteException rex) {
            ErrorDialog.showErrorDialog(this.frame, "Error occured while starting application '" + appName + "'", rex);
        }
    }

    private void stopAppAction() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.resTree.getLastSelectedPathComponent();
        String appName = node.getUserObject().toString();
        try {
            this.dsManager.stopApplication(appName);
            this.startBtn.setEnabled(true);
            this.stopBtn.setEnabled(false);
            this.resTree.repaint();
        }
        catch (RemoteException rex) {
            ErrorDialog.showErrorDialog(this.frame, "Error occured while stopping application '" + appName + "'", rex);
        }
    }

    private void copyAction() {
        this.clipbrdDescr = this.getJDBCDescriptorFromGui();
        this.pasteBtn.setEnabled(true);
    }

    private void pasteAction() {
        this.updateSettingsPanel(this.clipbrdDescr, true);
        this.updateDriversPanel(this.clipbrdDescr);
        this.saveBtn.setEnabled(true);
    }

    private void removeAction() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.resTree.getLastSelectedPathComponent();
        if (node.getParent().equals(this.drvNode)) {
            String selectedDrv = node.getUserObject().toString();
            if (JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to remove the driver:\n" + selectedDrv, "Confirmation", 0) == 0) {
                this.removeDriver(node, true);
            }
        } else if (node.getParent().equals(this.dsNode)) {
            String appName = node.getUserObject().toString();
            if (JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to remove the application:\n" + appName, "Confirmation", 0) != 0) {
                return;
            }
            try {
                this.dsManager.removeApplication(appName);
                this.removeAppNode(appName);
            }
            catch (RemoteException rex) {
                ErrorDialog.showErrorDialog(this.frame, "Application '" + appName + "' can't be removed", rex);
            }
        } else if (node.getParent().getParent().equals(this.dsNode)) {
            if (JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to remove the DataSource:\n" + this.nameField.getText(), "Confirmation", 0) != 0) {
                return;
            }
            String appName = this.appNameField.getText();
            Vector dsVtr = (Vector)this.datasources.get(appName);
            try {
                JDBCDescriptor descr = (JDBCDescriptor)node.getUserObject();
                dsVtr.remove(descr);
                this.dsManager.updateDataSourceApplication(appName, dsVtr, true);
                this.datasources.put(appName, dsVtr);
                this.dsNodes.remove(descr.getDataSourceName());
                this.resTreeModel.removeNodeFromParent(node);
                this.resTree.getSelectionModel().setSelectionPath(this.dsNodePath.pathByAddingChild(this.appNodes.get(appName)));
            }
            catch (RemoteException rex) {
                ErrorDialog.showErrorDialog(this.frame, "Error occured while updating application '" + appName + "'", rex);
            }
        }
    }

    private void defDrvAction() {
        String selectedLib = this.getLibraryName();
        if (this.drivers.get(selectedLib) == null) {
            try {
                this.dsManager.defineJdbcDriver(selectedLib);
                this.drivers.put(selectedLib, this.libraries.remove(selectedLib));
                this.driverComboBox.insertItemAt(selectedLib, this.updateDrvTree(selectedLib, false));
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.libTree.getLastSelectedPathComponent();
                this.libTreeModel.removeNodeFromParent(node);
                this.resTree.setSelectionPath(this.drvNodePath.pathByAddingChild(this.drvNodes.get(selectedLib)));
            }
            catch (RemoteException rex) {
                ErrorDialog.showErrorDialog(this.frame, "Cannot define '" + selectedLib + "' driver", rex);
            }
        }
    }

    private void undefDrvAction() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.resTree.getLastSelectedPathComponent();
        this.removeDriver(node, false);
    }

    private void importFromXMLAction(boolean isDataSource) {
        this.jfc.setMultiSelectionEnabled(true);
        this.jfc.setDialogTitle("Import from XML...");
        int state = this.jfc.showOpenDialog(this);
        if (state == 0) {
            File[] files = this.jfc.getSelectedFiles();
            int i = 0;
            while (i < files.length) {
                try {
                    if (isDataSource) {
                        String appName = this.dsManager.deploy(new SerializableFile(files[i]));
                        if (appName == null) {
                            JOptionPane.showMessageDialog(this.frame, "'" + files[i] + "' is not deployed successfully!", "Error", 0);
                            return;
                        }
                        Vector descrVtr = XMLUtils.processXML(files[i]);
                        this.datasources.put(appName, descrVtr);
                        this.removeAppNode(appName);
                        this.updateDSTree(appName, false);
                        this.resTree.getSelectionModel().setSelectionPath(this.dsNodePath.pathByAddingChild(this.appNodes.get(appName)));
                        Enumeration enumeration = descrVtr.elements();
                        while (enumeration.hasMoreElements()) {
                            JDBCDescriptor descr = (JDBCDescriptor)enumeration.nextElement();
                            String drvName = descr.getDriverName();
                            if (this.drivers.get(drvName) != null) continue;
                            this.drivers.put(drvName, this.dsManager.getDrivers().get(drvName));
                            this.driverComboBox.insertItemAt(drvName, this.updateDrvTree(drvName, false));
                        }
                    } else {
                        String result = this.dsManager.dbInit(new SerializableFile(files[i]));
                        this.dbInitStatements = this.dsManager.getInitStatements();
                        this.statementsPanel.initList((StatementEntry[])this.dbInitStatements.get(this.nameField.getText()));
                        JOptionPane.showMessageDialog(this.frame, result, "DB Initialization", -1);
                    }
                }
                catch (IllegalArgumentException iaex) {
                    ErrorDialog.showErrorDialog(this.frame, "IllegalArgumentException occured during deployment of file '" + files[i].getName() + "'", iaex);
                }
                catch (RemoteException rex) {
                    ErrorDialog.showErrorDialog(this.frame, "RemoteException occured during deployment of file '" + files[i].getName() + "'", rex);
                }
                catch (IOException ioex) {
                    ErrorDialog.showErrorDialog(this.frame, "IOException occured during deployment of file '" + files[i].getName() + "'", ioex);
                }
                ++i;
            }
        }
    }

    private void exportToXMLAction(boolean isDataSource) {
        this.jfc.setMultiSelectionEnabled(false);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.resTree.getLastSelectedPathComponent();
        if (isDataSource) {
            if (node.getParent().equals(this.dsNode) && !node.equals(this.sysDSNode)) {
                this.jfc.setDialogTitle("Export all DataSources from selected application to XML...");
            } else {
                this.jfc.setDialogTitle("Export selected DataSource to XML...");
            }
        } else {
            this.jfc.setDialogTitle("Export init statements for the selected DataSource to XML...");
        }
        int state = this.jfc.showSaveDialog(this);
        if (state == 0) {
            String fileName;
            File file = this.jfc.getSelectedFile();
            if (file.exists()) {
                if (JOptionPane.showConfirmDialog(this.frame, "File already exists. Overwrite?", "Confirm", 0) != 0) {
                    return;
                }
                fileName = file.getAbsolutePath();
            } else {
                fileName = file.getName().indexOf(46) != -1 ? file.getAbsolutePath() : file.getAbsolutePath() + ".xml";
            }
            try {
                if (isDataSource) {
                    if (node.getParent().equals(this.dsNode) && !node.equals(this.sysDSNode)) {
                        String appName = node.getUserObject().toString();
                        XMLUtils.generateAllXMLForExport(appName, (Vector)this.datasources.get(appName), fileName);
                    } else {
                        XMLUtils.generateXMLForExport(this.appNameField.getText(), this.getJDBCDescriptorFromGui(), fileName);
                    }
                } else {
                    XMLUtils.generateStmtXML(this.nameField.getText(), this.statementsPanel.getListDataArray(), fileName);
                }
            }
            catch (IOException ioex) {
                ErrorDialog.showErrorDialog(this.frame, "Error occured while writing XML", ioex);
            }
        }
    }

    private void expAction() {
        if (this.expCheckBox.isSelected()) {
            this.connLifeField.setEnabled(true);
            this.runThreadField.setEnabled(true);
        } else {
            this.connLifeField.setEnabled(false);
            this.runThreadField.setEnabled(false);
        }
    }

    private void modifyStmtAction() {
        String dsName = this.nameField.getText();
        StatementEntry[] statements = this.statementsPanel.getListDataArray();
        try {
            if (statements != null && statements.length > 0) {
                this.dsManager.addInitStatements(dsName, statements);
                this.dbInitStatements.put(dsName, statements);
            } else {
                this.dsManager.removeInitStatements(dsName);
                this.dbInitStatements.remove(dsName);
            }
        }
        catch (RemoteException rex) {
            ErrorDialog.showErrorDialog(this.frame, "Error occured while modifying init statements", rex);
        }
    }

    private void executeStmtAction() {
        String dsName = this.nameField.getText();
        try {
            StatementEntry[] statements = this.statementsPanel.getListDataArray();
            this.dsManager.addInitStatements(dsName, statements);
            this.dbInitStatements.put(dsName, statements);
            String message = this.dsManager.executeInitStatements(dsName);
            MessageDialog.showDialog(this.frame, "Execute", message);
        }
        catch (RemoteException rex) {
            ErrorDialog.showErrorDialog(this.frame, "Error occured while executing init statements", rex);
        }
    }

    private void refreshAction() {
        this.saveChanges();
        try {
            this.clearAll();
            JDBCDescriptor sysDSDescr = this.dsManager.getSystemDataSourceDescriptor();
            if (sysDSDescr != null) {
                this.sysDSNode = new DefaultMutableTreeNode(sysDSDescr, false);
                this.resTreeModel.insertNodeInto(this.sysDSNode, this.dsNode, 0);
                this.resTree.expandRow(0);
            }
            this.datasources = this.dsManager.getDataSources();
            this.aliases = this.dsManager.getAliases();
            this.appNodes = new Hashtable();
            this.dsNodes = new Hashtable();
            ArrayObject keys = this.sortKeys(this.datasources);
            int i = 0;
            while (i < keys.size()) {
                this.updateDSTree((String)keys.get(i), true);
                ++i;
            }
            this.dbInitStatements = this.dsManager.getInitStatements();
            this.drivers = this.dsManager.getDrivers();
            this.libraries = this.dsManager.getServerLibraries();
            this.drvNodes = new Hashtable();
            keys = this.sortKeys(this.drivers);
            String curDrvName = null;
            int i2 = 0;
            while (i2 < keys.size()) {
                curDrvName = (String)keys.get(i2);
                this.driverComboBox.insertItemAt(curDrvName, this.updateDrvTree(curDrvName, true));
                this.libraries.remove(curDrvName);
                ++i2;
            }
            this.libNodes = new Hashtable();
            keys = this.sortKeys(this.libraries);
            int i3 = 0;
            while (i3 < keys.size()) {
                this.updateLibTree((String)keys.get(i3), true);
                ++i3;
            }
        }
        catch (RemoteException rex) {
            rex.printStackTrace();
            ErrorDialog.showErrorDialog(this.frame, "Error occured during refresh from server", rex);
        }
        this.disableButtons();
    }

    private void refreshDSNode(DefaultMutableTreeNode node) {
        JDBCDescriptor descr = (JDBCDescriptor)node.getUserObject();
        this.updateDriversPanel(descr);
        this.updateSettingsPanel(descr, false);
        this.updateMonitoringPanel(descr);
        this.exportBtn.setEnabled(true);
        Vector dsVtr = (Vector)this.datasources.get(this.appNameField.getText());
        if (dsVtr != null && dsVtr.size() > 1) {
            this.removeBtn.setEnabled(true);
        }
        this.copyBtn.setEnabled(true);
        this.pasteBtn.setEnabled(this.clipbrdDescr != null);
        this.enableComponentsForDefaultDS();
    }

    private void disableComponentsForDefaultDS() {
        this.disableListeners();
        this.driverComboBox.setEnabled(false);
        this.jdbcVerComboBox.setEnabled(false);
        this.driverField.setText("**********");
        this.driverField.setEnabled(false);
        this.urlField.setText("**********");
        this.urlField.setEnabled(false);
        this.userField.setText("**********");
        this.userField.setEnabled(false);
        ((JTextComponent)this.passField).setText("**********");
        this.passField.setEnabled(false);
        this.descrField.setEnabled(false);
        this.propertyEditor.setEnabled(false);
        this.openSQLButton.setEnabled(false);
        this.nativeSQLButton.setEnabled(false);
        this.vendorSQLButton.setEnabled(false);
        this.enableListeners();
    }

    private void enableComponentsForDefaultDS() {
        this.disableListeners();
        this.driverComboBox.setEnabled(true);
        this.jdbcVerComboBox.setEnabled(true);
        this.driverField.setEnabled(true);
        this.urlField.setEnabled(true);
        this.userField.setEnabled(true);
        this.passField.setEnabled(true);
        this.descrField.setEnabled(true);
        this.propertyEditor.setEnabled(true);
        this.openSQLButton.setEnabled(true);
        this.nativeSQLButton.setEnabled(true);
        this.vendorSQLButton.setEnabled(true);
        this.enableListeners();
    }

    private void disableButtons() {
        this.exportBtn.setEnabled(false);
        this.newBtn.setEnabled(false);
        this.removeBtn.setEnabled(false);
        this.saveBtn.setEnabled(false);
        this.startBtn.setEnabled(false);
        this.stopBtn.setEnabled(false);
        this.copyBtn.setEnabled(false);
        this.pasteBtn.setEnabled(false);
        this.defDrvBtn.setEnabled(false);
        this.undefDrvBtn.setEnabled(false);
    }

    private void updateDriversPanel(JDBCDescriptor descr) {
        this.driverComboBox.removeItemListener(this);
        if (descr != null) {
            String driver = descr.getDriverName();
            if (driver != null) {
                this.driverComboBox.setSelectedItem(driver);
            }
        } else {
            this.driverComboBox.setSelectedIndex(-1);
        }
        this.driverComboBox.addItemListener(this);
    }

    private int updateDrvTree(String driverName, boolean treeInit) {
        DefaultMutableTreeNode driverNode = new DefaultMutableTreeNode(driverName, true);
        String[] files = (String[])this.drivers.get(driverName);
        int i = 0;
        while (i < files.length) {
            if (files[i].indexOf(File.separatorChar) != -1) {
                driverNode.add(new DefaultMutableTreeNode(files[i].substring(files[i].lastIndexOf(File.separatorChar) + 1), false));
            } else {
                driverNode.add(new DefaultMutableTreeNode(files[i], false));
            }
            ++i;
        }
        int index = 0;
        if (!treeInit) {
            Enumeration enumeration = this.drivers.keys();
            index = this.getIndex(enumeration, driverName);
        }
        this.resTreeModel.insertNodeInto(driverNode, this.drvNode, index);
        this.drvNodes.put(driverName, driverNode);
        this.resTree.expandRow(0);
        return index;
    }

    private void updateLibTree(String libraryName, boolean treeInit) {
        DefaultMutableTreeNode libraryNode = new DefaultMutableTreeNode(libraryName, true);
        String[] files = (String[])this.libraries.get(libraryName);
        int i = 0;
        while (i < files.length) {
            if (files[i].indexOf(File.separatorChar) != -1) {
                libraryNode.add(new DefaultMutableTreeNode(files[i].substring(files[i].lastIndexOf(File.separatorChar) + 1), false));
            } else {
                libraryNode.add(new DefaultMutableTreeNode(files[i], false));
            }
            ++i;
        }
        int index = 0;
        if (!treeInit) {
            Enumeration enumeration = this.libraries.keys();
            index = this.getIndex(enumeration, libraryName);
        }
        this.libTreeModel.insertNodeInto(libraryNode, this.libTreeRoot, index);
        this.libNodes.put(libraryName, libraryNode);
        this.libTree.expandRow(0);
    }

    private int updateDSTree(String appName, boolean treeInit) {
        DefaultMutableTreeNode appDSNode = new DefaultMutableTreeNode(appName, true);
        Vector allDescr = (Vector)this.datasources.get(appName);
        Enumeration enumeration = allDescr.elements();
        while (enumeration.hasMoreElements()) {
            JDBCDescriptor descr = (JDBCDescriptor)enumeration.nextElement();
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(descr, false);
            appDSNode.add(child);
            this.dsNodes.put(descr.getDataSourceName(), child);
        }
        int index = 0;
        if (!treeInit) {
            Enumeration enumeration2 = this.datasources.keys();
            index = this.getIndex(enumeration2, appName);
        }
        this.resTreeModel.insertNodeInto(appDSNode, this.dsNode, index);
        this.appNodes.put(appName, appDSNode);
        this.resTree.expandRow(0);
        return index;
    }

    private void updateSettingsPanel(JDBCDescriptor descr, boolean fromPaste) {
        this.disableListeners();
        if (descr == null) {
            this.appNameField.setText("");
            this.appNameField.setEditable(true);
            this.nameField.setText("");
            this.nameField.setEditable(true);
            this.descrField.setText("");
            this.urlField.setText("");
            this.userField.setText("");
            ((JTextComponent)this.passField).setText("");
            this.driverField.setText("");
            this.factoryField.setText("");
            this.cpdsNameField.setText("");
            this.xadsNameField.setText("");
            this.initConnField.setValue(0);
            this.maxConnField.setValue(25);
            this.ttwConnField.setValue(60);
            this.aliasesPanel.setTableContents(null);
            this.propertyEditor.initProperties(new Properties());
            this.openSQLButton.setSelected(true);
            this.updateIsoCBox();
            this.expCheckBox.setSelected(false);
            this.connLifeField.setValue(0);
            this.runThreadField.setValue(0);
            this.expAction();
            this.statementsPanel.initList(null);
        } else {
            if (fromPaste) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.resTree.getLastSelectedPathComponent();
                if (node.equals(this.dsNode)) {
                    this.appNameField.setText(this.getAppNameFromJDBCDescriptor(descr));
                    this.appNameField.setEditable(true);
                    this.nameField.setText(descr.getDataSourceName());
                    this.nameField.setEditable(true);
                } else if (node.getParent().equals(this.dsNode) && !node.equals(this.sysDSNode)) {
                    this.nameField.setText(descr.getDataSourceName());
                    this.nameField.setEditable(true);
                }
            } else {
                this.appNameField.setText(this.getAppNameFromJDBCDescriptor(descr));
                this.appNameField.setEditable(false);
                this.nameField.setText(descr.getDataSourceName());
                this.nameField.setEditable(false);
            }
            this.descrField.setText(descr.getDescription() != null ? descr.getDescription() : "");
            this.urlField.setText(descr.getURL() != null ? descr.getURL() : "");
            this.driverField.setText(descr.getDriverClassName() != null ? descr.getDriverClassName() : "");
            this.userField.setText(descr.getUsername() != null ? descr.getUsername() : "");
            ((JTextComponent)this.passField).setText(descr.getPassword() != null ? descr.getPassword() : "");
            this.aliasesPanel.setTableContents(this.getAllDSAliases(descr));
            try {
                JDBCDescriptor sysDSDescr = this.dsManager.getSystemDataSourceDescriptor();
                if (sysDSDescr != null) {
                    if (descr.getDataSourceName().equals(sysDSDescr.getDataSourceName())) {
                        this.maxConnField.setMinimumValue(3);
                    } else {
                        this.maxConnField.setMinimumValue(1);
                    }
                }
            }
            catch (RemoteException rex) {
                LOCATION.traceThrowableT(500, "Unexpected exception", (Throwable)rex);
            }
            this.maxConnField.setValue(descr.getMaxConnections());
            this.initConnField.setValue(descr.getInitConnections());
            this.ttwConnField.setValue(descr.getMaxTimeToWaitConn());
            if (descr.isExpControlEnabled()) {
                this.expCheckBox.setSelected(true);
                this.expAction();
                this.connLifeField.setValue(descr.getConnLifetime());
                this.runThreadField.setValue(descr.getRunCleanupThread());
            } else {
                this.expCheckBox.setSelected(false);
                this.connLifeField.setValue(0);
                this.runThreadField.setValue(0);
                this.expAction();
            }
            if (descr.isOpenSQL()) {
                this.openSQLButton.setSelected(true);
            } else if (descr.isNativeSQL()) {
                this.nativeSQLButton.setSelected(true);
            } else {
                this.vendorSQLButton.setSelected(true);
            }
            int isoLvl = descr.getIsolationLevel();
            switch (isoLvl) {
                case -1: {
                    this.isolation.setSelectedItem(PropsEditorView.OPEN_SQL_ISOLATION_COMBO[0]);
                    this.isoCBoxLastSel = PropsEditorView.OPEN_SQL_ISOLATION_COMBO[0];
                    break;
                }
                case 0: {
                    this.isolation.setSelectedItem(PropsEditorView.THE_REST_ISOLATION_VALUES[0]);
                    this.isoCBoxLastSel = PropsEditorView.THE_REST_ISOLATION_VALUES[0];
                    break;
                }
                case 1: {
                    this.isolation.setSelectedItem(PropsEditorView.OPEN_SQL_ISOLATION_COMBO[1]);
                    this.isoCBoxLastSel = PropsEditorView.OPEN_SQL_ISOLATION_COMBO[1];
                    break;
                }
                case 2: {
                    this.isolation.setSelectedItem(PropsEditorView.OPEN_SQL_ISOLATION_COMBO[2]);
                    this.isoCBoxLastSel = PropsEditorView.OPEN_SQL_ISOLATION_COMBO[2];
                    break;
                }
                case 4: {
                    this.isolation.setSelectedItem(PropsEditorView.THE_REST_ISOLATION_VALUES[1]);
                    this.isoCBoxLastSel = PropsEditorView.THE_REST_ISOLATION_VALUES[1];
                    break;
                }
                case 8: {
                    this.isolation.setSelectedItem(PropsEditorView.THE_REST_ISOLATION_VALUES[2]);
                    this.isoCBoxLastSel = PropsEditorView.THE_REST_ISOLATION_VALUES[2];
                }
            }
            this.updateIsoCBox();
            this.factoryField.setText(descr.getObjectFactory() != null ? descr.getObjectFactory() : "");
            this.cpdsNameField.setText(descr.getCPDSClassName() != null ? descr.getCPDSClassName() : "");
            this.xadsNameField.setText(descr.getXADSClassName() != null ? descr.getXADSClassName() : "");
            if (descr.isNewDriver()) {
                this.jdbcVerComboBox.setSelectedIndex(1);
                this.verCBoxLastSel = PropsEditorView.JDBC_VER_COMBO[1];
                this.propertyEditor.initProperties(descr.getProps20());
            } else {
                this.jdbcVerComboBox.setSelectedIndex(0);
                this.verCBoxLastSel = PropsEditorView.JDBC_VER_COMBO[0];
                this.propertyEditor.initProperties(descr.getProps1x());
            }
            if (descr.isXADS()) {
                this.cpdsComboBox.setSelectedIndex(1);
                this.cpdsCBoxLastSel = PropsEditorView.XADS_CPDS_COMBO[1];
            } else {
                this.cpdsComboBox.setSelectedIndex(0);
                this.cpdsCBoxLastSel = PropsEditorView.XADS_CPDS_COMBO[0];
            }
            this.updateJDBCPanels();
            this.updateCPDSPanel();
            this.statementsPanel.initList((StatementEntry[])this.dbInitStatements.get(descr.getDataSourceName()));
        }
        this.enableListeners();
    }

    private void updateMonitoringPanel(JDBCDescriptor descr) {
        if (this.mt != null) {
            this.mt.kill();
            if (descr != null) {
                while (this.mt.isDead() == null) {
                    try {
                        Thread.sleep(3L);
                    }
                    catch (InterruptedException iex) {
                        if (this.mt.isDead() != null) break;
                    }
                }
            }
            this.mt = null;
        }
        if (descr != null) {
            this.mt = new MonitoringThread(this.frame, this.diagramsPanel, this.doubleDiagram, this.dsManager, descr.getDataSourceName(), descr.getMaxConnections());
            new Thread(this.mt).start();
        }
    }

    private String getLibraryName() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.libTree.getLastSelectedPathComponent();
        if (node != null && node != this.libTreeRoot) {
            if (node.getParent().equals(this.libTreeRoot)) {
                return node.getUserObject().toString();
            }
            return ((DefaultMutableTreeNode)node.getParent()).getUserObject().toString();
        }
        return "";
    }

    private void addDriver(String driver) {
        block12: {
            boolean flag = false;
            boolean selected1file = false;
            try {
                if (!this.checkDriver(driver)) {
                    String[] fileNames = new String[]{};
                    do {
                        flag = false;
                        String[] tempNames = this.cfc.showFileDialog("Choose a .jar file...", CFileChooser.LAST_DIR, false);
                        if (tempNames != null) {
                            int i = 0;
                            while (i < tempNames.length) {
                                File file = new File(tempNames[i]);
                                if (!file.exists()) {
                                    JOptionPane.showMessageDialog(this.frame, "file : " + file.getName() + " doesn't exists", "Error", 0);
                                    flag = true;
                                    break;
                                }
                                ++i;
                            }
                        } else {
                            if (selected1file) {
                                if (JOptionPane.showConfirmDialog(this.frame, "Do you want the files, already selected, to be kept ?", "Confirmation", 0) == 0) break;
                                return;
                            }
                            return;
                        }
                        if (flag) continue;
                        String[] oldData = fileNames;
                        fileNames = new String[oldData.length + tempNames.length];
                        System.arraycopy(oldData, 0, fileNames, 0, oldData.length);
                        System.arraycopy(tempNames, 0, fileNames, oldData.length, tempNames.length);
                        selected1file = true;
                    } while (JOptionPane.showConfirmDialog(this.frame, "Do you want to select other files?", "Confirmation", 0) == 0 && !flag);
                    SerializableFile[] files = new SerializableFile[fileNames.length];
                    int i = 0;
                    while (i < fileNames.length) {
                        files[i] = new SerializableFile(fileNames[i]);
                        ++i;
                    }
                    this.dsManager.deployJdbcDriver(driver, files);
                    this.drivers.put(driver, fileNames);
                    this.driverComboBox.insertItemAt(driver, this.updateDrvTree(driver, false));
                    this.libraries.put(driver, fileNames);
                    this.updateLibTree(driver, false);
                    break block12;
                }
                if (JOptionPane.showConfirmDialog(this.frame, "Driver with this name already exists. Do you want to overwrite it?", "Confirmation", 0) != 0) {
                    return;
                }
                this.removeDriver((DefaultMutableTreeNode)this.drvNodes.get(driver), true);
                this.addDriver(driver);
            }
            catch (RemoteException rex) {
                ErrorDialog.showErrorDialog(this.frame, "Error occured during checkDriver and/or registerDriver", rex);
                return;
            }
        }
    }

    private void removeAppNode(String appName) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.appNodes.remove(appName);
        if (node != null) {
            Enumeration<TreeNode> enumeration = node.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
                JDBCDescriptor descr = (JDBCDescriptor)child.getUserObject();
                this.dsNodes.remove(descr.getDataSourceName());
            }
            this.resTreeModel.removeNodeFromParent(node);
            this.resTree.getSelectionModel().setSelectionPath(this.dsNodePath);
        }
    }

    private void removeDriver(DefaultMutableTreeNode node, boolean delete) {
        String driver = node.getUserObject().toString();
        try {
            if (delete) {
                this.dsManager.undeployJdbcDriver(driver);
                this.libNodes.remove(driver);
                this.resTree.getSelectionModel().setSelectionPath(this.drvNodePath);
            } else {
                this.dsManager.undefineJdbcDriver(driver);
                this.libraries.put(driver, this.drivers.get(driver));
                this.updateLibTree(driver, false);
                this.libTree.setSelectionPath(new TreePath(new Object[]{this.libTreeRoot, this.libNodes.get(driver)}));
            }
            this.driverComboBox.removeItem(driver);
            this.resTreeModel.removeNodeFromParent(node);
            this.drivers.remove(driver);
            this.drvNodes.remove(driver);
        }
        catch (RemoteException rex) {
            ErrorDialog.showErrorDialog(this.frame, "Error occured while removing '" + driver + "' driver", rex);
            return;
        }
    }

    private JDBCDescriptor getJDBCDescriptorFromGui() {
        JDBCDescriptor descr = new JDBCDescriptor();
        descr.setDataSourceName(this.nameField.getText());
        descr.setDescription(this.descrField.getText());
        String[] aliases = this.aliasesPanel.getListDataArray();
        descr.setAliases(aliases == null ? new String[]{} : aliases);
        descr.setDriverName((String)this.driverComboBox.getSelectedItem());
        descr.setInitConnections(this.initConnField.getValue());
        descr.setMaxConnections(this.maxConnField.getValue());
        descr.setMaxTimeToWaitConn(this.ttwConnField.getValue());
        Object isolationOption = this.isolation.getSelectedItem();
        if (isolationOption.equals(PropsEditorView.OPEN_SQL_ISOLATION_COMBO[0])) {
            descr.setIsolationLevel(-1);
        } else if (isolationOption.equals(PropsEditorView.OPEN_SQL_ISOLATION_COMBO[1])) {
            descr.setIsolationLevel(1);
        } else if (isolationOption.equals(PropsEditorView.OPEN_SQL_ISOLATION_COMBO[2])) {
            descr.setIsolationLevel(2);
        } else if (isolationOption.equals(PropsEditorView.THE_REST_ISOLATION_VALUES[0])) {
            descr.setIsolationLevel(0);
        } else if (isolationOption.equals(PropsEditorView.THE_REST_ISOLATION_VALUES[1])) {
            descr.setIsolationLevel(4);
        } else if (isolationOption.equals(PropsEditorView.THE_REST_ISOLATION_VALUES[2])) {
            descr.setIsolationLevel(8);
        }
        if (this.expCheckBox.isSelected()) {
            descr.setConnLifetime(this.connLifeField.getValue());
            descr.setRunCleanupThread(this.runThreadField.getValue());
        }
        if (this.openSQLButton.isSelected()) {
            descr.setSQLEngine("open_sql");
        } else if (this.nativeSQLButton.isSelected()) {
            descr.setSQLEngine("native_sql");
        } else {
            descr.setSQLEngine("vendor_sql");
        }
        int jdbcIndex = this.jdbcVerComboBox.getSelectedIndex();
        if (jdbcIndex == 0) {
            descr.setNewDriver(false);
            descr.setUsername(this.userField.getText());
            descr.setPassword(new String(this.passField.getPassword()));
            descr.setURL(this.urlField.getText());
            descr.setDriverClassName(this.driverField.getText());
            descr.setProps1x(this.propertyEditor.getProps());
        }
        if (jdbcIndex == 1) {
            descr.setNewDriver(true);
            descr.setObjectFactory(this.factoryField.getText());
            descr.setProps20(this.propertyEditor.getProps());
            int cpdsIndex = this.cpdsComboBox.getSelectedIndex();
            if (cpdsIndex == 0) {
                descr.setCPDSClassName(this.cpdsNameField.getText());
                descr.setXADS(false);
            }
            if (cpdsIndex == 1) {
                descr.setXADSClassName(this.xadsNameField.getText());
                descr.setXADS(true);
            }
        }
        return descr;
    }

    /*
     * Unable to fully structure code
     */
    private Vector getAllDSAliases(JDBCDescriptor descr) {
        allDSAliases = new Vector<String[]>();
        intAliases = descr.getAliases();
        i = 0;
        while (i < intAliases.length) {
            allDSAliases.add(new String[]{intAliases[i], descr.getDataSourceName().concat(" DataSource")});
            ++i;
        }
        enum = this.aliases.keys();
        while (enum.hasMoreElements()) {
            appName = (String)enum.nextElement();
            ds = (Hashtable)this.aliases.get(appName);
            intEnum = ds.keys();
            while (intEnum.hasMoreElements()) {
                dsName = (String)intEnum.nextElement();
                if (!dsName.equals(descr.getDataSourceName())) continue;
                aliasesArray = (String[])ds.get(dsName);
                deployer = appName.endsWith(" Service") != false || appName.endsWith(" Library") != false ? appName : appName.concat(" Application");
                i = 0;
                while (i < aliasesArray.length) {
                    if (deployer.endsWith(" Application")) {
                        try {
                            if (!this.dsManager.isApplicationStarted(appName)) {
                            }
                            ** break block9
                        }
                        catch (RemoteException rex) {
                            PropsEditorLogical.LOCATION.traceThrowableT(500, "Unexpected exception", (Throwable)rex);
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        allDSAliases.add(new String[]{aliasesArray[i], deployer});
                    }
                    ++i;
                }
            }
        }
        return allDSAliases;
    }

    private void saveChanges() {
        if (this.saveBtn.isEnabled() && JOptionPane.showConfirmDialog(this.frame, SAVE_CHANGES, "Question", 0) == 0) {
            this.saveAction(this.lastSelectedDSNode);
        }
    }

    protected void clearAll() {
        if (this.datasources != null) {
            this.datasources.clear();
        }
        if (this.drivers != null) {
            this.drivers.clear();
        }
        if (this.libraries != null) {
            this.libraries.clear();
        }
        this.sysDSNode = null;
        this.resTree.removeTreeSelectionListener(this);
        this.dsNode.removeAllChildren();
        this.drvNode.removeAllChildren();
        this.libTreeRoot.removeAllChildren();
        this.resTreeModel.reload();
        this.libTreeModel.reload();
        this.resTree.addTreeSelectionListener(this);
        this.driverComboBox.removeAllItems();
        this.clearTabPane();
        this.updateDriversPanel(null);
        this.updateSettingsPanel(null, false);
        this.updateMonitoringPanel(null);
    }

    private boolean checkDriver(String driverName) {
        Enumeration enumeration = this.drivers.keys();
        while (enumeration.hasMoreElements()) {
            String curName = (String)enumeration.nextElement();
            if (!driverName.equals(curName)) continue;
            return true;
        }
        return false;
    }

    private int getIndex(Enumeration enumeration, String nodeName) {
        int pos = 0;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String curName = enumeration.nextElement().toString();
                if (nodeName.compareTo(curName) <= 0) continue;
                ++pos;
            }
        }
        return pos;
    }

    private void updateJDBCPanels() {
        int index = this.jdbcVerComboBox.getSelectedIndex();
        if (index == 0) {
            this.addJDBCPanel1x();
        } else if (index == 1) {
            this.addJDBCPanel20();
        }
    }

    private void updateCPDSPanel() {
        int index = this.cpdsComboBox.getSelectedIndex();
        if (index == 0) {
            this.addCPDSPanel();
        } else if (index == 1) {
            this.addXADSPanel();
        }
    }

    private void updateIsoCBox() {
        if (this.openSQLButton.isSelected()) {
            if (this.isolationModel.getSize() > 3) {
                Object curIsoSel = this.isolationModel.getSelectedItem();
                if (curIsoSel.equals(PropsEditorView.THE_REST_ISOLATION_VALUES[0]) || curIsoSel.equals(PropsEditorView.THE_REST_ISOLATION_VALUES[1]) || curIsoSel.equals(PropsEditorView.THE_REST_ISOLATION_VALUES[2])) {
                    this.isolationModel.setSelectedItem(PropsEditorView.OPEN_SQL_ISOLATION_COMBO[0]);
                }
                this.isolationModel.removeElement(PropsEditorView.THE_REST_ISOLATION_VALUES[0]);
                this.isolationModel.removeElement(PropsEditorView.THE_REST_ISOLATION_VALUES[1]);
                this.isolationModel.removeElement(PropsEditorView.THE_REST_ISOLATION_VALUES[2]);
            }
        } else if (this.isolationModel.getSize() < 6) {
            this.isolationModel.insertElementAt(PropsEditorView.THE_REST_ISOLATION_VALUES[0], 1);
            this.isolationModel.addElement(PropsEditorView.THE_REST_ISOLATION_VALUES[1]);
            this.isolationModel.addElement(PropsEditorView.THE_REST_ISOLATION_VALUES[2]);
        }
        this.isoCBoxLastSel = PropsEditorView.OPEN_SQL_ISOLATION_COMBO[0];
    }

    private String getAppNameFromJDBCDescriptor(JDBCDescriptor descr) {
        Enumeration htEnum = this.datasources.keys();
        while (htEnum.hasMoreElements()) {
            String appName = (String)htEnum.nextElement();
            Enumeration vecEnum = ((Vector)this.datasources.get(appName)).elements();
            while (vecEnum.hasMoreElements()) {
                JDBCDescriptor curDescr = (JDBCDescriptor)vecEnum.nextElement();
                if (!curDescr.equals(descr)) continue;
                return appName;
            }
        }
        return "";
    }

    private ArrayObject sortKeys(Hashtable ht) {
        Enumeration keysEnum = ht.keys();
        ArrayObject keys = new ArrayObject();
        while (keysEnum.hasMoreElements()) {
            keys.add(keysEnum.nextElement());
        }
        if (keys.size() > 0) {
            keys.sort(true);
        }
        return keys;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

