/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.gui;

import com.sap.engine.services.dbpool.gui.PropertiesTableModel;
import com.sap.engine.services.dbpool.gui.PropertyEditorView;
import com.sap.engine.services.dbpool.gui.TableEntry;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.JTextComponent;

public class PropertyEditor
extends PropertyEditorView {
    protected PropertiesTableModel tableModel;
    protected Properties props;
    protected ChangeListener listener;

    public PropertyEditor() {
        this.tableModel = new PropertiesTableModel();
        this.initEditor();
    }

    public PropertyEditor(String keyColumnName, String valueColumnName) {
        this.tableModel = new PropertiesTableModel(keyColumnName, valueColumnName);
        this.keyLabel.setText(keyColumnName + " :");
        this.valueLabel.setText(valueColumnName + " :");
        this.initEditor();
    }

    public void changedUpdate(DocumentEvent de) {
        this.encryptionCheck();
    }

    public void insertUpdate(DocumentEvent de) {
        this.encryptionCheck();
    }

    public void removeUpdate(DocumentEvent de) {
        this.encryptionCheck();
    }

    private void encryptionCheck() {
        if ("password".equalsIgnoreCase(this.keyTextField.getText())) {
            if (this.valueTextField.getEchoChar() != '*') {
                this.valueTextField.setEchoChar('*');
                this.valueTextField.repaint();
            }
        } else if (this.valueTextField.getEchoChar() != '\u0000') {
            this.valueTextField.setEchoChar('\u0000');
            ((JTextComponent)this.valueTextField).setText("");
        }
    }

    public void setChangeListener(ChangeListener cl) {
        this.listener = cl;
    }

    private void initEditor() {
        this.table.setModel(this.tableModel);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.keyTextField.addKeyListener(this);
        this.valueTextField.addKeyListener(this);
    }

    public void setFrame(Frame frame) {
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("ADD_CMD")) {
            this.addBtnAction();
        }
        if (cmd.equals("REMOVE_CMD")) {
            this.removeBtnAction();
        }
    }

    private void addBtnAction() {
        String key = this.keyTextField.getText().trim();
        if (key.length() == 0) {
            return;
        }
        this.tableModel.addRow(key, new TableEntry(new String(this.valueTextField.getPassword()), "password".equalsIgnoreCase(key)));
        this.keyTextField.setText("");
        ((JTextComponent)this.valueTextField).setText("");
        this.keyTextField.requestFocus();
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
    }

    private void removeBtnAction() {
        int selRow = this.table.getSelectedRow();
        this.table.editingStopped(new ChangeEvent(this.table));
        this.tableModel.removeRow(selRow);
        if (selRow >= this.table.getRowCount() && this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(this.table.getRowCount() - 1, this.table.getRowCount() - 1);
        } else {
            this.table.getSelectionModel().clearSelection();
        }
        this.table_valueChanged();
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e == null || e.getValueIsAdjusting()) {
            return;
        }
        this.table_valueChanged();
    }

    private void table_valueChanged() {
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            this.removeButton.setEnabled(false);
            return;
        }
        this.removeButton.setEnabled(true);
        this.keyTextField.setText((String)this.tableModel.getValueAt(row, 0));
        ((JTextComponent)this.valueTextField).setText(((TableEntry)this.tableModel.getValueAt(row, 1)).getText());
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.addBtnAction();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void initProperties(Properties properties) {
        this.tableModel.clearAll();
        this.keyTextField.setText("");
        ((JTextComponent)this.valueTextField).setText("");
        this.table.getSelectionModel().clearSelection();
        if (properties == null) {
            return;
        }
        this.props = properties;
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String key = (String)propNames.nextElement();
            this.tableModel.addRow(key, new TableEntry(properties.getProperty(key), "password".equalsIgnoreCase(key)));
        }
    }

    public Properties getProps() {
        Properties properties = new Properties();
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            properties.setProperty((String)this.tableModel.getValueAt(i, 0), ((TableEntry)this.tableModel.getValueAt(i, 1)).getText());
            ++i;
        }
        return properties;
    }

    public boolean isChanged() {
        Properties properties = this.getProps();
        if (this.props == null && properties == null) {
            return false;
        }
        if (this.props == null || properties == null || ((Hashtable)this.props).size() != ((Hashtable)properties).size()) {
            return true;
        }
        return !((Hashtable)this.props).equals(properties);
    }
}

