/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.gui;

import com.sap.engine.gui.diagram.DoubleDiagramPanel;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import com.sap.engine.services.dbpool.gui.ErrorDialog;
import java.awt.Color;
import java.awt.Frame;
import java.rmi.RemoteException;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class MonitoringThread
implements Runnable {
    private DataSourceManager dsManager;
    private Frame frame;
    private String dsName;
    private DoubleDiagramPanel ddp;
    private JPanel diagramsPanel;
    private Object isAlive;
    private Object isKilled;

    public MonitoringThread(Frame _frame, JPanel _diagramsPanel, DoubleDiagramPanel _ddp, DataSourceManager _dsManager, String _dsName, int max) {
        this.frame = _frame;
        this.diagramsPanel = _diagramsPanel;
        this.ddp = _ddp;
        this.dsManager = _dsManager;
        this.dsName = _dsName;
        this.ddp.reset();
        TitledBorder doubleBorder = new TitledBorder(" Connections for '" + this.dsName + "' DataSource: (green: free; red: used)");
        doubleBorder.setTitleColor(Color.yellow);
        this.ddp.setBorder(doubleBorder);
        this.ddp.setMaxValues(max, max);
        this.ddp.setColors(Color.green, Color.red);
        this.diagramsPanel.add(this.ddp);
        this.diagramsPanel.repaint();
        this.isAlive = new Object();
        this.isKilled = null;
    }

    public void run() {
        try {
            while (this.isAlive != null) {
                int freeConnCount = this.dsManager.getCurrentSize(this.dsName);
                int usedConnCount = this.dsManager.getUsedConnectionsCount(this.dsName);
                if (freeConnCount > -1 && usedConnCount > -1) {
                    this.ddp.setValue(freeConnCount, usedConnCount);
                    Thread.sleep(100L);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException ie) {
            ErrorDialog.showErrorDialog(this.frame, "InterruptedException in MonitoringThread.", ie);
        }
        catch (RemoteException rex) {
            ErrorDialog.showErrorDialog(this.frame, "Error occured while getting status of connections for '" + this.dsName + "' DataSource.", rex);
        }
        this.diagramsPanel.removeAll();
        this.diagramsPanel.repaint();
        this.isKilled = new Object();
    }

    public void kill() {
        this.isAlive = null;
    }

    public Object isDead() {
        return this.isKilled;
    }
}

