/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ErrorDialog
extends JDialog
implements ActionListener {
    private static final String OK_COMMAND = "ok";
    private static final String DETAILS_COMMAND = "det";
    private static final String PANEL_OPENED = "Details <<";
    private static final String PANEL_CLOSED = "Details >>";
    private static final int MAX_HEIGHT = 200;
    private static final int MAX_WIDTH = 300;
    private JButton detailsButton;
    private JPanel excPanel;
    private JPanel addPanel;

    private ErrorDialog(Frame frame, String message, String exception) {
        super(frame, "Error", true);
        Container cont = this.getContentPane();
        cont.setLayout(new GridBagLayout());
        cont.add((Component)new JLabel(new ImageIcon(this.getClass().getResource("images/error.gif"))), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 5), 0, 0));
        cont.add((Component)new JLabel(message){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (size.width > 300) {
                    size.width = 300;
                }
                return size;
            }
        }, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 10, 10), 0, 0));
        JPanel buttons = new JPanel();
        JButton okButton = new JButton("OK");
        okButton.setActionCommand(OK_COMMAND);
        okButton.addActionListener(this);
        buttons.add(okButton);
        this.detailsButton = new JButton(PANEL_CLOSED);
        this.detailsButton.setActionCommand(DETAILS_COMMAND);
        this.detailsButton.addActionListener(this);
        buttons.add(this.detailsButton);
        cont.add((Component)buttons, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, new Insets(2, 10, 4, 10), 0, 0));
        this.addPanel = new JPanel();
        cont.add((Component)this.addPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        JTextArea text = new JTextArea(exception){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension size = super.getPreferredScrollableViewportSize();
                if (size.height > 200) {
                    size.height = 200;
                }
                if (size.width > 300) {
                    size.width = 300;
                }
                return size;
            }
        };
        text.setEditable(false);
        this.excPanel = new JPanel(new BorderLayout());
        this.excPanel.setVisible(false);
        this.excPanel.setBorder(BorderFactory.createTitledBorder("Exception"));
        this.excPanel.add(new JScrollPane(text));
        cont.add((Component)this.excPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.pack();
        this.setLocationRelativeTo(frame);
        this.show();
    }

    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyChar() == '\u001b' || e.getKeyChar() == '\n') {
            this.dispose();
        } else {
            super.processKeyEvent(e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(OK_COMMAND)) {
            this.dispose();
        } else {
            if (this.detailsButton.getLabel().equals(PANEL_CLOSED)) {
                this.detailsButton.setLabel(PANEL_OPENED);
                this.addPanel.setVisible(false);
                this.excPanel.setVisible(true);
            } else {
                this.detailsButton.setLabel(PANEL_CLOSED);
                this.excPanel.setVisible(false);
                this.addPanel.setVisible(true);
            }
            this.pack();
        }
    }

    public static void showErrorDialog(Frame frame, String message, String exception) {
        new ErrorDialog(frame, message, exception);
    }

    public static void showErrorDialog(Frame frame, String message, Throwable exception) {
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        new ErrorDialog(frame, message, writer.toString());
    }
}

