/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.deploy;

import com.sap.engine.services.deploy.ear.common.CloneUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class JDBCDescriptor
implements Serializable {
    static final long serialVersionUID = -558970533333168525L;
    public static final int DEFAULT_MAX_CONNECTIONS_NUMBER = 25;
    public static final int DEFAULT_MAX_TIME_TO_WAIT_FOR_CONNECTION = 60;
    public static final String DEFAULT_SQL_ENGINE = "open_sql";
    public static final String CONFIDENTIAL_DATA = "**********";
    private String description = null;
    private String driverName = null;
    private String dataSourceName = null;
    private String[] aliases = null;
    private int maxConnections = 25;
    private int isolationLevel = -1;
    private int initConnections = 0;
    private int maxTimeToWaitConn = 60;
    private boolean newDriver = false;
    private String driverClassName = null;
    private String url = null;
    private String username = null;
    private String password = null;
    private String cpdsClassName = null;
    private String xadsClassName = null;
    private boolean xadsFlag = false;
    private String objectFactory = null;
    private Properties props20 = null;
    private Properties props1x = null;
    private int connLifetime = 0;
    private int runCleanupThread = 0;
    private String sqlEngine = "open_sql";
    private boolean defaultDSFlag = false;
    private String dbConnectInfo = null;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String _description) {
        this.description = _description;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String _dataSourceName) {
        this.dataSourceName = _dataSourceName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driver_name) {
        this.driverName = driver_name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public void setAliases(String[] alses) {
        this.aliases = alses;
    }

    public boolean isNewDriver() {
        return this.newDriver;
    }

    public void setNewDriver(boolean _newDriver) {
        this.newDriver = _newDriver;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String _username) {
        this.username = _username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String _password) {
        this.password = _password;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String _url) {
        this.url = _url;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String _driverClassName) {
        this.driverClassName = _driverClassName;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int _maxConnections) {
        this.maxConnections = _maxConnections;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(int _isolationLevel) {
        this.isolationLevel = _isolationLevel;
    }

    public String getCPDSClassName() {
        return this.cpdsClassName;
    }

    public void setCPDSClassName(String _cpdsClassName) {
        this.cpdsClassName = _cpdsClassName;
    }

    public String getXADSClassName() {
        return this.xadsClassName;
    }

    public void setXADSClassName(String _xadsClassName) {
        this.xadsClassName = _xadsClassName;
    }

    public void setXADS(boolean _xadsFlag) {
        this.xadsFlag = _xadsFlag;
    }

    public boolean isXADS() {
        return this.xadsFlag;
    }

    public String getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(String _objectFactory) {
        this.objectFactory = _objectFactory;
    }

    public Properties getProps20() {
        return this.props20;
    }

    public void setProps20(Properties _props20) {
        this.props20 = _props20;
    }

    public Properties getProps1x() {
        return this.props1x;
    }

    public void setProps1x(Properties _props1x) {
        this.props1x = _props1x;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void setInitConnections(int _initConnections) {
        this.initConnections = _initConnections;
    }

    public int getInitConnections() {
        return this.initConnections;
    }

    public void setMaxTimeToWaitConn(int _maxTimeToWaitConn) {
        this.maxTimeToWaitConn = _maxTimeToWaitConn;
    }

    public int getMaxTimeToWaitConn() {
        return this.maxTimeToWaitConn;
    }

    public void setConnLifetime(int _connLifetime) {
        this.connLifetime = _connLifetime;
    }

    public int getConnLifetime() {
        return this.connLifetime;
    }

    public void setRunCleanupThread(int _runCleanupThread) {
        this.runCleanupThread = _runCleanupThread;
    }

    public int getRunCleanupThread() {
        return this.runCleanupThread;
    }

    public boolean isExpControlEnabled() {
        return this.connLifetime > 0 && this.runCleanupThread > 0;
    }

    public void setSQLEngine(String _sqlEngine) {
        this.sqlEngine = _sqlEngine;
    }

    public String getSQLEngine() {
        return this.sqlEngine;
    }

    public boolean isOpenSQL() {
        return DEFAULT_SQL_ENGINE.equalsIgnoreCase(this.sqlEngine);
    }

    public boolean isNativeSQL() {
        return "native_sql".equalsIgnoreCase(this.sqlEngine);
    }

    public void setDefaultDS(boolean _defaultDSFlag) {
        this.defaultDSFlag = _defaultDSFlag;
    }

    public boolean isDefaultDS() {
        return this.defaultDSFlag;
    }

    public void setDBConnectInfo(String _dbConnectInfo) {
        this.dbConnectInfo = _dbConnectInfo;
    }

    public String getDBConnectInfo() {
        return this.dbConnectInfo;
    }

    private String hidePassword(String pwd) {
        return CONFIDENTIAL_DATA;
    }

    public String getInfo() {
        String isoLvlName;
        StringBuffer sb = new StringBuffer();
        sb.append("\n DataSource name = " + this.dataSourceName);
        sb.append("\n DataSource description = " + (this.description == null ? "not specified" : this.description));
        sb.append("\n Driver library name = " + this.driverName);
        sb.append("\n SQL Engine type = " + this.sqlEngine);
        switch (this.isolationLevel) {
            case 0: {
                isoLvlName = "TRANSACTION_NONE";
                break;
            }
            case 2: {
                isoLvlName = "TRANSACTION_READ_COMMITTED";
                break;
            }
            case 1: {
                isoLvlName = "TRANSACTION_READ_UNCOMMITTED";
                break;
            }
            case 4: {
                isoLvlName = "TRANSACTION_REPEATABLE_READ";
                break;
            }
            case 8: {
                isoLvlName = "TRANSACTION_SERIALIZABLE";
                break;
            }
            default: {
                isoLvlName = "not specified";
            }
        }
        sb.append("\n Connection isolation level = " + isoLvlName);
        sb.append("\n Max connections allowed = " + this.maxConnections);
        sb.append("\n Initial connections number = " + this.initConnections);
        sb.append("\n Max time to wait for connection (in seconds) = " + this.maxTimeToWaitConn);
        sb.append("\n Free connection lifetime (in seconds) = " + this.connLifetime);
        sb.append("\n Cleanup thread starting interval (in seconds) = " + this.runCleanupThread);
        boolean noProps = true;
        if (!this.newDriver) {
            sb.append("\n\n JDBC 1.x connection properties:");
            sb.append("\n   Driver classname = " + (this.defaultDSFlag ? CONFIDENTIAL_DATA : this.driverClassName));
            sb.append("\n   URL = " + (this.defaultDSFlag ? CONFIDENTIAL_DATA : this.url));
            sb.append("\n   User = " + (this.defaultDSFlag ? CONFIDENTIAL_DATA : this.username));
            sb.append("\n   Password = " + this.hidePassword(this.password));
            sb.append("\n\n Additional properties:");
            Enumeration enumeration = ((Hashtable)this.props1x).keys();
            while (enumeration.hasMoreElements()) {
                noProps = false;
                String key = (String)enumeration.nextElement();
                sb.append("\n   " + key + " = " + ("password".equalsIgnoreCase(key) ? this.hidePassword(this.props1x.getProperty(key)) : ((Hashtable)this.props1x).get(key)));
            }
        } else {
            sb.append("\n\n JDBC 2.0 connection properties:");
            sb.append("\n   ObjectFactory classname = " + (this.objectFactory == null ? "not specified" : this.objectFactory));
            if (this.xadsFlag) {
                sb.append("\n   XADataSource classname = " + this.xadsClassName);
            } else {
                sb.append("\n   ConnectionPoolDataSource classname = " + this.cpdsClassName);
            }
            sb.append("\n\n Additional properties:");
            Enumeration enumeration = ((Hashtable)this.props20).keys();
            while (enumeration.hasMoreElements()) {
                noProps = false;
                String key = (String)enumeration.nextElement();
                sb.append("\n   " + key + " = " + ("password".equalsIgnoreCase(key) ? this.hidePassword(this.props20.getProperty(key)) : ((Hashtable)this.props20).get(key)));
            }
        }
        if (noProps) {
            sb.append("\n   no additional properties specified.");
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        boolean bl8;
        JDBCDescriptor descr = (JDBCDescriptor)obj;
        if (this.driverName == null) {
            if (descr.driverName != null) return false;
            bl8 = true;
        } else {
            bl8 = this.driverName.equals(descr.driverName);
        }
        if (!bl8) return false;
        if (this.dataSourceName == null) {
            if (descr.dataSourceName != null) return false;
            bl7 = true;
        } else {
            bl7 = this.dataSourceName.equals(descr.dataSourceName);
        }
        if (!bl7) return false;
        if (this.aliases == null) {
            if (descr.aliases != null) return false;
            bl6 = true;
        } else {
            bl6 = Arrays.equals(this.aliases, descr.aliases);
        }
        if (!bl6) return false;
        if (this.description == null) {
            if (descr.description != null) return false;
            bl5 = true;
        } else {
            bl5 = this.description.equals(descr.description);
        }
        if (!bl5) return false;
        if (this.dbConnectInfo == null) {
            if (descr.dbConnectInfo != null) return false;
            bl4 = true;
        } else {
            bl4 = this.dbConnectInfo.equals(descr.dbConnectInfo);
        }
        if (!bl4) return false;
        if (this.sqlEngine == null) {
            if (descr.sqlEngine != null) return false;
            bl3 = true;
        } else {
            bl3 = this.sqlEngine.equalsIgnoreCase(descr.sqlEngine);
        }
        if (!bl3) return false;
        if (this.maxConnections != descr.maxConnections) return false;
        if (this.isolationLevel != descr.isolationLevel) return false;
        if (this.initConnections != descr.initConnections) return false;
        if (this.maxTimeToWaitConn != descr.maxTimeToWaitConn) return false;
        if (this.connLifetime != descr.connLifetime) return false;
        if (this.runCleanupThread != descr.runCleanupThread) return false;
        if (this.newDriver != descr.newDriver) return false;
        if (this.defaultDSFlag != descr.defaultDSFlag) {
            return false;
        }
        if (!this.newDriver) {
            boolean bl9;
            boolean bl10;
            boolean bl11;
            boolean bl12;
            if (this.driverClassName == null) {
                if (descr.driverClassName != null) return false;
                bl12 = true;
            } else {
                bl12 = this.driverClassName.equals(descr.driverClassName);
            }
            if (!bl12) return false;
            if (this.url == null) {
                if (descr.url != null) return false;
                bl11 = true;
            } else {
                bl11 = this.url.equals(descr.url);
            }
            if (!bl11) return false;
            if (this.username == null) {
                if (descr.username != null) return false;
                bl10 = true;
            } else {
                bl10 = this.username.equals(descr.username);
            }
            if (!bl10) return false;
            if (this.password == null) {
                if (descr.password != null) return false;
                bl9 = true;
            } else {
                bl9 = this.password.equals(descr.password);
            }
            if (!bl9) return false;
            if (this.props1x == null) {
                if (descr.props1x != null) return false;
                return true;
            }
            boolean bl13 = ((Hashtable)this.props1x).equals(descr.props1x);
            if (!bl13) return false;
            return true;
        }
        if (this.xadsFlag) {
            boolean bl14;
            boolean bl15;
            if (this.xadsClassName == null) {
                if (descr.xadsClassName != null) return false;
                bl15 = true;
            } else {
                bl15 = this.xadsClassName.equals(descr.xadsClassName);
            }
            if (!bl15) return false;
            if (this.objectFactory == null) {
                if (descr.objectFactory != null) return false;
                bl14 = true;
            } else {
                bl14 = this.objectFactory.equals(descr.objectFactory);
            }
            if (!bl14) return false;
            if (this.props20 == null) {
                if (descr.props20 != null) return false;
                return true;
            }
            boolean bl16 = ((Hashtable)this.props20).equals(descr.props20);
            if (!bl16) return false;
            return true;
        }
        if (this.cpdsClassName == null) {
            if (descr.cpdsClassName != null) return false;
            bl2 = true;
        } else {
            bl2 = this.cpdsClassName.equals(descr.cpdsClassName);
        }
        if (!bl2) return false;
        if (this.objectFactory == null) {
            if (descr.objectFactory != null) return false;
            bl = true;
        } else {
            bl = this.objectFactory.equals(descr.objectFactory);
        }
        if (!bl) return false;
        if (this.props20 == null) {
            if (descr.props20 != null) return false;
            return true;
        }
        boolean bl17 = ((Hashtable)this.props20).equals(descr.props20);
        if (!bl17) return false;
        return true;
    }

    public String toString() {
        return this.dataSourceName;
    }

    public Object clone() {
        JDBCDescriptor descr = new JDBCDescriptor();
        descr.driverName = this.getDriverName() != null ? new String(this.getDriverName()) : null;
        descr.description = this.getDescription() != null ? new String(this.getDescription()) : null;
        descr.dataSourceName = this.getDataSourceName() != null ? new String(this.getDataSourceName()) : null;
        descr.aliases = CloneUtils.cloneStringArray(this.getAliases());
        descr.sqlEngine = this.getSQLEngine() != null ? new String(this.getSQLEngine()) : null;
        descr.maxConnections = this.getMaxConnections();
        descr.isolationLevel = this.getIsolationLevel();
        descr.initConnections = this.getInitConnections();
        descr.maxTimeToWaitConn = this.getMaxTimeToWaitConn();
        descr.connLifetime = this.getConnLifetime();
        descr.runCleanupThread = this.getRunCleanupThread();
        descr.newDriver = this.isNewDriver();
        descr.defaultDSFlag = this.isDefaultDS();
        descr.dbConnectInfo = this.getDBConnectInfo();
        descr.driverClassName = this.getDriverClassName() != null ? new String(this.getDriverClassName()) : null;
        descr.url = this.getURL() != null ? new String(this.getURL()) : null;
        descr.username = this.getUsername() != null ? new String(this.getUsername()) : null;
        descr.password = this.getPassword() != null ? new String(this.getPassword()) : null;
        descr.props1x = CloneUtils.clonePropertiesString(this.props1x);
        descr.cpdsClassName = this.getCPDSClassName() != null ? new String(this.getCPDSClassName()) : null;
        descr.xadsClassName = this.getXADSClassName() != null ? new String(this.getXADSClassName()) : null;
        descr.xadsFlag = this.isXADS();
        descr.objectFactory = this.getObjectFactory() != null ? new String(this.getObjectFactory()) : null;
        descr.props20 = CloneUtils.clonePropertiesString(this.props20);
        return descr;
    }
}

