/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.deploy;

import com.sap.engine.lib.util.concurrent.CountDown;
import com.sap.engine.services.connector.jca.ResourceSetContextObject;
import com.sap.engine.services.connector.resource.impl.ResourceSetImpl;
import com.sap.engine.services.dbpool.deploy.StatementEntry;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;

public class DBInitializer
implements Runnable {
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$dbpool$deploy$DBInitializer == null ? (class$com$sap$engine$services$dbpool$deploy$DBInitializer = DBInitializer.class$("com.sap.engine.services.dbpool.deploy.DBInitializer")) : class$com$sap$engine$services$dbpool$deploy$DBInitializer));
    private static final int logDebug = 100;
    String dsName;
    StatementEntry[] statements;
    String[] results;
    Throwable throwable;
    CountDown cd;
    static /* synthetic */ Class class$com$sap$engine$services$dbpool$deploy$DBInitializer;

    public DBInitializer(String _dsName, StatementEntry[] _statements, CountDown _cd) {
        this.dsName = _dsName;
        this.statements = _statements;
        this.results = new String[this.statements.length];
        this.cd = _cd;
        this.throwable = null;
    }

    /*
     * Loose catch block
     */
    public void run() {
        block46: {
            Statement stmt;
            Connection conn;
            UserTransaction ut;
            block45: {
                SQLException sex322;
                block44: {
                    InitialContext naming = null;
                    ut = null;
                    DataSource ds = null;
                    conn = null;
                    stmt = null;
                    ResourceSetContextObject.replaceCurrentResourceSet(new ResourceSetImpl("DBInitProcess", this.dsName));
                    Properties contextProps = new Properties();
                    ((Hashtable)contextProps).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                    ((Hashtable)contextProps).put("domain", "true");
                    naming = new InitialContext(contextProps);
                    ut = (UserTransaction)naming.lookup("UserTransaction");
                    ds = (DataSource)naming.lookup("jdbc/" + this.dsName);
                    ut.begin();
                    conn = ds.getConnection();
                    stmt = conn.createStatement();
                    int i = 0;
                    while (i < this.statements.length) {
                        try {
                            String statement = this.statements[i].getStatement().trim();
                            this.results[i] = " Executing: '".concat(statement).concat("':\n");
                            this.results[i] = stmt.execute(statement) ? this.results[i].concat(this.visualizeRS(stmt.getResultSet())) : this.results[i].concat("    The SQL statement did not generate ResultSet.\n");
                        }
                        catch (SQLException sex2) {
                            this.results[i] = this.results[i].concat("    SQLException occured in execution of the SQL statement.");
                            if (this.statements[i].getIgnoreError()) {
                                this.results[i] = this.results[i].concat(" Ignored.\n");
                            }
                            this.results[i] = this.results[i].concat("\n");
                            throw sex2;
                        }
                        ++i;
                    }
                    Object var10_13 = null;
                    if (stmt == null) break block44;
                    try {
                        stmt.close();
                    }
                    catch (SQLException sex322) {
                        if (location.beLogged(500)) {
                            location.logT(500, "DBInitializer.run(): Cannot close Statement. Reason: " + sex322.toString());
                        }
                        if (!location.beLogged(100)) break block44;
                        location.traceThrowableT(100, "Full stacktrace:", (Throwable)sex322);
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sex322) {
                        if (location.beLogged(500)) {
                            location.logT(500, "DBInitializer.run(): Cannot close Connection. Reason: " + sex322.toString());
                        }
                        if (!location.beLogged(100)) break block45;
                        location.traceThrowableT(100, "Full stacktrace:", (Throwable)sex322);
                    }
                }
            }
            try {
                if (ut == null) break block46;
                if (this.throwable == null) {
                    ut.commit();
                    break block46;
                }
                ut.rollback();
            }
            catch (Exception ex) {
                if (location.beLogged(500)) {
                    location.logT(500, "DBInitializer.run(): Cannot commit/rollback UserTransaction. Reason: " + ex.toString());
                }
                if (location.beLogged(100)) {
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)ex);
                }
                break block46;
            }
            {
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (Throwable th) {
                    block48: {
                        SQLException sex322;
                        block47: {
                            if (location.beLogged(100)) {
                                location.traceThrowableT(100, "Full stacktrace:", th);
                            }
                            this.throwable = th;
                            Object var10_14 = null;
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (SQLException sex322) {
                                    if (location.beLogged(500)) {
                                        location.logT(500, "DBInitializer.run(): Cannot close Statement. Reason: " + sex322.toString());
                                    }
                                    if (!location.beLogged(100)) break block47;
                                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)sex322);
                                }
                            }
                        }
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException sex322) {
                                if (location.beLogged(500)) {
                                    location.logT(500, "DBInitializer.run(): Cannot close Connection. Reason: " + sex322.toString());
                                }
                                if (!location.beLogged(100)) break block48;
                                location.traceThrowableT(100, "Full stacktrace:", (Throwable)sex322);
                            }
                        }
                    }
                    try {
                        if (ut == null) break block46;
                        if (this.throwable == null) {
                            ut.commit();
                            break block46;
                        }
                        ut.rollback();
                    }
                    catch (Exception ex) {
                        if (location.beLogged(500)) {
                            location.logT(500, "DBInitializer.run(): Cannot commit/rollback UserTransaction. Reason: " + ex.toString());
                        }
                        if (location.beLogged(100)) {
                            location.traceThrowableT(100, "Full stacktrace:", (Throwable)ex);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block51: {
                    block50: {
                        SQLException sex322;
                        block49: {
                            Object var10_15 = null;
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (SQLException sex322) {
                                    if (location.beLogged(500)) {
                                        location.logT(500, "DBInitializer.run(): Cannot close Statement. Reason: " + sex322.toString());
                                    }
                                    if (!location.beLogged(100)) break block49;
                                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)sex322);
                                }
                            }
                        }
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException sex322) {
                                if (location.beLogged(500)) {
                                    location.logT(500, "DBInitializer.run(): Cannot close Connection. Reason: " + sex322.toString());
                                }
                                if (!location.beLogged(100)) break block50;
                                location.traceThrowableT(100, "Full stacktrace:", (Throwable)sex322);
                            }
                        }
                    }
                    try {
                        if (ut != null) {
                            if (this.throwable == null) {
                                ut.commit();
                            } else {
                                ut.rollback();
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (location.beLogged(500)) {
                            location.logT(500, "DBInitializer.run(): Cannot commit/rollback UserTransaction. Reason: " + ex.toString());
                        }
                        if (!location.beLogged(100)) break block51;
                        location.traceThrowableT(100, "Full stacktrace:", (Throwable)ex);
                    }
                }
                throw throwable;
            }
        }
        this.cd.release();
    }

    public String getResults() {
        StringBuffer result = new StringBuffer(0x100000);
        int i = 0;
        while (i < this.results.length) {
            result.append("\n").append(this.results[i]);
            ++i;
        }
        if (result.length() == 0) {
            return " OK.";
        }
        return result.append("\n OK.").toString();
    }

    private String visualizeRS(ResultSet rs) throws SQLException {
        StringBuffer result = new StringBuffer(0x100000);
        if (rs != null) {
            ResultSetMetaData rsmd = rs.getMetaData();
            String[] cols = new String[rsmd.getColumnCount()];
            int i = 0;
            while (i < cols.length) {
                cols[i] = rsmd.getColumnName(i + 1);
                ++i;
            }
            while (rs.next()) {
                result.append("    ");
                int i2 = 0;
                while (i2 < cols.length) {
                    Object object = cols[i2] == null ? rs.getObject(i2 + 1) : rs.getObject(cols[i2]);
                    result.append(cols[i2]).append(":(").append(object).append(")  ");
                    ++i2;
                }
                result.append("\n");
            }
            rs.close();
        }
        return result.toString();
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

