/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.dbpool.DBPoolResourceAccessor;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import com.sap.engine.services.dbpool.deploy.JDBCDescriptor;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RemoveDataSource
implements Command {
    private DataSourceManager jdbcManager = null;

    public RemoveDataSource(DataSourceManager _jdbcManager) {
        this.jdbcManager = _jdbcManager;
    }

    public String getName() {
        return "remove_data_source";
    }

    public String getGroup() {
        return "dbpool";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length != 1 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        try {
            JDBCDescriptor sysDSDescr = this.jdbcManager.getSystemDataSourceDescriptor();
            if (sysDSDescr != null && sysDSDescr.getDataSourceName().equals(params[0])) {
                out.println(" Cannot remove the installation DataSource.\n");
                return;
            }
            Hashtable res = this.jdbcManager.getDataSources();
            Enumeration htEnum = res.keys();
            while (htEnum.hasMoreElements()) {
                String appName = (String)htEnum.nextElement();
                Vector dsVtr = (Vector)res.get(appName);
                Enumeration vecEnum = dsVtr.elements();
                while (vecEnum.hasMoreElements()) {
                    JDBCDescriptor descr = (JDBCDescriptor)vecEnum.nextElement();
                    if (!params[0].equals(descr.getDataSourceName())) continue;
                    if (dsVtr.size() == 1) {
                        out.println(" Cannot remove DataSource because there is no other DataSources for its application (" + appName + ").");
                        out.println(" You can remove the whole application instead using 'remove_app -a <application_name>' command from Deploy Service.\n");
                        return;
                    }
                    Vector newDSVtr = (Vector)dsVtr.clone();
                    newDSVtr.remove(descr);
                    this.jdbcManager.updateDataSourceApplication(appName, newDSVtr, true);
                    out.println(" DataSource '" + params[0] + "' removed successfully.\n");
                    return;
                }
            }
            out.println(" There is no such DataSource currently deployed.\n");
        }
        catch (RemoteException exc) {
            DBPoolResourceAccessor.location.traceThrowableT(100, "Cannot remove this DataSource. Reason: ", (Throwable)exc);
            out.println(" Cannot remove this DataSource. Reason: " + exc.toString());
            exc.printStackTrace(out);
            return;
        }
    }

    public String getHelpMessage() {
        return "\nDestroys a specified DataSource if it is not the last DataSource in its application.\n\nUsage: REMOVE_DATA_SOURCE <dataSourceName>\nParameters:\n\t<dataSourceName> - the name of the DataSource to be removed\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

