/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.dbpool.DBPoolResourceAccessor;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class GetDrivers
implements Command {
    private DataSourceManager manager;

    public GetDrivers(DataSourceManager _manager) {
        this.manager = _manager;
    }

    public String getName() {
        return "get_drivers";
    }

    public String getGroup() {
        return "dbpool";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length != 0) {
            if (!(params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help"))) {
                out.println("\nWrong parameter(s)!\n");
            }
            out.println(this.getHelpMessage());
            return;
        }
        try {
            Hashtable drivers = this.manager.getDrivers();
            Enumeration enumeration = drivers.keys();
            if (drivers.size() == 0) {
                out.println(" There are no registered drivers.\n");
                return;
            }
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return;
                }
                out.println(" Driver Name : " + enumeration.nextElement());
            }
        }
        catch (Exception exc) {
            DBPoolResourceAccessor.location.traceThrowableT(100, "Cannot get information about drivers. Reason: ", (Throwable)exc);
            exc.printStackTrace(out);
            return;
        }
    }

    public String getHelpMessage() {
        return "\nReturns a list of the JDBC drivers that have been deployed and registered on J2EE Engine.\n\nUsage: GET_DRIVERS\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

