/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.dbpool.DBPoolResourceAccessor;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import com.sap.engine.services.dbpool.deploy.JDBCDescriptor;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GetDSProps
implements Command {
    private DataSourceManager manager;

    public GetDSProps(DataSourceManager _manager) {
        this.manager = _manager;
    }

    public String getName() {
        return "get_ds_props";
    }

    public String getGroup() {
        return "dbpool";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length != 1 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        try {
            JDBCDescriptor sysDSDescr = this.manager.getSystemDataSourceDescriptor();
            if (sysDSDescr != null && sysDSDescr.getDataSourceName().equals(params[0])) {
                out.println(sysDSDescr.getInfo());
                return;
            }
            Hashtable ds = this.manager.getDataSources();
            Enumeration htEnum = ds.keys();
            while (htEnum.hasMoreElements()) {
                String appName = (String)htEnum.nextElement();
                Enumeration vecEnum = ((Vector)ds.get(appName)).elements();
                while (vecEnum.hasMoreElements()) {
                    JDBCDescriptor descr = (JDBCDescriptor)vecEnum.nextElement();
                    if (descr.getDataSourceName().equals(params[0])) {
                        out.println("\n Deployer name = ".concat(appName.endsWith(" Service") || appName.endsWith(" Library") ? appName : appName.concat(" Application")));
                        out.println(descr.getInfo());
                        Vector aliasesVtr = this.getAllDSAliases(descr);
                        if (!aliasesVtr.isEmpty()) {
                            out.println("\n DataSource aliases (aliases deployer):");
                            Enumeration aliasEnum = aliasesVtr.elements();
                            while (aliasEnum.hasMoreElements()) {
                                String[] curElem = (String[])aliasEnum.nextElement();
                                out.println("   ".concat(curElem[0]).concat(" (").concat(curElem[1]).concat(")"));
                            }
                        }
                        return;
                    }
                    String[] aliases = descr.getAliases();
                    int i = 0;
                    while (i < aliases.length) {
                        if (aliases[i].equals(params[0])) {
                            out.println("\n Deployer name = ".concat(appName.endsWith(" Service") || appName.endsWith(" Library") ? appName : appName.concat(" Application")));
                            out.println(descr.getInfo());
                            Vector aliasesVtr = this.getAllDSAliases(descr);
                            if (!aliasesVtr.isEmpty()) {
                                out.println("\n DataSource aliases (aliases deployer):");
                                Enumeration aliasEnum = aliasesVtr.elements();
                                while (aliasEnum.hasMoreElements()) {
                                    String[] curElem = (String[])aliasEnum.nextElement();
                                    out.println("   ".concat(curElem[0]).concat(" (").concat(curElem[1]).concat(")"));
                                }
                            }
                            return;
                        }
                        ++i;
                    }
                }
            }
            out.println(" There is no such DataSource currently deployed.\n");
        }
        catch (Exception exc) {
            DBPoolResourceAccessor.location.traceThrowableT(100, "Cannot get information about this DataSources. Reason: ", (Throwable)exc);
            out.println(" Cannot get information about this DataSources. Reason: " + exc.toString());
            exc.printStackTrace(out);
            return;
        }
    }

    public String getHelpMessage() {
        return "\nReturns the properties of a DataSource object as specified in its descriptor XML file.\n\nUsage: GET_DS_PROPS <dataSourceName>\nParameters:\n\t<dataSourceName> - the name of the DataSource whose properties are displayed\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    /*
     * Unable to fully structure code
     */
    private Vector getAllDSAliases(JDBCDescriptor descr) throws RemoteException {
        allDSAliases = new Vector<String[]>();
        intAliases = descr.getAliases();
        i = 0;
        while (i < intAliases.length) {
            allDSAliases.add(new String[]{intAliases[i], descr.getDataSourceName().concat(" DataSource")});
            ++i;
        }
        aliases = this.manager.getAliases();
        enum = aliases.keys();
        while (enum.hasMoreElements()) {
            appName = (String)enum.nextElement();
            ds = (Hashtable)aliases.get(appName);
            intEnum = ds.keys();
            while (intEnum.hasMoreElements()) {
                dsName = (String)intEnum.nextElement();
                if (!dsName.equals(descr.getDataSourceName())) continue;
                aliasesArray = (String[])ds.get(dsName);
                deployer = appName.endsWith(" Service") != false || appName.endsWith(" Library") != false ? appName : appName.concat(" Application");
                i = 0;
                while (i < aliasesArray.length) {
                    if (deployer.endsWith(" Application")) {
                        try {
                            if (!this.manager.isApplicationStarted(appName)) {
                            }
                            ** break block9
                        }
                        catch (RemoteException rex) {
                            DBPoolResourceAccessor.location.traceThrowableT(500, "Unexpected exception: ", (Throwable)rex);
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        allDSAliases.add(new String[]{aliasesArray[i], deployer});
                    }
                    ++i;
                }
            }
        }
        return allDSAliases;
    }
}

