/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.dbpool.DBPoolResourceAccessor;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import com.sap.engine.services.dbpool.deploy.JDBCDescriptor;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GetDS
implements Command {
    private DataSourceManager manager;

    public GetDS(DataSourceManager _manager) {
        this.manager = _manager;
    }

    public String getName() {
        return "get_ds";
    }

    public String getGroup() {
        return "dbpool";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length != 0) {
            if (!(params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help"))) {
                out.println("\nWrong parameter(s)!\n");
            }
            out.println(this.getHelpMessage());
            return;
        }
        try {
            JDBCDescriptor sysDSDescr = this.manager.getSystemDataSourceDescriptor();
            Hashtable res = this.manager.getDataSources();
            if (sysDSDescr != null) {
                out.println("--------------------------------------------------------");
                out.println(" The default DataSource");
                out.println("   ".concat(sysDSDescr.getDataSourceName()).concat(" DataSource"));
                Vector aliases = this.getAllDSAliases(sysDSDescr);
                if (aliases.isEmpty()) {
                    out.println("     no aliases");
                } else {
                    Enumeration aliasEnum = aliases.elements();
                    while (aliasEnum.hasMoreElements()) {
                        String[] curElem = (String[])aliasEnum.nextElement();
                        out.println("     ".concat(curElem[0]).concat(" (").concat(curElem[1]).concat(")"));
                    }
                }
            }
            if (res.size() != 0) {
                Enumeration htEnum = res.keys();
                while (htEnum.hasMoreElements()) {
                    String appName = (String)htEnum.nextElement();
                    out.println("--------------------------------------------------------");
                    out.println(" ".concat(appName.endsWith(" Service") || appName.endsWith(" Library") ? appName : appName.concat(" Application")));
                    Enumeration vecEnum = ((Vector)res.get(appName)).elements();
                    while (vecEnum.hasMoreElements()) {
                        JDBCDescriptor descr = (JDBCDescriptor)vecEnum.nextElement();
                        out.println("   ".concat(descr.getDataSourceName().concat(" DataSource")));
                        Vector aliases = this.getAllDSAliases(descr);
                        if (aliases.isEmpty()) {
                            out.println("     no aliases");
                            continue;
                        }
                        Enumeration aliasEnum = aliases.elements();
                        while (aliasEnum.hasMoreElements()) {
                            String[] curElem = (String[])aliasEnum.nextElement();
                            out.println("     ".concat(curElem[0]).concat(" (").concat(curElem[1]).concat(")"));
                        }
                    }
                }
            } else {
                if (sysDSDescr != null) {
                    out.println();
                }
                out.println(" There are no applications with DataSources currently deployed.\n");
            }
        }
        catch (Exception exc) {
            DBPoolResourceAccessor.location.traceThrowableT(100, "Cannot get information about the deployed DataSources on this server node. Reason: ", (Throwable)exc);
            out.println(" Cannot get information about the deployed DataSources on this server node. Reason: " + exc.toString());
            exc.printStackTrace(out);
            return;
        }
    }

    public String getHelpMessage() {
        return "\nReturns a list of the DataSource objects and their aliases associated to the\napplications, services or libraries currently available on J2EE Engine.\n\nElements of the list have the following format:\n\n <DataSource deployer> Application|Service|Library\n   <DataSource name> DataSource\n     <alias> (<alias deployer>)\n     ...\n     <alias> (<alias deployer>)\n\nUsage: GET_DS\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    /*
     * Unable to fully structure code
     */
    private Vector getAllDSAliases(JDBCDescriptor descr) throws RemoteException {
        allDSAliases = new Vector<String[]>();
        intAliases = descr.getAliases();
        i = 0;
        while (i < intAliases.length) {
            allDSAliases.add(new String[]{intAliases[i], descr.getDataSourceName().concat(" DataSource")});
            ++i;
        }
        aliases = this.manager.getAliases();
        enum = aliases.keys();
        while (enum.hasMoreElements()) {
            appName = (String)enum.nextElement();
            ds = (Hashtable)aliases.get(appName);
            intEnum = ds.keys();
            while (intEnum.hasMoreElements()) {
                dsName = (String)intEnum.nextElement();
                if (!dsName.equals(descr.getDataSourceName())) continue;
                aliasesArray = (String[])ds.get(dsName);
                deployer = appName.endsWith(" Service") != false || appName.endsWith(" Library") != false ? appName : appName.concat(" Application");
                i = 0;
                while (i < aliasesArray.length) {
                    if (deployer.endsWith(" Application")) {
                        try {
                            if (!this.manager.isApplicationStarted(appName)) {
                            }
                            ** break block9
                        }
                        catch (RemoteException rex) {
                            DBPoolResourceAccessor.location.traceThrowableT(500, "Unexpected exception: ", (Throwable)rex);
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        allDSAliases.add(new String[]{aliasesArray[i], deployer});
                    }
                    ++i;
                }
            }
        }
        return allDSAliases;
    }
}

