/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.connector.ResourceObjectFactory;
import com.sap.engine.services.dbpool.DBPoolResourceAccessor;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class DestroyConnection
implements Command {
    public String getName() {
        return "destroy_conn";
    }

    public String getGroup() {
        return "dbpool";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length != 2 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        try {
            ResourceObjectFactory.destroyConnection(params[0], params[1], true);
            out.println(" Connection destroyed successfully.\n");
        }
        catch (Exception exc) {
            DBPoolResourceAccessor.location.traceThrowableT(100, "Connection cannot be destroyed. Reason: ", (Throwable)exc);
            out.println(" Connection cannot be destroyed. Reason: " + exc.toString());
            exc.printStackTrace(out);
            return;
        }
    }

    public String getHelpMessage() {
        return "\nDestroys previously acquired physical connection by DataSource name and connection ID.\n\nUsage: DESTROY_CONN <dataSourceName> <connectionID>\nParameters:\n\t<dataSourceName> - the name of the DataSource from which the connection is acquired.\n\t<connectionID>   - the ID number of the connection which has to be destroyed.\n\t                   The connection ID can be acquired with LIST_CONN command.\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

