/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.dbpool.DBPoolResourceAccessor;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;

public class DefineJDBCDriver
implements Command {
    private DataSourceManager jdbcManager = null;

    public DefineJDBCDriver(DataSourceManager _jdbcManager) {
        this.jdbcManager = _jdbcManager;
    }

    public String getName() {
        return "define_jdbc_driver";
    }

    public String getGroup() {
        return "dbpool";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length != 1 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        try {
            String output = this.jdbcManager.defineJdbcDriver(params[0]);
            if (output == null) {
                out.println("Specified library does not exist.\n");
            } else {
                out.println(output);
            }
        }
        catch (RemoteException exc) {
            DBPoolResourceAccessor.location.traceThrowableT(100, "Cannot define driver. Reason: ", (Throwable)exc);
            exc.printStackTrace(out);
            return;
        }
    }

    public String getHelpMessage() {
        return "\nRegisters a JDBC driver deployed on J2EE Engine as a library.\n\nUsage: DEFINE_JDBC_DRIVER <driverName>\nParameters:\n\t<driverName> - the name of the library that contains the classes of the JDBC driver\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

