/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.container.event.ContainerEventListenerAdapter;
import com.sap.engine.frame.container.monitor.LibraryMonitor;
import com.sap.engine.frame.container.monitor.ServiceMonitor;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.services.dbpool.DBPoolResourceAccessor;
import com.sap.engine.services.dbpool.command.CloseConnection;
import com.sap.engine.services.dbpool.command.DBInit;
import com.sap.engine.services.dbpool.command.DefineJDBCDriver;
import com.sap.engine.services.dbpool.command.DeployAliases;
import com.sap.engine.services.dbpool.command.DeployJDBCDriver;
import com.sap.engine.services.dbpool.command.DestroyConnection;
import com.sap.engine.services.dbpool.command.ExecuteInitStatements;
import com.sap.engine.services.dbpool.command.GetDS;
import com.sap.engine.services.dbpool.command.GetDSProps;
import com.sap.engine.services.dbpool.command.GetDrivers;
import com.sap.engine.services.dbpool.command.GetFreeConnectionsCount;
import com.sap.engine.services.dbpool.command.GetInitStatements;
import com.sap.engine.services.dbpool.command.GetUsedConnectionsCount;
import com.sap.engine.services.dbpool.command.ListConnections;
import com.sap.engine.services.dbpool.command.MakeDataSource;
import com.sap.engine.services.dbpool.command.RemoveDataSource;
import com.sap.engine.services.dbpool.command.RemoveInitStatements;
import com.sap.engine.services.dbpool.command.TestDS;
import com.sap.engine.services.dbpool.command.UndefineJDBCDriver;
import com.sap.engine.services.dbpool.command.UndeployJDBCDriver;
import com.sap.engine.services.dbpool.deploy.ContainerImpl;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import com.sap.engine.services.dbpool.deploy.DataSourceManagerImpl;
import com.sap.engine.services.dbpool.deploy.JDBCDescriptor;
import com.sap.engine.services.dbpool.deploy.XMLUtils;
import com.sap.engine.services.dbpool.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.dbpool.spi.CPManagedConnectionFactoryImpl;
import com.sap.engine.services.dbpool.spi.ManagedConnectionFactoryImpl;
import com.sap.engine.services.dbpool.spi.XAManagedConnectionFactoryImpl;
import com.sap.engine.services.deploy.container.ContainerManagement;
import com.sap.engine.services.deploy.container.DeployCommunicator;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.sql.connect.OpenSQLConnectionFactory;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.resource.spi.ManagedConnectionFactory;

public class PoolFrame
extends ContainerEventListenerAdapter
implements ApplicationServiceFrame {
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$dbpool$PoolFrame == null ? (class$com$sap$engine$services$dbpool$PoolFrame = PoolFrame.class$("com.sap.engine.services.dbpool.PoolFrame")) : class$com$sap$engine$services$dbpool$PoolFrame));
    private static final Category category = Category.SYS_SERVER;
    private static DataSourceManagerImpl manager;
    private ContainerImpl containerImpl;
    private ContainerManagement deployService;
    private DeployCommunicator deployCommunicator;
    private ShellInterface shell = null;
    private static ApplicationServiceContext serviceContext;
    private static ServiceMonitor serviceMonitor;
    private int commandsID = 0;
    Command[] commands = null;
    static /* synthetic */ Class class$com$sap$engine$services$dbpool$PoolFrame;

    public void start(ApplicationServiceContext _serviceContext) throws ServiceException {
        block9: {
            JDBCDescriptor sysDSDescr;
            Properties sysDSProps;
            block8: {
                OpenSQLConnectionFactory.jdbcConnectorStateChanged((int)1);
                serviceContext = _serviceContext;
                serviceMonitor = serviceContext.getContainerContext().getSystemMonitor().getService(serviceContext.getServiceState().getServiceName());
                sysDSProps = serviceMonitor.getProperties();
                this.clearNonSecuredProperties(sysDSProps);
                sysDSDescr = null;
                if (!((Hashtable)sysDSProps).isEmpty()) {
                    try {
                        sysDSDescr = XMLUtils.loadJdbcDescriptor(sysDSProps, serviceContext);
                    }
                    catch (BaseIllegalArgumentException biae) {
                        if (!category.beLogged(500)) break block8;
                        category.logThrowableT(500, location, "Cannot create the default DataSource", (Throwable)biae);
                    }
                }
            }
            try {
                manager = new DataSourceManagerImpl(serviceContext, sysDSDescr);
            }
            catch (RemoteException rex) {
                throw new ServiceException(category, 600, location, (LocalizableText)new LocalizableTextFormatter(DBPoolResourceAccessor.getResourceAccessor(), "Cannot initialize the DBPool Service"), rex);
            }
            this.containerImpl = new ContainerImpl(serviceContext, manager);
            int mask = 192;
            HashSet<String> names = new HashSet<String>(1);
            names.add("shell");
            serviceContext.getServiceState().registerContainerEventListener(mask, names, this);
            this.deployService = (ContainerManagement)serviceContext.getContainerContext().getObjectRegistry().getProvidedInterface("container");
            this.deployCommunicator = this.deployService.registerContainer(this.containerImpl.getContainerInfo().getName(), this.containerImpl);
            this.containerImpl.setDeployCommunicator(this.deployCommunicator);
            manager.setContainerImpl(this.containerImpl);
            serviceContext.getContainerContext().getObjectRegistry().registerInterface(manager);
            serviceContext.getServiceState().registerManagementInterface(manager);
            if (!((Hashtable)sysDSProps).isEmpty() && sysDSDescr != null) {
                this.containerImpl.createDefaultDataSource(sysDSDescr);
            }
            this.containerImpl.createServAndLibComponents(this.getServicesPersistentFiles("data-sources.xml"), true, true);
            this.containerImpl.createServAndLibComponents(this.getServicesPersistentFiles("data-source-aliases.xml"), false, true);
            this.containerImpl.createServAndLibComponents(this.getLibrariesPersistentFiles("data-sources.xml"), true, false);
            this.containerImpl.createServAndLibComponents(this.getLibrariesPersistentFiles("data-source-aliases.xml"), false, false);
            try {
                this.deployCommunicator.startMyApplications(this.deployCommunicator.getMyApplications());
            }
            catch (RemoteException rex) {
                if (!category.beLogged(500)) break block9;
                category.logThrowableT(500, location, "Cannot start the applications which are using DataSources", (Throwable)rex);
            }
        }
        OpenSQLConnectionFactory.jdbcConnectorStateChanged((int)2);
    }

    public void stop() {
        block7: {
            block6: {
                OpenSQLConnectionFactory.jdbcConnectorStateChanged((int)3);
                try {
                    this.deployCommunicator.stopMyApplications(this.deployCommunicator.getMyApplications());
                }
                catch (RemoteException rex) {
                    if (!category.beLogged(500)) break block6;
                    category.logThrowableT(500, location, "Cannot stop the applications which are using DataSources", (Throwable)rex);
                }
            }
            try {
                JDBCDescriptor sysDSDescr = manager.getSystemDataSourceDescriptor();
                if (sysDSDescr != null) {
                    this.containerImpl.destroyDefaultDataSource(sysDSDescr);
                }
            }
            catch (RemoteException rex) {
                if (!category.beLogged(500)) break block7;
                category.logThrowableT(500, location, "Cannot retrieve information about the default DataSource. Possible RMI problem.", (Throwable)rex);
            }
        }
        this.containerImpl.destroyServAndLibComponents();
        serviceContext.getContainerContext().getObjectRegistry().unregisterInterface();
        serviceContext.getServiceState().unregisterManagementInterface();
        serviceContext.getServiceState().unregisterContainerEventListener();
        this.deployService.unregisterContainer("JDBCConnector");
        if (this.shell != null) {
            this.shell.unregisterCommands(this.commandsID);
            this.shell = null;
        }
        manager = null;
        this.containerImpl = null;
        OpenSQLConnectionFactory.jdbcConnectorStateChanged((int)4);
    }

    public static ApplicationServiceContext getAppContext() {
        return serviceContext;
    }

    public static String getMessageAndStackTrace(Throwable th) {
        StringWriter stringWriter = new StringWriter();
        th.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return stringWriter.toString();
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("shell")) {
            this.shell = (ShellInterface)interfaceImpl;
            this.commands = new Command[20];
            this.commands[0] = new GetDrivers(manager);
            this.commands[1] = new GetDS(manager);
            this.commands[2] = new MakeDataSource(manager);
            this.commands[3] = new DeployJDBCDriver(manager);
            this.commands[4] = new RemoveDataSource(manager);
            this.commands[5] = new TestDS(manager);
            this.commands[6] = new UndeployJDBCDriver(manager);
            this.commands[7] = new GetDSProps(manager);
            this.commands[8] = new DefineJDBCDriver(manager);
            this.commands[9] = new UndefineJDBCDriver(manager);
            this.commands[10] = new DBInit(manager);
            this.commands[11] = new GetInitStatements(manager);
            this.commands[12] = new RemoveInitStatements(manager);
            this.commands[13] = new ExecuteInitStatements(manager);
            this.commands[14] = new GetFreeConnectionsCount(manager);
            this.commands[15] = new GetUsedConnectionsCount(manager);
            this.commands[16] = new ListConnections(manager);
            this.commands[17] = new DeployAliases(manager);
            this.commands[18] = new CloseConnection();
            this.commands[19] = new DestroyConnection();
            this.commandsID = this.shell.registerCommands(this.commands);
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
        if (interfaceName.equals("shell")) {
            this.shell.unregisterCommands(this.commandsID);
            this.shell = null;
        }
    }

    public boolean setServiceProperty(String key, String value) {
        return false;
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        Properties oldProps = PoolFrame.getServiceProperties();
        String isoLvl = serviceProperties.getProperty("sysDS.isolationLevel", "");
        if (((Hashtable)oldProps).get("sysDS.DBConnectInfo") != null && !((Hashtable)oldProps).get("sysDS.DBConnectInfo").equals(((Hashtable)serviceProperties).get("sysDS.DBConnectInfo")) || ((Hashtable)oldProps).get("sysDS.dataSourceName") != null && !((Hashtable)oldProps).get("sysDS.dataSourceName").equals(((Hashtable)serviceProperties).get("sysDS.dataSourceName")) || ((Hashtable)oldProps).get("sysDS.aliases") != null && !((Hashtable)oldProps).get("sysDS.aliases").equals(((Hashtable)serviceProperties).get("sysDS.aliases")) || ((Hashtable)oldProps).get("sysDS.SQLEngine") != null && !((Hashtable)oldProps).get("sysDS.SQLEngine").equals(((Hashtable)serviceProperties).get("sysDS.SQLEngine")) || !"".equals(isoLvl) && !"TRANSACTION_READ_UNCOMMITTED".equals(isoLvl) && !"TRANSACTION_READ_COMMITTED".equals(isoLvl)) {
            BaseIllegalArgumentException biae = new BaseIllegalArgumentException("dbpool_0610");
            biae.log();
            throw biae;
        }
        return false;
    }

    public static void _setServiceProperties(Properties serviceProperties) throws ServiceException {
        serviceMonitor.setGlobalCustomProperties(serviceProperties);
        if (!((Hashtable)serviceMonitor.getLocalCustomProperties()).isEmpty() || !((Hashtable)serviceMonitor.getLocalDefaultProperties()).isEmpty()) {
            serviceMonitor.setLocalCustomProperties(serviceProperties);
        }
    }

    public static Properties getServiceProperties() {
        return serviceContext.getServiceState().getProperties();
    }

    public static void setServicePersistentFile(String serviceName, File file, boolean isDataSource) throws ServiceException {
        SystemMonitor systemMonitor = serviceContext.getContainerContext().getSystemMonitor();
        ServiceMonitor serviceMonitor = systemMonitor.getService(serviceName);
        if (file == null) {
            if (isDataSource) {
                serviceMonitor.getDescriptorContainer().removeSecuredPersistentEntry("data-sources.xml", true);
            } else {
                serviceMonitor.getDescriptorContainer().removePersistentEntry("data-source-aliases.xml", true);
            }
        } else if (isDataSource) {
            serviceMonitor.getDescriptorContainer().setSecuredPersistentEntryFile("data-sources.xml", file, true);
        } else {
            serviceMonitor.getDescriptorContainer().setPersistentEntryFile("data-source-aliases.xml", file, true);
        }
    }

    public static void setLibraryPersistentFile(String libraryName, File file, boolean isDataSource) throws ServiceException {
        SystemMonitor systemMonitor = serviceContext.getContainerContext().getSystemMonitor();
        LibraryMonitor libraryMonitor = systemMonitor.getLibrary(libraryName);
        if (file == null) {
            if (isDataSource) {
                libraryMonitor.getDescriptorContainer().removeSecuredPersistentEntry("data-sources.xml", true);
            } else {
                libraryMonitor.getDescriptorContainer().removePersistentEntry("data-source-aliases.xml", true);
            }
        } else if (isDataSource) {
            libraryMonitor.getDescriptorContainer().setSecuredPersistentEntryFile("data-sources.xml", file, true);
        } else {
            libraryMonitor.getDescriptorContainer().setPersistentEntryFile("data-source-aliases.xml", file, true);
        }
    }

    public static DataSourceManager getDataSourceManager() {
        return manager;
    }

    private Hashtable getServicesPersistentFiles(String fileName) {
        Hashtable<String, File> result = new Hashtable<String, File>();
        SystemMonitor systemMonitor = serviceContext.getContainerContext().getSystemMonitor();
        ServiceMonitor[] serviceMonitors = systemMonitor.getServices();
        int i = 0;
        while (i < serviceMonitors.length) {
            File xml = "data-sources.xml".equals(fileName) ? serviceMonitors[i].getDescriptorContainer().getSecuredPersistentEntryFile(fileName, true) : serviceMonitors[i].getDescriptorContainer().getPersistentEntryFile(fileName, true);
            if (xml != null) {
                result.put(serviceMonitors[i].getComponentName(), xml);
            }
            ++i;
        }
        return result;
    }

    private Hashtable getLibrariesPersistentFiles(String fileName) {
        Hashtable<String, File> result = new Hashtable<String, File>();
        SystemMonitor systemMonitor = serviceContext.getContainerContext().getSystemMonitor();
        LibraryMonitor[] libraryMonitors = systemMonitor.getLibraries();
        int i = 0;
        while (i < libraryMonitors.length) {
            File xml = "data-sources.xml".equals(fileName) ? libraryMonitors[i].getDescriptorContainer().getSecuredPersistentEntryFile(fileName, true) : libraryMonitors[i].getDescriptorContainer().getPersistentEntryFile(fileName, true);
            if (xml != null) {
                result.put(libraryMonitors[i].getComponentName(), xml);
            }
            ++i;
        }
        return result;
    }

    private void clearNonSecuredProperties(Properties sysDSProps) {
        block10: {
            Vector<String> localPropsToRemove;
            block9: {
                String[] oldPropNames = new String[]{"sysDS.driverClassName", "sysDS.URL", "sysDS.User", "sysDS.Password", "sysDS.isPasswordEncrypted"};
                Properties globalDefaultProps = serviceMonitor.getGlobalDefaultProperties();
                Properties globalCustomProps = serviceMonitor.getGlobalCustomProperties();
                Properties localDefaultProps = serviceMonitor.getLocalDefaultProperties();
                Properties localCustomProps = serviceMonitor.getLocalCustomProperties();
                localPropsToRemove = new Vector<String>();
                Vector<String> globalPropsToRemove = new Vector<String>();
                int i = 0;
                while (i < oldPropNames.length) {
                    if (((Hashtable)globalDefaultProps).get(oldPropNames[i]) != null || ((Hashtable)globalCustomProps).get(oldPropNames[i]) != null) {
                        ((Hashtable)sysDSProps).remove(oldPropNames[i]);
                        globalPropsToRemove.add(oldPropNames[i]);
                    }
                    if (((Hashtable)localDefaultProps).get(oldPropNames[i]) != null || ((Hashtable)localCustomProps).get(oldPropNames[i]) != null) {
                        ((Hashtable)sysDSProps).remove(oldPropNames[i]);
                        localPropsToRemove.add(oldPropNames[i]);
                    }
                    ++i;
                }
                if (!globalPropsToRemove.isEmpty()) {
                    try {
                        serviceMonitor.removeGlobalProperties(globalPropsToRemove.toArray(new String[0]));
                    }
                    catch (ServiceException sex) {
                        if (!location.beLogged(300)) break block9;
                        location.traceThrowableT(300, "PoolFrame.clearNonSecuredProperties(): Cannot remove some obsolete global properties of the DBPool Service", (Throwable)((Object)sex));
                    }
                }
            }
            if (!localPropsToRemove.isEmpty()) {
                try {
                    serviceMonitor.removeLocalProperties(localPropsToRemove.toArray(new String[0]));
                }
                catch (ServiceException sex) {
                    if (!location.beLogged(300)) break block10;
                    location.traceThrowableT(300, "PoolFrame.clearNonSecuredProperties(): Cannot remove some obsolete local properties of the DBPool Service", (Throwable)((Object)sex));
                }
            }
        }
    }

    public static String getDSName(ManagedConnectionFactory mcf) {
        if (mcf == null) {
            return null;
        }
        if (mcf instanceof ManagedConnectionFactoryImpl) {
            return ((ManagedConnectionFactoryImpl)mcf).getJDBCDescriptor().getDataSourceName();
        }
        if (mcf instanceof CPManagedConnectionFactoryImpl) {
            return ((CPManagedConnectionFactoryImpl)mcf).getJDBCDescriptor().getDataSourceName();
        }
        if (mcf instanceof XAManagedConnectionFactoryImpl) {
            return ((XAManagedConnectionFactoryImpl)mcf).getJDBCDescriptor().getDataSourceName();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        serviceContext = null;
        serviceMonitor = null;
    }
}

