/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.resource.impl;

import com.sap.engine.interfaces.resourcecontext.ResourceContext;
import com.sap.engine.interfaces.resourcecontext.ResourceContextException;
import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.exceptions.BaseResourceContextException;
import com.sap.engine.services.connector.jca.ResourceSetContextObject;
import com.sap.engine.services.connector.resource.ResourceSet;
import com.sap.engine.services.connector.resource.impl.ResourceSetImpl;
import com.sap.engine.services.connector.resource.impl.ResourceSetRecord;
import com.sap.engine.services.connector.resource.impl.RestrictedResourceSetImpl;
import com.sap.tc.logging.Location;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.EmptyStackException;
import javax.resource.ResourceException;
import javax.transaction.Transaction;

public class ResourceContextImpl
implements ResourceContext {
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$connector$resource$impl$ResourceContextImpl == null ? (class$com$sap$engine$services$connector$resource$impl$ResourceContextImpl = ResourceContextImpl.class$("com.sap.engine.services.connector.resource.impl.ResourceContextImpl")) : class$com$sap$engine$services$connector$resource$impl$ResourceContextImpl));
    private static int severityDebug = 100;
    private String appName = null;
    private String moduleName = null;
    private boolean isStateless = false;
    private ResourceSetImpl ownResourceSet = null;
    private int ownDefaultIsolationLevel = -1;
    private boolean destroyed = false;
    static /* synthetic */ Class class$com$sap$engine$services$connector$resource$impl$ResourceContextImpl;

    public ResourceContextImpl(String app_Name, String module_Name, boolean is_stateless, int isolation_level) {
        if (location.beLogged(severityDebug)) {
            location.logT(100, "--> " + this + ".<constructor>(appName: " + app_Name + ", compName: " + module_Name + ", isStateless: " + is_stateless + ", isoLevel: " + isolation_level + ")");
        }
        this.appName = app_Name;
        this.moduleName = module_Name;
        this.isStateless = is_stateless;
        this.ownResourceSet = new ResourceSetImpl(this.appName, this.moduleName);
        this.ownDefaultIsolationLevel = isolation_level;
    }

    public ResourceContextImpl(String app_name, String module_name) {
        if (location.beLogged(severityDebug)) {
            location.logT(100, "--> " + this + ".<RestrictedConstructor>(appName: " + app_name + ", compName: " + module_name + ")");
        }
        this.appName = app_name;
        this.moduleName = module_name;
        this.isStateless = true;
        this.ownResourceSet = new RestrictedResourceSetImpl(this.appName, this.moduleName);
    }

    public void enterMethod(String methodName, int isolationLevel) throws ResourceContextException {
        if (location.beLogged(severityDebug)) {
            location.logT(100, "--> " + this + ".enterMethod(" + methodName + ", " + isolationLevel + ")");
        }
        if (this.destroyed) {
            BaseResourceContextException brcExc = new BaseResourceContextException("connector_1200");
            location.traceThrowableT(500, "", (Throwable)((Object)brcExc));
            throw brcExc;
        }
        if (methodName == null) {
            BaseResourceContextException brcExc = new BaseResourceContextException("connector_1201", "enterMethod");
            location.traceThrowableT(500, "", (Throwable)((Object)brcExc));
            throw brcExc;
        }
        try {
            Transaction transaction = ConnectorServiceFrame.transactionManager.getTransaction();
            if (this.isStateless) {
                if (transaction != null) {
                    this.ownResourceSet.enlistAll(transaction);
                }
            } else {
                this.ownResourceSet.enlistAllStateful(transaction);
            }
        }
        catch (Exception exc) {
            BaseResourceContextException brcExc = new BaseResourceContextException("connector_1202", exc);
            location.traceThrowableT(500, "", (Throwable)((Object)brcExc));
            throw brcExc;
        }
        ResourceSet rs = ResourceSetContextObject.replaceCurrentResourceSet(this.ownResourceSet);
        ResourceSetContextObject.pushRecord(new ResourceSetRecord(rs, methodName));
        this.ownResourceSet.setMethodName(methodName);
        this.ownResourceSet.setIsolationLevel(isolationLevel);
        if (location.beLogged(severityDebug)) {
            location.logT(100, "<-- " + this + ".enterMethod(" + methodName + ", " + isolationLevel + ") OK");
        }
    }

    public void enterMethod(String methodName) throws ResourceContextException {
        if (location.beLogged(severityDebug)) {
            location.logT(100, "--> " + this + ".enterMethod(" + methodName + ")");
        }
        this.enterMethod(methodName, this.ownDefaultIsolationLevel);
    }

    public void exitMethod(String methodName, boolean exitStatus) throws ResourceContextException {
        if (location.beLogged(severityDebug)) {
            location.logT(100, "--> " + this + ".exitMethod(" + methodName + ", " + exitStatus + ")");
        }
        ConnectorServiceFrame.sendEventToDsr(this.moduleName, this.appName, methodName);
        ResourceSetRecord rsRecord = null;
        try {
            rsRecord = ResourceSetContextObject.popRecord();
            String storageMethodName = rsRecord.getCheckMethodName();
            if (storageMethodName == null || !storageMethodName.equals(methodName)) {
                BaseResourceContextException brcExc = new BaseResourceContextException("connector_1203", new String[]{storageMethodName, methodName});
                location.traceThrowableT(500, "", (Throwable)((Object)brcExc));
                throw brcExc;
            }
        }
        catch (EmptyStackException ese) {
            BaseResourceContextException brcExc = new BaseResourceContextException("connector_1204");
            location.traceThrowableT(500, "", (Throwable)((Object)brcExc));
            throw brcExc;
        }
        ResourceSetContextObject.replaceCurrentResourceSet(rsRecord.getResourceSet());
        try {
            if (this.isStateless) {
                if (exitStatus) {
                    this.ownResourceSet.delistAll(0x4000000);
                } else {
                    this.ownResourceSet.delistAll(0x20000000);
                }
            } else if (exitStatus) {
                this.ownResourceSet.delistAllStateful(0x4000000);
            } else {
                this.ownResourceSet.delistAllStateful(0x20000000);
            }
        }
        catch (Exception exc) {
            BaseResourceContextException bcrExc = new BaseResourceContextException("connector_1205", exc);
            throw bcrExc;
        }
        rsRecord.setOwnValues();
        try {
            if (this.isStateless) {
                this.ownResourceSet.clearStateless();
            }
        }
        catch (Exception exc) {
            BaseResourceContextException brcExc = new BaseResourceContextException("connector_1206", exc);
            location.traceThrowableT(500, "", (Throwable)((Object)brcExc));
            throw brcExc;
        }
        if (location.beLogged(severityDebug)) {
            location.logT(100, "<-- " + this + ".exitMethod(" + methodName + ", " + exitStatus + ") OK");
        }
    }

    public void destroy() {
        if (location.beLogged(severityDebug)) {
            location.logT(100, "--> " + this + ".destroy()");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new Exception("trace of ResourceContextImpl.destroy()").printStackTrace(new PrintStream(baos));
            location.logT(100, baos.toString());
        }
        try {
            try {
                this.clearConnections();
            }
            catch (Exception exc) {
                BaseResourceContextException brcExc = new BaseResourceContextException("connector_1207", exc);
                location.traceThrowableT(500, "", (Throwable)((Object)brcExc));
                Object var4_4 = null;
                this.destroyed = true;
            }
            Object var4_3 = null;
            this.destroyed = true;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.destroyed = true;
            throw throwable;
        }
    }

    public void clearConnections() throws ResourceContextException {
        if (location.beLogged(severityDebug)) {
            location.logT(100, "--> " + this + ".clearConnections()");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new Exception("trace of ResourceContextImpl.clearConnections").printStackTrace(new PrintStream(baos));
            location.logT(100, baos.toString());
        }
        try {
            this.ownResourceSet.clearStateless();
        }
        catch (NullPointerException npExc) {
            BaseResourceContextException brcExc = new BaseResourceContextException("connector_1208", npExc);
            location.traceThrowableT(500, "", (Throwable)((Object)brcExc));
            throw brcExc;
        }
        catch (ResourceException resExc) {
            BaseResourceContextException brcExc = new BaseResourceContextException("connector_1206", resExc);
            location.traceThrowableT(500, "", (Throwable)((Object)brcExc));
            throw brcExc;
        }
    }

    public Transaction getTransaction() {
        if (this.ownResourceSet != null) {
            return this.ownResourceSet.getTransaction();
        }
        return null;
    }

    public ResourceSet getResourceSet() {
        return this.ownResourceSet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

