/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.work;

import com.sap.engine.frame.core.thread.Task;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.jca15.work.BaseWorkCompletedException;
import com.sap.engine.services.connector.jca15.work.BaseWorkRejectedException;
import com.sap.engine.services.connector.jca15.work.HollowTimeoutManager;
import com.sap.engine.services.connector.jca15.work.TaskImpl;
import com.sap.engine.services.timeout.TimeoutListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.WorkRejectedException;

public class WorkManagerImpl
implements WorkManager {
    private ThreadSystem threadSystem = ConnectorServiceFrame.threadSystem;

    public void doWork(Work work) throws WorkCompletedException {
        TaskImpl task = TaskImpl.getInstance();
        task.type = 0;
        task.init((Runnable)work);
        TaskImpl taskImpl = task;
        synchronized (taskImpl) {
            this.threadSystem.startTask((Task)task, false);
            try {
                task.wait();
            }
            catch (InterruptedException e) {
                Log.logThrowable(e);
            }
            task.notify();
            if (task.exception != null) {
                StringWriter stringWriter = new StringWriter();
                task.exception.printStackTrace(new PrintWriter((Writer)stringWriter, true));
                BaseWorkCompletedException exception = new BaseWorkCompletedException(stringWriter.toString());
                exception.log();
                throw exception;
            }
        }
    }

    public void doWork(Work work, long timeout, ExecutionContext executionContext, WorkListener workListener) throws WorkCompletedException, WorkRejectedException {
        TaskImpl task = TaskImpl.getInstance();
        task.type = 1;
        task.workListener = workListener;
        task.expired = false;
        task.executionContext = executionContext;
        task.init((Runnable)work);
        if (workListener != null) {
            workListener.workAccepted(new WorkEvent((Object)work, 1, work, null));
        }
        TaskImpl taskImpl = task;
        synchronized (taskImpl) {
            if (timeout == 0L) {
                this.threadSystem.startTask((Task)task, true);
                try {
                    task.wait();
                }
                catch (InterruptedException e) {
                    Log.logThrowable(e);
                }
                task.notify();
                if (task.xidRejected) {
                    if (workListener != null) {
                        workListener.workRejected(new WorkEvent((Object)work, 2, work, null));
                    }
                    BaseWorkRejectedException exception = new BaseWorkRejectedException("connector_0900");
                    exception.log();
                    throw exception;
                }
                if (task.exception != null) {
                    StringWriter stringWriter = new StringWriter();
                    task.exception.printStackTrace(new PrintWriter((Writer)stringWriter, true));
                    BaseWorkCompletedException exception = new BaseWorkCompletedException(stringWriter.toString());
                    if (workListener != null) {
                        workListener.workCompleted(new WorkEvent((Object)work, 4, work, (WorkException)exception));
                    }
                    exception.log();
                    throw exception;
                }
                if (workListener != null) {
                    workListener.workCompleted(new WorkEvent((Object)work, 4, work, null));
                }
            } else {
                this.threadSystem.startTask((Task)task, false);
                try {
                    task.wait(timeout);
                }
                catch (InterruptedException e) {
                    Log.logThrowable(e);
                }
                if (task.expired) {
                    task.notify();
                    if (task.xidRejected) {
                        if (workListener != null) {
                            workListener.workRejected(new WorkEvent((Object)work, 2, work, null));
                        }
                        BaseWorkRejectedException exception = new BaseWorkRejectedException("connector_0900");
                        exception.log();
                        throw exception;
                    }
                    if (task.exception != null) {
                        StringWriter stringWriter = new StringWriter();
                        task.exception.printStackTrace(new PrintWriter((Writer)stringWriter, true));
                        BaseWorkCompletedException exception = new BaseWorkCompletedException(stringWriter.toString());
                        if (workListener != null) {
                            workListener.workCompleted(new WorkEvent((Object)work, 4, work, (WorkException)exception));
                        }
                        exception.log();
                        throw exception;
                    }
                    if (workListener != null) {
                        workListener.workCompleted(new WorkEvent((Object)work, 4, work, null));
                    }
                } else {
                    task.expired = true;
                    if (workListener != null) {
                        workListener.workRejected(new WorkEvent((Object)work, 2, work, null));
                    }
                    BaseWorkRejectedException exception = new BaseWorkRejectedException("connector_0901");
                    exception.log();
                    throw exception;
                }
            }
        }
    }

    public long startWork(Work work) {
        TaskImpl task = TaskImpl.getInstance();
        task.type = 4;
        task.init((Runnable)work);
        long startTime = System.currentTimeMillis();
        TaskImpl taskImpl = task;
        synchronized (taskImpl) {
            this.threadSystem.startTask((Task)task, false);
            try {
                task.wait();
            }
            catch (InterruptedException e) {
                Log.logThrowable(e);
            }
        }
        return System.currentTimeMillis() - startTime;
    }

    public long startWork(Work work, long timeout, ExecutionContext executionContext, WorkListener workListener) throws WorkRejectedException {
        TaskImpl task = TaskImpl.getInstance();
        task.type = 5;
        task.workListener = workListener;
        task.expired = false;
        task.executionContext = executionContext;
        task.init((Runnable)work);
        long startTime = System.currentTimeMillis();
        if (workListener != null) {
            workListener.workAccepted(new WorkEvent((Object)work, 1, work, null));
        }
        TaskImpl taskImpl = task;
        synchronized (taskImpl) {
            if (timeout == 0L) {
                this.threadSystem.startTask((Task)task, true);
                try {
                    task.wait();
                }
                catch (InterruptedException e) {
                    Log.logThrowable(e);
                }
                task.notify();
                if (task.xidRejected) {
                    if (workListener != null) {
                        workListener.workRejected(new WorkEvent((Object)work, 2, work, null));
                    }
                    BaseWorkRejectedException exception = new BaseWorkRejectedException("connector_0900");
                    exception.log();
                    throw exception;
                }
                long exception = System.currentTimeMillis() - startTime;
                return exception;
            }
            this.threadSystem.startTask((Task)task, false);
            try {
                task.wait(timeout);
            }
            catch (InterruptedException e) {
                Log.logThrowable(e);
            }
            if (task.expired) {
                task.notify();
                if (task.xidRejected) {
                    if (workListener != null) {
                        workListener.workRejected(new WorkEvent((Object)work, 2, work, null));
                    }
                    BaseWorkRejectedException exception = new BaseWorkRejectedException("connector_0900");
                    exception.log();
                    throw exception;
                }
                long exception = System.currentTimeMillis() - startTime;
                return exception;
            }
            task.expired = true;
            if (workListener != null) {
                workListener.workRejected(new WorkEvent((Object)work, 2, work, null));
            }
            BaseWorkRejectedException exception = new BaseWorkRejectedException("connector_0901");
            exception.log();
            throw exception;
        }
    }

    public void scheduleWork(Work work) {
        TaskImpl task = TaskImpl.getInstance();
        task.type = 2;
        task.init((Runnable)work);
        this.threadSystem.startThread((Runnable)work, false);
    }

    public void scheduleWork(Work work, long timeout, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        TaskImpl task = TaskImpl.getInstance();
        task.type = 3;
        task.workListener = workListener;
        task.expired = false;
        task.executionContext = executionContext;
        task.init((Runnable)work);
        if (workListener != null) {
            workListener.workAccepted(new WorkEvent((Object)work, 1, work, null));
        }
        if (timeout == 0L) {
            this.threadSystem.startTask((Task)task, true);
        } else {
            try {
                ConnectorServiceFrame.timeoutManager.registerTimeoutListener((TimeoutListener)task, timeout, 0L);
            }
            catch (HollowTimeoutManager.TimeOutIsStoppedException e) {
                if (workListener != null) {
                    workListener.workRejected(new WorkEvent((Object)work, 2, work, null));
                }
                BaseWorkRejectedException exception = new BaseWorkRejectedException("connector_0903");
                exception.log();
                throw exception;
            }
            this.threadSystem.startTask((Task)task, false);
        }
    }
}

