/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.work;

import com.sap.engine.frame.core.thread.Task;
import com.sap.engine.interfaces.transaction.JCATransaction;
import com.sap.engine.lib.util.base.ListPool;
import com.sap.engine.lib.util.base.NextItem;
import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.jca15.TransactionRegistry;
import com.sap.engine.services.connector.jca15.work.HollowTimeoutManager;
import com.sap.engine.services.timeout.TimeoutListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;

class TaskImpl
extends Task
implements TimeoutListener {
    public static final int DO_WORK = 0;
    public static final int DO_WORK_EXC = 1;
    public static final int SCHEDULE_WORK = 2;
    public static final int SCHEDULE_WORK_EXC = 3;
    public static final int START_WORK = 4;
    public static final int START_WORK_EXC = 5;
    private static final TaskPool pool = new TaskPool();
    private static final Object lockMonitor = new Object();
    int type;
    Throwable exception;
    WorkListener workListener;
    boolean expired;
    boolean xidRejected;
    ExecutionContext executionContext;

    private TaskImpl() {
    }

    public Object run() {
        switch (this.type) {
            case 0: {
                TaskImpl taskImpl = this;
                synchronized (taskImpl) {
                    try {
                        this.work.run();
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (OutOfMemoryError error) {
                        throw error;
                    }
                    catch (Throwable t) {
                        this.exception = t;
                    }
                    this.notify();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Log.logThrowable(e);
                    }
                    break;
                }
            }
            case 1: {
                TaskImpl taskImpl = this;
                synchronized (taskImpl) {
                    if (this.expired) {
                        Object e = null;
                        return e;
                    }
                    this.expired = true;
                    boolean inTransaction = this.executionContext != null && this.executionContext.getXid() != null;
                    JCATransaction transaction = null;
                    try {
                        boolean mustResume = false;
                        this.xidRejected = false;
                        if (inTransaction) {
                            Object object = lockMonitor;
                            synchronized (object) {
                                Xid xid = this.executionContext.getXid();
                                Hashtable txRegistry = TransactionRegistry.getTxRegistry();
                                transaction = (JCATransaction)txRegistry.get(xid);
                                if (transaction == null) {
                                    transaction = ConnectorServiceFrame.transactionManager.beginJCATransaction(xid, this.executionContext.getTransactionTimeout());
                                    txRegistry.put(xid, transaction);
                                } else if (transaction.activateInThread()) {
                                    this.xidRejected = true;
                                } else {
                                    mustResume = true;
                                }
                            }
                        }
                        if (!this.xidRejected) {
                            if (mustResume) {
                                ConnectorServiceFrame.transactionManager.resume(transaction);
                            }
                            if (this.workListener != null) {
                                this.workListener.workStarted(new WorkEvent((Object)this.work, 3, (Work)this.work, null));
                            }
                            this.work.run();
                        }
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (OutOfMemoryError error) {
                        throw error;
                    }
                    catch (Throwable t) {
                        Log.logThrowable(t);
                        this.exception = t;
                    }
                    if (!this.xidRejected && inTransaction) {
                        try {
                            ConnectorServiceFrame.transactionManager.suspend();
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (OutOfMemoryError error) {
                            throw error;
                        }
                        catch (Throwable e) {
                            this.exception = e;
                        }
                        transaction.notInThread();
                    }
                    this.notify();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Log.logThrowable(e);
                    }
                    break;
                }
            }
            case 4: {
                TaskImpl taskImpl = this;
                synchronized (taskImpl) {
                    this.notify();
                }
                try {
                    this.work.run();
                    break;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (OutOfMemoryError error) {
                    throw error;
                }
                catch (Throwable t) {
                    Log.logThrowable(t);
                    break;
                }
            }
            case 5: {
                StringWriter stringWriter;
                boolean inTransaction = this.executionContext != null && this.executionContext.getXid() != null;
                JCATransaction transaction = null;
                boolean mustResume = false;
                TaskImpl e = this;
                synchronized (e) {
                    if (this.expired) {
                        Object error = null;
                        return error;
                    }
                    this.expired = true;
                    this.xidRejected = false;
                    if (inTransaction) {
                        Object error = lockMonitor;
                        synchronized (error) {
                            Xid xid = this.executionContext.getXid();
                            Hashtable txRegistry = TransactionRegistry.getTxRegistry();
                            transaction = (JCATransaction)txRegistry.get(xid);
                            if (transaction == null) {
                                try {
                                    transaction = ConnectorServiceFrame.transactionManager.beginJCATransaction(xid, this.executionContext.getTransactionTimeout());
                                    txRegistry.put(xid, transaction);
                                }
                                catch (ThreadDeath td) {
                                    throw td;
                                }
                                catch (OutOfMemoryError error2) {
                                    throw error2;
                                }
                                catch (Throwable t) {
                                    this.exception = t;
                                }
                            } else if (transaction.activateInThread()) {
                                this.xidRejected = true;
                            } else {
                                mustResume = true;
                            }
                        }
                    }
                    this.notify();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        Log.logThrowable(e2);
                    }
                }
                if (this.xidRejected) break;
                if (this.exception == null) {
                    if (this.workListener != null) {
                        try {
                            if (mustResume) {
                                ConnectorServiceFrame.transactionManager.resume((Transaction)transaction);
                            }
                            this.workListener.workStarted(new WorkEvent((Object)this.work, 3, (Work)this.work, null));
                            this.work.run();
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (OutOfMemoryError error) {
                            throw error;
                        }
                        catch (Throwable throwable) {
                            this.exception = throwable;
                            Log.logThrowable(throwable);
                        }
                        if (inTransaction) {
                            try {
                                ConnectorServiceFrame.transactionManager.suspend();
                            }
                            catch (ThreadDeath td) {
                                throw td;
                            }
                            catch (OutOfMemoryError error) {
                                throw error;
                            }
                            catch (Throwable e3) {
                                Log.logThrowable(e3);
                            }
                            transaction.notInThread();
                        }
                        try {
                            if (this.exception != null) {
                                stringWriter = new StringWriter();
                                this.exception.printStackTrace(new PrintWriter((Writer)stringWriter, true));
                                this.workListener.workCompleted(new WorkEvent((Object)this.work, 4, (Work)this.work, (WorkException)new WorkCompletedException(stringWriter.toString())));
                                break;
                            }
                            this.workListener.workCompleted(new WorkEvent((Object)this.work, 4, (Work)this.work, null));
                            break;
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (OutOfMemoryError error) {
                            throw error;
                        }
                        catch (Throwable t) {
                            Log.logThrowable(t);
                            break;
                        }
                    }
                    try {
                        if (mustResume) {
                            ConnectorServiceFrame.transactionManager.resume((Transaction)transaction);
                        }
                        this.work.run();
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (OutOfMemoryError error) {
                        throw error;
                    }
                    catch (Throwable throwable) {
                        Log.logThrowable(throwable);
                    }
                    if (!inTransaction) break;
                    try {
                        ConnectorServiceFrame.transactionManager.suspend();
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (OutOfMemoryError error) {
                        throw error;
                    }
                    catch (Throwable e4) {
                        Log.logThrowable(e4);
                    }
                    transaction.notInThread();
                    break;
                }
                if (this.workListener == null) break;
                stringWriter = new StringWriter();
                this.exception.printStackTrace(new PrintWriter((Writer)stringWriter, true));
                this.workListener.workCompleted(new WorkEvent((Object)this.work, 4, (Work)this.work, (WorkException)new WorkCompletedException(stringWriter.toString())));
                break;
            }
            case 2: {
                try {
                    this.work.run();
                    break;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (OutOfMemoryError error) {
                    throw error;
                }
                catch (Throwable t) {
                    Log.logThrowable(t);
                    break;
                }
            }
            case 3: {
                TaskImpl taskImpl = this;
                synchronized (taskImpl) {
                    if (this.expired) {
                        Object error = null;
                        return error;
                    }
                    this.expired = true;
                    try {
                        ConnectorServiceFrame.timeoutManager.unregisterTimeoutListener((TimeoutListener)this);
                    }
                    catch (HollowTimeoutManager.TimeOutIsStoppedException e) {
                        ConnectorServiceFrame.logException(e);
                    }
                }
                boolean inTransaction = this.executionContext != null && this.executionContext.getXid() != null;
                boolean mustResume = false;
                if (this.workListener != null) {
                    Object stringWriter;
                    JCATransaction transaction = null;
                    this.xidRejected = false;
                    if (inTransaction) {
                        stringWriter = lockMonitor;
                        synchronized (stringWriter) {
                            Xid xid = this.executionContext.getXid();
                            Hashtable txRegistry = TransactionRegistry.getTxRegistry();
                            transaction = (JCATransaction)txRegistry.get(xid);
                            if (transaction == null) {
                                try {
                                    transaction = ConnectorServiceFrame.transactionManager.beginJCATransaction(xid, this.executionContext.getTransactionTimeout());
                                    txRegistry.put(xid, transaction);
                                }
                                catch (ThreadDeath td) {
                                    throw td;
                                }
                                catch (OutOfMemoryError error) {
                                    throw error;
                                }
                                catch (Throwable t) {
                                    Log.logThrowable(t);
                                    this.exception = t;
                                }
                            } else if (transaction.activateInThread()) {
                                this.xidRejected = true;
                            } else {
                                mustResume = true;
                            }
                        }
                    }
                    if (this.xidRejected) {
                        this.workListener.workRejected(new WorkEvent((Object)this.work, 2, (Work)this.work, (WorkException)new WorkRejectedException("Transaction with this XID has already started.")));
                        break;
                    }
                    try {
                        if (mustResume) {
                            ConnectorServiceFrame.transactionManager.resume(transaction);
                        }
                        this.workListener.workStarted(new WorkEvent((Object)this.work, 3, (Work)this.work, null));
                        this.work.run();
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (OutOfMemoryError error) {
                        throw error;
                    }
                    catch (Throwable throwable) {
                        this.exception = throwable;
                        Log.logThrowable(throwable);
                    }
                    if (inTransaction) {
                        try {
                            ConnectorServiceFrame.transactionManager.suspend();
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (OutOfMemoryError error) {
                            throw error;
                        }
                        catch (Throwable e) {
                            Log.logThrowable(e);
                        }
                        transaction.notInThread();
                    }
                    try {
                        if (this.exception != null) {
                            stringWriter = new StringWriter();
                            this.exception.printStackTrace(new PrintWriter((Writer)stringWriter, true));
                            this.workListener.workCompleted(new WorkEvent((Object)this.work, 4, (Work)this.work, (WorkException)new WorkCompletedException(((StringWriter)stringWriter).toString())));
                            break;
                        }
                        this.workListener.workCompleted(new WorkEvent((Object)this.work, 4, (Work)this.work, null));
                        break;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (OutOfMemoryError error) {
                        throw error;
                    }
                    catch (Throwable t) {
                        Log.logThrowable(t);
                        break;
                    }
                }
                JCATransaction transaction = null;
                this.xidRejected = false;
                if (inTransaction) {
                    Object td = lockMonitor;
                    synchronized (td) {
                        Xid xid = this.executionContext.getXid();
                        Hashtable txRegistry = TransactionRegistry.getTxRegistry();
                        transaction = (JCATransaction)txRegistry.get(xid);
                        if (transaction == null) {
                            try {
                                transaction = ConnectorServiceFrame.transactionManager.beginJCATransaction(xid, this.executionContext.getTransactionTimeout());
                                txRegistry.put(xid, transaction);
                            }
                            catch (ThreadDeath td2) {
                                throw td2;
                            }
                            catch (OutOfMemoryError error) {
                                throw error;
                            }
                            catch (Throwable t) {
                                Log.logThrowable(t);
                                this.exception = t;
                            }
                        } else if (transaction.activateInThread()) {
                            this.xidRejected = true;
                        } else {
                            mustResume = true;
                        }
                    }
                }
                if (this.xidRejected || this.exception != null) break;
                try {
                    if (mustResume) {
                        ConnectorServiceFrame.transactionManager.resume(transaction);
                    }
                    this.work.run();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (OutOfMemoryError error) {
                    throw error;
                }
                catch (Throwable throwable) {
                    Log.logThrowable(throwable);
                }
                if (!inTransaction) break;
                try {
                    ConnectorServiceFrame.transactionManager.suspend();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (OutOfMemoryError error) {
                    throw error;
                }
                catch (Throwable e) {
                    Log.logThrowable(e);
                }
                transaction.notInThread();
            }
        }
        return null;
    }

    public void disableTask() {
    }

    public void release() {
        super.release();
        this.exception = null;
        this.workListener = null;
        this.executionContext = null;
        pool.releaseObject(this);
    }

    static TaskImpl getInstance() {
        return (TaskImpl)pool.getObject();
    }

    public void timeout() {
    }

    public boolean check() {
        TaskImpl taskImpl = this;
        synchronized (taskImpl) {
            if (!this.expired) {
                this.expired = true;
                if (this.workListener != null) {
                    this.workListener.workRejected(new WorkEvent((Object)this.work, 2, (Work)this.work, null));
                }
            }
        }
        return false;
    }

    private static class TaskPool
    extends ListPool {
        private TaskPool() {
        }

        public NextItem newInstance() {
            return new TaskImpl();
        }
    }
}

