/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.transaction;

import com.sap.engine.interfaces.transaction.JCATransaction;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.exceptions.BaseXAException;
import com.sap.engine.services.connector.jca15.TransactionRegistry;
import java.util.Hashtable;
import javax.resource.spi.XATerminator;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class XATerminatorImpl
implements XATerminator {
    private Hashtable txRegistry = TransactionRegistry.getTxRegistry();

    public void commit(Xid xid, boolean one_phase) throws XAException {
        JCATransaction jcaTx = (JCATransaction)this.txRegistry.get(xid);
        if (jcaTx != null && jcaTx.isAlive()) {
            if (jcaTx.getActiveThreadFlag()) {
                throw new XAException(this + " was tried to be commited while it was active in another thread");
            }
            try {
                if (!one_phase && jcaTx.getStatus() != 2) {
                    throw new BaseXAException("connector_1100");
                }
                JCATransaction jCATransaction = jcaTx;
                synchronized (jCATransaction) {
                    if (jcaTx.getStatus() == 2) {
                        jcaTx.commit();
                    } else {
                        int prepareStatus = jcaTx.prepare();
                        if (prepareStatus == 0) {
                            jcaTx.commit();
                        }
                    }
                    this.txRegistry.remove(xid);
                }
            }
            catch (RollbackException e) {
                Log.logThrowable(e);
            }
            catch (HeuristicMixedException e) {
                Log.logThrowable(e);
            }
            catch (HeuristicRollbackException e) {
                Log.logThrowable(e);
            }
            catch (SecurityException e) {
                Log.logThrowable(e);
            }
            catch (IllegalStateException e) {
                Log.logThrowable(e);
            }
            catch (SystemException e) {
                Log.logThrowable(e);
            }
        }
    }

    public void forget(Xid xid) throws XAException {
        JCATransaction jcaTx = (JCATransaction)this.txRegistry.get(xid);
        if (jcaTx != null && jcaTx.isAlive()) {
            JCATransaction jCATransaction = jcaTx;
            synchronized (jCATransaction) {
                jcaTx.forget();
            }
        }
    }

    public int prepare(Xid xid) throws XAException {
        JCATransaction jcaTx = (JCATransaction)this.txRegistry.get(xid);
        if (jcaTx != null && jcaTx.isAlive()) {
            try {
                JCATransaction jCATransaction = jcaTx;
                synchronized (jCATransaction) {
                    int prepStatus;
                    int n = prepStatus = jcaTx.prepare();
                    return n;
                }
            }
            catch (RollbackException e) {
                Log.logThrowable(e);
            }
            catch (HeuristicMixedException e) {
                Log.logThrowable(e);
            }
            catch (SystemException e) {
                Log.logThrowable(e);
            }
        }
        throw new XAException("Trying to prepare transaction which is not alive");
    }

    public Xid[] recover(int i) throws XAException {
        return new Xid[0];
    }

    public void rollback(Xid xid) throws XAException {
        JCATransaction jcaTx = (JCATransaction)this.txRegistry.get(xid);
        if (jcaTx != null && jcaTx.isAlive()) {
            if (jcaTx.getActiveThreadFlag()) {
                throw new XAException(this + " was tried to be commited while it was active in another thread");
            }
            try {
                JCATransaction jCATransaction = jcaTx;
                synchronized (jCATransaction) {
                    jcaTx.rollback();
                    this.txRegistry.remove(xid);
                }
            }
            catch (IllegalStateException e) {
                Log.logThrowable(e);
            }
            catch (SystemException e) {
                Log.logThrowable(e);
            }
        }
    }
}

