/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.gui;

import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca15.gui.RuntimeControls;
import javax.swing.tree.DefaultMutableTreeNode;

public class ApplicationNode
extends DefaultMutableTreeNode {
    private String appName = null;
    private String jndiName = null;
    private boolean isConnector = false;
    private JCDescriptor jcDescriptor = null;
    private RuntimeControls connectorRuntimeInt = null;
    private boolean isAppStarted = false;
    private boolean isRealApp = false;

    public ApplicationNode(JCDescriptor jcDescriptor) {
        this.isConnector = true;
        this.jcDescriptor = jcDescriptor;
        this.appName = jcDescriptor.getApplicationName();
        this.jndiName = jcDescriptor.getConnectorJNDIName();
    }

    public ApplicationNode(String appName, boolean isRealApp) {
        this.appName = appName;
        this.isRealApp = isRealApp;
    }

    public String getName() {
        return this.isConnector ? this.jndiName : this.appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public JCDescriptor getJCDescriptor() {
        return this.jcDescriptor;
    }

    public void setJCDescriptor(JCDescriptor jcDescriptor) {
        this.jcDescriptor = jcDescriptor;
    }

    public RuntimeControls getRuntimeInterface() {
        return this.connectorRuntimeInt;
    }

    public boolean isApplicationNode() {
        return !this.isConnector;
    }

    public boolean isRealApplication() {
        return this.isRealApp;
    }

    public boolean isAppStarted() {
        return this.isAppStarted;
    }

    public void setAppStarted(boolean isAppStarted) {
        this.isAppStarted = isAppStarted;
    }

    public String toString() {
        return this.getName();
    }
}

