/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy.verify;

import com.sap.engine.frame.core.load.ResourceLoader;
import com.sap.engine.services.connector.exceptions.BaseDeploymentException;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConnectorDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ResourceAdapterDescriptor;
import com.sap.engine.services.connector.jca15.deploy.verify.CheckResult;
import com.sap.engine.services.connector.jca15.deploy.verify.ConnectorConfigPropertiesVerifier;
import com.sap.engine.services.connector.jca15.deploy.verify.Log;
import com.sap.engine.services.connector.jca15.deploy.verify.ResAdapterClassImplVerifier;
import com.sap.engine.services.connector.jca15.deploy.verify.Utilities;
import com.sap.engine.services.deploy.container.DeploymentException;

public class RARequirementsCheck {
    public static void checkJ2EEConnectorRequirements(ConnectorDescriptor connectorDescriptor, ResourceLoader resourceLoader) throws DeploymentException {
        Log.logDebug("RARequirementsCheck.checkJ2EEConnectorRequirements()");
        ResourceAdapterDescriptor raDescriptor = connectorDescriptor.getResourceAdapterDescriptor();
        ResAdapterClassImplVerifier resAdapterVerifier = new ResAdapterClassImplVerifier(connectorDescriptor, resourceLoader);
        CheckResult checkResult = resAdapterVerifier.verify();
        Log.logError("1st phase: " + checkResult.toString());
        ConnectorConfigPropertiesVerifier connectorCfgPropsVerifier = new ConnectorConfigPropertiesVerifier(connectorDescriptor, resourceLoader);
        CheckResult currCheckResult = connectorCfgPropsVerifier.verify();
        checkResult.appendCheckResult(currCheckResult);
        Log.logError("2nd phase: " + checkResult.toString());
        if (checkResult.hasErrors()) {
            throw new BaseDeploymentException("connector_0046", new String[]{Utilities.LINE_SEPARATOR + checkResult.toString()});
        }
    }
}

