/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy.verify;

import com.sap.engine.services.connector.ConnectorResourceAccessor;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.jca15.deploy.verify.Utilities;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class CheckResult {
    List warningsList = new LinkedList();
    List errorsList = new LinkedList();

    CheckResult() {
    }

    void addWarning(String msg) {
        this.warningsList.add(msg);
    }

    void addError(String msg) {
        this.errorsList.add(msg);
    }

    List getErrorsList() {
        return this.errorsList;
    }

    List getWarningsList() {
        return this.warningsList;
    }

    boolean appendCheckResult(CheckResult checkResult) {
        try {
            this.errorsList.addAll(checkResult.errorsList);
            this.warningsList.addAll(checkResult.warningsList);
        }
        catch (Exception exc) {
            ConnectorResourceAccessor.location.logT(500, "appendCheckResult(), Error: " + Log.getStackTrace(exc));
            return false;
        }
        return true;
    }

    boolean hasErrors() {
        return this.errorsList != null && !this.errorsList.isEmpty();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String lineSep = Utilities.LINE_SEPARATOR;
        Iterator iter = this.errorsList.iterator();
        Object currElement = null;
        while (iter.hasNext()) {
            currElement = iter.next();
            sb.append((Object)currElement);
            sb.append(lineSep);
        }
        iter = this.warningsList.iterator();
        while (iter.hasNext()) {
            currElement = iter.next();
            sb.append((Object)currElement);
            sb.append(lineSep);
        }
        return sb.toString();
    }
}

