/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy.generator;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.lib.lang.RunExec;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.connector.ConnectorResourceAccessor;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.exceptions.BaseDeploymentException;
import com.sap.engine.services.connector.exceptions.BaseXMLParserException;
import com.sap.engine.services.connector.jca15.deploy.AdminUtils;
import com.sap.engine.services.connector.jca15.deploy.descriptors.xml.XMLGenerator;
import com.sap.engine.services.deploy.container.DeploymentException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EndPointGenerator {
    public static final String PRIMITIVE_BYTE = "byte";
    public static final String PRIMITIVE_CHAR = "char";
    public static final String PRIMITIVE_SHORT = "short";
    public static final String PRIMITIVE_INT = "int";
    public static final String PRIMITIVE_LONG = "long";
    public static final String PRIMITIVE_FLOAT = "float";
    public static final String PRIMITIVE_DOUBLE = "double";
    public static final String PRIMITIVE_BOOLEAN = "boolean";
    public static final String EMPTY = "";
    public static final String QUOTE = "\"";
    public static final char separatorChar = File.separatorChar;
    public static final String JAR_ENTRY_SEP_STRING = "/";
    public static final char JAR_ENTRY_SEP_CHAR = '/';
    public static final String INTERNAL_COMPILER = "InternalCompiler";
    public static final String DEF_INTERNAL_COMPILER = "false";
    public static final String INTERNAL_COMPILER_CLASS = "sun.tools.javac.Main";
    public static final String INTERNAL_COMPILER_METHOD = "compile";
    public static final String EXTERNAL_COMPILER = "ExternalCompiler";
    public static final String DEF_EXTERNAL_COMPILER = "javac";
    public static final String MAX_FILES_FOR_COMPILE = "MaxFilesForCompile";
    public static final int DEF_MAX_FILES_FOR_COMPILE = 50;
    public static final String PROP_OS_NAME = "os.name";
    public static final String WINDOWS = "WINDOWS";
    public static final String OPTION_NOWARN = "-nowarn";
    public static final String OPTION_ENCODING = "-encoding";
    public static final String OPTION_CLASSPATH = "-classpath";
    public static final String PROP_FILE_ENCODING = "file.encoding";
    public static final String UTF8 = "UTF8";
    public static final String PROP_JAVA_CLASS_PATH = "java.class.path";
    public static final String EXT_CLASS = ".class";
    public static Method sun_tools_javac_Main_compile = null;
    public static Constructor sun_tools_javac_Main_constructor = null;
    private String messageListenerType = null;
    private ClassLoader classLoader = null;
    private String tempDirectory = null;
    private TransformerFactory factory = null;
    private Properties transformerProps = null;
    static /* synthetic */ Class class$com$sap$engine$services$connector$jca15$deploy$generator$EndPointGenerator;

    public EndPointGenerator(String messageListenerType, ClassLoader classLoader, String tempDirectory) {
        this.messageListenerType = messageListenerType;
        this.classLoader = classLoader;
        this.tempDirectory = tempDirectory;
        this.transformerProps = new Properties();
        this.transformerProps.setProperty("omit-xml-declaration", "yes");
        this.transformerProps.setProperty("indent", "no");
    }

    public void generateEndPointXML() throws DeploymentException {
        Document document = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$connector$jca15$deploy$generator$EndPointGenerator == null ? (class$com$sap$engine$services$connector$jca15$deploy$generator$EndPointGenerator = EndPointGenerator.class$("com.sap.engine.services.connector.jca15.deploy.generator.EndPointGenerator")) : class$com$sap$engine$services$connector$jca15$deploy$generator$EndPointGenerator).getClassLoader());
            document = StandardDOMParser.createDocument();
            Object var4_3 = null;
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Thread.currentThread().setContextClassLoader(cl);
            throw throwable;
        }
        Element root = document.createElement("end-point");
        document.appendChild(root);
        Class<?> mlClass = null;
        try {
            mlClass = this.classLoader.loadClass(this.messageListenerType);
        }
        catch (ClassNotFoundException e) {
            throw new BaseDeploymentException("connector_0026", this.messageListenerType, (Throwable)e);
        }
        String fullName = mlClass.getName();
        int index = fullName.lastIndexOf(46);
        String packageName = fullName.substring(0, index);
        String className = fullName.substring(index + 1);
        XMLGenerator.createSubElement(document, root, packageName, "package-name");
        XMLGenerator.createSubElement(document, root, className, "class-name");
        Method[] methods = mlClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (!Modifier.isStatic(methods[i].getModifiers())) {
                Element method = document.createElement("method");
                Element methodParameters = document.createElement("method-parameters");
                Element exceptions = document.createElement("exceptions");
                XMLGenerator.createSubElement(document, method, Modifier.toString(methods[i].getModifiers() ^ 0x400), "modifier");
                XMLGenerator.createSubElement(document, method, EndPointGenerator.convertClassName(methods[i].getReturnType().getName()), "return-type");
                XMLGenerator.createSubElement(document, method, methods[i].getName(), "method-name");
                Class<?>[] parameters = methods[i].getParameterTypes();
                int j = 0;
                while (j < parameters.length) {
                    XMLGenerator.createSubElement(document, methodParameters, EndPointGenerator.convertClassName(parameters[j].getName()), "parameter");
                    ++j;
                }
                Class<?>[] methodExceptions = methods[i].getExceptionTypes();
                int k = 0;
                while (k < methodExceptions.length) {
                    XMLGenerator.createSubElement(document, exceptions, methodExceptions[k].getName(), "exception");
                    ++k;
                }
                method.appendChild(methodParameters);
                method.appendChild(exceptions);
                root.appendChild(method);
            }
            ++i;
        }
        XMLGenerator.writeToFile(document, this.tempDirectory + "message-listener-methods.xml");
    }

    public static String convertClassName(String className) {
        if (className.charAt(0) != '[') {
            return className;
        }
        int first = className.indexOf(91);
        int last = className.lastIndexOf(91);
        char ch = className.charAt(last + 1);
        String st = EMPTY;
        int i = 0;
        while (i <= last - first) {
            st = st + "[]";
            ++i;
        }
        switch (ch) {
            case 'B': {
                return PRIMITIVE_BYTE + st;
            }
            case 'C': {
                return PRIMITIVE_CHAR + st;
            }
            case 'D': {
                return PRIMITIVE_DOUBLE + st;
            }
            case 'F': {
                return PRIMITIVE_FLOAT + st;
            }
            case 'I': {
                return PRIMITIVE_INT + st;
            }
            case 'J': {
                return PRIMITIVE_LONG + st;
            }
            case 'S': {
                return PRIMITIVE_SHORT + st;
            }
            case 'Z': {
                return PRIMITIVE_BOOLEAN + st;
            }
            case 'L': {
                return className.substring(last + 2, className.length() - 1) + st;
            }
        }
        return EMPTY;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File processXSLT(String fileName, String xmlFileName, String xslFileName) throws DeploymentException {
        FileOutputStream fos = null;
        File file = null;
        try {
            try {
                fileName = fileName.replace('.', separatorChar) + ".java";
                Transformer transformer = this.getTransformerFactory().newTransformer(new StreamSource(xslFileName));
                transformer.setOutputProperties(this.transformerProps);
                file = new File(this.tempDirectory, fileName);
                AdminUtils.makeAllSubDirs(file, true);
                fos = new FileOutputStream(file);
                transformer.transform(new StreamSource(xmlFileName), new StreamResult(fos));
            }
            catch (TransformerConfigurationException tcExc) {
                ConnectorResourceAccessor.location.logT(500, "processXSLT(), Error: " + Log.getStackTrace(tcExc));
                Object var10_9 = null;
                if (fos == null) return file;
                try {
                    fos.close();
                    return file;
                }
                catch (IOException e) {
                    throw new BaseXMLParserException("connector_0801", new Object[]{fileName}, (Throwable)e);
                }
            }
            catch (FileNotFoundException fnfe) {
                throw new BaseXMLParserException("connector_0801", new Object[]{fileName}, (Throwable)fnfe);
            }
            catch (TransformerException tExc) {
                ConnectorResourceAccessor.location.logT(500, "processXSLT(), Error: " + Log.getStackTrace(tExc));
                Object var10_10 = null;
                if (fos == null) return file;
                try {}
                catch (IOException e) {
                    throw new BaseXMLParserException("connector_0801", new Object[]{fileName}, (Throwable)e);
                }
                fos.close();
                return file;
            }
            Object var10_8 = null;
            if (fos == null) return file;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (fos == null) return file;
            try {}
            catch (IOException e) {
                throw new BaseXMLParserException("connector_0801", new Object[]{fileName}, (Throwable)e);
            }
            fos.close();
            return file;
        }
        try {}
        catch (IOException e) {
            throw new BaseXMLParserException("connector_0801", new Object[]{fileName}, (Throwable)e);
        }
        fos.close();
        return file;
    }

    private TransformerFactory getTransformerFactory() {
        if (this.factory == null) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.factory = TransformerFactory.newInstance();
            Thread.currentThread().setContextClassLoader(this.classLoader);
        }
        return this.factory;
    }

    public void compile(String classPath, String[] javaFiles, Properties serviceProps) throws IOException {
        boolean internalCompiler = new Boolean(serviceProps.getProperty(INTERNAL_COMPILER, DEF_INTERNAL_COMPILER));
        String externalCompiler = serviceProps.getProperty(EXTERNAL_COMPILER, DEF_EXTERNAL_COMPILER);
        String stringMaxFiles = serviceProps.getProperty(MAX_FILES_FOR_COMPILE);
        int maxFilesForCompile = 50;
        if (stringMaxFiles != null && (maxFilesForCompile = new Integer(stringMaxFiles).intValue()) <= 0) {
            maxFilesForCompile = 50;
        }
        if (!internalCompiler) {
            this.compileExternal(classPath, javaFiles, externalCompiler, maxFilesForCompile);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void compileExternal(String classPath, String[] javaFiles, String externalCompiler, int maxFilesForCompile) throws IOException {
        if (javaFiles.length == 0) {
            return;
        }
        try {
            quote = SystemProperties.getProperty("os.name").toUpperCase().startsWith("WINDOWS") != false ? "\"" : "";
        }
        catch (Exception e) {
            quote = "";
        }
        cmd = new String[]{externalCompiler, "-nowarn", "-encoding", SystemProperties.getProperty("file.encoding", "UTF8"), "-classpath", quote + classPath + File.pathSeparator + SystemProperties.getProperty("java.class.path") + quote};
        filesForCompile = javaFiles.length;
        currentFilesForCompile = 0;
        while (filesForCompile > 0) {
            block10: {
                currentFilesForCompile = filesForCompile > maxFilesForCompile ? maxFilesForCompile : filesForCompile;
                cmd1 = new String[currentFilesForCompile + 6];
                System.arraycopy(cmd, 0, cmd1, 0, 6);
                pt = 0;
                i = 0;
                while (i < currentFilesForCompile) {
                    cmd1[i + 6] = quote + EndPointGenerator.separatorChar + javaFiles[pt++] + quote;
                    ++i;
                }
                filesForCompile -= currentFilesForCompile;
                compiler = null;
                try {
                    compiler = new RunExec(cmd1);
                    compiler.exec();
                    break block10;
                }
                catch (IOException ioExc) {
                    commandLine = new StringBuffer();
                    c = 0;
                    ** while (c < cmd1.length)
                }
lbl-1000:
                // 1 sources

                {
                    commandLine.append(cmd1[c]).append(" ");
                    ++c;
                    continue;
                }
lbl35:
                // 1 sources

                ConnectorResourceAccessor.location.logT(500, "compileExternal(), Error: " + Log.getStackTrace(ioExc));
            }
            res = 1;
            try {
                res = compiler.waitFor();
            }
            catch (Exception intExc) {
                ConnectorResourceAccessor.location.logT(500, "compileExternal(), Error: " + Log.getStackTrace(intExc));
            }
            errors = null;
            if (res == 0) continue;
            errors = compiler.getError();
            System.out.println("errors = " + errors);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ZipOutputStream makeJar(File dir, String jarFileName) throws IOException {
        byte[] byteBuffer = new byte[1024];
        ZipOutputStream jar = null;
        try {
            jar = new ZipOutputStream(new FileOutputStream(jarFileName));
        }
        catch (IOException ioExc) {
            ConnectorResourceAccessor.location.logT(500, "makeJar(), Dir: " + dir.getAbsolutePath() + ", JarFileNane: " + jarFileName + ", Error: " + Log.getStackTrace(ioExc));
        }
        try {
            try {
                File[] files = dir.listFiles();
                int i = 0;
                block6: while (i < files.length) {
                    Vector entries = this.listNames(files[i]);
                    Enumeration e = entries.elements();
                    while (true) {
                        if (!e.hasMoreElements()) {
                            ++i;
                            continue block6;
                        }
                        String entryName = (String)e.nextElement();
                        if (!entryName.endsWith(EXT_CLASS)) continue;
                        jar.putNextEntry(new ZipEntry(entryName));
                        FileInputStream fis = new FileInputStream(new File(dir, entryName.replace('/', separatorChar)));
                        jar.write(this.read(fis, byteBuffer));
                        jar.closeEntry();
                    }
                }
            }
            catch (IOException ioExc) {
                ConnectorResourceAccessor.location.logT(500, "makeJar(), Dir: " + dir.getAbsolutePath() + ", JarFileNane: " + jarFileName + ", Error: " + Log.getStackTrace(ioExc));
                Object var12_14 = null;
                jar.close();
                return jar;
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            jar.close();
            return jar;
        }
        jar.close();
        return jar;
    }

    public Vector listNames(File dir) throws IOException {
        Vector<String> result = new Vector<String>();
        String fileName = dir.getName();
        if (dir.isFile()) {
            result.add(fileName);
            return result;
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                Vector newFiles = this.listNames(files[i]);
                Enumeration e = newFiles.elements();
                while (e.hasMoreElements()) {
                    result.add(fileName + JAR_ENTRY_SEP_STRING + (String)e.nextElement());
                }
            } else {
                result.add(fileName + JAR_ENTRY_SEP_STRING + files[i].getName());
            }
            ++i;
        }
        return result;
    }

    public byte[] read(InputStream source, byte[] byteBuffer) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int length = source.read(byteBuffer, 0, 1024);
        while (length != -1) {
            buffer.write(byteBuffer, 0, length);
            length = source.read(byteBuffer, 0, 1024);
        }
        source.close();
        buffer.flush();
        buffer.close();
        return buffer.toByteArray();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

