/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy.descriptors;

import com.sap.engine.services.connector.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.connector.jca15.deploy.descriptors.AuthenticationMechanism;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConnectionDefinition;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import java.io.Serializable;

public class OutboundResourceAdapterDescriptor
implements Serializable {
    public static final String NO_TRANSACTION_SUPPORT = "NoTransaction";
    public static final String LOCAL_TRANSACTION_SUPPORT = "LocalTransaction";
    public static final String XA_TRANSACTION_SUPPORT = "XATransaction";
    public static final byte NO_TRANSACTION_LEVEL = 0;
    public static final byte LOCAL_TRANSACTION_LEVEL = 1;
    public static final byte XA_TRANSACTION_LEVEL = 2;
    private ConnectionDefinition[] connectionDefinitions = null;
    private String transactionSupport = null;
    private int transactionLevel = 0;
    private AuthenticationMechanism[] authenticationMechanisms = null;
    private boolean reauthenticationSupport = false;

    public OutboundResourceAdapterDescriptor() {
    }

    public OutboundResourceAdapterDescriptor(ConnectionDefinition[] connectionDefinitions, String transactionSupport, AuthenticationMechanism[] authenticationMechanisms, boolean reauthenticationSupport) {
        this.setConnectionDefinitions(connectionDefinitions);
        this.setTransactionSupport(transactionSupport);
        this.setAuthenticationMechanisms(authenticationMechanisms);
        this.setReauthenticationSupport(reauthenticationSupport);
    }

    public ConnectionDefinition[] getConnectionDefinitions() {
        return this.connectionDefinitions;
    }

    public void setConnectionDefinitions(ConnectionDefinition[] connectionDefinitions) {
        if (connectionDefinitions == null) {
            throw new BaseIllegalArgumentException("connector_0306", "connection-definition");
        }
        this.connectionDefinitions = connectionDefinitions;
    }

    public String getTransactionSupport() {
        return this.transactionSupport;
    }

    public int getTransactionLevel() {
        return this.transactionLevel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTransactionSupport(String transactionSupport) {
        if (transactionSupport == null) throw new BaseIllegalArgumentException("connector_0306", "transaction-support");
        if (transactionSupport.equals(NO_TRANSACTION_SUPPORT)) {
            this.transactionSupport = NO_TRANSACTION_SUPPORT;
            this.transactionLevel = 0;
            return;
        } else if (transactionSupport.equals(LOCAL_TRANSACTION_SUPPORT)) {
            this.transactionSupport = LOCAL_TRANSACTION_SUPPORT;
            this.transactionLevel = 1;
            return;
        } else {
            if (!transactionSupport.equals(XA_TRANSACTION_SUPPORT)) throw new BaseIllegalArgumentException("connector_0303", new String[]{"transaction-support", "NoTransaction,LocalTransaction,XATransaction"});
            this.transactionSupport = XA_TRANSACTION_SUPPORT;
            this.transactionLevel = 2;
        }
    }

    public AuthenticationMechanism[] getAuthenticationMechanisms() {
        return this.authenticationMechanisms;
    }

    public void setAuthenticationMechanisms(AuthenticationMechanism[] authenticationMechanisms) {
        this.authenticationMechanisms = authenticationMechanisms;
    }

    public boolean isReauthenticationSupport() {
        return this.reauthenticationSupport;
    }

    public void setReauthenticationSupport(boolean reauthenticationSupport) {
        this.reauthenticationSupport = reauthenticationSupport;
    }

    public Object clone() {
        int i;
        OutboundResourceAdapterDescriptor cloning = new OutboundResourceAdapterDescriptor();
        if (this.connectionDefinitions == null) {
            cloning.connectionDefinitions = null;
        } else {
            cloning.connectionDefinitions = new ConnectionDefinition[this.connectionDefinitions.length];
            i = 0;
            while (i < this.connectionDefinitions.length) {
                cloning.connectionDefinitions[i] = this.connectionDefinitions[i] == null ? null : (ConnectionDefinition)this.connectionDefinitions[i].clone();
                ++i;
            }
        }
        cloning.transactionSupport = this.transactionSupport == null ? null : new String(this.transactionSupport);
        cloning.transactionLevel = this.transactionLevel;
        if (this.authenticationMechanisms == null) {
            cloning.authenticationMechanisms = null;
        } else {
            cloning.authenticationMechanisms = new AuthenticationMechanism[this.authenticationMechanisms.length];
            i = 0;
            while (i < this.authenticationMechanisms.length) {
                cloning.authenticationMechanisms[i] = this.authenticationMechanisms[i] == null ? null : (AuthenticationMechanism)this.authenticationMechanisms[i].clone();
                ++i;
            }
        }
        cloning.reauthenticationSupport = this.isReauthenticationSupport();
        return cloning;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof OutboundResourceAdapterDescriptor)) {
            return false;
        }
        OutboundResourceAdapterDescriptor outboundResourceAdapter = (OutboundResourceAdapterDescriptor)object;
        if (!EqualUtils.equalUnOrderedArrays(outboundResourceAdapter.connectionDefinitions, this.connectionDefinitions)) {
            return false;
        }
        if (outboundResourceAdapter.transactionSupport != null ? !outboundResourceAdapter.transactionSupport.equals(this.transactionSupport) : this.transactionSupport != null) {
            return false;
        }
        if (outboundResourceAdapter.transactionLevel != this.transactionLevel) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(outboundResourceAdapter.authenticationMechanisms, this.authenticationMechanisms)) {
            return false;
        }
        return outboundResourceAdapter.reauthenticationSupport == this.reauthenticationSupport;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

