/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy.descriptors;

import com.sap.engine.services.connector.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.connector.jca15.deploy.descriptors.RequiredConfigProperty;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import java.io.Serializable;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.endpoint.MessageEndpointFactory;

public class MessageListener
implements Serializable {
    private String messageListenerType = null;
    private String activationSpecClass = null;
    private RequiredConfigProperty[] requiredConfigProperties = null;
    private transient MessageEndpointFactory messageEndpointFactory = null;
    private transient ActivationSpec activationSpec = null;
    private String messageListenerName = null;

    public MessageListener() {
    }

    public MessageListener(String messageListenerType, String activationSpecClass, RequiredConfigProperty[] requiredConfigProperties, MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec, String messageListenerName) {
        this.setMessageListenerType(messageListenerType);
        this.setActivationSpecClass(activationSpecClass);
        this.setRequiredConfigProperties(requiredConfigProperties);
        this.setMessageEndpointFactory(messageEndpointFactory);
        this.setActivationSpec(activationSpec);
        this.setMessageListenerName(messageListenerName);
    }

    public String getMessageListenerType() {
        return this.messageListenerType;
    }

    public void setMessageListenerType(String messageListenerType) {
        if (messageListenerType == null) {
            throw new BaseIllegalArgumentException("connector_0306", "messagelistener-type");
        }
        this.messageListenerType = messageListenerType;
    }

    public String getActivationSpecClass() {
        return this.activationSpecClass;
    }

    public void setActivationSpecClass(String activationSpecClass) {
        if (activationSpecClass == null) {
            throw new BaseIllegalArgumentException("connector_0306", "activationspec-class");
        }
        this.activationSpecClass = activationSpecClass;
    }

    public RequiredConfigProperty[] getRequiredConfigProperties() {
        return this.requiredConfigProperties;
    }

    public void setRequiredConfigProperties(RequiredConfigProperty[] requiredConfigProperties) {
        this.requiredConfigProperties = requiredConfigProperties;
    }

    public MessageEndpointFactory getMessageEndpointFactory() {
        return this.messageEndpointFactory;
    }

    public void setMessageEndpointFactory(MessageEndpointFactory messageEndpointFactory) {
        this.messageEndpointFactory = messageEndpointFactory;
    }

    public ActivationSpec getActivationSpec() {
        return this.activationSpec;
    }

    public void setActivationSpec(ActivationSpec activationSpec) {
        this.activationSpec = activationSpec;
    }

    public String getMessageListenerName() {
        return this.messageListenerName;
    }

    public void setMessageListenerName(String messageListenerName) {
        if (messageListenerName == null) {
            throw new BaseIllegalArgumentException("connector_0306", "messagelistener-name");
        }
        this.messageListenerName = messageListenerName;
    }

    public Object clone() {
        MessageListener cloning = new MessageListener();
        cloning.messageListenerType = this.messageListenerType == null ? null : new String(this.messageListenerType);
        String string = cloning.activationSpecClass = this.activationSpecClass == null ? null : new String(this.activationSpecClass);
        if (this.requiredConfigProperties == null) {
            cloning.requiredConfigProperties = null;
        } else {
            cloning.requiredConfigProperties = new RequiredConfigProperty[this.requiredConfigProperties.length];
            int i = 0;
            while (i < this.requiredConfigProperties.length) {
                cloning.requiredConfigProperties[i] = this.requiredConfigProperties[i] == null ? null : (RequiredConfigProperty)this.requiredConfigProperties[i].clone();
                ++i;
            }
        }
        cloning.messageEndpointFactory = this.messageEndpointFactory;
        cloning.activationSpec = this.activationSpec;
        cloning.messageListenerName = this.messageListenerName == null ? null : new String(this.messageListenerName);
        return cloning;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof MessageListener)) {
            return false;
        }
        MessageListener messageListener = (MessageListener)object;
        if (messageListener.messageListenerType != null ? !messageListener.messageListenerType.equals(this.messageListenerType) : this.messageListenerType != null) {
            return false;
        }
        if (messageListener.activationSpecClass != null ? !messageListener.activationSpecClass.equals(this.activationSpecClass) : this.activationSpecClass != null) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(messageListener.requiredConfigProperties, this.requiredConfigProperties)) {
            return false;
        }
        if (messageListener.messageEndpointFactory != null ? !messageListener.messageEndpointFactory.equals(this.messageEndpointFactory) : this.messageEndpointFactory != null) {
            return false;
        }
        if (messageListener.activationSpec != null ? !messageListener.activationSpec.equals(this.activationSpec) : this.activationSpec != null) {
            return false;
        }
        return !(messageListener.messageListenerName != null ? !messageListener.messageListenerName.equals(this.messageListenerName) : this.messageListenerName != null);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

