/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy.descriptors;

import com.sap.engine.services.connector.exceptions.BaseIllegalArgumentException;
import java.io.Serializable;

public class AuthenticationMechanism
implements Serializable {
    public static final String BASIC_PASSWORD = "BasicPassword";
    public static final String KERBV_5 = "Kerbv5";
    public static final String PASSWORD_CREDENTIAL = "javax.resource.spi.security.PasswordCredential";
    public static final String GSS_CREDENTIAL = "org.ietf.jgss.GSSCredential";
    public static final String GENERIC_CREDENTIAL = "javax.resource.spi.security.GenericCredential";
    private String description = null;
    private String authenticationMechanismType = null;
    private String credentialInterface = null;

    public AuthenticationMechanism() {
    }

    public AuthenticationMechanism(String description, String authenticationMechanismType, String credentialInterface) {
        this.setDescription(description);
        this.setAuthenticationMechanismType(authenticationMechanismType);
        this.setCredentialInterface(credentialInterface);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAuthenticationMechanismType() {
        return this.authenticationMechanismType;
    }

    public void setAuthenticationMechanismType(String authenticationMechanismType) {
        if (authenticationMechanismType != null) {
            if (!authenticationMechanismType.equals(BASIC_PASSWORD) && !authenticationMechanismType.equals(KERBV_5)) {
                throw new BaseIllegalArgumentException("connector_0303", new String[]{"authentication-mechanism-type", "BasicPassword,Kerbv5"});
            }
        } else {
            throw new BaseIllegalArgumentException("connector_0306", "authentication-mechanism-type");
        }
        this.authenticationMechanismType = authenticationMechanismType;
    }

    public String getCredentialInterface() {
        return this.credentialInterface;
    }

    public void setCredentialInterface(String credentialInterface) {
        if (credentialInterface != null) {
            if (!(credentialInterface.equals(PASSWORD_CREDENTIAL) || credentialInterface.equals(GSS_CREDENTIAL) || credentialInterface.equals(GENERIC_CREDENTIAL))) {
                throw new BaseIllegalArgumentException("connector_0303", new String[]{"credential-interface", "javax.resource.spi.security.PasswordCredential,org.ietf.jgss.GSSCredential,javax.resource.spi.security.GenericCredential"});
            }
        } else {
            throw new BaseIllegalArgumentException("connector_0306", "credential-interface");
        }
        this.credentialInterface = credentialInterface;
    }

    public Object clone() {
        AuthenticationMechanism cloning = new AuthenticationMechanism();
        cloning.description = this.description == null ? null : new String(this.description);
        cloning.authenticationMechanismType = this.authenticationMechanismType == null ? null : new String(this.authenticationMechanismType);
        cloning.credentialInterface = this.credentialInterface == null ? null : new String(this.credentialInterface);
        return cloning;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof AuthenticationMechanism)) {
            return false;
        }
        AuthenticationMechanism authenticationMechanism = (AuthenticationMechanism)object;
        if (authenticationMechanism.description != null ? !authenticationMechanism.description.equals(this.description) : this.description != null) {
            return false;
        }
        if (authenticationMechanism.authenticationMechanismType != null ? !authenticationMechanism.authenticationMechanismType.equals(this.authenticationMechanismType) : this.authenticationMechanismType != null) {
            return false;
        }
        return !(authenticationMechanism.credentialInterface != null ? !authenticationMechanism.credentialInterface.equals(this.credentialInterface) : this.credentialInterface != null);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

