/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy.descriptors;

import com.sap.engine.services.connector.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConfigProperty;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import java.io.Serializable;

public class AdminObjectDescriptor
implements Serializable {
    private String adminObjectInterface = null;
    private String adminObjectClass = null;
    private ConfigProperty[] configProperties = null;

    public AdminObjectDescriptor() {
    }

    public AdminObjectDescriptor(String adminObjectInterface, String adminObjectClass, ConfigProperty[] configProperties) {
        this.setAdminObjectInterface(adminObjectInterface);
        this.setAdminObjectClass(adminObjectClass);
        this.setConfigProperties(configProperties);
    }

    public String getAdminObjectInterface() {
        return this.adminObjectInterface;
    }

    public void setAdminObjectInterface(String adminObjectInterface) {
        if (adminObjectInterface == null) {
            throw new BaseIllegalArgumentException("connector_0306", "adminobject-interface");
        }
        this.adminObjectInterface = adminObjectInterface;
    }

    public String getAdminObjectClass() {
        return this.adminObjectClass;
    }

    public void setAdminObjectClass(String adminObjectClass) {
        if (adminObjectClass == null) {
            throw new BaseIllegalArgumentException("connector_0306", "adminobject-class");
        }
        this.adminObjectClass = adminObjectClass;
    }

    public ConfigProperty[] getConfigProperties() {
        return this.configProperties;
    }

    public void setConfigProperties(ConfigProperty[] configProperties) {
        this.configProperties = configProperties;
    }

    public Object clone() {
        AdminObjectDescriptor cloning = new AdminObjectDescriptor();
        cloning.adminObjectInterface = this.adminObjectInterface == null ? null : new String(this.adminObjectInterface);
        String string = cloning.adminObjectClass = this.adminObjectClass == null ? null : new String(this.adminObjectClass);
        if (this.configProperties == null) {
            cloning.configProperties = null;
        } else {
            cloning.configProperties = new ConfigProperty[this.configProperties.length];
            int i = 0;
            while (i < this.configProperties.length) {
                cloning.configProperties[i] = this.configProperties[i] == null ? null : (ConfigProperty)this.configProperties[i].clone();
                ++i;
            }
        }
        return cloning;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof AdminObjectDescriptor)) {
            return false;
        }
        AdminObjectDescriptor adminObject = (AdminObjectDescriptor)object;
        if (adminObject.adminObjectInterface != null ? !adminObject.adminObjectInterface.equals(this.adminObjectInterface) : this.adminObjectInterface != null) {
            return false;
        }
        if (adminObject.adminObjectClass != null ? !adminObject.adminObjectClass.equals(this.adminObjectClass) : this.adminObjectClass != null) {
            return false;
        }
        return EqualUtils.equalUnOrderedArrays(adminObject.configProperties, this.configProperties);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

