/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ResourceLoader;
import com.sap.engine.interfaces.security.AuthenticationContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.auth.CallerImpersonationConfiguration;
import com.sap.engine.interfaces.security.auth.ConfiguredIdentityConfiguration;
import com.sap.engine.interfaces.security.auth.CredentialsMappingConfiguration;
import com.sap.engine.interfaces.security.auth.PrincipalMappingConfiguration;
import com.sap.engine.interfaces.security.userstore.UserStore;
import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.ResourceObjectFactory;
import com.sap.engine.services.connector.exceptions.BaseDeploymentException;
import com.sap.engine.services.connector.exceptions.BaseXMLParserException;
import com.sap.engine.services.connector.jca.deploy.DeployAdmin;
import com.sap.engine.services.connector.jca.deploy.MCFWrapper;
import com.sap.engine.services.connector.jca.deploy.VersionChecker;
import com.sap.engine.services.connector.jca.deploy.descriptor.CallerPrincipal;
import com.sap.engine.services.connector.jca.deploy.descriptor.ConnectorUserstoreConfiguration;
import com.sap.engine.services.connector.jca.deploy.descriptor.IdentitySubject;
import com.sap.engine.services.connector.jca.deploy.descriptor.ResourcePrincipal;
import com.sap.engine.services.connector.jca15.deploy.AdminUtils;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConfigProperty;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConnectionDefinition;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConnectorDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.DriverDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.OutboundResourceAdapterDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ResourceAdapterDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.xml.ConnectorParser;
import com.sap.engine.services.connector.jca15.deploy.verify.Log;
import com.sap.engine.services.connector.jca15.deploy.verify.RARequirementsCheck;
import com.sap.engine.services.connector.jca15.startup.Connector15Startup;
import com.sap.engine.services.deploy.container.DeploymentException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.login.AppConfigurationEntry;

public class DeployAdmin15 {
    public static final String META_INF = "META-INF";
    public static final String SECURE_META_INF = "SECURE_META-INF";
    public static final String meta_inf = "meta-inf";
    public static final String CONNECTORS = "connectors";
    public static final String PROPERTIES = "properties";
    public static final String DRIVERS = "drivers";
    public static final String ra_xml = "ra.xml";
    public static final String RA_XML = "RA.XML";
    public static final String CONNECTOR15_J2EE_ENGINE_XML = "connector15-j2ee-engine.xml";
    public static final String MCF_CONTEXT_NAME = "mcf/";
    public static final char separatorChar = File.separatorChar;
    private LoadContext loadContext = null;
    private SecurityContext securityContext = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$resource$spi$ResourceAdapter;

    public DeployAdmin15(ApplicationServiceContext asc) {
        this.loadContext = asc.getCoreContext().getLoadContext();
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public InputStream[] getConnectorXMLFiles(ZipFile archive, Vector warnings) throws DeploymentException {
        InputStream raXml = null;
        InputStream addXml = null;
        try {
            ZipEntry entry = archive.getEntry("META-INF/ra.xml");
            if (entry == null && (entry = archive.getEntry("meta-inf/ra.xml")) == null && (entry = archive.getEntry("META-INF/RA.XML")) == null && (entry = archive.getEntry("meta-inf/RA.XML")) == null) {
                warnings.add("There is no ra.xml file in the rar archive - " + archive.getName() + "!");
            }
            raXml = archive.getInputStream(entry);
            ZipEntry entry1 = archive.getEntry("META-INF/connector15-j2ee-engine.xml");
            if (entry1 == null && (entry1 = archive.getEntry("meta-inf/connector15-j2ee-engine.xml")) == null) {
                warnings.add("There is no connector15-j2ee-engine.xml file in the rar archive - " + archive.getName() + "!");
            }
            if (entry1 != null) {
                addXml = archive.getInputStream(entry1);
            }
        }
        catch (IOException ioe) {
            throw new BaseXMLParserException("connector_0801", new Object[]{ra_xml}, (Throwable)ioe);
        }
        return new InputStream[]{raXml, addXml};
    }

    /*
     * Unable to fully structure code
     */
    public String getConnectorVersion(String rarFile, Vector warnings) throws DeploymentException {
        block9: {
            document = null;
            archive = null;
            try {
                archive = new ZipFile(rarFile);
                is = this.getConnectorXMLFiles(archive, warnings);
                document = ConnectorParser.getDocument(new BufferedInputStream(is[0]), "ra.xml");
                var7_7 = null;
                ** if (archive == null) goto lbl-1000
            }
            catch (Throwable var6_11) {
                var7_8 = null;
                if (archive != null) {
                    try {
                        archive.close();
                    }
                    catch (IOException ioe) {
                        warnings.add("Can not close ZipFile, the reason is : " + ioe.toString());
                    }
                }
                throw var6_11;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    archive.close();
                }
                catch (IOException ioe) {
                    warnings.add("Can not close ZipFile, the reason is : " + ioe.toString());
                }
            }
lbl-1000:
            // 2 sources

            {
                break block9;
                catch (IOException e) {
                    throw new BaseXMLParserException("connector_0801", new Object[]{rarFile}, (Throwable)e);
                }
            }
        }
        checker = new VersionChecker(document);
        return checker.getConnectorVersion();
    }

    /*
     * Loose catch block
     */
    public String[] extractFiles(Configuration rootConfig, String appWorkDir, String absoluteRarName, String relativeRarName, Vector connectorXmlISs, Vector warnings, boolean update) throws DeploymentException {
        Vector<String> allJars;
        block49: {
            String outputDir = AdminUtils.makeSubDirectory(AdminUtils.makeSubDirectory(appWorkDir, CONNECTORS), relativeRarName.replace('/', separatorChar));
            File dir = new File(outputDir);
            AdminUtils.makeAllSubDirs(dir, false);
            Configuration connectorConfig = AdminUtils.createSubConfiguration(rootConfig, "connectors/" + relativeRarName, 0);
            Configuration secureMetaInfConfig = null;
            PropertySheet propertySheet = null;
            try {
                secureMetaInfConfig = AdminUtils.createSubConfiguration(connectorConfig, SECURE_META_INF, 1);
                propertySheet = secureMetaInfConfig.getPropertySheetInterface();
            }
            catch (ConfigurationException confExc) {
                throw new BaseDeploymentException("connector_0000", new String[]{relativeRarName, secureMetaInfConfig.getPath()}, (Throwable)((Object)confExc));
            }
            Configuration config = null;
            allJars = new Vector<String>();
            JarFile rarFile = null;
            rarFile = new JarFile(absoluteRarName);
            Enumeration<JarEntry> entries = rarFile.entries();
            JarEntry entry = null;
            String entryName = null;
            while (entries.hasMoreElements()) {
                File file;
                block48: {
                    entry = entries.nextElement();
                    entryName = entry.getName();
                    file = null;
                    if (entry.isDirectory()) {
                        if (entryName.substring(0, 9).equalsIgnoreCase("META-INF/")) continue;
                        AdminUtils.createSubConfiguration(connectorConfig, entryName, 0);
                        AdminUtils.makeAllSubDirs(file, false);
                        continue;
                    }
                    BufferedInputStream in = new BufferedInputStream(rarFile.getInputStream(entry));
                    int index = entryName.lastIndexOf("/");
                    if (index != -1) {
                        if (!entryName.substring(0, entryName.indexOf("/")).equalsIgnoreCase(META_INF)) {
                            if (entryName.endsWith(".jar")) {
                                file = new File(outputDir + File.separatorChar + entryName.replace('/', File.separatorChar));
                            }
                            config = AdminUtils.createSubConfiguration(connectorConfig, entryName.substring(0, index), 0);
                            entryName = entryName.substring(index + 1);
                        } else if (entryName.substring(index + 1).equalsIgnoreCase(ra_xml)) {
                            Object var24_30;
                            if (index > 9) {
                                try {
                                    config = AdminUtils.createSubConfiguration(secureMetaInfConfig, entryName.substring(9, index), 1);
                                    propertySheet = config.getPropertySheetInterface();
                                }
                                catch (ConfigurationException confExc) {
                                    throw new BaseDeploymentException("connector_0000", new String[]{entryName.substring(9, index), secureMetaInfConfig.getPath()}, (Throwable)((Object)confExc));
                                }
                            } else {
                                config = secureMetaInfConfig;
                            }
                            byte[] b = new byte[((InputStream)in).available()];
                            try {
                                ((InputStream)in).read(b);
                                var24_30 = null;
                            }
                            catch (Throwable throwable) {
                                var24_30 = null;
                                ((InputStream)in).close();
                                throw throwable;
                            }
                            ((InputStream)in).close();
                            String addXmlEntryName = entryName.substring(0, entryName.length() - 6) + CONNECTOR15_J2EE_ENGINE_XML;
                            JarEntry addXmlEntry = rarFile.getJarEntry(addXmlEntryName);
                            entryName = entryName.substring(index + 1);
                            addXmlEntryName = addXmlEntryName.substring(index + 1);
                            try {
                                propertySheet.createSecurePropertyEntry(entryName, new String(b), entryName);
                            }
                            catch (ConfigurationException confExc) {
                                throw new BaseDeploymentException("connector_0056", new String[]{entryName, config.getPath()}, (Throwable)((Object)confExc));
                            }
                            connectorXmlISs.add(new ByteArrayInputStream(b));
                            if (addXmlEntry != null) {
                                Object var27_34;
                                in = new BufferedInputStream(rarFile.getInputStream(addXmlEntry));
                                b = new byte[((InputStream)in).available()];
                                try {
                                    ((InputStream)in).read(b);
                                    var27_34 = null;
                                }
                                catch (Throwable throwable) {
                                    var27_34 = null;
                                    ((InputStream)in).close();
                                    throw throwable;
                                }
                                ((InputStream)in).close();
                                try {
                                    propertySheet.createSecurePropertyEntry(addXmlEntryName, new String(b), addXmlEntryName);
                                }
                                catch (ConfigurationException confExc) {
                                    throw new BaseDeploymentException("connector_0056", new String[]{entryName, config.getPath()}, (Throwable)((Object)confExc));
                                }
                                connectorXmlISs.add(new ByteArrayInputStream(b));
                            }
                        }
                    } else {
                        if (entryName.endsWith(".jar")) {
                            file = new File(outputDir + File.separatorChar + entryName.replace('/', File.separatorChar));
                        }
                        config = connectorConfig;
                    }
                    if (entryName.endsWith(".jar")) {
                        allJars.add(file.getPath());
                    }
                    if (file == null) continue;
                    AdminUtils.makeAllSubDirs(file, true);
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(file);
                    }
                    catch (FileNotFoundException fnfe) {
                        throw new BaseXMLParserException("connector_0801", new Object[]{file.getName()}, (Throwable)fnfe);
                    }
                    int count = 1024;
                    in = new BufferedInputStream(rarFile.getInputStream(entry));
                    byte[] buff = new byte[count];
                    while ((count = ((InputStream)in).read(buff)) != -1) {
                        fos.write(buff, 0, count);
                    }
                    Object var29_35 = null;
                    try {
                        ((InputStream)in).close();
                        if (fos != null) {
                            fos.flush();
                            fos.close();
                        }
                        break block48;
                    }
                    catch (IOException ioe) {
                        warnings.add("Can not close streams, the reason is : " + ioe.toString());
                    }
                    break block48;
                    {
                        catch (EOFException eof) {
                            buff = new byte[(int)entry.getSize()];
                            ((InputStream)in).read(buff);
                            var29_35 = null;
                            try {
                                ((InputStream)in).close();
                                if (fos != null) {
                                    fos.flush();
                                    fos.close();
                                }
                                break block48;
                            }
                            catch (IOException ioe) {
                                warnings.add("Can not close streams, the reason is : " + ioe.toString());
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        var29_35 = null;
                        try {
                            ((InputStream)in).close();
                            if (fos != null) {
                                fos.flush();
                                fos.close();
                            }
                        }
                        catch (IOException ioe) {
                            warnings.add("Can not close streams, the reason is : " + ioe.toString());
                        }
                        throw throwable;
                    }
                }
                FileInputStream fin = new FileInputStream(file);
                AdminUtils.addFileAsStream(entryName, config, fin, update, warnings);
            }
            Object var32_40 = null;
            try {
                if (rarFile != null) {
                    rarFile.close();
                }
                break block49;
            }
            catch (IOException ioex) {
                warnings.add("Can not close ZipFile, the reason is : " + ioex.toString());
            }
            break block49;
            {
                catch (IOException ioe) {
                    throw new BaseXMLParserException("connector_0801", new Object[]{absoluteRarName}, (Throwable)ioe);
                }
            }
            catch (Throwable throwable) {
                Object var32_41 = null;
                try {
                    if (rarFile != null) {
                        rarFile.close();
                    }
                }
                catch (IOException ioex) {
                    warnings.add("Can not close ZipFile, the reason is : " + ioex.toString());
                }
                throw throwable;
            }
        }
        return allJars.toArray(new String[allJars.size()]);
    }

    /*
     * Unable to fully structure code
     */
    public ConnectorDescriptor getConnectorDescriptor(String appWorkDir, String rarFile, boolean isRealApplication, InputStream raXmlIs, InputStream addXmlIs, Vector warnings) throws DeploymentException {
        connectorParser = new ConnectorParser();
        connectorDescriptor = new ConnectorDescriptor();
        try {
            connectorParser.parseXml(new BufferedInputStream(raXmlIs), connectorDescriptor, false, "ra.xml", warnings);
            if (addXmlIs != null) {
                connectorParser.parseXml(new BufferedInputStream(addXmlIs), connectorDescriptor, true, "connector15-j2ee-engine.xml", warnings);
            }
            var10_9 = null;
        }
        catch (Throwable var9_20) {
            var10_10 = null;
            try {
                try {
                    raXmlIs.close();
                    var12_13 = null;
                    ** if (addXmlIs == null) goto lbl-1000
                }
                catch (Throwable var11_17) {
                    var12_14 = null;
                    if (addXmlIs != null) {
                        addXmlIs.close();
                    }
                    throw var11_17;
                }
lbl-1000:
                // 1 sources

                {
                    addXmlIs.close();
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (IOException e) {
                warnings.add("Can not close streams, the reason is : " + e.toString());
            }
            throw var9_20;
        }
        try {
            try {
                raXmlIs.close();
                var12_11 = null;
                ** if (addXmlIs == null) goto lbl-1000
            }
            catch (Throwable var11_15) {
                var12_12 = null;
                if (addXmlIs != null) {
                    addXmlIs.close();
                }
                throw var11_15;
            }
lbl-1000:
            // 1 sources

            {
                addXmlIs.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (IOException e) {
            warnings.add("Can not close streams, the reason is : " + e.toString());
        }
        connectorDescriptor.setRarFileName(rarFile);
        connectorDescriptor.setRealApplication(isRealApplication);
        raDescriptor = connectorDescriptor.getResourceAdapterDescriptor();
        outboundRA = raDescriptor.getOutboundResourceAdapter();
        counter = 0;
        if (outboundRA != null) {
            connectionDefinitions = outboundRA.getConnectionDefinitions();
            j = 0;
            while (j < connectionDefinitions.length) {
                if (connectionDefinitions[j].getJNDIName() == null) {
                    connectionDefinitions[j].setJNDIName(rarFile + "_out_" + counter);
                    ++counter;
                }
                ++j;
            }
        }
        counter = 0;
        inboundRA = raDescriptor.getInboundResourceAdapter();
        if (inboundRA != null) {
            messageListeners = inboundRA.getMessageListeners();
            j = 0;
            while (messageListeners != null && j < messageListeners.length) {
                if (messageListeners[j].getMessageListenerName() == null) {
                    messageListeners[j].setMessageListenerName(rarFile + "_in_" + counter);
                    ++counter;
                }
                ++j;
            }
        }
        return connectorDescriptor;
    }

    public String[] extractDrivers(Configuration rootConfig, ConnectorDescriptor descriptor, String workAppName, String relativeRarName, boolean update, Vector warnings) throws DeploymentException {
        DriverDescriptor[] drivers = descriptor.getResourceAdapterDescriptor().getDriverDescriptors();
        if (drivers == null) {
            return new String[0];
        }
        Vector<String> allJars = new Vector<String>();
        String workDriversDirName = AdminUtils.makeSubDirectory(AdminUtils.makeSubDirectory(workAppName, DRIVERS), relativeRarName.replace('/', separatorChar));
        Configuration driversConfig = null;
        driversConfig = AdminUtils.createSubConfiguration(rootConfig, "drivers/" + relativeRarName, 0);
        int i = 0;
        while (i < drivers.length) {
            String[] jars = drivers[i].getFileNames();
            if (jars != null) {
                int j = 0;
                while (j < jars.length) {
                    String jar = jars[j];
                    File jarSourceFile = new File(jar);
                    String realDriverJarName = AdminUtils.makeDriverJarName(descriptor.getRarFileName(), drivers[i].getDriverName(), jarSourceFile.getName());
                    String replacedDriverJarName = realDriverJarName.replace('\\', separatorChar).replace('/', separatorChar);
                    File jarOutputFile = new File(AdminUtils.makeSubDirectory(workDriversDirName, replacedDriverJarName));
                    AdminUtils.makeAllSubDirs(jarOutputFile, true);
                    allJars.add(jarOutputFile.getPath());
                    int index = replacedDriverJarName.lastIndexOf(separatorChar);
                    if (index != -1) {
                        AdminUtils.createSubConfiguration(driversConfig, replacedDriverJarName.substring(0, index), 0);
                    }
                    try {
                        FileUtils.copyFile(jarSourceFile, jarOutputFile);
                    }
                    catch (IOException ioe) {
                        throw new BaseDeploymentException("connector_0013", jar, (Throwable)ioe);
                    }
                    try {
                        AdminUtils.addFileAsStream(replacedDriverJarName, driversConfig, new FileInputStream(jarOutputFile), update, warnings);
                    }
                    catch (FileNotFoundException fnfExc) {
                        throw new BaseDeploymentException("connector_0002", new String[]{replacedDriverJarName, driversConfig.getPath()}, (Throwable)fnfExc);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return allJars.toArray(new String[allJars.size()]);
    }

    public void checkResourceAdapter(Vector connectorNames, ConnectorDescriptor connectorDescriptor, ResourceLoader tempRL, Configuration securityConfig) throws DeploymentException {
        DriverDescriptor[] drivers;
        Log.logDebug(this + ".checkResourceAdapter(" + connectorNames + "," + connectorDescriptor + "," + tempRL + ")");
        RARequirementsCheck.checkJ2EEConnectorRequirements(connectorDescriptor, tempRL);
        ResourceAdapterDescriptor raDescriptor = connectorDescriptor.getResourceAdapterDescriptor();
        if (raDescriptor != null) {
            this.instantiateRA(tempRL, connectorDescriptor);
        }
        if ((drivers = raDescriptor.getDriverDescriptors()) != null) {
            int j = 0;
            while (j < drivers.length) {
                this.instantiateDriver(tempRL, drivers[j].getDriverClassName());
                ++j;
            }
        }
        OutboundResourceAdapterDescriptor outboundRA = raDescriptor.getOutboundResourceAdapter();
        ManagedConnectionFactory[] mcfs = null;
        if (outboundRA != null) {
            mcfs = this.instantiateMCF(tempRL, connectorDescriptor);
            ConnectionDefinition[] connectionDefinitions = outboundRA.getConnectionDefinitions();
            int j = 0;
            while (j < connectionDefinitions.length) {
                connectorNames.add(connectionDefinitions[j].getJNDIName());
                String[] aliases = connectionDefinitions[j].getAliases();
                int k = 0;
                while (aliases != null && k < aliases.length) {
                    String alias = aliases[k];
                    connectorNames.add(alias);
                    ++k;
                }
                ++j;
            }
            int j2 = 0;
            while (j2 < mcfs.length) {
                this.registerIdentitySubjects(mcfs[j2], connectionDefinitions[j2], securityConfig);
                ++j2;
            }
        }
    }

    public ResourceAdapter instantiateRA(ClassLoader loader, ConnectorDescriptor descriptor) throws DeploymentException {
        String[] loaderNames = descriptor.getResourceAdapterDescriptor().getLoaderNames();
        String loaderName = null;
        try {
            loaderName = ((ResourceLoader)loader).getName();
        }
        catch (ClassCastException cce) {
            throw new BaseDeploymentException("connector_0024", loader, (Throwable)cce);
        }
        int i = 0;
        while (loaderNames != null && i < loaderNames.length) {
            this.loadContext.registerReference(loaderName, loaderNames[i]);
            ++i;
        }
        Class<?> raClass = null;
        ResourceAdapterDescriptor raDescriptor = descriptor.getResourceAdapterDescriptor();
        String raClassName = null;
        String raMethodName = null;
        try {
            raClassName = raDescriptor.getResourceAdapterClass();
            if (raClassName == null) {
                throw new BaseDeploymentException("connector_0044", new String[]{"resourceadapter-class", ra_xml});
            }
            raClass = loader.loadClass(raClassName);
            ResourceAdapter ra = (ResourceAdapter)raClass.newInstance();
            ConfigProperty[] configProps = raDescriptor.getConfigProperties();
            if (configProps == null) {
                return ra;
            }
            int j = 0;
            while (j < configProps.length) {
                String property = configProps[j].getConfigPropertyName();
                String type = configProps[j].getConfigPropertyType();
                String value = configProps[j].getConfigPropertyValue();
                Class<?> propsClass = Class.forName(type);
                raMethodName = AdminUtils.setMethodName(property);
                if (type.equals("java.lang.String")) {
                    raClass.getMethod(AdminUtils.setMethodName(property), propsClass).invoke((Object)ra, value);
                } else {
                    Object obj = propsClass.getConstructor(class$java$lang$String == null ? DeployAdmin15.class$("java.lang.String") : class$java$lang$String).newInstance(value);
                    try {
                        raClass.getMethod(AdminUtils.setMethodName(property), propsClass).invoke((Object)ra, obj);
                    }
                    catch (NoSuchMethodException e) {
                        raClass.getMethod(AdminUtils.setMethodName(property), AdminUtils.getPrimaryTypeClass(propsClass.getName())).invoke((Object)ra, obj);
                    }
                }
                ++j;
            }
            return ra;
        }
        catch (ClassNotFoundException cnfe) {
            throw new BaseDeploymentException("connector_0026", raClassName, (Throwable)cnfe);
        }
        catch (InstantiationException instExc) {
            throw new BaseDeploymentException("connector_0027", raClass.getName(), (Throwable)instExc);
        }
        catch (IllegalAccessException illAssExc) {
            throw new BaseDeploymentException("connector_0028", raClass.getName(), (Throwable)illAssExc);
        }
        catch (NoSuchMethodException nsmExc) {
            throw new BaseDeploymentException("connector_0045", new String[]{raClass.getName(), raMethodName}, (Throwable)nsmExc);
        }
        catch (InvocationTargetException itExc) {
            throw new BaseDeploymentException("connector_0029", raClass.getName(), (Throwable)itExc);
        }
    }

    public Driver instantiateDriver(ClassLoader loader, String driverClassName) throws DeploymentException {
        Class<?> driverClass = null;
        try {
            driverClass = loader.loadClass(driverClassName);
            Driver driver = (Driver)driverClass.newInstance();
            return driver;
        }
        catch (ClassNotFoundException cnfe) {
            throw new BaseDeploymentException("connector_0026", driverClassName, (Throwable)cnfe);
        }
        catch (InstantiationException instExc) {
            throw new BaseDeploymentException("connector_0027", driverClass.getName(), (Throwable)instExc);
        }
        catch (IllegalAccessException illAssExc) {
            throw new BaseDeploymentException("connector_0028", driverClass.getName(), (Throwable)illAssExc);
        }
    }

    public ManagedConnectionFactory[] instantiateMCF(ClassLoader loader, ConnectorDescriptor descriptor) throws DeploymentException {
        Class<?> mcfClass = null;
        ConnectionDefinition[] conDefinitions = descriptor.getResourceAdapterDescriptor().getOutboundResourceAdapter().getConnectionDefinitions();
        Vector<ManagedConnectionFactory> mcfVector = new Vector<ManagedConnectionFactory>();
        String mcfClassName = null;
        String mcfMethodName = null;
        try {
            int i = 0;
            while (i < conDefinitions.length) {
                mcfClassName = conDefinitions[i].getManagedConnectionFactoryClass();
                mcfClass = loader.loadClass(mcfClassName);
                ManagedConnectionFactory mcf = (ManagedConnectionFactory)mcfClass.newInstance();
                mcfVector.add(mcf);
                ConfigProperty[] configProps = conDefinitions[i].getConfigProperties();
                if (configProps == null) {
                    return mcfVector.toArray(new ManagedConnectionFactory[mcfVector.size()]);
                }
                int j = 0;
                while (j < configProps.length) {
                    String property = configProps[j].getConfigPropertyName();
                    String type = configProps[j].getConfigPropertyType();
                    String value = configProps[j].getConfigPropertyValue();
                    Class<?> propsClass = Class.forName(type);
                    mcfMethodName = AdminUtils.setMethodName(property);
                    if (type.equals("java.lang.String")) {
                        mcfClass.getMethod(AdminUtils.setMethodName(property), propsClass).invoke((Object)mcf, value);
                    } else {
                        Object obj = propsClass.getConstructor(class$java$lang$String == null ? DeployAdmin15.class$("java.lang.String") : class$java$lang$String).newInstance(value);
                        try {
                            mcfClass.getMethod(AdminUtils.setMethodName(property), propsClass).invoke((Object)mcf, obj);
                        }
                        catch (NoSuchMethodException nsmExc) {
                            mcfClass.getMethod(AdminUtils.setMethodName(property), AdminUtils.getPrimaryTypeClass(propsClass.getName())).invoke((Object)mcf, obj);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            return mcfVector.toArray(new ManagedConnectionFactory[mcfVector.size()]);
        }
        catch (ClassNotFoundException cnfe) {
            throw new BaseDeploymentException("connector_0026", mcfClassName, (Throwable)cnfe);
        }
        catch (InstantiationException instExc) {
            throw new BaseDeploymentException("connector_0027", mcfClass.getName(), (Throwable)instExc);
        }
        catch (IllegalAccessException illAssExc) {
            throw new BaseDeploymentException("connector_0028", mcfClass.getName(), (Throwable)illAssExc);
        }
        catch (NoSuchMethodException nsmExc) {
            throw new BaseDeploymentException("connector_0045", new String[]{mcfClass.getName(), mcfMethodName}, (Throwable)nsmExc);
        }
        catch (InvocationTargetException itExc) {
            throw new BaseDeploymentException("connector_0029", mcfClass.getName(), (Throwable)itExc);
        }
    }

    public void extractProperties(Configuration rootConfig, String appName, Properties props, Vector warnings, boolean update) throws DeploymentException {
        Configuration propertiesConfig = AdminUtils.createSubConfiguration(rootConfig, PROPERTIES, 0);
        this.saveProperties(propertiesConfig, appName + ".properties", props, warnings, update);
    }

    private void saveProperties(Configuration propertiesConfig, String configEntryName, Properties props, Vector warnings, boolean update) throws DeploymentException {
        ByteArrayInputStream bais = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            props.store(baos, null);
        }
        catch (IOException ioExc) {
            throw new BaseDeploymentException("connector_0011", new String[]{configEntryName, propertiesConfig.getPath()}, (Throwable)ioExc);
        }
        bais = new ByteArrayInputStream(baos.toByteArray());
        AdminUtils.addFileAsStream(configEntryName, propertiesConfig, bais, update, warnings);
    }

    public void downloadConnectorEntries(Configuration config, String appName, String workAppDir, Vector warnings) throws DeploymentException {
        FileUtils.deleteDirectory(new File(workAppDir));
        Hashtable map = new Hashtable();
        try {
            AdminUtils.getAllConfigFileEntries("", config, map);
        }
        catch (ConfigurationException confExc) {
            throw new BaseDeploymentException("connector_0004", config.getPath(), (Throwable)((Object)confExc));
        }
        Iterator fileNamesIter = map.keySet().iterator();
        InputStream fis = null;
        String fileName = null;
        while (fileNamesIter.hasNext()) {
            int index;
            fileName = (String)fileNamesIter.next();
            if (fileName.substring((index = fileName.lastIndexOf("/")) - 8, index).equals(META_INF) && !fileName.endsWith(".jar") || fileName.startsWith("/properties/")) continue;
            fis = (InputStream)map.get(fileName);
            File file = new File(AdminUtils.makeSubDirectory(workAppDir, fileName));
            AdminUtils.makeAllSubDirs(file, true);
            try {
                FileUtils.writeToFile(fis, file);
            }
            catch (IOException e) {
                warnings.add("Can not write in '" + file.getAbsolutePath() + "' file, reason : " + e.toString());
            }
        }
    }

    private void bindMCF(Context root, int transactionLevel, ConnectionDefinition connectionDefinition, ManagedConnectionFactory mcf, boolean rebind) throws NamingException {
        MCFWrapper mcfWrapper = new MCFWrapper(mcf, transactionLevel, connectionDefinition.getAliases(), 0, connectionDefinition.getMaxConnectionsNumber(), connectionDefinition.getMaxTimeToWaitConnection(), connectionDefinition.getConnectionLifeTime(), connectionDefinition.getRunCleanupThreadTime());
        AdminUtils.bind(root, MCF_CONTEXT_NAME + connectionDefinition.getJNDIName(), mcfWrapper, rebind);
    }

    public void unbindMCF(Context root, String jndiName) throws NamingException {
        root.unbind(MCF_CONTEXT_NAME + jndiName);
    }

    public void registerConnector(Context rootContext, ConnectorDescriptor connectorDescriptor, ResourceLoader loader, Vector warnings) throws DeploymentException {
        ResourceAdapterDescriptor raDescriptor = connectorDescriptor.getResourceAdapterDescriptor();
        ResourceAdapter ra = this.instantiateRA(loader, connectorDescriptor);
        Connector15Startup startup = Connector15Startup.getInstance();
        if (startup == null) {
            BaseDeploymentException bdex = new BaseDeploymentException("Connector15 is not started");
            ConnectorServiceFrame.logException((Exception)((Object)bdex));
            throw bdex;
        }
        try {
            ra.start((BootstrapContext)startup.createBootstrapContextImpl(connectorDescriptor));
        }
        catch (ResourceAdapterInternalException raIntEx) {
            BaseDeploymentException bdex = new BaseDeploymentException("", (Throwable)raIntEx);
            ConnectorServiceFrame.logException((Exception)((Object)bdex));
            throw bdex;
        }
        raDescriptor.setResourceAdapter(ra);
        ManagedConnectionFactory[] mcfs = this.instantiateMCF(loader, connectorDescriptor);
        int n = 0;
        while (n < mcfs.length) {
            Class<?> mcfClass = mcfs[n].getClass();
            try {
                mcfClass.getMethod("setResourceAdapter", class$javax$resource$spi$ResourceAdapter == null ? DeployAdmin15.class$("javax.resource.spi.ResourceAdapter") : class$javax$resource$spi$ResourceAdapter).invoke((Object)mcfs[n], ra);
            }
            catch (NoSuchMethodException nsmex) {
                warnings.add(nsmex.toString());
            }
            catch (IllegalAccessException iaex) {
                warnings.add(iaex.toString());
            }
            catch (InvocationTargetException itex) {
                warnings.add(itex.toString());
            }
            ++n;
        }
        OutboundResourceAdapterDescriptor outboundResourceAdapter = connectorDescriptor.getResourceAdapterDescriptor().getOutboundResourceAdapter();
        ConnectionDefinition[] connectionDefinitions = outboundResourceAdapter.getConnectionDefinitions();
        int i = 0;
        while (i < mcfs.length) {
            this.preRegisterIdentitySubjects(mcfs[i], connectionDefinitions[i]);
            String[] aliases = connectionDefinitions[i].getAliases();
            try {
                this.bindMCF(rootContext, outboundResourceAdapter.getTransactionLevel(), connectionDefinitions[i], mcfs[i], false);
                try {
                    if (aliases != null) {
                        ResourceObjectFactory.registerAliases(connectionDefinitions[i].getJNDIName(), aliases);
                    }
                }
                catch (Exception exc) {
                    try {
                        this.unbindMCF(rootContext, connectionDefinitions[i].getJNDIName());
                    }
                    catch (NamingException nexc) {
                        throw new BaseDeploymentException("connector_0008", new String[]{connectionDefinitions[i].getJNDIName(), "MCF"}, (Throwable)nexc);
                    }
                    throw new BaseDeploymentException("connector_0042", connectionDefinitions[i].getJNDIName(), (Throwable)exc);
                }
            }
            catch (NamingException nexc) {
                throw new BaseDeploymentException("connector_0007", new String[]{connectionDefinitions[i].getJNDIName(), "MCF"}, (Throwable)nexc);
            }
            AdminUtils.startFactory(connectorDescriptor.getApplicationName(), connectionDefinitions[i].getJNDIName(), connectionDefinitions[i].getConnectionFactoryInterface(), connectionDefinitions[i].getAuthenticationType() != null, !connectorDescriptor.isRealApplication());
            ++i;
        }
        DriverDescriptor[] drivers = raDescriptor.getDriverDescriptors();
        if (drivers != null) {
            int j = 0;
            while (j < drivers.length) {
                Driver driver = this.instantiateDriver(loader, drivers[j].getDriverClassName());
                this.registerDriver(driver);
                ++j;
            }
        }
    }

    public void registerDriver(Driver driver) throws DeploymentException {
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException sqle) {
            throw new BaseDeploymentException("connector_0040", driver.getClass(), (Throwable)sqle);
        }
    }

    private void registerIdentitySubjects(ManagedConnectionFactory mcf, ConnectionDefinition connectionDefinition, Configuration securityConfig) throws DeploymentException {
        IdentitySubject[] subjects = connectionDefinition.getIdentitySubjects();
        String userStore = connectionDefinition.getUserStore();
        String jndiName = DeployAdmin.fixName(connectionDefinition.getJNDIName());
        String authenticationType = connectionDefinition.getAuthenticationType();
        if (authenticationType == null) {
            return;
        }
        SecurityContext mySecurityContext = null;
        try {
            mySecurityContext = this.securityContext.getModificationContext().beginModifications(securityConfig);
        }
        catch (NullPointerException npExc) {
            throw new BaseDeploymentException("connector_0030", new String[]{"security", "security service"});
        }
        catch (SecurityException sexc) {
            throw new BaseDeploymentException("connector_0031", securityConfig.getPath(), (Throwable)sexc);
        }
        try {
            mySecurityContext.registerPolicyConfiguration(jndiName);
        }
        catch (SecurityException se) {
            throw new BaseDeploymentException("connector_0039", jndiName, (Throwable)se);
        }
        try {
            mySecurityContext = mySecurityContext.getPolicyConfigurationContext(jndiName);
        }
        catch (NullPointerException npExc) {
            throw new BaseDeploymentException("connector_0030", new String[]{"security", "security service"});
        }
        catch (SecurityException sexc) {
            throw new BaseDeploymentException("connector_0038", jndiName, (Throwable)sexc);
        }
        UserStore raUserStore = null;
        boolean externalUS = true;
        if (userStore == null && !authenticationType.equalsIgnoreCase("Caller Impersonation")) {
            userStore = this.registerRAUserStore(jndiName, mySecurityContext);
            connectionDefinition.setInternalUserStore(true);
            connectionDefinition.setUserStore(userStore);
            raUserStore = mySecurityContext.getUserStoreContext().getUserStore(userStore);
            if (raUserStore == null) {
                throw new BaseDeploymentException("connector_0032", userStore);
            }
            externalUS = false;
        }
        Hashtable userMapping = new Hashtable();
        Hashtable groupMapping = new Hashtable();
        Hashtable<String, Object> options = new Hashtable<String, Object>();
        CallerPrincipal callerPrincipal = null;
        ResourcePrincipal resourcePrincipal = null;
        AppConfigurationEntry configEntry = null;
        Vector<CallerImpersonationConfiguration> configEntries = new Vector<CallerImpersonationConfiguration>();
        int i = 0;
        while (subjects != null && i < subjects.length) {
            callerPrincipal = subjects[i].getCallerPrincipal();
            resourcePrincipal = subjects[i].getResourcePrincipal();
            if (!externalUS && !authenticationType.equalsIgnoreCase("Caller Impersonation")) {
                this.addMappingInUS(raUserStore, subjects[i]);
            }
            if (authenticationType.equalsIgnoreCase("Principal Mapping")) {
                HashSet groups;
                HashSet users = callerPrincipal.getUserNames();
                if (users != null) {
                    Iterator usersIterator = users.iterator();
                    while (usersIterator.hasNext()) {
                        userMapping.put(usersIterator.next(), resourcePrincipal.getUserName());
                    }
                }
                if ((groups = callerPrincipal.getGroups()) != null) {
                    Iterator groupsIterator = groups.iterator();
                    while (groupsIterator.hasNext()) {
                        groupMapping.put(groupsIterator.next(), resourcePrincipal.getUserName());
                    }
                }
            }
            ++i;
        }
        if (authenticationType.equalsIgnoreCase("Principal Mapping")) {
            options.put("User_Store", userStore);
            options.put("Managed_Connection_Factory", mcf);
            options.put("Users_Mapping", userMapping);
            options.put("Groups_Mapping", groupMapping);
            configEntry = new PrincipalMappingConfiguration(options);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        } else if (authenticationType.equalsIgnoreCase("Caller Impersonation")) {
            options.put("Managed_Connection_Factory", mcf);
            configEntry = new CallerImpersonationConfiguration(options);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        } else if (authenticationType.equalsIgnoreCase("Credentials Mapping")) {
            options.put("User_Store", userStore);
            options.put("Managed_Connection_Factory", mcf);
            configEntry = new CredentialsMappingConfiguration(options);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        } else if (authenticationType.equalsIgnoreCase("Configured Identity")) {
            Hashtable<String, String> intOptions = new Hashtable<String, String>();
            intOptions.put("Configured_Identity", resourcePrincipal.getUserName());
            intOptions.put("User_Store", userStore);
            intOptions.put("Managed_Connection_Factory", (String)mcf);
            configEntry = new ConfiguredIdentityConfiguration(intOptions);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        }
        AuthenticationContext myAuthenticationContext = mySecurityContext.getAuthenticationContext();
        try {
            if (!authenticationType.equalsIgnoreCase("Caller Impersonation")) {
                myAuthenticationContext.setAuthenticationUserStore(raUserStore);
            }
        }
        catch (SecurityException se) {
            throw new BaseDeploymentException("connector_0036", new String[]{userStore, jndiName}, (Throwable)se);
        }
        try {
            myAuthenticationContext.setLoginModules(configEntries.toArray(new AppConfigurationEntry[configEntries.size()]));
        }
        catch (SecurityException se) {
            throw new BaseDeploymentException("connector_0037", jndiName, (Throwable)se);
        }
    }

    private void preRegisterIdentitySubjects(ManagedConnectionFactory mcf, ConnectionDefinition connectionDefinition) throws DeploymentException {
        IdentitySubject[] subjects = connectionDefinition.getIdentitySubjects();
        String userStore = connectionDefinition.getUserStore();
        String jndiName = DeployAdmin.fixName(connectionDefinition.getJNDIName());
        String authenticationType = connectionDefinition.getAuthenticationType();
        if (authenticationType == null) {
            return;
        }
        SecurityContext mySecurityContext = null;
        try {
            mySecurityContext = this.securityContext.getPolicyConfigurationContext(jndiName);
        }
        catch (NullPointerException npExc) {
            throw new BaseDeploymentException("connector_0030", new String[]{"security", "security service"});
        }
        catch (SecurityException sexc) {
            throw new BaseDeploymentException("connector_0038", jndiName, (Throwable)sexc);
        }
        UserStore raUserStore = null;
        if (userStore == null && !authenticationType.equalsIgnoreCase("Caller Impersonation")) {
            userStore = jndiName;
            try {
                raUserStore = this.securityContext.getUserStoreContext().getUserStore(userStore);
            }
            catch (NullPointerException npExc) {
                throw new BaseDeploymentException("connector_0030", new String[]{"security", "security service"});
            }
            if (raUserStore == null) {
                throw new BaseDeploymentException("connector_0032", jndiName);
            }
        }
        Hashtable userMapping = new Hashtable();
        Hashtable groupMapping = new Hashtable();
        Hashtable<String, Object> options = new Hashtable<String, Object>();
        Vector<CallerImpersonationConfiguration> configEntries = new Vector<CallerImpersonationConfiguration>();
        CallerPrincipal callerPrincipal = null;
        ResourcePrincipal resourcePrincipal = null;
        AppConfigurationEntry configEntry = null;
        int i = 0;
        while (subjects != null && i < subjects.length) {
            callerPrincipal = subjects[i].getCallerPrincipal();
            resourcePrincipal = subjects[i].getResourcePrincipal();
            if (authenticationType.equalsIgnoreCase("Principal Mapping")) {
                HashSet groups;
                HashSet users = callerPrincipal.getUserNames();
                if (users != null) {
                    Iterator usersIterator = users.iterator();
                    while (usersIterator.hasNext()) {
                        userMapping.put(usersIterator.next(), resourcePrincipal.getUserName());
                    }
                }
                if ((groups = callerPrincipal.getGroups()) != null) {
                    Iterator groupsIterator = groups.iterator();
                    while (groupsIterator.hasNext()) {
                        groupMapping.put(groupsIterator.next(), resourcePrincipal.getUserName());
                    }
                }
            }
            ++i;
        }
        if (authenticationType.equalsIgnoreCase("Principal Mapping")) {
            options.put("User_Store", userStore);
            options.put("Managed_Connection_Factory", mcf);
            options.put("Users_Mapping", userMapping);
            options.put("Groups_Mapping", groupMapping);
            configEntry = new PrincipalMappingConfiguration(options);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        } else if (authenticationType.equalsIgnoreCase("Caller Impersonation")) {
            options.put("Managed_Connection_Factory", mcf);
            configEntry = new CallerImpersonationConfiguration(options);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        } else if (authenticationType.equalsIgnoreCase("Credentials Mapping")) {
            options.put("User_Store", userStore);
            options.put("Managed_Connection_Factory", mcf);
            configEntry = new CredentialsMappingConfiguration(options);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        } else if (authenticationType.equalsIgnoreCase("Configured Identity")) {
            Hashtable<String, String> intOptions = new Hashtable<String, String>();
            intOptions.put("Configured_Identity", resourcePrincipal.getUserName());
            intOptions.put("User_Store", userStore);
            intOptions.put("Managed_Connection_Factory", (String)mcf);
            configEntry = new ConfiguredIdentityConfiguration(intOptions);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        }
        AuthenticationContext myAuthenticationContext = mySecurityContext.getAuthenticationContext();
        try {
            if (!authenticationType.equalsIgnoreCase("Caller Impersonation")) {
                myAuthenticationContext.setAuthenticationUserStore(raUserStore);
            }
        }
        catch (SecurityException se) {
            throw new BaseDeploymentException("connector_0036", new String[]{userStore, jndiName}, (Throwable)se);
        }
        try {
            myAuthenticationContext.setLoginModules(configEntries.toArray(new AppConfigurationEntry[configEntries.size()]));
        }
        catch (SecurityException se) {
            throw new BaseDeploymentException("connector_0037", jndiName, (Throwable)se);
        }
    }

    private String registerRAUserStore(String userStore, SecurityContext mySecurityContext) throws DeploymentException {
        ConnectorUserstoreConfiguration userStoreConfig = new ConnectorUserstoreConfiguration(userStore);
        try {
            mySecurityContext.getUserStoreContext().registerUserStore(userStoreConfig, this.getClass().getClassLoader());
        }
        catch (SecurityException se) {
            throw new BaseDeploymentException("connector_0033", userStore, (Throwable)se);
        }
        return userStoreConfig.getName();
    }

    private void addMappingInUS(UserStore userStore, IdentitySubject subject) {
        ResourcePrincipal resPrincipal = subject.getResourcePrincipal();
        UserInfo info = userStore.getUserContext().createUser(subject.getResourcePrincipal().getUserName());
        info.setPassword(resPrincipal.getPassword().toCharArray());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

