/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ResourceLoader;
import com.sap.engine.frame.core.load.res.JarsResource;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.services.connector.ResourceObjectFactory;
import com.sap.engine.services.connector.exceptions.BaseDeploymentException;
import com.sap.engine.services.connector.exceptions.BaseXMLParserException;
import com.sap.engine.services.connector.jca15.deploy.AdminUtils;
import com.sap.engine.services.connector.jca15.deploy.DeployAdmin15;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConnectionDefinition;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConnectorDescriptor;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeployCommunicator;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ExportInfo;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.container.ProgressListener;
import com.sap.engine.services.deploy.container.WarningException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.ResourceAdapter;

public class Container15Impl
implements ContainerInterface {
    public static final String CONTAINER_NAME = "connector15";
    public static final String[] RESOURCE_TYPES = new String[]{"javax.resource.cci.ConnectionFactory", "javax.jms.QueueConnectionFactory", "javax.jms.TopicConnectionFactory", "javax.sql.DataSource"};
    public static final int APP_PRIORITY = 85;
    private ContainerInfo containerInfo = null;
    private Hashtable descriptors = null;
    private String serviceName = null;
    private Properties initialContextProperties = null;
    private DeployCommunicator deployCommunicator = null;
    private DeployAdmin15 deployAdmin = null;
    private LoadContext loadContext = null;
    private ManagementListener managementListener = null;

    public Container15Impl(ApplicationServiceContext asc) {
        this.deployAdmin = new DeployAdmin15(asc);
        this.loadContext = asc.getCoreContext().getLoadContext();
        this.serviceName = asc.getServiceState().getServiceName();
        this.descriptors = new Hashtable();
        this.containerInfo = new ContainerInfo();
        this.containerInfo.setName(CONTAINER_NAME);
        this.containerInfo.setModuleName(CONTAINER_NAME);
        this.containerInfo.setServiceName(this.serviceName);
        this.containerInfo.setJ2EEContainer(true);
        this.containerInfo.setJ2EEModuleName("connector");
        this.containerInfo.setFileExtensions(new String[]{".rar"});
        this.containerInfo.setResourceTypes(RESOURCE_TYPES);
        this.containerInfo.setPriority(85);
        this.containerInfo.setSupportingSingleFileUpdate(false);
        this.initialContextProperties = new Properties();
        ((Hashtable)this.initialContextProperties).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
        ((Hashtable)this.initialContextProperties).put("domain", "true");
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public void stop() {
        ResourceObjectFactory.closeFactory();
    }

    public void start() {
        ResourceObjectFactory.openFactory();
    }

    public void setDeployCommunicator(DeployCommunicator deployCommunicator) {
        this.deployCommunicator = deployCommunicator;
    }

    public DeployCommunicator getDeployCommunicator() {
        return this.deployCommunicator;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.deployAdmin.setSecurityContext(securityContext);
    }

    public Hashtable getDescriptors() {
        return this.descriptors;
    }

    public String getApplicationName(File standaloneFile) throws DeploymentException {
        return "connector-" + standaloneFile.getName();
    }

    public ManagementListener getManagementListener() {
        return this.managementListener;
    }

    public void setManagementListener(ManagementListener managementListener) {
        this.managementListener = managementListener;
    }

    public Vector getAllAppNames() {
        Vector result = new Vector();
        Enumeration e = this.descriptors.elements();
        while (e.hasMoreElements()) {
            ConnectorDescriptor[] conDescriptors = (ConnectorDescriptor[])e.nextElement();
            Vector<String> vec = null;
            int j = 0;
            while (j < conDescriptors.length) {
                vec = new Vector<String>();
                vec.add(conDescriptors[j].getDisplayName());
                vec.add(conDescriptors[j].getApplicationName());
                result.add(vec);
                ++j;
            }
        }
        String[] appNames = this.deployCommunicator.getMyApplications();
        int i = 0;
        while (i < appNames.length) {
            Vector<String> vec = null;
            if (this.deployCommunicator.getStatus(appNames[i]) == 0) {
                vec = new Vector<String>();
                vec.add(null);
                vec.add(appNames[i]);
                result.add(vec);
            }
            ++i;
        }
        return result;
    }

    public ConnectorDescriptor[] getAllConnectorDescriptors() {
        Vector<ConnectorDescriptor> result = new Vector<ConnectorDescriptor>();
        Enumeration e = this.descriptors.elements();
        while (e.hasMoreElements()) {
            ConnectorDescriptor[] conDescriptors = (ConnectorDescriptor[])e.nextElement();
            int i = 0;
            while (i < conDescriptors.length) {
                result.add(conDescriptors[i]);
                ++i;
            }
        }
        return result.toArray(new ConnectorDescriptor[result.size()]);
    }

    public ConnectorDescriptor[] getAllConnectorDescriptors(String appName) {
        return (ConnectorDescriptor[])this.descriptors.get(appName);
    }

    public ConnectorDescriptor getConnectorDescriptor(String appName, String displayName) {
        Enumeration e = this.descriptors.elements();
        while (e.hasMoreElements()) {
            ConnectorDescriptor[] conDescriptors = (ConnectorDescriptor[])e.nextElement();
            int j = 0;
            while (j < conDescriptors.length) {
                if (displayName.equals(conDescriptors[j].getDisplayName()) && appName.equals(conDescriptors[j].getApplicationName())) {
                    return conDescriptors[j];
                }
                ++j;
            }
        }
        return null;
    }

    public ApplicationDeployInfo deploy(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        Vector warnings = new Vector();
        Vector newArchiveFiles = null;
        int i = 0;
        while (i < archiveFiles.length) {
            String version = this.deployAdmin.getConnectorVersion(archiveFiles[i].getAbsolutePath(), warnings);
            if (version.equals("1.5")) {
                throw new BaseDeploymentException("connector_0061");
            }
            ++i;
        }
        File[] fileArray = archiveFiles = newArchiveFiles == null ? null : newArchiveFiles.toArray(new File[newArchiveFiles.size()]);
        if (archiveFiles == null) {
            return null;
        }
        ApplicationDeployInfo adInfo = new ApplicationDeployInfo();
        if (dInfo.isStandAloneArchive()) {
            ((Hashtable)props).put("isStandAlone", "true");
        } else {
            ((Hashtable)props).put("isStandAlone", "false");
        }
        adInfo.setDeployProperties(props);
        Configuration configuration = dInfo.getConfiguration();
        try {
            configuration = configuration.createSubConfiguration(CONTAINER_NAME);
        }
        catch (ConfigurationException confExc) {
            throw new BaseDeploymentException("connector_0000", new String[]{CONTAINER_NAME, configuration.getPath()}, (Throwable)((Object)confExc));
        }
        ResourceLoader tempRL = null;
        try {
            tempRL = (ResourceLoader)dInfo.getLoader();
        }
        catch (ClassCastException ex) {
            throw new BaseDeploymentException("connector_0024", dInfo.getLoader(), (Throwable)ex);
        }
        String appName = dInfo.getApplicationName();
        Hashtable filesMapping = dInfo.getFileMappings();
        boolean isRealApp = true;
        if (props.getProperty("isStandAlone").equalsIgnoreCase("true")) {
            isRealApp = false;
            filesMapping.put(archiveFiles[0].getAbsolutePath(), archiveFiles[0].getName());
        }
        String appWorkDir = null;
        try {
            appWorkDir = this.deployCommunicator.getMyWorkDirectory(appName);
        }
        catch (IOException ioexc) {
            throw new BaseXMLParserException("connector_0801", new Object[]{appName}, (Throwable)ioexc);
        }
        Vector connectorNames = new Vector();
        Vector<ConnectorDescriptor> descriptorsVector = new Vector<ConnectorDescriptor>();
        Vector<String> filesForClassloader = new Vector<String>();
        int i2 = 0;
        while (i2 < archiveFiles.length) {
            Vector connectorXmls;
            String relativePath;
            String absolutePath = archiveFiles[i2].getAbsolutePath();
            String[] allJars = this.deployAdmin.extractFiles(configuration, appWorkDir, absolutePath, relativePath = (String)filesMapping.get(absolutePath), connectorXmls = new Vector(), warnings, false);
            if (allJars != null) {
                int j = 0;
                while (j < allJars.length) {
                    filesForClassloader.add(allJars[j]);
                    ++j;
                }
            }
            InputStream raXmlIs = (InputStream)connectorXmls.elementAt(0);
            InputStream addXmlIs = null;
            if (connectorXmls.size() > 1) {
                addXmlIs = (InputStream)connectorXmls.elementAt(1);
            }
            ConnectorDescriptor connectorDescriptor = this.deployAdmin.getConnectorDescriptor(appWorkDir, relativePath, isRealApp, raXmlIs, addXmlIs, warnings);
            connectorDescriptor.setApplicationName(appName);
            descriptorsVector.add(connectorDescriptor);
            allJars = this.deployAdmin.extractDrivers(configuration, connectorDescriptor, appWorkDir, relativePath, false, warnings);
            if (allJars != null) {
                int j = 0;
                while (j < allJars.length) {
                    filesForClassloader.add(allJars[j]);
                    ++j;
                }
                tempRL.addResource(new JarsResource(allJars));
            }
            this.deployAdmin.checkResourceAdapter(connectorNames, connectorDescriptor, tempRL, configuration);
            ConnectionDefinition[] connDefs = connectorDescriptor.getResourceAdapterDescriptor().getOutboundResourceAdapter().getConnectionDefinitions();
            int j = 0;
            while (j < connDefs.length) {
                adInfo.addDeployedResource_Type(connDefs[j].getJNDIName(), connDefs[j].getConnectionFactoryInterface());
                ++j;
            }
            ++i2;
        }
        this.descriptors.put(appName, descriptorsVector.toArray(new ConnectorDescriptor[descriptorsVector.size()]));
        this.deployAdmin.extractProperties(configuration, appName, props, warnings, false);
        adInfo.setFilesForClassloader(filesForClassloader.toArray(new String[filesForClassloader.size()]));
        adInfo.setDeployedComponentNames(connectorNames.toArray(new String[connectorNames.size()]));
        adInfo.setWarnings(warnings);
        return adInfo;
    }

    public void prepareDeploy(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
    }

    public void commitDeploy(String applicationName) throws WarningException {
    }

    public void rollbackDeploy(String applicationName) throws WarningException {
        this.descriptors.remove(applicationName);
    }

    public void notifyDeployedComponents(String applicationName, Properties props) throws WarningException {
    }

    public boolean needUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return true;
    }

    public ApplicationDeployInfo makeUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        WarningException we = null;
        try {
            this.remove(dInfo.getApplicationName());
        }
        catch (WarningException _we) {
            we = _we;
        }
        try {
            dInfo.getConfiguration().deleteConfiguration(CONTAINER_NAME);
        }
        catch (ConfigurationException cex) {
            cex.log();
        }
        ApplicationDeployInfo appDeployInfo = this.deploy(archiveFiles, dInfo, props);
        if (we != null) {
            appDeployInfo.addWarnings(we.getWarnings());
        }
        return appDeployInfo;
    }

    public void prepareUpdate(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitUpdate(String applicationName) throws WarningException {
        return null;
    }

    public void rollbackUpdate(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
    }

    public void notifyUpdatedComponents(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
    }

    public void remove(String applicationName) throws DeploymentException, WarningException {
    }

    public void downloadApplicationFiles(String applicationName, Configuration applicationConfig) throws DeploymentException, WarningException {
        Vector warnings = new Vector();
        try {
            applicationConfig = applicationConfig.getSubConfiguration(CONTAINER_NAME);
        }
        catch (ConfigurationException confExc) {
            throw new BaseDeploymentException("connector_0001", new String[]{CONTAINER_NAME, applicationConfig.getPath()}, (Throwable)((Object)confExc));
        }
        String appWorkDir = null;
        try {
            appWorkDir = this.deployCommunicator.getMyWorkDirectory(applicationName);
        }
        catch (IOException ioexc) {
            throw new BaseDeploymentException("connector_0009", applicationName, (Throwable)ioexc);
        }
        this.deployAdmin.downloadConnectorEntries(applicationConfig, applicationName, appWorkDir, warnings);
    }

    public void prepareStart(String applicationName, Configuration applicationConfig) throws DeploymentException, WarningException {
        Vector warnings = new Vector();
        Configuration propertiesConfig = null;
        try {
            applicationConfig = applicationConfig.getSubConfiguration(CONTAINER_NAME);
        }
        catch (ConfigurationException confExc) {
            throw new BaseDeploymentException("connector_0001", new String[]{CONTAINER_NAME, applicationConfig.getPath()}, (Throwable)((Object)confExc));
        }
        try {
            propertiesConfig = applicationConfig.getSubConfiguration("properties");
        }
        catch (ConfigurationException confExc) {
            throw new BaseDeploymentException("connector_0001", new String[]{"properties", applicationConfig.getPath()}, (Throwable)((Object)confExc));
        }
        InitialContext rootCtx = null;
        try {
            rootCtx = new InitialContext(this.initialContextProperties);
        }
        catch (NamingException nexc) {
            throw new BaseDeploymentException("connector_0006", (Throwable)nexc);
        }
        String appWorkDir = null;
        try {
            appWorkDir = this.deployCommunicator.getMyWorkDirectory(applicationName);
        }
        catch (IOException ioexc) {
            throw new BaseDeploymentException("connector_0009", applicationName, (Throwable)ioexc);
        }
        ResourceLoader loader = null;
        try {
            loader = (ResourceLoader)this.loadContext.getClassLoader(applicationName);
            this.loadContext.registerReference(applicationName, "library:j2eeca");
            if (loader == null) {
                throw new BaseDeploymentException("connector_0025", applicationName);
            }
        }
        catch (ClassCastException cce) {
            throw new BaseDeploymentException("connector_0024", applicationName, (Throwable)cce);
        }
        boolean isRealApp = true;
        Properties props = AdminUtils.getPropertiesFromConfig(propertiesConfig, applicationName, warnings);
        if (props.getProperty("isStandAlone").equalsIgnoreCase("true")) {
            isRealApp = false;
        }
        Vector<ConnectorDescriptor> descriptorsVector = new Vector<ConnectorDescriptor>();
        Hashtable map = new Hashtable();
        try {
            AdminUtils.getAllSecurePropertyEntries("", applicationConfig, map);
            if (map.size() == 0) {
                throw new BaseDeploymentException("connector_0057", new String[]{applicationConfig.getPath()});
            }
        }
        catch (ConfigurationException confExc) {
            throw new BaseDeploymentException("connector_0057", new String[]{applicationConfig.getPath()}, (Throwable)((Object)confExc));
        }
        Iterator fileNamesIter = map.keySet().iterator();
        while (fileNamesIter.hasNext()) {
            String fileName = (String)fileNamesIter.next();
            InputStream is = (InputStream)map.get(fileName);
            int index = fileName.indexOf("/SECURE_META-INF/");
            if (index == -1 || !fileName.substring(index, index + 17).equalsIgnoreCase("/SECURE_META-INF/") || !fileName.substring(fileName.lastIndexOf("/") + 1).equalsIgnoreCase("ra.xml")) continue;
            String rarName = fileName.substring(12, index);
            String addXmlName = fileName.substring(0, fileName.length() - 6) + "connector15-j2ee-engine.xml";
            InputStream addXmlIs = (InputStream)map.get(addXmlName);
            ConnectorDescriptor descr = this.deployAdmin.getConnectorDescriptor(appWorkDir, rarName, isRealApp, is, addXmlIs, warnings);
            descr.setClassLoader(loader);
            descr.setApplicationName(applicationName);
            descriptorsVector.add(descr);
            this.deployAdmin.registerConnector(rootCtx, descr, loader, warnings);
        }
        this.descriptors.put(applicationName, descriptorsVector.toArray(new ConnectorDescriptor[descriptorsVector.size()]));
        if (warnings.size() != 0) {
            WarningException wexc = new WarningException();
            wexc.setWarnings(warnings);
            throw wexc;
        }
    }

    public void prepareStop(String applicationName, Configuration applicationConfig) throws DeploymentException, WarningException {
        this.rollbackStart(applicationName);
    }

    public void commitStart(String applicationName) throws WarningException {
    }

    public void commitStop(String applicationName) throws WarningException {
    }

    public void rollbackStart(String applicationName) throws WarningException {
        Vector<String> warnings = new Vector<String>();
        ConnectorDescriptor[] connectorDescriptors = (ConnectorDescriptor[])this.descriptors.remove(applicationName);
        int j = 0;
        while (j < connectorDescriptors.length) {
            ConnectorDescriptor connectorDescriptor = connectorDescriptors[j];
            if (connectorDescriptor == null) {
                return;
            }
            ResourceAdapter ra = connectorDescriptor.getResourceAdapterDescriptor().getResourceAdapter();
            if (ra != null) {
                try {
                    ra.stop();
                }
                catch (Exception e) {
                    warnings.add("Can't stop resource adapter reason : " + e.toString());
                }
            } else {
                return;
            }
            InitialContext rootContext = null;
            try {
                rootContext = new InitialContext(this.initialContextProperties);
            }
            catch (NamingException nexc) {
                warnings.add("Can not get initial context, reason : " + nexc.toString());
            }
            ConnectionDefinition[] connDefinitions = connectorDescriptor.getResourceAdapterDescriptor().getOutboundResourceAdapter().getConnectionDefinitions();
            int i = 0;
            while (connDefinitions != null && i < connDefinitions.length) {
                String jndiName = connDefinitions[i].getJNDIName();
                AdminUtils.stopFactory(jndiName, connDefinitions[i].getAliases(), warnings);
                if (rootContext != null) {
                    try {
                        this.deployAdmin.unbindMCF(rootContext, jndiName);
                    }
                    catch (NamingException nexc) {
                        warnings.add("Can not unbind '" + jndiName + "' mcf, reason : " + nexc.toString());
                    }
                } else {
                    warnings.add("Can not unbind '" + jndiName + "' mcf, reason : can not get initial context.");
                }
                ++i;
            }
            ++j;
        }
        if (warnings.size() != 0) {
            WarningException wexc = new WarningException();
            wexc.setWarnings(warnings);
            throw wexc;
        }
    }

    public void rollbackStop(String applicationName) throws WarningException {
    }

    public File[] getClientJar(String applicationName) {
        return new File[0];
    }

    public ExportInfo[] getCurrentStatus(String applicationName) throws WarningException {
        return new ExportInfo[0];
    }

    public void appInfoChangedRollback(String appName) throws WarningException {
    }

    public void rollbackRuntimeChanges(String applicationName) throws WarningException {
    }

    public void notifyAppInfoChanged(String appName) throws WarningException {
    }

    public String[] getResourcesForTempLoader(String applicationName) throws DeploymentException {
        return null;
    }

    public ApplicationDeployInfo makeSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        return null;
    }

    public void removeProgressListener(ProgressListener listener) {
    }

    public boolean needStopOnAppInfoChanged(String appName, AdditionalAppInfo addAppInfo) {
        return false;
    }

    public void prepareRuntimeChanges(String applicationName) throws DeploymentException, WarningException {
    }

    public void rollbackSingleFileUpdate(String applicationName, Configuration config) throws WarningException {
    }

    public boolean needStopOnUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return true;
    }

    public ApplicationDeployInfo commitSingleFileUpdate(String applicationName) throws WarningException {
        return null;
    }

    public void appInfoChangedCommit(String appName) throws WarningException {
    }

    public boolean needStopOnSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return false;
    }

    public void notifyRuntimeChanges(String applicationName, Configuration appConfig) throws WarningException {
    }

    public void addProgressListener(ProgressListener listener) {
    }

    public void prepareSingleFileUpdate(String applicationName) throws DeploymentException, WarningException {
    }

    public void notifySingleFileUpdate(String applicationName, Configuration config, Properties props) throws WarningException {
    }

    public ApplicationDeployInfo commitRuntimeChanges(String applicationName) throws WarningException {
        return null;
    }

    public void applicationStatusChanged(String applicationName, byte status) {
    }

    public boolean acceptedAppInfoChange(String appName, AdditionalAppInfo addAppInfo) throws DeploymentException {
        return false;
    }

    public void makeAppInfoChange(String appName, AdditionalAppInfo addAppInfo, Configuration configuration) throws WarningException, DeploymentException {
    }
}

