/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0;

import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.jca.deploy.descriptor.CallerPrincipal;
import com.sap.engine.services.connector.jca.deploy.descriptor.IdentitySubject;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.UserGroupTreeNode;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.UsersPanel;
import com.sap.engine.services.security.remote.RemoteGroupInfo;
import com.sap.engine.services.security.remote.RemoteIterator;
import com.sap.engine.services.security.remote.RemoteUserStoreFactory;
import com.sap.engine.services.security.remote.RemoteUserStoreInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UsersPanelLogical
extends UsersPanel {
    private RemoteUserStoreFactory usf;
    private JCDescriptor descr;
    private IdentitySubject[] identities;
    private Vector treePaths;

    public UsersPanelLogical(boolean isEditable) {
        super(isEditable);
    }

    public UsersPanelLogical() {
    }

    public void setTitle(String title) {
        this.titledBorder.setTitle(title);
    }

    public Vector setSelectionPath(String caller, boolean isUser) {
        UserGroupTreeNode callerNode;
        Vector treePaths = new Vector();
        Hashtable callerPathsMapping = null;
        if (isUser) {
            callerPathsMapping = (Hashtable)this.userTreePaths.get(caller);
            callerNode = (UserGroupTreeNode)this.directUsers.get(caller);
        } else {
            callerPathsMapping = (Hashtable)this.groupTreePaths.get(caller);
            callerNode = (UserGroupTreeNode)this.directGroups.get(caller);
            if (callerNode == null) {
                callerNode = (UserGroupTreeNode)this.groupNodes.get(caller);
            }
        }
        Enumeration enumeration = callerPathsMapping.elements();
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                Vector allPathsForElement = (Vector)enumeration.nextElement();
                treePaths.add(allPathsForElement);
            }
        } else {
            Vector<TreePath> allPathsForElement = new Vector<TreePath>();
            allPathsForElement.add(new TreePath(callerNode));
            treePaths.add(allPathsForElement);
        }
        return treePaths;
    }

    public void setUsers(Iterator groupsIterator, Iterator usersIterator) throws RemoteException {
        while (groupsIterator.hasNext()) {
            UserGroupTreeNode userNode = this.initUsers(this.usf.getActiveUserStore().getGroupContext().getGroupInfo((String)groupsIterator.next()));
            this.usersModel.insertNodeInto(userNode, this.root);
        }
        while (usersIterator.hasNext()) {
            this.usersModel.insertNodeInto(new UserGroupTreeNode(this.usf.getActiveUserStore().getUserContext().getUserInfo((String)usersIterator.next()).getName(), true), this.root);
        }
        this.usersModel.fireTreeStructureChanged(new TreeModelEvent((Object)this.usersModel, new TreePath(this.root)));
    }

    private UserGroupTreeNode initUsers(RemoteGroupInfo groupInfo) throws RemoteException {
        RemoteIterator iter = groupInfo.getChildGroups();
        UserGroupTreeNode parentNode = new UserGroupTreeNode(groupInfo, false);
        while (iter.hasNext()) {
            UserGroupTreeNode userNode = this.initUsers(this.usf.getActiveUserStore().getGroupContext().getGroupInfo((String)iter.next()));
            this.usersModel.insertNodeInto(userNode, parentNode);
        }
        iter = groupInfo.getUsersInGroup();
        while (iter.hasNext()) {
            this.usersModel.insertNodeInto(new UserGroupTreeNode(this.usf.getActiveUserStore().getUserContext().getUserInfo((String)iter.next()).getName(), true), parentNode);
        }
        return parentNode;
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.users.setEnabled(enable);
    }

    public void setUserStoreFactory(RemoteUserStoreFactory usf) {
        this.usf = usf;
    }

    public void setJCDescriptor(JCDescriptor descr) {
        this.descr = descr;
    }

    public void setUserDataSource(RemoteUserStoreFactory usf) throws RemoteException {
        this.clearAll();
        this.usf = usf;
        RemoteIterator groupsIterator = usf.getActiveUserStore().getGroupContext().listRootGroups();
        RemoteIterator usersIterator = usf.getActiveUserStore().getUserContext().listRootUsers();
        this.setUsers(groupsIterator, usersIterator);
    }

    public void setUserDataSource(IdentitySubject[] subjects) throws RemoteException {
        this.identities = subjects;
        this.clearAll();
        try {
            this.showIdentitySubjects(this.identities);
        }
        catch (Exception exc) {
            ConnectorServiceFrame.logException(exc);
        }
    }

    public void setUserDataSource(JCDescriptor descr) throws RemoteException {
        this.clearAll();
        this.descr = descr;
        if (descr != null) {
            this.identities = descr.getIdentitySubjects();
            if (this.identities == null) {
                return;
            }
        } else {
            this.identities = null;
            return;
        }
        this.showIdentitySubjects(this.identities);
    }

    /*
     * Unable to fully structure code
     */
    public void setUserDataSource(Vector treePaths, TreePath selectionPath) {
        this.treePaths = (Vector)treePaths.clone();
        this.clearAll();
        if (treePaths == null) {
            return;
        }
        root = (UserGroupTreeNode)this.usersModel.getRoot();
        this.groupNodes.put(root.toString(), root);
        i = 0;
        while (i < treePaths.size()) {
            treePath = (Vector)treePaths.elementAt(i);
            j = 0;
            while (j < treePath.size()) {
                path = (TreePath)treePath.elementAt(j);
                pathElements = path.getPath();
                lastParent = root;
                k = 0;
                while (k < pathElements.length - 2) {
                    block6: {
                        childNode = (UserGroupTreeNode)pathElements[k + 1];
                        index = lastParent.getIndex(childNode);
                        if (index != -1) break block6;
                        childNode = new UserGroupTreeNode(childNode.getUserObject(), false);
                        this.groupNodes.put(childNode.toString(), childNode);
                        ** GOTO lbl-1000
                    }
                    childNode = (UserGroupTreeNode)lastParent.getChildAt(index);
                    if (lastParent == childNode.getParent()) {
                        lastParent = childNode;
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.usersModel.insertNodeInto(childNode, lastParent);
                        lastParent = childNode;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.usersModel.fireTreeStructureChanged(this.usersModel, new Object[]{this.usersModel.getRoot()}, null, null);
        this.users.setSelectionPath(selectionPath);
        this.users.scrollPathToVisible(selectionPath);
    }

    private void showIdentitySubjects(IdentitySubject[] subjects) throws RemoteException {
        if (subjects == null) {
            return;
        }
        int i = 0;
        while (i < subjects.length) {
            HashSet users;
            CallerPrincipal caller = subjects[i].getCallerPrincipal();
            if (caller == null) {
                return;
            }
            HashSet groups = caller.getGroups();
            if (groups != null) {
                Iterator groupsIerator = groups.iterator();
                while (groupsIerator.hasNext()) {
                    String groupName = (String)groupsIerator.next();
                    if (this.directGroups.containsKey(groupName) || this.groupNodes.containsKey(groupName)) continue;
                    RemoteGroupInfo groupInfo = this.usf.getActiveUserStore().getGroupContext().getGroupInfo(groupName);
                    UserGroupTreeNode destNode = new UserGroupTreeNode(groupInfo, false);
                    Vector createdNodes = new Vector();
                    destNode.setDirect(true);
                    this.initVisibleGroups(destNode, null, false, createdNodes);
                    this.directGroups.put(groupName, destNode);
                    int j = 0;
                    while (j < createdNodes.size()) {
                        this.usersModel.insertNodeInto((UserGroupTreeNode)createdNodes.elementAt(j), this.root);
                        ++j;
                    }
                }
            }
            if ((users = caller.getUserNames()) != null) {
                Iterator usersIerator = users.iterator();
                while (usersIerator.hasNext()) {
                    String userName = (String)usersIerator.next();
                    if (this.directUsers.get(userName) != null) continue;
                    RemoteUserStoreInfo userInfo = this.usf.getActiveUserStore().getUserContext().getUserInfo(userName);
                    UserGroupTreeNode destNode = new UserGroupTreeNode(userInfo, true);
                    Vector createdNodes = new Vector();
                    destNode.setDirect(true);
                    this.initVisibleGroups(destNode, null, true, createdNodes);
                    this.directUsers.put(userName, userInfo);
                    int j = 0;
                    while (j < createdNodes.size()) {
                        this.usersModel.insertNodeInto((UserGroupTreeNode)createdNodes.elementAt(j), this.root);
                        ++j;
                    }
                }
            }
            ++i;
        }
        this.usersModel.fireTreeStructureChanged(new TreeModelEvent((Object)this.usersModel, new TreePath(this.root)));
        Enumeration enumeration = this.groupTreePaths.keys();
        while (enumeration.hasMoreElements()) {
            String mainElementName = (String)enumeration.nextElement();
            Hashtable pathsMapping = (Hashtable)this.groupTreePaths.get(mainElementName);
            Enumeration pathsEnum = pathsMapping.keys();
            while (pathsEnum.hasMoreElements()) {
                String subElementName = (String)pathsEnum.nextElement();
                Vector<TreePath> allTreePaths = new Vector<TreePath>();
                Vector allPathsForElement = (Vector)pathsMapping.get(subElementName);
                int i2 = 0;
                while (i2 < allPathsForElement.size()) {
                    if (!(allPathsForElement.elementAt(i2) instanceof TreePath)) {
                        Vector onePathForElement = (Vector)allPathsForElement.elementAt(i2);
                        Vector treePath = (Vector)onePathForElement.clone();
                        treePath.insertElementAt(this.root, 0);
                        allTreePaths.add(new TreePath(treePath.toArray()));
                    }
                    ++i2;
                }
                pathsMapping.put(subElementName, allTreePaths);
            }
        }
    }

    public void addExistingNode(Object userInfo) throws RemoteException {
        if (userInfo instanceof RemoteGroupInfo) {
            UserGroupTreeNode destNode = new UserGroupTreeNode(userInfo, false);
            Vector createdNodes = new Vector();
            destNode.setDirect(true);
            this.initVisibleGroups(destNode, null, false, createdNodes);
            this.directGroups.put(destNode.toString(), destNode);
        } else if (userInfo instanceof RemoteUserStoreInfo) {
            UserGroupTreeNode destNode = new UserGroupTreeNode(userInfo, true);
            Vector createdNodes = new Vector();
            destNode.setDirect(true);
            this.initVisibleGroups(destNode, null, false, createdNodes);
            this.directUsers.put(destNode.toString(), destNode);
        }
    }

    private void showAllSubTrees(Hashtable table, String sign) {
        Enumeration enumeration = table.elements();
        System.out.println("-------------------- " + sign + " START -----------------");
        while (enumeration.hasMoreElements()) {
            Object nextEl = enumeration.nextElement();
            if (nextEl instanceof Vector) {
                int i = 0;
                while (i < ((Vector)nextEl).size()) {
                    this.showTree((UserGroupTreeNode)((Vector)nextEl).elementAt(i));
                    ++i;
                }
                continue;
            }
            this.showTree((UserGroupTreeNode)nextEl);
        }
        System.out.println("-------------------- " + sign + " END -----------------");
    }

    private void showTree(UserGroupTreeNode root) {
        Vector<TreeNode> nodes = new Vector<TreeNode>();
        nodes.add(root);
        String emptySpaces = "";
        int firstIndex = 0;
        int secondIndex = 0;
        int level = 0;
        int step = 1;
        boolean finished = false;
        while (nodes.size() != 0) {
            UserGroupTreeNode node = (UserGroupTreeNode)nodes.remove(firstIndex);
            System.out.println(this.makeSpace(level) + node);
            int index = node.getChildCount();
            if (index > 0) {
                int i = 0;
                while (i < index) {
                    nodes.add(node.getChildAt(i));
                    ++i;
                }
                secondIndex = firstIndex;
                firstIndex = nodes.size() - index;
                ++level;
                if (index != 1) continue;
                ++step;
                continue;
            }
            if (firstIndex < nodes.size()) continue;
            if (secondIndex < nodes.size()) {
                firstIndex = secondIndex;
                --level;
                continue;
            }
            firstIndex = 0;
            level = level - step + 1;
            step = 1;
        }
    }

    private String makeSpace(int level) {
        StringBuffer space = new StringBuffer("");
        int i = 0;
        while (i < level) {
            space.append(" ");
            ++i;
        }
        return space.toString();
    }

    /*
     * Unable to fully structure code
     */
    private void initVisibleGroups(UserGroupTreeNode destNode, UserGroupTreeNode srcNode, boolean isUser, Vector createdNodes) throws RemoteException {
        block17: {
            block18: {
                groupInfo = null;
                destGroupName = null;
                userName = null;
                usersIterator = null;
                if (destNode.isUser()) {
                    userInfo = (RemoteUserStoreInfo)destNode.getUserObject();
                    userName = userInfo.getName();
                    usersIterator = userInfo.getParentGroups();
                } else {
                    groupInfo = (RemoteGroupInfo)destNode.getUserObject();
                    destGroupName = groupInfo.getName();
                    usersIterator = groupInfo.getParentGroups();
                }
                if (destGroupName != null) {
                    this.groupTreePaths.put(destGroupName, new Hashtable<K, V>());
                    if (srcNode != null) {
                        this.usersModel.insertNodeInto(srcNode, destNode);
                        this.groupNodes.put(destGroupName, destNode);
                    }
                } else {
                    this.userTreePaths.put(userName, new Hashtable<K, V>());
                }
                hasParents = true;
                hasParents = usersIterator.hasNext() != false;
                index = 0;
                while (usersIterator.hasNext()) {
                    ++index;
                    name = (String)usersIterator.next();
                    if (destGroupName != null) {
                        if (this.directGroups.containsKey(name)) {
                            existingDestNode = (UserGroupTreeNode)this.directGroups.get(name);
                            this.usersModel.insertNodeInto(destNode, existingDestNode);
                            existingDestNodes = (Vector)this.clonedGroupNodes.get(name);
                            i = 0;
                            while (existingDestNodes != null && i < existingDestNodes.size()) {
                                existingDestNode = (UserGroupTreeNode)existingDestNodes.elementAt(i);
                                destNode = (UserGroupTreeNode)destNode.cloneNode(this.clonedGroupNodes);
                                this.usersModel.insertNodeInto(destNode, existingDestNode);
                                ++i;
                            }
                            this.showAllSubTrees(this.directGroups, "AFTER DIRECT GROUPS");
                            this.showAllSubTrees(this.clonedGroupNodes, "AFTER CLONED GROUP NODES");
                            this.initCurrentPathsFromExistingDestNode(destNode, existingDestNode);
                            continue;
                        }
                        if (this.groupNodes.containsKey(name)) {
                            existingDestNode = (UserGroupTreeNode)this.groupNodes.get(name);
                            this.usersModel.insertNodeInto(destNode, existingDestNode);
                            existingDestNodes = (Vector)this.clonedGroupNodes.get(name);
                            i = 0;
                            while (existingDestNodes != null && i < existingDestNodes.size()) {
                                existingDestNode = (UserGroupTreeNode)existingDestNodes.elementAt(i);
                                this.usersModel.insertNodeInto(destNode, existingDestNode);
                                ++i;
                            }
                            this.initCurrentPathsFromExistingDestNode(destNode, existingDestNode);
                            continue;
                        }
                    }
                    groupInfo = this.usf.getActiveUserStore().getGroupContext().getGroupInfo(name);
                    newSrcNode = new UserGroupTreeNode(groupInfo, false);
                    if (index >= 2) {
                        existingDestNodes = (Vector)this.clonedGroupNodes.get((destNode = (UserGroupTreeNode)destNode.cloneNode(this.clonedGroupNodes)).toString());
                        if (existingDestNodes == null) {
                            existingDestNodes = new Vector();
                            this.clonedGroupNodes.put(destNode.toString(), existingDestNodes);
                        }
                        existingDestNodes.add(destNode);
                    }
                    this.initVisibleGroups(newSrcNode, destNode, false, createdNodes);
                }
                allDestPaths = null;
                srcAllDestPaths = null;
                srcPathMapping = null;
                if (srcNode != null) {
                    srcAllDestPaths = new Vector<Vector>();
                    srcGroupName = srcNode.toString();
                    srcPathMapping = isUser != false ? (Hashtable)this.userTreePaths.get(srcGroupName) : (Hashtable)this.groupTreePaths.get(srcGroupName);
                }
                allDestPaths = isUser != false ? (Hashtable)this.userTreePaths.get(destGroupName) : (Hashtable)this.groupTreePaths.get(destGroupName);
                if (srcNode == null) break block17;
                allDestPathsEnum = allDestPaths.elements();
                if (allDestPathsEnum.hasMoreElements()) ** GOTO lbl98
                oneDestPath = new Vector<UserGroupTreeNode>();
                oneDestPath.add(destNode);
                oneDestPath.add(srcNode);
                srcAllDestPaths.add(oneDestPath);
                break block18;
lbl-1000:
                // 1 sources

                {
                    destPaths = (Vector)allDestPathsEnum.nextElement();
                    i = 0;
                    while (i < destPaths.size()) {
                        oneDestPath = (Vector)((Vector)destPaths.elementAt(i)).clone();
                        oneDestPath.add(srcNode);
                        srcAllDestPaths.add(oneDestPath);
                        ++i;
                    }
lbl98:
                    // 2 sources

                    ** while (allDestPathsEnum.hasMoreElements())
                }
            }
            srcPathMapping.put(destGroupName, srcAllDestPaths);
        }
        if (!hasParents) {
            createdNodes.add(destNode);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initCurrentPathsFromExistingDestNode(UserGroupTreeNode destNode, UserGroupTreeNode existingDestNode) throws RemoteException {
        block4: {
            destName = destNode.toString();
            existingDestName = existingDestNode.toString();
            allExistingDestPaths = (Hashtable)this.groupTreePaths.get(existingDestName);
            allDestPaths = new Vector<Vector>();
            if (destNode.isUser()) {
                ((Hashtable)this.userTreePaths.get(destName)).put(existingDestName, allDestPaths);
            } else {
                ((Hashtable)this.groupTreePaths.get(destName)).put(existingDestName, allDestPaths);
            }
            allExistingDestPathsEnum = allExistingDestPaths.elements();
            if (allExistingDestPathsEnum.hasMoreElements()) ** GOTO lbl31
            oneClonedExistingDestPath = new Vector<UserGroupTreeNode>();
            oneClonedExistingDestPath.add(existingDestNode);
            oneClonedExistingDestPath.add(destNode);
            allDestPaths.add(oneClonedExistingDestPath);
            break block4;
lbl-1000:
            // 1 sources

            {
                existingDestPaths = (Vector)allExistingDestPathsEnum.nextElement();
                i = 0;
                while (i < existingDestPaths.size()) {
                    oneClonedExistingDestPath = (Vector)((Vector)existingDestPaths.elementAt(i)).clone();
                    oneClonedExistingDestPath.add(destNode);
                    allDestPaths.add(oneClonedExistingDestPath);
                    ++i;
                }
lbl31:
                // 2 sources

                ** while (allExistingDestPathsEnum.hasMoreElements())
            }
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("TestFrame");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        UsersPanelLogical panel = new UsersPanelLogical();
        frame.getContentPane().add((Component)panel, "Center");
        ((Component)frame).setSize(800, 600);
        ((Component)frame).setVisible(true);
    }
}

