/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0;

import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.AdditionalInfo;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.TreeCellRenderer;
import com.sap.engine.services.security.remote.RemoteGroupInfo;
import com.sap.engine.services.security.remote.RemoteUserStoreInfo;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class UserGroupTreeNode
implements TreeNode,
Comparable,
AdditionalInfo {
    static final long serialVersionUID = 8365394829584554387L;
    protected ArrayList children;
    protected UserGroupTreeNode parent;
    protected Object userObject;
    protected String userName;
    protected boolean isUser = false;
    protected boolean exists = true;
    protected boolean isDirect = false;
    protected TreeCellRenderer cellRenderer;
    protected Object cellEditor;
    public static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("No more elements");
        }
    };

    public UserGroupTreeNode(Object userObject, boolean isUser) {
        this.userObject = userObject;
        try {
            this.userName = userObject instanceof RemoteGroupInfo ? ((RemoteGroupInfo)userObject).getName() : (userObject instanceof RemoteUserStoreInfo ? ((RemoteUserStoreInfo)userObject).getName() : userObject.toString());
        }
        catch (RemoteException re) {
            this.userName = "UNKNOWN group or user name";
        }
        catch (NullPointerException npe) {
            this.userName = "UNKNOWN group or user name";
        }
        this.isUser = isUser;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
        try {
            this.userName = userObject instanceof RemoteGroupInfo ? ((RemoteGroupInfo)userObject).getName() : (userObject instanceof RemoteUserStoreInfo ? ((RemoteUserStoreInfo)userObject).getName() : userObject.toString());
        }
        catch (RemoteException re) {
            this.userName = "UNKNOWN group or user name";
        }
        catch (NullPointerException npe) {
            this.userName = "UNKNOWN group or user name";
        }
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void add(UserGroupTreeNode newChild) {
        int index;
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (this.isNodeAncestor(newChild)) {
            throw new IllegalArgumentException("new child is an ancestor");
        }
        UserGroupTreeNode oldParent = (UserGroupTreeNode)newChild.getParent();
        if (oldParent != null) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if ((index = Collections.binarySearch(this.children, newChild)) < 0) {
            index = -index - 1;
            this.children.add(index, newChild);
        }
    }

    public void removeAllChildren() {
        int i = this.getChildCount() - 1;
        while (i >= 0) {
            this.remove(i);
            --i;
        }
        this.children = null;
    }

    public void remove(int childIndex) {
        if (this.children == null) {
            return;
        }
        UserGroupTreeNode child = (UserGroupTreeNode)this.getChildAt(childIndex);
        this.children.remove(childIndex);
        child.setParent(null);
    }

    public void remove(UserGroupTreeNode node) {
        if (this.children == null) {
            return;
        }
        ((AbstractCollection)this.children).remove(node);
    }

    public void removeFromParent() {
        UserGroupTreeNode parent = (UserGroupTreeNode)this.getParent();
        if (parent != null) {
            parent.remove(this);
        }
    }

    public void setParent(UserGroupTreeNode newParent) {
        this.parent = newParent;
    }

    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        if (this.children != null) {
            return this.children.size();
        }
        return 0;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public int getIndex(TreeNode node) {
        if (this.children == null) {
            return -1;
        }
        int index = Collections.binarySearch(this.children, node);
        if (index >= 0) {
            return index;
        }
        return -1;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public Enumeration children() {
        if (this.children != null && this.children.size() != 0) {
            final Iterator iter = ((AbstractList)this.children).iterator();
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return iter.hasNext();
                }

                public Object nextElement() {
                    return iter.next();
                }
            };
        }
        return EMPTY_ENUMERATION;
    }

    public boolean isNodeAncestor(UserGroupTreeNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        UserGroupTreeNode ancestor = this;
        do {
            if (ancestor != anotherNode) continue;
            return true;
        } while ((ancestor = (UserGroupTreeNode)ancestor.getParent()) != null);
        return false;
    }

    public int compareTo(Object o) {
        UserGroupTreeNode node = (UserGroupTreeNode)o;
        if (this.isUser() == node.isUser()) {
            return this.toString().compareTo(node.toString());
        }
        if (this.isUser()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object o) {
        UserGroupTreeNode node = (UserGroupTreeNode)o;
        if (this == node) {
            return true;
        }
        if (this.isUser() != node.isUser()) {
            return false;
        }
        return this.toString().equals(node.toString());
    }

    public int hashCode() {
        return this.userObject.toString().hashCode();
    }

    public String toString() {
        return this.userName;
    }

    public void setUser(boolean isUser) {
        this.isUser = isUser;
    }

    public boolean isUser() {
        return this.isUser;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public boolean exists() {
        return this.exists;
    }

    public void setDirect(boolean isDirect) {
        this.isDirect = isDirect;
    }

    public boolean isDirect() {
        return this.isDirect;
    }

    public void setCellRenderer(TreeCellRenderer cellRenderer) {
        this.cellRenderer = cellRenderer;
    }

    public TreeCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellEditor(Object cellEditor) {
        this.cellEditor = cellEditor;
    }

    public Object getCellEditor() {
        return this.cellEditor;
    }

    public Object cloneNode(Hashtable clonedObjects) {
        UserGroupTreeNode cloning = new UserGroupTreeNode(this.userObject, this.isUser);
        cloning.children = this.children;
        if (this.children != null) {
            cloning.children = (ArrayList)this.children.clone();
            int i = 0;
            while (i < cloning.children.size()) {
                UserGroupTreeNode child = (UserGroupTreeNode)((UserGroupTreeNode)cloning.children.get(i)).cloneNode(clonedObjects);
                Vector<UserGroupTreeNode> allCloningsOfNode = (Vector<UserGroupTreeNode>)clonedObjects.get(child.toString());
                if (allCloningsOfNode == null) {
                    allCloningsOfNode = new Vector<UserGroupTreeNode>();
                    clonedObjects.put(child.toString(), allCloningsOfNode);
                }
                allCloningsOfNode.add(child);
                child.parent = cloning;
                cloning.children.set(i, child);
                ++i;
            }
        }
        cloning.parent = null;
        cloning.userName = this.userName;
        cloning.exists = this.exists;
        cloning.isDirect = this.isDirect;
        return cloning;
    }
}

