/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class SortedTableModel
extends AbstractTableModel
implements MouseListener,
Comparator {
    protected ArrayList rows;
    protected ArrayList columnNames;
    protected TableColumnModel columnModel;
    protected DefaultListSelectionModel selectionModel;
    protected JTableHeader tableHeader;
    private int sortCol = -1;
    private boolean straightDirection;

    public SortedTableModel(JTable table) {
        this.tableHeader = table.getTableHeader();
        this.tableHeader.addMouseListener(this);
        this.columnModel = table.getColumnModel();
        this.selectionModel = (DefaultListSelectionModel)table.getSelectionModel();
        this.rows = new ArrayList();
        this.columnNames = new ArrayList();
        table.setModel(this);
    }

    public void mouseClicked(MouseEvent e) {
        int index = this.selectionModel.getMinSelectionIndex();
        ArrayList list = null;
        if (index != -1) {
            list = (ArrayList)this.rows.get(index);
        }
        this.sort(this.columnModel.getColumn(this.tableHeader.columnAtPoint(e.getPoint())).getModelIndex());
        if (index != -1) {
            index = this.rows.indexOf(list);
            this.selectionModel.setSelectionInterval(index, index);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public int compare(Object o1, Object o2) {
        int res = ((Comparable)((ArrayList)o2).get(this.sortCol)).compareTo((Comparable)((ArrayList)o1).get(this.sortCol));
        if (this.straightDirection) {
            return res;
        }
        return res * -1;
    }

    protected void sort(int col) {
        if (this.sortCol == col) {
            this.straightDirection = !this.straightDirection;
        } else {
            this.sortCol = col;
            this.straightDirection = false;
        }
        Collections.sort(this.rows, this);
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public ArrayList getRows() {
        return this.rows;
    }

    public Object getValueAt(int row, int col) {
        return ((ArrayList)this.rows.get(row)).get(col);
    }

    public void setValueAt(Object value, int row, int col) {
        ((ArrayList)this.rows.get(row)).set(col, value);
        this.fireTableDataChanged();
    }

    public String getColumnName(int column) {
        return (String)this.columnNames.get(column);
    }

    public void addRow(ArrayList newRow) {
        this.rows.add(newRow);
        this.fireTableDataChanged();
    }

    public void addRow(int index, ArrayList newRow) {
        this.rows.add(index, newRow);
        this.fireTableDataChanged();
    }

    public void removeRow(int index) {
        this.rows.remove(index);
        this.fireTableDataChanged();
    }

    public void clearAll() {
        this.rows.clear();
        this.fireTableDataChanged();
    }

    public void refresh() {
        this.fireTableStructureChanged();
    }

    public void setColumnNames(ArrayList names) {
        this.columnNames = names;
        this.fireTableStructureChanged();
    }
}

