/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0;

import com.sap.engine.services.connector.jca.deploy.descriptor.SecurityPermission;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.ObjectValues;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.SecurityPermissionWrapper;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.SecurityPermissionsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.AbstractList;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class SecurityPermissionsPanelLogical
extends SecurityPermissionsPanel {
    private SecurityPermission[] secPermissions = null;
    private int lastSelected = -1;
    private Frame mainFrame = null;

    public SecurityPermissionsPanelLogical() {
    }

    public SecurityPermissionsPanelLogical(Frame mainFrame) {
        this.setFrame(mainFrame);
    }

    public SecurityPermissionsPanelLogical(SecurityPermission[] secPermissions) {
        this.setSecurityPermissions(secPermissions);
    }

    public SecurityPermissionsPanelLogical(Frame mainFrame, SecurityPermission[] secPermissions) {
        this.setFrame(mainFrame);
        this.setSecurityPermissions(secPermissions);
    }

    public void setFrame(Frame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void setSecurityPermissions(SecurityPermission[] sPermissions) {
        this.secPermissions = sPermissions;
        this.clearFields();
        this.initList(this.secPermissions);
    }

    private void initList(SecurityPermission[] values) {
        this.model.clear();
        this.lastSelected = -1;
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                this.model.add(new ObjectValues(this.wrapPermission(i + 1, values[i]), 1));
                ++i;
            }
        }
    }

    private SecurityPermissionWrapper wrapPermission(int index, SecurityPermission perm) {
        SecurityPermissionWrapper wrapped = null;
        if (perm != null && index > 0) {
            wrapped = new SecurityPermissionWrapper(index, perm);
        }
        return wrapped;
    }

    private SecurityPermission unwrapPermission(SecurityPermissionWrapper perm) {
        SecurityPermission unwrapped = null;
        if (perm != null) {
            unwrapped = perm.getSecurityPermission();
        }
        return unwrapped;
    }

    private void addPermission(String spec, String descr) {
        if (spec == null || spec.equals("")) {
            return;
        }
        ObjectValues value = null;
        SecurityPermission perm = null;
        int answer = 1;
        Iterator iter = ((AbstractList)this.model.getData()).iterator();
        while (iter.hasNext()) {
            value = (ObjectValues)iter.next();
            perm = value.getSecurityPermission().getSecurityPermission();
            if (!spec.equals(perm.getSecurityPermissionSpec())) continue;
            if (descr != null) {
                if (descr.equals(perm.getDescription())) {
                    this.addButton.setEnabled(false);
                    int index = this.model.getData().indexOf(value);
                    if (index != this.lastSelected) {
                        this.permissionsList.setSelectedIndex(index);
                        this.scrollToSelected(index);
                    }
                    return;
                }
            } else if (perm.getDescription() == null || perm.getDescription().equals("")) {
                this.addButton.setEnabled(false);
                int index = this.model.getData().indexOf(value);
                if (index != this.lastSelected) {
                    this.permissionsList.setSelectedIndex(index);
                    this.scrollToSelected(index);
                }
                return;
            }
            if ((answer = JOptionPane.showConfirmDialog(this.mainFrame, "Security Permission <" + spec + "> already exists.\n Would you like to save the changes and modify this Security Permission?", "Warning", 0, 2)) == 0) {
                this.modifyPermission(value, spec, descr);
                int index = this.model.getData().indexOf(value);
                this.permissionsList.setSelectedIndex(index);
                this.scrollToSelected(index);
            }
            return;
        }
        SecurityPermissionWrapper wrap = new SecurityPermissionWrapper(this.model.size() + 1, new SecurityPermission(spec, descr));
        value = new ObjectValues(wrap, 1);
        this.model.add(value);
        int index = this.model.getData().indexOf(value);
        this.permissionsList.setSelectedIndex(index);
        this.scrollToSelected(index);
    }

    private void modifyPermission(ObjectValues perm, String spec, String descr) {
        if (perm == null) {
            return;
        }
        if (spec == null || spec.equals("")) {
            JOptionPane.showMessageDialog(this.mainFrame, "Can not modify Security Permission because Security Permission Specification is not specified.", "Warning", 2);
            return;
        }
        perm.getSecurityPermission().getSecurityPermission().setSecurityPermissionSpec(spec);
        perm.getSecurityPermission().getSecurityPermission().setDescription(descr);
        this.modifyButton.setEnabled(false);
    }

    private void removePermission(ObjectValues perm) {
        if (perm == null) {
            return;
        }
        int index = this.model.getData().indexOf(perm);
        if (index - 1 >= 0) {
            this.lastSelected = index - 1;
            this.permissionsList.setSelectedIndex(this.lastSelected);
            this.scrollToSelected(this.lastSelected);
        } else if (index < this.model.size() - 1) {
            this.lastSelected = index + 1;
            this.permissionsList.setSelectedIndex(this.lastSelected);
            this.scrollToSelected(this.lastSelected);
        } else {
            this.permissionsList.clearSelection();
            this.clearFields();
            this.lastSelected = -1;
        }
        this.model.remove(this.model.getData().indexOf(perm));
    }

    private void scrollToSelected(int selectedIndex) {
        Rectangle rec = this.permissionsList.getCellBounds(0, 0);
        rec.y = selectedIndex * rec.height;
        this.permissionsList.scrollRectToVisible(rec);
    }

    public SecurityPermission[] getSecurityPermissions() {
        return this.secPermissions;
    }

    private void showPermission(ObjectValues perm) {
        if (perm == null || perm.getSecurityPermission() == null || perm.getSecurityPermission().getSecurityPermission() == null || perm.getSecurityPermission().getSecurityPermission().getSecurityPermissionSpec() == null || perm.getSecurityPermission().getSecurityPermission().getSecurityPermissionSpec().equals("")) {
            return;
        }
        SecurityPermission secPerm = perm.getSecurityPermission().getSecurityPermission();
        this.specPanel.setText(secPerm.getSecurityPermissionSpec());
        if (secPerm.getDescription() == null) {
            this.descrPanel.setText("");
        } else {
            this.descrPanel.setText(secPerm.getDescription());
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int selected = -1;
        if (this.permissionsList.getSelectedIndex() == -1) {
            this.lastSelected = -1;
            this.clearFields();
            return;
        }
        if (!this.model.getData().isEmpty()) {
            this.checkPanel();
            this.clearFields();
            selected = this.permissionsList.getSelectedIndex();
            this.showPermission((ObjectValues)this.model.get(selected));
            this.removeButton.setEnabled(true);
        } else {
            this.clearFields();
        }
        this.lastSelected = selected;
    }

    private void checkPanel() {
        String spec = null;
        String descr = null;
        if (this.permissionsList.getSelectedIndex() == this.lastSelected) {
            return;
        }
        if (!this.specPanel.getText().trim().equals("")) {
            spec = this.specPanel.getText().trim();
        }
        if (!this.descrPanel.getText().trim().equals("")) {
            descr = this.descrPanel.getText().trim();
        }
        ObjectValues value = null;
        SecurityPermission perm = null;
        boolean changed = false;
        int answer = 1;
        if (spec == null) {
            return;
        }
        Iterator iter = ((AbstractList)this.model.getData()).iterator();
        while (iter.hasNext()) {
            value = (ObjectValues)iter.next();
            perm = value.getSecurityPermission().getSecurityPermission();
            if (!spec.equals(perm.getSecurityPermissionSpec())) continue;
            if (descr != null) {
                if (!descr.equals(perm.getDescription())) {
                    changed = true;
                    break;
                }
                this.addButton.setEnabled(false);
                int index = this.model.getData().indexOf(value);
                if (index != this.lastSelected) {
                    this.permissionsList.setSelectedIndex(index);
                    this.scrollToSelected(index);
                }
                return;
            }
            if (perm.getDescription() != null && !perm.getDescription().equals("")) {
                changed = true;
                break;
            }
            this.addButton.setEnabled(false);
            int index = this.model.getData().indexOf(value);
            if (index != this.lastSelected) {
                this.permissionsList.setSelectedIndex(index);
                this.scrollToSelected(index);
            }
            return;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Description of Security Permission <" + spec + "> was changed.\n Would you like to save the changes and modify this Security Permission?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyPermission(value, spec, descr);
            }
            this.clearFields();
            return;
        }
        answer = JOptionPane.showConfirmDialog(this.mainFrame, "Would you like to add this Security Permission?", "Warning", 0, 2);
        if (answer == 0) {
            this.addPermission(spec, descr);
        }
        this.clearFields();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        String spec = this.specPanel.getText().trim();
        String descr = this.descrPanel.getText().trim();
        if (cmd.equals("ADD_CMD")) {
            this.addPermission(spec, descr);
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyPermission((ObjectValues)this.permissionsList.getSelectedValue(), spec, descr);
        } else if (cmd.equals("REMOVE_CMD")) {
            int index = this.permissionsList.getSelectedIndex();
            this.removePermission((ObjectValues)this.permissionsList.getSelectedValue());
            int i = index;
            while (i < this.model.size()) {
                ((ObjectValues)this.model.get(i)).changeIndex(i + 1);
                ++i;
            }
        } else if (cmd.equals("CLEAR_CMD")) {
            this.lastSelected = -1;
            this.permissionsList.clearSelection();
            this.clearFields();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.processDocumentEvent(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.processDocumentEvent(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.processDocumentEvent(e);
    }

    private void processDocumentEvent(DocumentEvent e) {
        ObjectValues value;
        String spec = this.specPanel.getText().trim();
        String descr = this.descrPanel.getText().trim();
        if (!spec.equals("") || !descr.equals("")) {
            this.clearButton.setEnabled(true);
        } else {
            this.clearButton.setEnabled(false);
        }
        if (!spec.equals("")) {
            if (!this.permissionsList.isSelectionEmpty()) {
                value = (ObjectValues)this.permissionsList.getSelectedValue();
                if (spec.equals(value.getSecurityPermission().getSecurityPermission().getSecurityPermissionSpec())) {
                    this.addButton.setEnabled(false);
                } else {
                    this.addButton.setEnabled(true);
                }
            } else {
                this.addButton.setEnabled(true);
            }
        } else {
            this.addButton.setEnabled(false);
        }
        if (!this.permissionsList.isSelectionEmpty()) {
            value = (ObjectValues)this.permissionsList.getSelectedValue();
            if (!this.compareDescrs(value.getSecurityPermission().getSecurityPermission().getDescription(), descr)) {
                if (!this.addButton.isEnabled()) {
                    this.modifyButton.setEnabled(true);
                }
            } else {
                this.modifyButton.setEnabled(false);
            }
        } else {
            this.modifyButton.setEnabled(false);
        }
        if (!this.permissionsList.isSelectionEmpty()) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
    }

    private boolean compareDescrs(String currentDescr, String newDescr) {
        return !(currentDescr != null ? (newDescr != null ? !currentDescr.equals(newDescr) : !currentDescr.equals("")) : newDescr != null && !newDescr.equals(""));
    }

    public boolean isCorrect() {
        return true;
    }

    public void commitChange() {
        if (this.model.size() != 0) {
            this.secPermissions = new SecurityPermission[this.model.size()];
            int i = 0;
            while (i < this.model.size()) {
                this.secPermissions[i] = this.unwrapPermission(((ObjectValues)this.model.get(i)).getSecurityPermission());
                ++i;
            }
        } else {
            this.secPermissions = null;
        }
    }

    public void clear() {
        this.model.clear();
        this.secPermissions = null;
        this.clearFields();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("myFrame");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        SecurityPermissionsPanelLogical gp = new SecurityPermissionsPanelLogical(frame);
        frame.getContentPane().add((Component)gp, "Center");
        ((Component)frame).setSize(new Dimension(600, 500));
        ((Component)frame).setVisible(true);
    }
}

