/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0;

import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.jca.deploy.descriptor.CallerPrincipal;
import com.sap.engine.services.connector.jca.deploy.descriptor.IdentitySubject;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.ResourcePrincipal;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.ObjectValues;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.PrincipalMappingPanel;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.SortedListModel;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.UserGroupTreeNode;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.security.remote.RemoteUserStoreFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

public class PrincipalMappingPanelLogical
extends PrincipalMappingPanel {
    private JCDescriptor descr = null;
    private IdentitySubject[] identities = null;
    private int lastSelectedAuthType = -1;
    private int lastSelectedStore = -1;
    private int modified = 0;

    public void setFrame(Frame mainFrame) {
        this.mainFrame = mainFrame;
        this.defineUsersPanel.setFrame(mainFrame);
    }

    public void setUserStoreFactory(RemoteUserStoreFactory usf) {
        this.callersList.setUserStoreFactory(usf);
    }

    public void setDescriptor(JCDescriptor descr) throws RemoteException {
        this.descr = descr;
        if (descr == null) {
            this.identities = null;
            this.setIdentitySubjects(null);
            return;
        }
        this.setIdentitySubjects(descr.getIdentitySubjects());
        this.callersList.setJCDescriptor(descr);
        String authType = descr.getAuthenticationType();
        if (authType.equals("Caller Impersonation")) {
            this.authComboBox.setSelectedItem("Caller Impersonation");
        } else if (authType.equals("Credentials Mapping")) {
            this.authComboBox.setSelectedItem("Credentials Mapping");
        } else if (authType.equals("Configured Identity")) {
            this.authComboBox.setSelectedItem("Configured Identity");
        } else {
            this.authComboBox.setSelectedItem("Principal Mapping");
        }
        this.setUserStore();
    }

    public void setUserStore() {
        ComboBoxModel storeComboBoxModel = this.storeComboBox.getModel();
        if (storeComboBoxModel.getSelectedItem() != null) {
            return;
        }
        if (this.descr.getUserStore() != null) {
            String userStore = this.descr.getUserStore();
            int size = storeComboBoxModel.getSize();
            int i = 0;
            while (i < size) {
                if (((ObjectValues)storeComboBoxModel.getElementAt(i)).getName().equals(userStore)) {
                    storeComboBoxModel.setSelectedItem(storeComboBoxModel.getElementAt(i));
                    return;
                }
                ++i;
            }
            this.storeComboBox.addItem(new ObjectValues(this.descr.getUserStore(), 6));
        } else {
            this.storeComboBox.setSelectedIndex(0);
        }
    }

    public JCDescriptor getDescriptor() {
        return this.descr;
    }

    private void resetExistingIdentitySubjects() {
        try {
            this.setIdentitySubjects(this.identities);
        }
        catch (Exception exc) {
            ConnectorServiceFrame.logException(exc);
        }
        this.callersList.usersModel.setVisible(true);
        this.callerGroupStructure.usersModel.setVisible(true);
    }

    private void setIdentitySubjects(IdentitySubject[] subjects) {
        this.callerModel.clear();
        this.identitiesModel.clear();
        if (subjects == null) {
            this.identities = null;
            return;
        }
        this.identities = new IdentitySubject[subjects.length];
        int i = 0;
        while (i < subjects.length) {
            if (subjects[i] != null) {
                this.identities[i] = (IdentitySubject)subjects[i].clone();
                CallerPrincipal caller = this.identities[i].getCallerPrincipal();
                if (caller != null) {
                    if (caller.getGroups() != null) {
                        Iterator groupsIter = caller.getGroups().iterator();
                        while (groupsIter.hasNext()) {
                            String group = (String)groupsIter.next();
                            this.callerModel.addUnique(new ObjectValues(group, false, 5));
                        }
                    }
                    if (caller.getUserNames() != null) {
                        Iterator usersIter = caller.getUserNames().iterator();
                        while (usersIter.hasNext()) {
                            String user = (String)usersIter.next();
                            this.callerModel.addUnique(new ObjectValues(user, true, 5));
                        }
                    }
                }
                this.identitiesModel.addUnique(new ObjectValues(this.identities[i], 4));
            }
            ++i;
        }
    }

    public IdentitySubject[] getIdentitySubjects() {
        return this.identities;
    }

    public void valueChanged(ListSelectionEvent lse) {
        JList list = (JList)lse.getSource();
        if (list.equals(this.callerList)) {
            if (list.getSelectedIndex() == -1) {
                this.callerGroupStructure.clearAll();
                this.callersList.clearAll();
                this.identitiesList.clearSelection();
                return;
            }
            ObjectValues value = (ObjectValues)this.callerList.getSelectedValue();
            String caller = value.getCallerPrincipal();
            boolean isUser = value.isUser();
            ArrayList values = this.identitiesModel.getData();
            int i = 0;
            while (i < values.size()) {
                String[] users;
                ObjectValues identityValue = (ObjectValues)values.get(i);
                CallerPrincipal cprincipal = identityValue.getIdentitySubject().getCallerPrincipal();
                if (cprincipal != null && (cprincipal.getUserNames() != null || cprincipal.getGroups() != null) && (users = isUser ? ((AbstractCollection)cprincipal.getUserNames()).toArray(new String[cprincipal.getUserNames().size()]) : ((AbstractCollection)cprincipal.getGroups()).toArray(new String[cprincipal.getGroups().size()])) != null) {
                    int j = 0;
                    while (j < users.length) {
                        if (users[j].equals(caller)) {
                            int index = this.identitiesModel.getData().indexOf(identityValue);
                            if (this.identitiesList.getSelectedIndex() != index) {
                                this.identitiesList.setSelectedIndex(index);
                            } else {
                                Vector allTreePaths = this.callersList.setSelectionPath(caller, isUser);
                                TreePath selectionPath = this.callersList.users.getSelectionPath();
                                if (selectionPath == null || !selectionPath.getLastPathComponent().toString().equals(caller)) {
                                    selectionPath = (TreePath)((Vector)allTreePaths.elementAt(0)).elementAt(0);
                                }
                                this.callerGroupStructure.setUserDataSource(allTreePaths, selectionPath.getParentPath());
                                this.callersList.users.setSelectionPath(selectionPath);
                                this.callersList.users.scrollPathToVisible(selectionPath);
                            }
                            return;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else if (list.equals(this.identitiesList)) {
            if (list.getSelectedIndex() == -1) {
                this.clearFields();
                this.callerList.clearSelection();
                this.selectButton.setEnabled(false);
                this.deselectButton.setEnabled(false);
                this.removeRIButton.setEnabled(false);
                return;
            }
            if (this.authComboBox.getSelectedItem().toString().equals("Principal Mapping")) {
                this.setSelectButtonStatus();
            } else {
                this.selectButton.setEnabled(false);
                this.deselectButton.setEnabled(false);
            }
            this.removeRIButton.setEnabled(true);
            IdentitySubject subj = ((ObjectValues)list.getSelectedValue()).getIdentitySubject();
            ObjectValues selectedCallerValue = (ObjectValues)this.callerList.getSelectedValue();
            try {
                this.callersList.setUserDataSource(new IdentitySubject[]{subj});
            }
            catch (RemoteException re) {
                ConnectorServiceFrame.logException(re);
            }
            Vector allTreePaths = this.callersList.setSelectionPath(selectedCallerValue.getName(), selectedCallerValue.isUser());
            TreePath path = (TreePath)((Vector)allTreePaths.elementAt(0)).elementAt(0);
            this.callerGroupStructure.setUserDataSource(allTreePaths, path.getParentPath());
            this.callersList.users.setSelectionPath(path);
            this.callersList.users.scrollPathToVisible(path);
            ResourcePrincipal resPrincipal = subj.getResourcePrincipal();
            if (resPrincipal != null) {
                this.userTextField.setText(resPrincipal.getUserName());
                if (this.storeComboBox.getSelectedItem() == null) {
                    ((JTextComponent)this.passwordField).setText(resPrincipal.getPassword().trim());
                } else {
                    ((JTextComponent)this.passwordField).setText("");
                    this.checkPasswordFieldModified((ObjectValues)list.getSelectedValue());
                }
            }
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        JTree source = (JTree)e.getSource();
        TreePath path = source.getSelectionPath();
        if (source.equals(this.callerGroupStructure.users)) {
            if (path != null) {
                UserGroupTreeNode lastPathComponent = (UserGroupTreeNode)path.getLastPathComponent();
                if (lastPathComponent.isLeaf()) {
                    ObjectValues selectedValue = (ObjectValues)this.callerList.getSelectedValue();
                    if (selectedValue == null) {
                        return;
                    }
                    UserGroupTreeNode lastNode = (UserGroupTreeNode)this.callersList.groupNodes.get(path.getLastPathComponent().toString());
                    if (lastNode == null) {
                        lastNode = (UserGroupTreeNode)this.callersList.directGroups.get(path.getLastPathComponent().toString());
                    }
                    path = path.getParentPath().pathByAddingChild(lastNode);
                    path = path.pathByAddingChild(this.callersList.directGroups.get(selectedValue.getName()));
                    this.callersList.users.setSelectionPath(path);
                    this.callersList.users.scrollPathToVisible(path);
                } else {
                    this.callersList.users.clearSelection();
                }
            }
        } else if (source.equals(this.callersList.users)) {
            if (path != null) {
                this.deselectButton.setEnabled(true);
                UserGroupTreeNode lastPathComponent = (UserGroupTreeNode)path.getLastPathComponent();
                if (this.callersList.directGroups.containsValue(lastPathComponent)) {
                    Object[] values = this.callerModel.getData().toArray();
                    String caller = lastPathComponent.toString();
                    int i = 0;
                    while (i < values.length) {
                        if (((ObjectValues)values[i]).getName().equals(caller)) {
                            if (i != this.callerList.getSelectedIndex()) {
                                this.callerList.setSelectedValue(values[i], true);
                            } else {
                                this.callerGroupStructure.users.setSelectionPath(path.getParentPath().getParentPath().pathByAddingChild(this.callerGroupStructure.groupNodes.get(path.getLastPathComponent().toString())));
                            }
                            return;
                        }
                        ++i;
                    }
                } else {
                    this.callerGroupStructure.users.clearSelection();
                }
            } else {
                this.deselectButton.setEnabled(false);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() instanceof JComboBox) {
            JComboBox source = (JComboBox)e.getSource();
            String type = (String)this.authComboBox.getSelectedItem();
            if (source.equals(this.authComboBox)) {
                if (source.getSelectedIndex() == -1) {
                    source.setSelectedIndex(this.lastSelectedAuthType);
                    return;
                }
                this.lastSelectedAuthType = source.getSelectedIndex();
            } else {
                if (source.getSelectedIndex() == -1) {
                    source.setSelectedIndex(this.lastSelectedStore);
                    return;
                }
                this.lastSelectedStore = source.getSelectedIndex();
                this.modified = source.getSelectedItem().toString().equals(this.descr.getUserStore()) ? (this.modified &= 0x11110) : (this.modified |= 1);
                this.modified = this.descr.getUserStore() != null ? (this.modified |= 1) : (this.modified &= 0x11110);
            }
            this.checkButtonEnables(type);
            this.checkModifyRIButtonEnabled();
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.setSelectButtonStatus();
    }

    private void setSelectButtonStatus() {
        if (this.defineExistingTabbedPane.getSelectedIndex() == 0) {
            if (this.existingUsersPanel.users.getSelectionPath() != null) {
                this.selectButton.setEnabled(true);
            } else {
                this.selectButton.setEnabled(false);
            }
        } else {
            this.selectButton.setEnabled(true);
        }
    }

    private int checkPanel() {
        if (!this.authComboBox.getSelectedItem().toString().equals("Principal Mapping")) {
            return 0;
        }
        String userName = this.userTextField.getText();
        String password = String.valueOf(this.passwordField.getPassword()).trim();
        int i = 0;
        while (i < this.identitiesModel.size()) {
            IdentitySubject subj = ((ObjectValues)this.identitiesModel.getElementAt(i)).getIdentitySubject();
            if (subj.getResourcePrincipal().getUserName().equals(userName) && !subj.getResourcePrincipal().getPassword().equals(password)) {
                return -i - 1;
            }
            if (subj.getCallerPrincipal().getUserNames() == null || subj.getCallerPrincipal().getUserNames().isEmpty()) {
                if (i == this.identitiesList.getSelectedIndex()) {
                    return 0;
                }
                return i + 1;
            }
            ++i;
        }
        return 0;
    }

    private void checkButtonEnables(String type) {
        ObjectValues value = (ObjectValues)this.identitiesList.getSelectedValue();
        if (type.equals("Caller Impersonation")) {
            this.modified = 0;
            this.storeLabel.setEnabled(false);
            this.storeComboBox.setSelectedIndex(0);
            this.storeComboBox.setEnabled(false);
            this.userLabel.setEnabled(false);
            this.userTextField.setText("");
            this.userTextField.setEnabled(false);
            this.passwordLabel.setEnabled(false);
            ((JTextComponent)this.passwordField).setText("");
            this.passwordField.setEnabled(false);
            this.addRIButton.setEnabled(false);
            this.setEnabledCallerPrincipals(false);
        } else if (type.equals("Credentials Mapping")) {
            this.modified = 0;
            this.storeLabel.setEnabled(true);
            this.storeComboBox.setEnabled(true);
            this.userLabel.setEnabled(false);
            this.userTextField.setText("");
            this.userTextField.setEnabled(false);
            this.passwordLabel.setEnabled(false);
            ((JTextComponent)this.passwordField).setText("");
            this.passwordField.setEnabled(false);
            this.addRIButton.setEnabled(false);
            this.setEnabledCallerPrincipals(false);
        } else if (type.equals("Configured Identity")) {
            this.userLabel.setEnabled(true);
            this.userTextField.setEnabled(true);
            this.checkUserStoreStatus();
            this.checkUserFieldModified(value);
            this.checkAddRIButtonEnabled();
            this.setEnabledCallerPrincipals(false);
        } else if (type.equals("Principal Mapping")) {
            this.userLabel.setEnabled(true);
            this.userTextField.setEnabled(true);
            this.checkUserStoreStatus();
            this.checkUserFieldModified(value);
            this.checkAddRIButtonEnabled();
            this.setEnabledCallerPrincipals(true);
        }
        this.modified = !type.equals(this.descr.getAuthenticationType()) ? (this.modified |= 0x1000) : (this.modified &= 0x10111);
    }

    private void checkUserStoreStatus() {
        this.setUserStore();
        this.storeLabel.setEnabled(true);
        String store = null;
        if (this.storeComboBox.getModel().getSize() != 0) {
            this.storeComboBox.setEnabled(true);
            store = ((ObjectValues)this.storeComboBox.getSelectedItem()).getStoreName();
        } else {
            this.storeComboBox.setEnabled(false);
        }
        this.userLabel.setEnabled(true);
        this.userTextField.setEnabled(true);
        if (store == null) {
            this.passwordLabel.setEnabled(true);
            this.passwordField.setEnabled(true);
        } else {
            this.passwordLabel.setEnabled(false);
            ((JTextComponent)this.passwordField).setText("");
            this.passwordField.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("TAB_MODE")) {
            this.callerRIdentitySplitPane.remove(this.ridentityCallersSplitPane);
            this.ridentityCallersSplitPane.remove(this.ridentitiesPanel);
            this.ridentityCallersSplitPane.remove(this.callerPrincipalsPrincipalsPanel);
            this.ridentityCallersTabbedPane = new JTabbedPane();
            this.ridentityCallersTabbedPane.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.ridentityCallersTabbedPane.add((Component)this.ridentitiesPanel, "Resource Principals");
            this.ridentityCallersTabbedPane.add((Component)this.callerPrincipalsPrincipalsPanel, "Caller Principals");
            this.callerRIdentitySplitPane.setRightComponent(this.ridentityCallersTabbedPane);
            this.callerRIdentitySplitPane.setDividerLocation(140);
            this.doLayout();
            this.repaint();
        } else if (cmd.equals("SPLIT_MODE")) {
            this.callerRIdentitySplitPane.remove(this.ridentityCallersTabbedPane);
            this.ridentityCallersTabbedPane.remove(this.ridentitiesPanel);
            this.ridentityCallersTabbedPane.remove(this.callerPrincipalsPrincipalsPanel);
            this.ridentityCallersSplitPane = new JSplitPane();
            this.ridentityCallersSplitPane.setOrientation(0);
            this.ridentityCallersSplitPane.setTopComponent(this.ridentitiesPanel);
            this.ridentityCallersSplitPane.setBottomComponent(this.callerPrincipalsPrincipalsPanel);
            this.ridentityCallersSplitPane.setDividerLocation(this.ridentitiesPanel.getPreferredSize().height);
            this.callerRIdentitySplitPane.setRightComponent(this.ridentityCallersSplitPane);
            this.callerRIdentitySplitPane.setDividerLocation(140);
            this.doLayout();
            this.repaint();
        } else if (cmd.equals("ADD_CMD")) {
            String userName = this.userTextField.getText().trim();
            String password = String.valueOf(this.passwordField.getPassword()).trim();
            ResourcePrincipal resPrincipal = new ResourcePrincipal();
            resPrincipal.setUserName(userName);
            resPrincipal.setPassword(password);
            ObjectValues value = null;
            int i = 0;
            while (i < this.identitiesModel.size()) {
                value = (ObjectValues)this.identitiesModel.getElementAt(i);
                if (value.getIdentitySubject().getResourcePrincipal().getUserName().equals(userName)) break;
                value = null;
                ++i;
            }
            IdentitySubject subject = null;
            if (value != null) {
                if (!password.equals(value.getIdentitySubject().getResourcePrincipal().getPassword())) {
                    int answer = JOptionPane.showConfirmDialog(this.mainFrame, "Information for Identity Subject <" + value + "> was changed.\n Would you like to save the changes and modify this Identity Subject?", "Warning", 0, 2);
                    if (answer == 0) {
                        this.modifySubject(value, password);
                    }
                    this.identitiesList.setSelectedIndex(this.identitiesModel.getData().indexOf(value));
                    if (!EqualUtils.equalUnOrderedArrays(this.identities, this.descr.getIdentitySubjects())) {
                        this.fireElementModified(this, "IDENTITY_SUBJECTS_CHANGED_CMD");
                    }
                    return;
                }
            } else {
                subject = new IdentitySubject(resPrincipal, new CallerPrincipal());
            }
            value = new ObjectValues(subject, 4);
            this.identitiesModel.addUnique(value);
            this.identitiesList.setSelectedIndex(this.identitiesModel.getData().indexOf(value));
            IdentitySubject[] newData = new IdentitySubject[this.identities.length + 1];
            System.arraycopy(this.identities, 0, newData, 0, this.identities.length);
            newData[newData.length - 1] = subject;
            this.identities = newData;
            if (!EqualUtils.equalUnOrderedArrays(this.identities, this.descr.getIdentitySubjects())) {
                this.fireElementModified(this, "IDENTITY_SUBJECTS_CHANGED_CMD");
            }
        } else if (cmd.equals("REMOVE_CMD")) {
            ObjectValues value = (ObjectValues)this.identitiesList.getSelectedValue();
            int index = this.getNewIndex(this.identitiesModel, this.identitiesList);
            if (value != null) {
                IdentitySubject subject = value.getIdentitySubject();
                int i = 0;
                while (i < this.identities.length) {
                    if (this.identities[i] != null && subject.equals(this.identities[i])) {
                        HashSet users;
                        IdentitySubject[] newData = new IdentitySubject[this.identities.length - 1];
                        System.arraycopy(this.identities, 0, newData, 0, i);
                        System.arraycopy(this.identities, i + 1, newData, i, this.identities.length - i - 1);
                        this.identities = newData;
                        CallerPrincipal caller = subject.getCallerPrincipal();
                        if (caller == null || (users = caller.getUserNames()) == null) break;
                        String[] allUsers = ((AbstractCollection)users).toArray(new String[users.size() - 1]);
                        int j = 0;
                        while (j < allUsers.length) {
                            ++j;
                        }
                        break;
                    }
                    ++i;
                }
                if (index == this.identities.length) {
                    this.identitiesList.setSelectedIndex(index - 1);
                } else {
                    this.identitiesList.setSelectedIndex(index);
                }
                if (!EqualUtils.equalUnOrderedArrays(this.identities, this.descr.getIdentitySubjects())) {
                    this.fireElementModified(this, "IDENTITY_SUBJECTS_CHANGED_CMD");
                }
            }
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifySubject((ObjectValues)this.identitiesList.getSelectedValue(), String.valueOf(this.passwordField.getPassword()).trim());
        } else if (cmd.equals("SELECT_CMD")) {
            ObjectValues value = null;
            if (this.defineExistingTabbedPane.getSelectedComponent().equals(this.existingUsersPanel)) {
                UserGroupTreeNode existingUser = (UserGroupTreeNode)this.existingUsersPanel.users.getLastSelectedPathComponent();
                try {
                    this.callersList.addExistingNode(existingUser);
                }
                catch (RemoteException rexc) {
                    ConnectorServiceFrame.logException(rexc);
                }
                value = new ObjectValues(existingUser.toString(), existingUser.isUser(), 5);
            } else {
                value = new ObjectValues(this.defineUsersPanel.nameTextField.getText(), true, 5);
                if (this.callerModel.getData().indexOf(value) == -1 && this.callerModel.getData().indexOf(value) != -1) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Caller Principal with name '" + value + "' already exists for another subject.", "Error", 0);
                    return;
                }
            }
            this.callerModel.addUnique(value);
            CallerPrincipal caller = ((ObjectValues)this.identitiesList.getSelectedValue()).getIdentitySubject().getCallerPrincipal();
            caller.addUserName(value.getName());
            if (!EqualUtils.equalUnOrderedArrays(this.identities, this.descr.getIdentitySubjects())) {
                this.fireElementModified(this, "IDENTITY_SUBJECTS_CHANGED_CMD");
            }
        } else if (cmd.equals("DESELECT_CMD")) {
            ObjectValues value = (ObjectValues)this.callerList.getSelectedValue();
            CallerPrincipal caller = ((ObjectValues)this.identitiesList.getSelectedValue()).getIdentitySubject().getCallerPrincipal();
            if (value.isUser()) {
                caller.getUserNames().remove(value.getCallerPrincipal());
            } else {
                caller.getGroups().remove(value.getCallerPrincipal());
            }
            this.setSelectedIndex(this.callerModel, this.callerList);
            if (!EqualUtils.equalUnOrderedArrays(this.identities, this.descr.getIdentitySubjects())) {
                System.out.println("CHANGED AFTER DESELECT");
                this.fireElementModified(this, "IDENTITY_SUBJECTS_CHANGED_CMD");
            }
        } else {
            this.defineUsersPanel.clear();
        }
    }

    private void modifySubject(ObjectValues value, String password) {
        IdentitySubject currentSubject = value.getIdentitySubject();
        currentSubject.getResourcePrincipal().setPassword(password);
        this.modifyRIButton.setEnabled(false);
        this.modified &= 0x11011;
        if (!EqualUtils.equalUnOrderedArrays(this.identities, this.descr.getIdentitySubjects())) {
            this.fireElementModified(this, "IDENTITY_SUBJECTS_CHANGED_CMD");
        }
    }

    private void setSelectedIndex(SortedListModel model, JList list) {
        UserGroupTreeNode node = (UserGroupTreeNode)this.callersList.users.getLastSelectedPathComponent();
        this.removeNode(node, null);
        int index = model.getData().indexOf(list.getSelectedValue());
        int newIndex = this.getNewIndex(model, list);
        if (newIndex != -1) {
            list.setSelectedIndex(newIndex);
            this.scrollToSelected(list, newIndex);
        } else {
            list.clearSelection();
        }
        model.remove(index);
    }

    private void removeNode(UserGroupTreeNode destination, UserGroupTreeNode source) {
        if (destination == null) {
            return;
        }
        int index = destination.getChildCount();
        if (source != null) {
            this.callersList.usersModel.removeNodeFromParent(source);
            Vector clonedNodesForRemove = (Vector)this.callersList.clonedGroupNodes.get(source.toString());
            int i = 0;
            while (clonedNodesForRemove != null && i < clonedNodesForRemove.size()) {
                UserGroupTreeNode nodeForRemove = (UserGroupTreeNode)clonedNodesForRemove.elementAt(i);
                if (nodeForRemove != source) {
                    this.removeNode((UserGroupTreeNode)nodeForRemove.getParent(), nodeForRemove);
                }
                ++i;
            }
            if (index != 1 || destination.isDirect()) {
                return;
            }
        }
        this.removeNode((UserGroupTreeNode)destination.getParent(), destination);
    }

    public int getNewIndex(SortedListModel model, JList list) {
        int index = model.getData().indexOf(list.getSelectedValue());
        if (index - 1 >= 0) {
            return index - 1;
        }
        if (index >= model.size() - 1) {
            return -1;
        }
        return index + 1;
    }

    private void scrollToSelected(JList list, int selectedIndex) {
        Rectangle rec = list.getCellBounds(0, 0);
        rec.y = selectedIndex * rec.height;
        list.scrollRectToVisible(rec);
    }

    public void insertUpdate(DocumentEvent e) {
        this.processDocumentEvent(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.processDocumentEvent(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.processDocumentEvent(e);
    }

    private void processDocumentEvent(DocumentEvent e) {
        Document document = e.getDocument();
        ObjectValues value = (ObjectValues)this.identitiesList.getSelectedValue();
        if (document.equals(this.defineUsersPanel.nameTextField.getDocument())) {
            if (value == null) {
                this.selectButton.setEnabled(false);
            } else {
                this.selectButton.setEnabled(true);
            }
        } else if (document.equals(this.userTextField.getDocument())) {
            this.checkUserFieldModified(value);
        } else if (document.equals(this.passwordField.getDocument())) {
            this.checkPasswordFieldModified(value);
        }
        this.checkAddRIButtonEnabled();
        this.checkModifyRIButtonEnabled();
    }

    private void checkAddRIButtonEnabled() {
        if ((this.modified & 0x10000) == 0) {
            this.addRIButton.setEnabled(false);
        } else {
            this.addRIButton.setEnabled(true);
        }
    }

    private void checkModifyRIButtonEnabled() {
        if ((this.modified & 0x110) != 0 && (this.modified & 0x10000) == 0) {
            this.modifyRIButton.setEnabled(true);
        } else {
            this.modifyRIButton.setEnabled(false);
        }
    }

    private void checkUserFieldModified(ObjectValues value) {
        this.modified = value != null ? (this.userTextField.getText().trim().equals(value.getName()) ? (this.modified &= 0x1111) : (this.modified |= 0x10000)) : (this.modified |= 0x10000);
    }

    private void checkPasswordFieldModified(ObjectValues value) {
        if (value != null) {
            ResourcePrincipal resPrincipal = value.getIdentitySubject().getResourcePrincipal();
            this.modified = String.valueOf(this.passwordField.getPassword()).trim().equals(resPrincipal.getPassword()) ? (this.modified &= 0x11011) : (this.modified |= 0x100);
        } else {
            this.modified |= 0x100;
        }
    }

    private void clearFields() {
        this.userTextField.setText("");
        ((JTextComponent)this.passwordField).setText("");
    }

    public boolean isCorrect() {
        return true;
    }

    public void commitChange() {
    }

    public void setEnabledCallerPrincipals(boolean enable) {
        this.callersList.setEnabled(enable);
        if (!enable) {
            this.selectButton.setEnabled(enable);
            this.deselectButton.setEnabled(enable);
        }
        this.callerList.setEnabled(enable);
        this.callersList.setEnabled(enable);
        this.callerGroupStructure.setEnabled(enable);
        this.defineExistingTabbedPane.setEnabled(enable);
        this.existingUsersPanel.setEnabled(enable);
        this.defineUsersPanel.setEnabled(enable);
        this.identitiesList.setEnabled(enable);
        if (enable) {
            try {
                this.resetExistingIdentitySubjects();
            }
            catch (Exception e) {
                ConnectorServiceFrame.logException(e);
            }
        } else {
            this.callerModel.clear();
            this.callersList.clearAll();
            this.callerGroupStructure.clearAll();
            this.identitiesModel.clear();
            this.defineUsersPanel.clear();
            this.existingUsersPanel.clear();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("TestFrame");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        IdentitySubject subj = new IdentitySubject();
        IdentitySubject subj1 = new IdentitySubject();
        subj.setResourcePrincipal(new ResourcePrincipal("Peter", "Master"));
        subj1.setResourcePrincipal(new ResourcePrincipal("Matov", "Master"));
        CallerPrincipal caller = new CallerPrincipal();
        CallerPrincipal caller1 = new CallerPrincipal();
        caller.addUserName("Admin");
        caller1.addUserName("Test");
        caller.addUserName("Guest");
        caller1.addUserName("Proba");
        subj.setCallerPrincipal(caller);
        subj1.setCallerPrincipal(caller1);
        IdentitySubject[] subjects = new IdentitySubject[]{subj, subj1};
        JCDescriptor descriptor = new JCDescriptor();
        descriptor.setIdentitySubjects(subjects);
        descriptor.setAuthenticationType("Configured Identity");
        descriptor.setUserStore("proba");
        try {
            PrincipalMappingPanelLogical panel = new PrincipalMappingPanelLogical();
            panel.setFrame(frame);
            panel.setDescriptor(descriptor);
            frame.getContentPane().add((Component)panel, "Center");
            ((Component)frame).setSize(800, 600);
            ((Component)frame).setVisible(true);
        }
        catch (Exception exc) {
            ConnectorServiceFrame.logException(exc);
        }
    }
}

