/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0;

import com.sap.engine.services.connector.jca.deploy.descriptor.AuthMechanism;
import com.sap.engine.services.connector.jca.deploy.descriptor.ConfigProperty;
import com.sap.engine.services.connector.jca.deploy.descriptor.IdentitySubject;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.SecurityPermissionWrapper;

public class ObjectValues
implements Comparable {
    public static final byte JC_DESCRIPTOR = 0;
    public static final byte SEC_PERMISSION = 1;
    public static final byte AUTH_MECHANISM = 2;
    public static final byte CONFIG_PROPERTY = 3;
    public static final byte IDENTITY_SUBJECT = 4;
    public static final byte CALLER_PRINCIPAL = 5;
    public static final byte USER_STORE = 6;
    private JCDescriptor descr = null;
    private SecurityPermissionWrapper secPerm = null;
    private AuthMechanism authMech = null;
    private ConfigProperty configProp = null;
    private IdentitySubject identSubject = null;
    private String caller = null;
    private boolean isUser = true;
    private String storeName = null;
    private String name = null;
    private byte type = (byte)-1;

    public ObjectValues(JCDescriptor descr, byte _type) {
        this.descr = descr;
        this.type = _type;
        this.name = descr != null ? (descr.getConnectorJNDIName() != null ? descr.getConnectorJNDIName() : (descr.getRarName() != null ? descr.getRarName() : "Unknown Connector")) : "Unknown Connector";
    }

    public ObjectValues(SecurityPermissionWrapper permission, byte _type) {
        this.secPerm = permission;
        this.type = _type;
        this.name = this.secPerm != null && this.secPerm.getName() != null ? this.secPerm.getName() : "Unknown Security Permission";
    }

    public ObjectValues(AuthMechanism auth, byte _type) {
        this.authMech = auth;
        this.type = _type;
        this.name = this.authMech != null && this.authMech.getAuthMechType() != null ? this.authMech.getAuthMechType() : "Unknown Authentication Mechanism";
    }

    public ObjectValues(ConfigProperty prop, byte _type) {
        this.configProp = prop;
        this.type = _type;
        this.name = this.configProp != null && this.configProp.getConfigPropertyName() != null ? this.configProp.getConfigPropertyName() : "Unknown Config Property";
    }

    public ObjectValues(IdentitySubject ident, byte _type) {
        this.identSubject = ident;
        this.type = _type;
        this.name = this.identSubject != null && this.identSubject.getResourcePrincipal() != null && this.identSubject.getResourcePrincipal().getUserName() != null ? this.identSubject.getResourcePrincipal().getUserName() : "Unknown Identity Subject";
    }

    public ObjectValues(String caller, boolean isUser, byte _type) {
        this.caller = caller;
        this.type = _type;
        this.isUser = isUser;
        this.name = caller != null ? caller : "Unknown Caller Principal";
    }

    public ObjectValues(String storeName, byte _type) {
        this.type = _type;
        this.storeName = storeName;
        this.name = storeName == null ? "<empty>" : storeName;
    }

    public JCDescriptor getJCDescriptor() {
        return this.descr;
    }

    public SecurityPermissionWrapper getSecurityPermission() {
        return this.secPerm;
    }

    public AuthMechanism getAuthMechanism() {
        return this.authMech;
    }

    public ConfigProperty getConfigProperty() {
        return this.configProp;
    }

    public IdentitySubject getIdentitySubject() {
        return this.identSubject;
    }

    public String getCallerPrincipal() {
        return this.caller;
    }

    public boolean isUser() {
        return this.isUser;
    }

    public String getName() {
        return this.name;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setName(String _name) {
        this.name = _name;
    }

    public void changeIndex(int index) {
        if (index < 1 || this.name == null) {
            return;
        }
        if (this.type != 1) {
            return;
        }
        this.name = "permission_" + index;
        this.secPerm.changeIndex(index);
    }

    public byte getType() {
        return this.type;
    }

    public String toString() {
        if ("".equals(this.name)) {
            return "<empty>";
        }
        return this.name;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object value) {
        if (!(value instanceof ObjectValues)) {
            return false;
        }
        ObjectValues objectValues = (ObjectValues)value;
        if (this == objectValues) {
            return true;
        }
        if (objectValues == null) {
            return false;
        }
        if (this.type == 0) {
            if (this.descr != null) {
                return this.descr.equals(objectValues.getJCDescriptor());
            }
            if (objectValues.getJCDescriptor() != null) {
                return objectValues.getJCDescriptor().equals(this.descr);
            }
            return true;
        }
        if (this.type == 1) {
            if (this.secPerm != null) {
                return this.secPerm.equals(objectValues.getSecurityPermission());
            }
            if (objectValues.getSecurityPermission() != null) {
                return objectValues.getSecurityPermission().equals(this.secPerm);
            }
            return true;
        }
        if (this.type == 2) {
            if (this.authMech != null) {
                return this.authMech.equals(objectValues.getAuthMechanism());
            }
            if (objectValues.getAuthMechanism() != null) {
                return objectValues.getAuthMechanism().equals(this.authMech);
            }
            return true;
        }
        if (this.type == 3) {
            if (this.configProp != null) {
                return this.configProp.equals(objectValues.getConfigProperty());
            }
            if (objectValues.getConfigProperty() != null) {
                return objectValues.getConfigProperty().equals(this.configProp);
            }
            return true;
        }
        if (this.type == 4) {
            if (this.identSubject != null) {
                return this.identSubject.equals(objectValues.getIdentitySubject());
            }
            if (objectValues.getIdentitySubject() != null) {
                return objectValues.getIdentitySubject().equals(this.identSubject);
            }
            return true;
        }
        if (this.type == 5) {
            if (this.caller != null && objectValues.getCallerPrincipal() == null) {
                return false;
            }
            if (this.caller == null && objectValues.getCallerPrincipal() != null) {
                return false;
            }
            if (this.caller != null) {
                return this.caller.equals(objectValues.getCallerPrincipal());
            }
            return true;
        }
        if (this.type == 6) {
            if (this.storeName != null && objectValues.getStoreName() == null) {
                return false;
            }
            if (this.storeName == null && objectValues.getStoreName() != null) {
                return false;
            }
            if (this.storeName != null) {
                return this.storeName.equals(objectValues.getStoreName());
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object o) {
        ObjectValues value = (ObjectValues)o;
        if (this.secPerm != null) {
            return this.secPerm.getSecurityPermission().getSecurityPermissionSpec().compareTo(value.getSecurityPermission().getSecurityPermission().getSecurityPermissionSpec());
        }
        return this.getName().compareTo(value.getName());
    }
}

