/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0;

import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.ObjectValues;
import com.sap.engine.services.deploy.gui.common.ImageHolder;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class ListRenderer
extends JLabel
implements ListCellRenderer {
    private Icon securityPermission;
    private Icon authMechanism;
    private Icon configProperty;
    private Icon identitySubject;

    public ListRenderer() {
        this.setOpaque(true);
        this.initImages();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (!(value instanceof ObjectValues)) {
            return this;
        }
        ObjectValues info = (ObjectValues)value;
        switch (info.getType()) {
            case 1: {
                this.setIcon(this.securityPermission);
                break;
            }
            case 2: {
                this.setIcon(this.authMechanism);
                break;
            }
            case 3: {
                this.setIcon(this.configProperty);
                break;
            }
            case 4: {
                this.setIcon(this.identitySubject);
            }
        }
        this.setText(info.toString());
        this.setBackground(isSelected ? UIManager.getColor("List.selectionBackground") : UIManager.getColor("Tree.textBackground"));
        this.setForeground(isSelected ? UIManager.getColor("List.selectionForeground") : UIManager.getColor("Tree.textForeground"));
        return this;
    }

    private void initImages() {
        try {
            this.securityPermission = ImageHolder.aSecPermission;
            this.authMechanism = ImageHolder.anAuthMechanism;
            this.configProperty = ImageHolder.aConfigProp;
            this.identitySubject = ImageHolder.anIdentSubject;
        }
        catch (Exception exc) {
            ConnectorServiceFrame.logException(exc);
        }
    }
}

