/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0;

import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.GeneralPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class GeneralPanelLogical
extends GeneralPanel {
    private JCDescriptor descriptor = null;
    private Frame mainFrame = null;

    public GeneralPanelLogical() {
    }

    public GeneralPanelLogical(Frame mainFrame) {
        this.setFrame(mainFrame);
    }

    public GeneralPanelLogical(JCDescriptor descr) {
        this.setDescriptor(descr);
    }

    public GeneralPanelLogical(Frame mainFrame, JCDescriptor descr) {
        this.setFrame(mainFrame);
        this.setDescriptor(descr);
    }

    public void setFrame(Frame frame) {
        this.mainFrame = this.mainFrame;
    }

    public void setDescriptor(JCDescriptor descr) {
        this.descriptor = descr;
        this.clear();
        this.initFields();
    }

    public String[] getClasses() {
        return new String[]{this.cfImplTextField.getText().trim(), this.connectionImplTextField.getText().trim(), this.cfInterfaceTextField.getText().trim(), this.connectionTextField.getText().trim()};
    }

    public void initFields() {
        if (this.descriptor.getVendorName() != null) {
            this.vendorTextField.setText(this.descriptor.getVendorName());
        }
        if (this.descriptor.getSpecVersion() != null) {
            this.specTextField.setText(this.descriptor.getSpecVersion());
        }
        if (this.descriptor.getVersion() != null) {
            this.versionTextField.setText(this.descriptor.getVersion());
        }
        if (this.descriptor.getEisType() != null) {
            this.eisTextField.setText(this.descriptor.getEisType());
        }
        if (this.descriptor.getLicenseRequired()) {
            this.licenseCheckBox.setSelected(true);
        } else {
            this.licenseCheckBox.setSelected(false);
        }
        if (this.descriptor.getLicenseDescription() != null) {
            this.descrPanel.setText(this.descriptor.getLicenseDescription());
        }
        if (this.descriptor.getConnectionFactoryInterface() != null) {
            this.cfInterfaceTextField.setText(this.descriptor.getConnectionFactoryInterface());
        }
        if (this.descriptor.getConnectionFactoryImplClass() != null) {
            this.cfImplTextField.setText(this.descriptor.getConnectionFactoryImplClass());
        }
        if (this.descriptor.getConnectionInterface() != null) {
            this.connectionTextField.setText(this.descriptor.getConnectionInterface());
        }
        if (this.descriptor.getConnectionImplClass() != null) {
            this.connectionImplTextField.setText(this.descriptor.getConnectionImplClass());
        }
        if (this.descriptor.getTransactionSupport() != null && (this.descriptor.getTransactionSupport().equals("LocalTransaction") || this.descriptor.getTransactionSupport().equals("XATransaction"))) {
            this.transactionComboBox.setSelectedItem(this.descriptor.getTransactionSupport());
        } else {
            this.transactionComboBox.setSelectedItem("NoTransaction");
        }
    }

    public void commitChange() {
        if (!this.vendorTextField.getText().trim().equals("")) {
            this.descriptor.setVendorName(this.vendorTextField.getText());
        }
        if (!this.specTextField.getText().trim().equals("")) {
            this.descriptor.setSpecVersion(this.specTextField.getText());
        }
        if (!this.versionTextField.getText().trim().equals("")) {
            this.descriptor.setVersion(this.versionTextField.getText());
        }
        if (!this.eisTextField.getText().trim().equals("")) {
            this.descriptor.setEisType(this.eisTextField.getText());
        }
        if (this.licenseCheckBox.isSelected()) {
            this.descriptor.setLicenseRequired(true);
        } else {
            this.descriptor.setLicenseRequired(false);
        }
        if (!this.descrPanel.getText().trim().equals("")) {
            this.descriptor.setLicenseDescription(this.descrPanel.getText());
        }
        if (!this.cfInterfaceTextField.getText().trim().equals("")) {
            this.descriptor.setConnectionFactoryInterface(this.cfInterfaceTextField.getText());
        }
        if (!this.cfImplTextField.getText().trim().equals("")) {
            this.descriptor.setConnectionFactoryImplClass(this.cfImplTextField.getText());
        }
        if (!this.connectionTextField.getText().trim().equals("")) {
            this.descriptor.setConnectionInterface(this.connectionTextField.getText());
        }
        if (!this.connectionImplTextField.getText().trim().equals("")) {
            this.descriptor.setConnectionImplClass(this.connectionImplTextField.getText());
        }
        this.descriptor.setTransactionSupport((String)this.transactionComboBox.getSelectedItem());
    }

    public void clear() {
        this.vendorTextField.setText("");
        this.specTextField.setText("");
        this.eisTextField.setText("");
        this.versionTextField.setText("");
        this.cfInterfaceTextField.setText("");
        this.cfImplTextField.setText("");
        this.connectionTextField.setText("");
        this.connectionImplTextField.setText("");
        this.descrPanel.setText("");
        this.licenseCheckBox.setSelected(false);
        this.transactionComboBox.setSelectedIndex(-1);
    }

    public boolean isCorrect() {
        return true;
    }

    public static void main(String[] args) {
        Frame frame = new Frame("TestFrame");
        frame.setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        GeneralPanelLogical gp = new GeneralPanelLogical(frame);
        gp.setDescriptor(new JCDescriptor());
        frame.add((Component)gp, "Center");
        ((Component)frame).setSize(new Dimension(600, 500));
        ((Component)frame).setVisible(true);
        frame.show();
    }
}

