/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0;

import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.GuiSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentListener;

public class DefineUsersPanel
extends JPanel
implements ItemListener {
    protected JPanel radioPanel = new JPanel();
    protected ButtonGroup buttonGroup = new ButtonGroup();
    protected JRadioButton userRadio = new JRadioButton();
    protected JRadioButton groupRadio = new JRadioButton();
    protected JLabel nameLabel = new JLabel();
    protected JTextField nameTextField = new JTextField();
    protected TitledBorder titledBorder = null;
    private Frame mainFrame = null;

    public DefineUsersPanel() {
        this((Frame)null);
    }

    public DefineUsersPanel(Frame mainFrame) {
        this.mainFrame = mainFrame;
        try {
            this.init();
        }
        catch (Exception e) {
            ConnectorServiceFrame.logException(e);
        }
    }

    public void setFrame(Frame mainFrame) {
        this.mainFrame = mainFrame;
    }

    private void init() throws Exception {
        this.setLayout(new GridBagLayout());
        this.titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), GuiSettings.getResourceString("Define Users", "Define Users"));
        this.setBorder(this.titledBorder);
        this.radioPanel.setLayout(new GridBagLayout());
        this.radioPanel.setBorder(BorderFactory.createEtchedBorder());
        this.userRadio.setText(GuiSettings.getResourceString("User", "User"));
        this.groupRadio.setText(GuiSettings.getResourceString("Group", "Group"));
        this.userRadio.setSelected(true);
        this.buttonGroup.add(this.userRadio);
        this.buttonGroup.add(this.groupRadio);
        this.radioPanel.add((Component)this.userRadio, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.radioPanel.add((Component)this.groupRadio, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.nameLabel.setText(GuiSettings.getResourceString("Name", "Name") + ":");
        this.add((Component)new JPanel(), new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridBagLayout());
        centerPanel.add((Component)new JPanel(), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        centerPanel.add((Component)this.radioPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.7, 17, 1, new Insets(0, 5, 10, 5), 0, 0));
        centerPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 8, 5), 0, 0));
        centerPanel.add((Component)this.nameTextField, new GridBagConstraints(1, 2, 1, 1, 0.3, 0.4, 17, 2, new Insets(0, 5, 8, 5), 0, 0));
        centerPanel.add((Component)new JPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 8, 5), 0, 0));
        this.add((Component)centerPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.initListeners();
    }

    private void initListeners() {
        this.userRadio.addItemListener(this);
        this.groupRadio.addItemListener(this);
    }

    public void itemStateChanged(ItemEvent ie) {
        JRadioButton btn = (JRadioButton)ie.getSource();
        if (btn.equals(this.groupRadio) && btn.isSelected()) {
            JOptionPane.showMessageDialog(this.mainFrame, "Group mapping not supported yet.", "Warning", 2);
            this.userRadio.setSelected(true);
        }
    }

    public void addDocumentListener(DocumentListener listener) {
        this.nameTextField.getDocument().addDocumentListener(listener);
    }

    public String getName() {
        return this.nameTextField.getText();
    }

    public boolean isUser() {
        return this.userRadio.isSelected();
    }

    public void clear() {
        this.userRadio.setSelected(true);
        this.nameTextField.setText("");
    }

    public boolean isCorrect() {
        return true;
    }

    public void commitChange() {
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.radioPanel.setEnabled(enable);
        this.userRadio.setEnabled(enable);
        this.groupRadio.setEnabled(enable);
        this.nameLabel.setEnabled(enable);
        this.nameTextField.setEnabled(enable);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("TestFrame");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        DefineUsersPanel panel = new DefineUsersPanel(frame);
        frame.getContentPane().add((Component)panel, "Center");
        ((Component)frame).setSize(800, 600);
        ((Component)frame).setVisible(true);
    }
}

