/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0;

import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.jca.deploy.descriptor.ConfigProperty;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.ConfigPropertiesPanel;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.ObjectValues;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.Document;

public class ConfigPropertiesPanelLogical
extends ConfigPropertiesPanel {
    private ConfigProperty[] defaultProps = new ConfigProperty[]{new ConfigProperty("ServerName", "java.lang.String", null, null), new ConfigProperty("PortNumber", "java.lang.String", null, null), new ConfigProperty("UserName", "java.lang.String", null, null), new ConfigProperty("Password", "java.lang.String", null, null), new ConfigProperty("ConnectionURL", "java.lang.String", null, null)};
    private ConfigProperty[] props = null;
    private Frame mainFrame = null;
    static /* synthetic */ Class class$java$lang$String;

    public ConfigPropertiesPanelLogical() {
    }

    public ConfigPropertiesPanelLogical(Frame mainFrame) {
        this.setFrame(mainFrame);
    }

    public ConfigPropertiesPanelLogical(ConfigProperty[] props) {
        this.setConfigProperties(props);
    }

    public ConfigPropertiesPanelLogical(Frame mainFrame, ConfigProperty[] props) {
        this.setFrame(mainFrame);
        this.setConfigProperties(props);
    }

    public void setFrame(Frame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void setConfigProperties(ConfigProperty[] configProps) {
        this.props = configProps;
        this.clearFields();
        this.checkDefaultProperties();
        this.initList(configProps);
    }

    private void initList(ConfigProperty[] values) {
        this.model.clear();
        this.lastSelectedProps = -1;
        int i = 0;
        while (i < this.defaultProps.length) {
            this.model.add(new ObjectValues(this.defaultProps[i], 3));
            ++i;
        }
        String name = null;
        if (values != null) {
            int i2 = 0;
            while (i2 < values.length) {
                if (!(values[i2] == null || (name = values[i2].getConfigPropertyName()) == null || name.equals("") || name.equals("ServerName") || name.equals("PortNumber") || name.equals("UserName") || name.equals("Password") || name.equals("ConnectionURL"))) {
                    this.model.add(new ObjectValues(values[i2], 3));
                }
                ++i2;
            }
        }
    }

    private void addProp(String name, String type, String value, String descr) {
        if (name == null || name.equals("")) {
            return;
        }
        ObjectValues listValue = null;
        ConfigProperty prop = null;
        ConfigProperty temp = new ConfigProperty(name, type, value, descr);
        boolean changed = false;
        int answer = 1;
        Iterator en = ((AbstractList)this.model.getData()).iterator();
        while (en.hasNext()) {
            listValue = (ObjectValues)en.next();
            prop = listValue.getConfigProperty();
            if (!name.equals(prop.getConfigPropertyName())) continue;
            if (temp.equals(prop)) {
                int index = this.model.getData().indexOf(listValue);
                if (index != this.lastSelectedProps) {
                    this.propertiesList.setSelectedIndex(index);
                    this.scrollToSelected(index);
                    this.addButton.setEnabled(false);
                }
                return;
            }
            changed = true;
            break;
        }
        if (!this.checkTypeValueConformity(type, value)) {
            return;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Config Property <" + name + "> already exists.\n Would you like to save the changes and modify this Config Property?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyProp(listValue, type, value, descr);
                int index = this.model.getData().indexOf(listValue);
                this.propertiesList.setSelectedIndex(index);
                this.scrollToSelected(index);
            }
            return;
        }
        ObjectValues added = new ObjectValues(temp, 3);
        this.model.add(added);
        int index = this.model.getData().indexOf(added);
        this.propertiesList.setSelectedIndex(index);
        this.scrollToSelected(index);
    }

    private void modifyProp(ObjectValues prop, String type, String value, String descr) {
        if (prop == null) {
            return;
        }
        if (!this.checkTypeValueConformity(type, value)) {
            return;
        }
        prop.getConfigProperty().setConfigPropertyType(type);
        prop.getConfigProperty().setConfigPropertyValue(value);
        prop.getConfigProperty().setDescription(descr);
        this.modifyButton.setEnabled(false);
    }

    private void removeProp(ObjectValues prop) {
        if (prop == null) {
            return;
        }
        int index = this.model.getData().indexOf(prop);
        if (index - 1 >= 0) {
            this.lastSelectedProps = index - 1;
            this.propertiesList.setSelectedIndex(this.lastSelectedProps);
            this.scrollToSelected(this.lastSelectedProps);
        } else if (index >= this.model.size() - 1) {
            this.lastSelectedProps = -1;
            this.propertiesList.clearSelection();
            this.clearFields();
        } else {
            this.lastSelectedProps = index + 1;
            this.propertiesList.setSelectedIndex(this.lastSelectedProps);
            this.scrollToSelected(this.lastSelectedProps);
        }
        index = this.model.getData().indexOf(prop);
        this.model.remove(index);
    }

    private void scrollToSelected(int selectedIndex) {
        Rectangle rec = this.propertiesList.getCellBounds(0, 0);
        rec.y = selectedIndex * rec.height;
        this.propertiesList.scrollRectToVisible(rec);
    }

    private void checkDefaultProperties() {
        if (this.props == null || this.props.length == 0) {
            return;
        }
        ConfigProperty prop = null;
        String name = null;
        int i = 0;
        while (i < this.props.length) {
            prop = this.props[i];
            if (prop != null && (name = prop.getConfigPropertyName()) != null && !name.equals("")) {
                if (name.equals("ServerName")) {
                    this.defaultProps[0] = prop;
                } else if (name.equals("PortNumber")) {
                    this.defaultProps[1] = prop;
                } else if (name.equals("UserName")) {
                    this.defaultProps[2] = prop;
                } else if (name.equals("Password")) {
                    this.defaultProps[3] = prop;
                } else if (name.equals("ConnectionURL")) {
                    this.defaultProps[4] = prop;
                }
                if (this.props.length == 1) {
                    this.props = null;
                    return;
                }
                ConfigProperty[] data = new ConfigProperty[this.props.length - 1];
                System.arraycopy(this.props, 0, data, 0, i);
                System.arraycopy(this.props, i + 1, data, 0, this.props.length - i);
            }
            ++i;
        }
    }

    private void showProp(ObjectValues prop) {
        if (prop == null || prop.getConfigProperty() == null || prop.getConfigProperty().getConfigPropertyName() == null || prop.getConfigProperty().getConfigPropertyName().equals("")) {
            return;
        }
        ConfigProperty configProp = prop.getConfigProperty();
        this.nameTextField.setText(configProp.getConfigPropertyName());
        this.typeComboBox.setSelectedItem(configProp.getConfigPropertyType());
        if (configProp.getConfigPropertyValue() == null) {
            this.valueTextField.setText("");
        } else {
            this.valueTextField.setText(configProp.getConfigPropertyValue());
        }
        if (configProp.getDescription() == null) {
            this.descrPanel.setText("");
        } else {
            this.descrPanel.setText(configProp.getDescription());
        }
        this.nameTextField.requestFocus();
    }

    public void valueChanged(ListSelectionEvent e) {
        int selected = -1;
        if (this.propertiesList.getSelectedIndex() == -1) {
            this.lastSelectedProps = -1;
            this.clearFields();
            return;
        }
        if (!this.model.getData().isEmpty()) {
            this.checkPanel();
            this.clearFields();
            if (!this.propertiesList.isSelectionEmpty()) {
                selected = this.propertiesList.getSelectedIndex();
                this.showProp((ObjectValues)this.model.get(selected));
            }
            this.removeButton.setEnabled(true);
        } else {
            this.clearFields();
        }
        this.modifyButton.setEnabled(false);
        this.lastSelectedProps = selected;
    }

    private void checkPanel() {
        String name = null;
        String type = null;
        String value = null;
        String descr = null;
        if (this.propertiesList.getSelectedIndex() == this.lastSelectedProps) {
            return;
        }
        if (!this.nameTextField.getText().trim().equals("")) {
            name = this.nameTextField.getText().trim();
        }
        if (!((String)this.typeComboBox.getSelectedItem()).trim().equals("")) {
            type = ((String)this.typeComboBox.getSelectedItem()).trim();
        }
        if (!this.valueTextField.getText().trim().equals("")) {
            value = this.valueTextField.getText().trim();
        }
        if (!this.descrPanel.getText().trim().equals("")) {
            descr = this.descrPanel.getText().trim();
        }
        if (name == null || type == null) {
            return;
        }
        if (!this.checkTypeValueConformity(type, value)) {
            return;
        }
        ObjectValues listValue = null;
        ConfigProperty prop = null;
        ConfigProperty temp = new ConfigProperty(name, type, value, descr);
        boolean changed = false;
        int answer = 1;
        Iterator en = ((AbstractList)this.model.getData()).iterator();
        while (en.hasNext()) {
            listValue = (ObjectValues)en.next();
            prop = listValue.getConfigProperty();
            if (!name.equals(prop.getConfigPropertyName())) continue;
            if (temp.equals(prop)) {
                int index = this.model.getData().indexOf(listValue);
                if (index != this.lastSelectedProps) {
                    this.propertiesList.setSelectedIndex(index);
                    this.addButton.setEnabled(false);
                }
                return;
            }
            changed = true;
            break;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Information for Config Property <" + name + "> was changed.\n Would you like to save the changes and modify this Config Property?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyProp(listValue, type, value, descr);
            }
            return;
        }
        answer = JOptionPane.showConfirmDialog(this.mainFrame, "Would you like to add this Config Property?", "Warning", 0, 2);
        if (answer == 0) {
            this.addProp(name, type, value, descr);
        }
    }

    public void itemStateChanged(ItemEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String name = null;
        String type = null;
        String value = null;
        String descr = null;
        String cmd = e.getActionCommand();
        if (cmd.equals("comboBoxChanged")) {
            if (this.typeComboBox.getSelectedIndex() == -1) {
                this.typeComboBox.setSelectedIndex(this.lastSelectedType);
                return;
            }
            this.lastSelectedType = this.typeComboBox.getSelectedIndex();
        }
        if (!this.nameTextField.getText().trim().equals("")) {
            name = this.nameTextField.getText().trim();
        }
        if (!((String)this.typeComboBox.getSelectedItem()).trim().equals("")) {
            type = ((String)this.typeComboBox.getSelectedItem()).trim();
        }
        if (!this.valueTextField.getText().trim().equals("")) {
            value = this.valueTextField.getText().trim();
        }
        if (!this.descrPanel.getText().trim().equals("")) {
            descr = this.descrPanel.getText().trim();
        }
        if (!this.checkTypeValueConformity(type, value)) {
            this.typeComboBox.setSelectedIndex(this.lastSelectedProps);
            return;
        }
        if (cmd.equals("ADD_CMD")) {
            this.addProp(name, type, value, descr);
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyProp((ObjectValues)this.propertiesList.getSelectedValue(), type, value, descr);
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeProp((ObjectValues)this.propertiesList.getSelectedValue());
        } else if (cmd.equals("CLEAR_CMD")) {
            this.propertiesList.clearSelection();
            this.clearFields();
        } else if (cmd.equals(this.typeComboBox.getActionCommand())) {
            if (this.propertiesList.getSelectedIndex() == -1) {
                return;
            }
            String currentName = ((ObjectValues)this.propertiesList.getSelectedValue()).getConfigProperty().getConfigPropertyName();
            if (!currentName.equals("") && !currentName.equals(name)) {
                this.modifyButton.setEnabled(true);
            } else {
                this.modifyButton.setEnabled(false);
            }
        }
    }

    private boolean checkTypeValueConformity(String type, String value) {
        if (type == null || type.equals("")) {
            return false;
        }
        if (value == null || value.equals("")) {
            return true;
        }
        Constructor<?> constructor = null;
        Class<?> clazz = null;
        Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ConfigPropertiesPanelLogical.class$("java.lang.String")) : class$java$lang$String};
        try {
            clazz = Class.forName(type);
            constructor = clazz.getDeclaredConstructor(params);
            constructor.newInstance(value);
            if (type.equals("java.lang.Boolean") && !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                JOptionPane.showMessageDialog(this.mainFrame, "Value for this Config Property does not conform to its type. Please, specify another value.", "Warning", 2);
                return false;
            }
        }
        catch (Exception ex) {
            try {
                if (!type.equals("java.lang.Character") || value.length() != 1) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Value for this Config Property does not conform to its type. Please, specify another value.", "Warning", 2);
                    return false;
                }
                new Character(value.charAt(0));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.mainFrame, "Value for this Config Property does not conform to its type. Please, specify another value.", "Warning", 2);
                return false;
            }
        }
        return true;
    }

    public void insertUpdate(DocumentEvent e) {
        this.processDocumentEvent(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.processDocumentEvent(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.processDocumentEvent(e);
    }

    private void processDocumentEvent(DocumentEvent e) {
        ConfigProperty configProp;
        String name = this.nameTextField.getText().trim();
        String type = ((String)this.typeComboBox.getSelectedItem()).trim();
        String value = this.valueTextField.getText().trim();
        String descr = this.descrPanel.getText().trim();
        String currentName = null;
        try {
            currentName = ((ObjectValues)this.propertiesList.getSelectedValue()).getConfigProperty().getConfigPropertyName();
        }
        catch (NullPointerException nexc) {
            ConnectorServiceFrame.logException(nexc);
        }
        Document doc = e.getDocument();
        if (doc.equals(this.valueTextField.getDocument()) || doc.equals(this.descrPanel.getDocument())) {
            if (this.propertiesList.getSelectedIndex() != -1 && name.equals(currentName)) {
                configProp = ((ObjectValues)this.propertiesList.getSelectedValue()).getConfigProperty();
                if (!value.equals(configProp.getConfigPropertyValue()) || !descr.equals(configProp.getDescription())) {
                    this.modifyButton.setEnabled(true);
                } else {
                    this.modifyButton.setEnabled(false);
                }
            } else {
                this.modifyButton.setEnabled(false);
            }
        }
        if (!name.equals("")) {
            if (this.propertiesList.getSelectedIndex() != -1) {
                configProp = ((ObjectValues)this.propertiesList.getSelectedValue()).getConfigProperty();
                if (!name.equals(configProp.getConfigPropertyName())) {
                    this.addButton.setEnabled(true);
                } else {
                    this.addButton.setEnabled(false);
                }
            } else {
                this.addButton.setEnabled(true);
            }
        } else {
            this.addButton.setEnabled(false);
        }
        if (name.equals("") && type.equals("java.lang.String") && value.equals("") && descr.equals("") && this.propertiesList.isSelectionEmpty()) {
            this.clearButton.setEnabled(false);
        } else {
            this.clearButton.setEnabled(true);
        }
    }

    public boolean isCorrect() {
        if (this.model.getData().isEmpty()) {
            return true;
        }
        ConfigProperty prop = null;
        String name = null;
        int i = 0;
        while (i < this.model.size()) {
            prop = ((ObjectValues)this.model.get(i)).getConfigProperty();
            name = prop.getConfigPropertyName();
            if (!(name == null || name.equals("") || name.equals("ServerName") || name.equals("PortNumber") || name.equals("UserName") || name.equals("Password") || name.equals("ConnectionURL") || prop.getConfigPropertyValue() != null)) {
                JOptionPane.showMessageDialog(this.mainFrame, "Value for Config Property < " + name + " > is not specified!", "Warning", 2);
                return true;
            }
            ++i;
        }
        return true;
    }

    public void commitChange() {
        Vector<ConfigProperty> temp = new Vector<ConfigProperty>();
        if (this.model.size() != 0) {
            int i = 0;
            while (i < this.model.size()) {
                if (((ObjectValues)this.model.get(i)).getConfigProperty().getConfigPropertyValue() != null && ((ObjectValues)this.model.get(i)).getConfigProperty() != null) {
                    temp.add(((ObjectValues)this.model.get(i)).getConfigProperty());
                }
                ++i;
            }
        }
        if (temp.size() != 0) {
            this.props = new ConfigProperty[temp.size()];
            temp.copyInto(this.props);
        } else {
            this.props = null;
        }
    }

    public void clear() {
        this.model.clear();
        this.props = null;
        this.clearFields();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("myFrame");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        ConfigPropertiesPanelLogical gp = new ConfigPropertiesPanelLogical(frame);
        frame.getContentPane().add((Component)gp, "Center");
        ((Component)frame).setSize(800, 600);
        ((Component)frame).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

