/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0;

import com.sap.engine.services.connector.jca.deploy.descriptor.AuthMechanism;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.AuthenticationPanel;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.ObjectValues;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.AbstractList;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class AuthenticationPanelLogical
extends AuthenticationPanel {
    private AuthMechanism[] auths = null;
    private boolean reauth = false;
    private int lastSelectedMech = -1;
    private int lastSelectedAuth = -1;
    private Frame mainFrame = null;

    public AuthenticationPanelLogical() {
    }

    public AuthenticationPanelLogical(Frame mainFrame) {
        this.setFrame(mainFrame);
    }

    public AuthenticationPanelLogical(AuthMechanism[] mech) {
        this.setAuthMechanisms(mech);
    }

    public AuthenticationPanelLogical(Frame mainFrame, AuthMechanism[] mech) {
        this.setFrame(mainFrame);
        this.setAuthMechanisms(mech);
    }

    public void setFrame(Frame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void setAuthMechanisms(AuthMechanism[] mech) {
        this.auths = mech;
        this.clearFields();
        this.initList(this.auths);
    }

    private void initList(AuthMechanism[] values) {
        this.model.clear();
        this.lastSelectedAuth = -1;
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                if (values[i] != null && values[i].getAuthMechType() != null && !values[i].getAuthMechType().equals("")) {
                    if (values[i].getAuthMechType().equals("BasicPassword")) {
                        values[i].setCredentialInterface("javax.resource.spi.security.PasswordCredential");
                    } else if (values[i].getAuthMechType().equals("Kerbv5")) {
                        values[i].setCredentialInterface("javax.resource.spi.security.GenericCredential");
                    }
                    this.model.add(new ObjectValues(values[i], 2));
                }
                ++i;
            }
        }
    }

    private boolean compareAuths(AuthMechanism auth1, AuthMechanism auth2) {
        if (auth1 == auth2) {
            return true;
        }
        if (!auth1.getAuthMechType().equals(auth2.getAuthMechType())) {
            return false;
        }
        if (!auth1.getCredentialInterface().equals(auth2.getCredentialInterface())) {
            return false;
        }
        return this.compareDescrs(auth1.getDescription(), auth2.getDescription());
    }

    private boolean compareDescrs(String currentDescr, String newDescr) {
        return !(currentDescr != null ? (newDescr != null ? !currentDescr.equals(newDescr) : !currentDescr.equals("")) : newDescr != null && !newDescr.equals(""));
    }

    private void addAuth(String type, String interf, String descr) {
        if (type == null || type.equals("")) {
            return;
        }
        ObjectValues value = null;
        AuthMechanism auth = null;
        AuthMechanism temp = new AuthMechanism(type, interf, descr);
        boolean changed = false;
        int answer = 1;
        Iterator iter = ((AbstractList)this.model.getData()).iterator();
        while (iter.hasNext()) {
            value = (ObjectValues)iter.next();
            auth = value.getAuthMechanism();
            if (!type.equals(auth.getAuthMechType())) continue;
            if (this.compareAuths(temp, auth)) {
                int index = this.model.getData().indexOf(value);
                if (index != this.lastSelectedMech) {
                    this.addButton.setEnabled(false);
                    this.authList.setSelectedIndex(index);
                    this.scrollToSelected(index);
                }
                return;
            }
            if (interf != null) {
                if (!interf.equals(auth.getCredentialInterface())) {
                    changed = true;
                }
            } else if (auth.getCredentialInterface() != null && !auth.getCredentialInterface().equals("")) {
                changed = true;
            }
            if (this.compareDescrs(auth.getDescription(), descr)) break;
            changed = true;
            break;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Authentication Mechanism <" + type + "> already exists.\n Would you like to save the changes and modify this Authentication Mechanism?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyAuth(value, interf, descr);
                int index = this.model.getData().indexOf(value);
                this.authList.setSelectedIndex(index);
                this.scrollToSelected(index);
            }
            return;
        }
        ObjectValues added = new ObjectValues(temp, 2);
        this.model.add(added);
        int index = this.model.getData().indexOf(added);
        this.authList.setSelectedIndex(index);
        this.scrollToSelected(index);
    }

    private void modifyAuth(ObjectValues auth, String interf, String descr) {
        if (auth == null) {
            return;
        }
        if (interf == null || interf.equals("")) {
            JOptionPane.showMessageDialog(this.mainFrame, "Can not modify Authentication Mechanism because Credential Interface is not specified.", "Warning", 2);
            return;
        }
        auth.getAuthMechanism().setCredentialInterface(interf);
        auth.getAuthMechanism().setDescription(descr);
        this.modifyButton.setEnabled(false);
    }

    private void removeAuth(ObjectValues auth) {
        if (auth == null) {
            return;
        }
        int index = this.model.getData().indexOf(auth);
        if (index - 1 >= 0) {
            this.lastSelectedMech = index - 1;
            this.authList.setSelectedIndex(this.lastSelectedMech);
            this.scrollToSelected(this.lastSelectedMech);
        } else if (index >= this.model.size() - 1) {
            this.lastSelectedMech = -1;
            this.authList.clearSelection();
            this.clearFields();
        } else {
            this.lastSelectedMech = index + 1;
            this.authList.setSelectedIndex(this.lastSelectedMech);
            this.scrollToSelected(this.lastSelectedMech);
        }
        this.model.remove(this.model.getData().indexOf(auth));
    }

    private void scrollToSelected(int selectedIndex) {
        Rectangle rec = this.authList.getCellBounds(0, 0);
        rec.y = selectedIndex * rec.height;
        this.authList.scrollRectToVisible(rec);
    }

    public void setReauthSupport(boolean reauthSupport) {
        this.reauth = reauthSupport;
        this.reauthCheckBox.setSelected(reauthSupport);
    }

    public boolean getReauthSupport() {
        return this.reauth;
    }

    private void showAuth(ObjectValues auth) {
        if (auth == null || auth.getAuthMechanism() == null || auth.getAuthMechanism().getAuthMechType() == null || auth.getAuthMechanism().getAuthMechType().equals("") || auth.getAuthMechanism().getCredentialInterface() == null || auth.getAuthMechanism().getCredentialInterface().equals("")) {
            return;
        }
        AuthMechanism authMech = auth.getAuthMechanism();
        this.typeComboBox.setSelectedItem(authMech.getAuthMechType());
        this.interfaceComboBox.setSelectedItem(authMech.getCredentialInterface());
        if (authMech.getDescription() == null) {
            this.descrPanel.setText("");
        } else {
            this.descrPanel.setText(authMech.getDescription());
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int selected = -1;
        if (this.authList.getSelectedIndex() == -1) {
            this.lastSelectedMech = -1;
            this.clearFields();
            return;
        }
        if (!this.model.getData().isEmpty()) {
            this.checkPanel();
            this.clearFields();
            selected = this.authList.getSelectedIndex();
            this.showAuth((ObjectValues)this.model.get(selected));
            this.removeButton.setEnabled(true);
        } else {
            this.clearFields();
        }
        this.lastSelectedMech = selected;
    }

    private void checkPanel() {
        int answer = 1;
        String type = null;
        String interf = null;
        String descr = null;
        if (this.authList.getSelectedIndex() == this.lastSelectedMech) {
            return;
        }
        if (!((String)this.typeComboBox.getSelectedItem()).trim().equals("")) {
            type = ((String)this.typeComboBox.getSelectedItem()).trim();
        }
        if (!((String)this.interfaceComboBox.getSelectedItem()).trim().equals("")) {
            interf = ((String)this.interfaceComboBox.getSelectedItem()).trim();
        }
        if (!this.descrPanel.getText().trim().equals("")) {
            descr = this.descrPanel.getText().trim();
        }
        if (type == null || interf == null) {
            return;
        }
        ObjectValues value = null;
        AuthMechanism auth = null;
        AuthMechanism temp = new AuthMechanism(type, interf, descr);
        boolean changed = false;
        Iterator iter = ((AbstractList)this.model.getData()).iterator();
        while (iter.hasNext()) {
            value = (ObjectValues)iter.next();
            auth = value.getAuthMechanism();
            if (!type.equals(auth.getAuthMechType())) continue;
            if (this.compareAuths(temp, auth)) {
                int index = this.model.getData().indexOf(value);
                if (index != this.lastSelectedMech) {
                    this.addButton.setEnabled(false);
                    this.authList.setSelectedIndex(index);
                    this.scrollToSelected(index);
                }
                return;
            }
            if (!interf.equals(auth.getCredentialInterface())) {
                changed = true;
            }
            if (this.compareDescrs(auth.getDescription(), descr)) break;
            changed = true;
            break;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Credential Interface or Description of Authentication Mechanism <" + type + "> was changed.\n Would you like to save the changes and modify this Authentication Mechanism?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyAuth(value, interf, descr);
                int index = this.model.getData().indexOf(value);
                this.authList.setSelectedIndex(index);
                this.scrollToSelected(index);
            }
            this.clearFields();
            return;
        }
        answer = JOptionPane.showConfirmDialog(this.mainFrame, "Would you like to add this Authentication Mechanism?", "Warning", 0, 2);
        if (answer == 0) {
            this.addAuth(type, interf, descr);
        }
        this.clearFields();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        String type = (String)this.typeComboBox.getSelectedItem();
        String interf = (String)this.interfaceComboBox.getSelectedItem();
        String descr = this.descrPanel.getText().trim();
        int typeIndex = this.typeComboBox.getSelectedIndex();
        int interfIndex = this.interfaceComboBox.getSelectedIndex();
        if (cmd.equals("comboBoxChanged")) {
            Object src = e.getSource();
            if (src.equals(this.typeComboBox)) {
                if (this.typeComboBox.getSelectedIndex() == -1) {
                    this.typeComboBox.setSelectedIndex(this.lastSelectedAuth);
                    return;
                }
                this.lastSelectedAuth = typeIndex;
                this.interfaceComboBox.setSelectedIndex(typeIndex);
                this.lastSelectedAuth = typeIndex;
            } else if (src.equals(this.interfaceComboBox)) {
                if (this.interfaceComboBox.getSelectedIndex() == -1) {
                    this.interfaceComboBox.setSelectedIndex(this.lastSelectedAuth);
                    return;
                }
                this.lastSelectedAuth = interfIndex;
                this.typeComboBox.setSelectedIndex(interfIndex);
                this.lastSelectedAuth = interfIndex;
            }
            type = (String)this.typeComboBox.getSelectedItem();
            interf = (String)this.interfaceComboBox.getSelectedItem();
            descr = this.descrPanel.getText().trim();
            typeIndex = this.typeComboBox.getSelectedIndex();
            interfIndex = this.interfaceComboBox.getSelectedIndex();
            if (this.authList.getSelectedIndex() != -1) {
                AuthMechanism auth = ((ObjectValues)this.authList.getSelectedValue()).getAuthMechanism();
                if (!type.equals("") && !type.equals(auth.getAuthMechType())) {
                    this.addButton.setEnabled(true);
                    this.modifyButton.setEnabled(false);
                } else {
                    this.addButton.setEnabled(false);
                    if (!this.compareDescrs(auth.getDescription(), descr)) {
                        this.modifyButton.setEnabled(true);
                    }
                }
            } else {
                this.modifyButton.setEnabled(false);
                if (type.equals("")) {
                    this.addButton.setEnabled(false);
                } else {
                    this.addButton.setEnabled(true);
                }
            }
            if ((type == null || type.equals("")) && (descr == null || descr.equals(""))) {
                this.clearButton.setEnabled(false);
            } else {
                this.clearButton.setEnabled(true);
            }
        } else if (cmd.equals("ADD_CMD")) {
            this.addAuth(type, interf, descr);
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyAuth((ObjectValues)this.authList.getSelectedValue(), interf, descr);
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeAuth((ObjectValues)this.authList.getSelectedValue());
        } else if (cmd.equals("CLEAR_CMD")) {
            this.authList.clearSelection();
            this.clearFields();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.processDocumentEvent(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.processDocumentEvent(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.processDocumentEvent(e);
    }

    private void processDocumentEvent(DocumentEvent de) {
        String descr = this.descrPanel.getText().trim();
        if (this.authList.getSelectedValue() != null && !this.typeComboBox.getSelectedItem().equals("")) {
            AuthMechanism auth = ((ObjectValues)this.authList.getSelectedValue()).getAuthMechanism();
            if (auth.getAuthMechType().equals(this.typeComboBox.getSelectedItem()) && !this.compareDescrs(auth.getDescription(), descr)) {
                this.modifyButton.setEnabled(true);
            } else {
                this.modifyButton.setEnabled(false);
            }
        } else {
            this.modifyButton.setEnabled(false);
        }
        if (!this.descrPanel.getText().trim().equals("") || !((String)this.typeComboBox.getSelectedItem()).equals("")) {
            this.clearButton.setEnabled(true);
        } else {
            this.clearButton.setEnabled(false);
        }
    }

    public boolean isCorrect() {
        return true;
    }

    public void commitChange() {
        this.auths = new AuthMechanism[this.model.size()];
        int i = 0;
        while (i < this.model.size()) {
            this.auths[i] = ((ObjectValues)this.model.get(i)).getAuthMechanism();
            ++i;
        }
        this.reauth = this.reauthCheckBox.isSelected();
    }

    public void clear() {
        this.model.clear();
        this.auths = null;
        this.setReauthSupport(false);
        this.clearFields();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("myFrame");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        AuthenticationPanelLogical gp = new AuthenticationPanelLogical(frame);
        frame.getContentPane().add((Component)gp, "Center");
        ((Component)frame).setSize(800, 600);
        ((Component)frame).setVisible(true);
    }
}

