/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.connector.jca.deploy.descriptor.SecurityPermission;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.ListValues;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.SecurityPermissionWrapper;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.SecurityPermissionsPanel;
import com.sap.engine.services.deploy.ear.common.MadeFromConstants;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class SecurityPermissionsPanelLogical
extends SecurityPermissionsPanel
implements MadeFromConstants {
    private SecurityPermission[] secPermissions = null;
    private int madeFrom = 0;
    private int lastSelected = -1;
    private ApplicationInformationProvider appProvider;

    public SecurityPermissionsPanelLogical(Frame mainFrame, int madeFromConstant) {
        this.setFrame(mainFrame);
        this.madeFrom = madeFromConstant;
        this.init(this.madeFrom);
    }

    private void initList(SecurityPermission[] values) {
        this.model.clear();
        this.lastSelected = -1;
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                this.model.addElement(new ListValues(this.wrapPermission(i + 1, values[i]), 0));
                ++i;
            }
        }
    }

    private SecurityPermissionWrapper wrapPermission(int index, SecurityPermission perm) {
        SecurityPermissionWrapper wrapped = null;
        if (perm != null && index > 0) {
            wrapped = new SecurityPermissionWrapper(index, perm);
        }
        return wrapped;
    }

    private SecurityPermission unwrapPermission(SecurityPermissionWrapper perm) {
        SecurityPermission unwrapped = null;
        if (perm != null) {
            unwrapped = perm.getSecurityPermission();
        }
        return unwrapped;
    }

    private void addPermission(String spec, String descr) {
        if (spec == null || spec.equals("")) {
            return;
        }
        ListValues value = null;
        SecurityPermission perm = null;
        boolean changed = false;
        int answer = 1;
        Enumeration en = this.model.elements();
        while (en.hasMoreElements()) {
            value = (ListValues)en.nextElement();
            perm = value.getSecurityPermission().getSecurityPermission();
            if (!spec.equals(perm.getSecurityPermissionSpec())) continue;
            if (descr != null) {
                if (!descr.equals(perm.getDescription())) {
                    changed = true;
                    break;
                }
                this.permissionsList.clearSelection();
                return;
            }
            if (perm.getDescription() != null && !perm.getDescription().equals("")) {
                changed = true;
                break;
            }
            return;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Security Permission <" + spec + "> already exists.\n Would you like to save the changes and modify this Security Permission?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyPermission(value, spec, descr);
            }
            this.clearFields();
            return;
        }
        SecurityPermissionWrapper wrap = new SecurityPermissionWrapper(this.model.size() + 1, new SecurityPermission(spec, descr));
        this.model.addElement(new ListValues(wrap, 0));
    }

    private void modifyPermission(ListValues perm, String spec, String descr) {
        if (perm == null) {
            return;
        }
        if (spec == null || spec.equals("")) {
            JOptionPane.showMessageDialog(this.mainFrame, "Can not modify Security Permission because Security Permission Specification is not specified.", "Warning", 2);
            return;
        }
        perm.getSecurityPermission().getSecurityPermission().setSecurityPermissionSpec(spec);
        perm.getSecurityPermission().getSecurityPermission().setDescription(descr);
    }

    private void removePermission(ListValues perm) {
        if (perm == null) {
            return;
        }
        this.permissionsList.clearSelection();
        this.clearFields();
        this.model.removeElement(perm);
    }

    public void setSecurityPermissions(SecurityPermission[] sPermissions) {
        this.secPermissions = sPermissions;
        this.clearFields();
        this.initList(this.secPermissions);
    }

    public SecurityPermission[] getSecurityPermissions() {
        return this.secPermissions;
    }

    private void showPermission(ListValues perm) {
        if (perm == null || perm.getSecurityPermission() == null || perm.getSecurityPermission().getSecurityPermission() == null || perm.getSecurityPermission().getSecurityPermission().getSecurityPermissionSpec() == null || perm.getSecurityPermission().getSecurityPermission().getSecurityPermissionSpec().equals("")) {
            return;
        }
        SecurityPermission secPerm = perm.getSecurityPermission().getSecurityPermission();
        this.specPanel.setText(secPerm.getSecurityPermissionSpec());
        if (secPerm.getDescription() == null) {
            this.descrPanel.setText("");
        } else {
            this.descrPanel.setText(secPerm.getDescription());
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int selected = -1;
        if (!this.model.isEmpty()) {
            this.checkPanel();
            this.clearFields();
            if (!this.permissionsList.isSelectionEmpty()) {
                selected = this.permissionsList.getSelectedIndex();
                this.showPermission((ListValues)this.model.get(selected));
                if (this.madeFrom == 1 || this.madeFrom == 0) {
                    this.addButton.setEnabled(true);
                    this.modifyButton.setEnabled(true);
                    this.removeButton.setEnabled(true);
                }
            }
            this.lastSelected = selected;
        }
        this.processDocumentEvent();
    }

    private void checkPanel() {
        String spec = null;
        String descr = null;
        if (!this.specPanel.getText().trim().equals("")) {
            spec = this.specPanel.getText().trim();
        }
        if (!this.descrPanel.getText().trim().equals("")) {
            descr = this.descrPanel.getText().trim();
        }
        ListValues value = null;
        SecurityPermission perm = null;
        boolean changed = false;
        int answer = 1;
        if (spec == null) {
            return;
        }
        Enumeration en = this.model.elements();
        while (en.hasMoreElements()) {
            value = (ListValues)en.nextElement();
            perm = value.getSecurityPermission().getSecurityPermission();
            if (!spec.equals(perm.getSecurityPermissionSpec())) continue;
            if (descr != null) {
                if (!descr.equals(perm.getDescription())) {
                    changed = true;
                    break;
                }
                return;
            }
            if (perm.getDescription() != null && !perm.getDescription().equals("")) {
                changed = true;
                break;
            }
            return;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Description of Security Permission <" + spec + "> was changed.\n Would you like to save the changes and modify this Security Permission?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyPermission(value, spec, descr);
            }
            this.clearFields();
            return;
        }
        answer = JOptionPane.showConfirmDialog(this.mainFrame, "Would you like to add this Security Permission?", "Warning", 0, 2);
        if (answer == 0) {
            this.addPermission(spec, descr);
        }
        this.clearFields();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        String spec = this.specPanel.getText().trim();
        String descr = this.descrPanel.getText().trim();
        if (cmd.equals("ADD_CMD")) {
            this.addPermission(spec, descr);
            this.clearFields();
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyPermission((ListValues)this.permissionsList.getSelectedValue(), spec, descr);
            this.permissionsList.clearSelection();
            this.clearFields();
        } else if (cmd.equals("REMOVE_CMD")) {
            int index = this.permissionsList.getSelectedIndex();
            this.removePermission((ListValues)this.permissionsList.getSelectedValue());
            int i = index;
            while (i < this.model.size()) {
                ((ListValues)this.model.get(i)).changeIndex(i + 1);
                ++i;
            }
            this.clearFields();
        } else if (cmd.equals("CLEAR_CMD")) {
            this.permissionsList.clearSelection();
            this.clearFields();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    public void removeUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    public void changedUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    private void processDocumentEvent() {
        String spec = this.specPanel.getText().trim();
        String descr = this.descrPanel.getText().trim();
        if (!(this.permissionsList.isSelectionEmpty() && spec.equals("") && descr.equals(""))) {
            this.clearButton.setEnabled(true);
        } else {
            this.clearButton.setEnabled(false);
        }
        if (this.madeFrom == 1 || this.madeFrom == 0) {
            if (!spec.equals("")) {
                boolean exist = false;
                SecurityPermission perm = null;
                ListValues value = null;
                Enumeration en = this.model.elements();
                while (en.hasMoreElements()) {
                    value = (ListValues)en.nextElement();
                    perm = value.getSecurityPermission().getSecurityPermission();
                    if (!spec.equals(perm.getSecurityPermissionSpec())) continue;
                    exist = true;
                }
                if (exist) {
                    this.addButton.setEnabled(false);
                    this.modifyButton.setEnabled(true);
                } else {
                    this.addButton.setEnabled(true);
                    this.modifyButton.setEnabled(false);
                }
            } else {
                this.addButton.setEnabled(false);
                this.modifyButton.setEnabled(false);
            }
            if (!this.permissionsList.isSelectionEmpty()) {
                this.removeButton.setEnabled(true);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
        if (this.madeFrom == 0 || this.madeFrom == 1) {
            this.specPanel.setEnabled(true);
            this.descrPanel.setEnabled(true);
        } else {
            this.specPanel.setEnabled(false);
            this.descrPanel.setEnabled(false);
        }
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
        if (this.model.size() != 0) {
            this.secPermissions = new SecurityPermission[this.model.size()];
            int i = 0;
            while (i < this.model.size()) {
                this.secPermissions[i] = this.unwrapPermission(((ListValues)this.model.get(i)).getSecurityPermission());
                ++i;
            }
        } else {
            this.secPermissions = null;
        }
    }

    public void clear() {
        this.model.clear();
        this.secPermissions = null;
        this.clearFields();
    }

    public void setLoader(ClassLoader loader) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }
}

