/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.connector.jca.deploy.descriptor.CallerPrincipal;
import com.sap.engine.services.connector.jca.deploy.descriptor.IdentitySubject;
import com.sap.engine.services.connector.jca.deploy.descriptor.ResourcePrincipal;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.PrincipalMappingPanel;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.ListValues;
import com.sap.engine.services.security.remote.RemoteGroupInfo;
import com.sap.engine.services.security.remote.RemoteSecurity;
import com.sap.engine.services.security.remote.RemoteUserStoreInfo;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.text.JTextComponent;

public class PrincipalMappingPanelLogical
extends PrincipalMappingPanel {
    private IdentitySubject identity = null;
    private int madeFrom = 0;
    private boolean enableAdd = false;
    private boolean enableClear = false;
    private ApplicationInformationProvider appProvider;
    private RemoteSecurity remoteSecurity = null;

    public PrincipalMappingPanelLogical() {
        this(null, null, 0);
    }

    public PrincipalMappingPanelLogical(Frame mainFrame, IdentitySubject ident, int madeFromConstant) {
        this.setFrame(mainFrame);
        this.madeFrom = madeFromConstant;
        this.init(this.madeFrom);
        this.setIdentitySubject(ident);
    }

    public void setIdentitySubject(IdentitySubject ident) {
        this.identity = ident;
        this.clearFields();
        if (ident == null || ident.getResourcePrincipal() == null || ident.getResourcePrincipal().getUserName() == null || ident.getResourcePrincipal().getUserName().equals("")) {
            return;
        }
        this.userTextField.setText(ident.getResourcePrincipal().getUserName());
        String password = ident.getResourcePrincipal().getPassword();
        if (password == null) {
            password = "";
        }
        ((JTextComponent)this.passwordField).setText(password);
        CallerPrincipal caller = ident.getCallerPrincipal();
        HashSet users = null;
        String user = null;
        ListValues listValue = null;
        if (caller != null) {
            Iterator iter;
            if (caller.getUserNames() == null && caller.getGroups() == null) {
                return;
            }
            users = caller.getGroups();
            if (users != null) {
                iter = users.iterator();
                while (iter.hasNext()) {
                    user = (String)iter.next();
                    if (user == null || user.equals("")) continue;
                    listValue = new ListValues(user, 4);
                    this.model.addElement(listValue);
                }
            }
            if ((users = caller.getUserNames()) != null) {
                iter = users.iterator();
                while (iter.hasNext()) {
                    user = (String)iter.next();
                    if (user == null || user.equals("")) continue;
                    listValue = new ListValues(user, 3);
                    this.model.addElement(listValue);
                }
            }
        }
    }

    public IdentitySubject getIdentitySubject() {
        return this.identity;
    }

    private void addPrincipal() {
        ListValues listValue = null;
        if (this.tabbedPane.getSelectedIndex() == 1) {
            int type;
            String name = this.definePanel.getName();
            int n = type = this.definePanel.isUser() ? 3 : 4;
            if (name != null) {
                int i = 0;
                while (i < this.model.size()) {
                    listValue = (ListValues)this.model.get(i);
                    if (listValue.getName().equals(name) && listValue.getType() == type) {
                        return;
                    }
                    ++i;
                }
                listValue = new ListValues(name, type);
                this.model.addElement(listValue);
                this.definePanel.clear();
            }
            return;
        }
        Object node = this.availablePanel.getSelectedUser();
        if (node == null) {
            return;
        }
        int type = -1;
        String name = "";
        try {
            if (node instanceof RemoteGroupInfo) {
                type = 4;
                name = ((RemoteGroupInfo)node).getName();
            } else {
                type = 3;
                name = ((RemoteUserStoreInfo)node).getName();
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
            return;
        }
        int i = 0;
        while (i < this.model.size()) {
            listValue = (ListValues)this.model.get(i);
            if (listValue.getName().equals(name) && listValue.getType() == type) {
                return;
            }
            ++i;
        }
        if (type == 4) {
            listValue = new ListValues(node.toString(), 4);
        } else if (type == 3) {
            listValue = new ListValues(node.toString(), 3);
        }
        this.model.addElement(listValue);
    }

    private void removePrincipal() {
        ListValues listValue = (ListValues)this.usersList.getSelectedValue();
        if (listValue == null) {
            return;
        }
        this.model.removeElement(listValue);
    }

    public void setContext(RemoteSecurity node) {
        this.remoteSecurity = node;
        if (node == null) {
            this.selectButton.setEnabled(false);
            this.tabbedPane.setEnabledAt(0, false);
            this.tabbedPane.setSelectedIndex(1);
        } else {
            this.definePanel.clear();
            this.tabbedPane.setEnabledAt(0, true);
            this.tabbedPane.setSelectedIndex(0);
            try {
                this.availablePanel.init(node);
                this.availablePanel.refresh(null);
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.availablePanel.getSelectedUser() != null && !this.userTextField.getText().equals("")) {
            this.selectButton.setEnabled(true);
        } else {
            this.selectButton.setEnabled(false);
        }
        if (!this.usersList.isSelectionEmpty() && !this.userTextField.getText().equals("")) {
            this.deselectButton.setEnabled(true);
        } else {
            this.deselectButton.setEnabled(false);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (this.availablePanel.getSelectedUser() != null && !this.userTextField.getText().equals("")) {
            this.selectButton.setEnabled(true);
        } else {
            this.selectButton.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("SELECT_CMD")) {
            this.addPrincipal();
        } else if (cmd.equals("DESELECT_CMD")) {
            this.removePrincipal();
            this.deselectButton.setEnabled(false);
        }
        this.enableAdd = !this.userTextField.getText().equals("");
        this.enableClear = !this.userTextField.getText().equals("") || !this.getText(this.passwordField).equals("") || !this.model.isEmpty();
        this.fireActionPerformed(e);
    }

    public void insertUpdate(DocumentEvent e) {
        this.processDocumentEvent();
        this.fireInsertUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.processDocumentEvent();
        this.fireRemoveUpdate(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.processDocumentEvent();
        this.fireChangedUpdate(e);
    }

    private void processDocumentEvent() {
        if (!this.userTextField.getText().equals("")) {
            if (!this.usersList.isSelectionEmpty()) {
                this.deselectButton.setEnabled(true);
            } else {
                this.deselectButton.setEnabled(false);
            }
            if (this.availablePanel.getSelectedUser() != null || this.definePanel.getName() != null && !this.definePanel.getName().equals("")) {
                this.selectButton.setEnabled(true);
            } else {
                this.selectButton.setEnabled(false);
            }
            this.enableAdd = true;
            this.enableClear = true;
        } else {
            this.selectButton.setEnabled(false);
            this.deselectButton.setEnabled(false);
            this.enableClear = !this.getText(this.passwordField).equals("") || !this.model.isEmpty();
            this.enableAdd = false;
        }
    }

    public boolean checkEnabling(String button) {
        if (button == null) {
            return false;
        }
        if (button.equals("ADD")) {
            return this.enableAdd;
        }
        if (button.equals("MODIFY")) {
            return this.enableAdd;
        }
        if (button.equals("CLEAR")) {
            return this.enableClear;
        }
        return false;
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
    }

    public void clear() {
        this.identity = null;
        this.clearFields();
    }

    public boolean isDefined() {
        return !this.userTextField.getText().equals("");
    }

    public int isCorrect() {
        if (this.userTextField.getText().equals("")) {
            JOptionPane.showMessageDialog(this.mainFrame, "User name is not specified for this Identity Subject.", "Warning", 2);
            return 2;
        }
        return 0;
    }

    public void commitChange() {
        String user = null;
        String password = null;
        CallerPrincipal caller = null;
        ListValues listValue = null;
        if (!this.userTextField.getText().equals("")) {
            user = this.userTextField.getText();
        }
        password = this.getText(this.passwordField);
        if (!this.model.isEmpty()) {
            caller = new CallerPrincipal();
            int i = 0;
            while (i < this.model.size()) {
                listValue = (ListValues)this.model.get(i);
                if (listValue.getType() == 4) {
                    caller.addGroup(listValue.getName());
                } else if (listValue.getType() == 3) {
                    caller.addUserName(listValue.getName());
                }
                ++i;
            }
        }
        if (user != null) {
            this.identity = new IdentitySubject();
            this.identity.setResourcePrincipal(new ResourcePrincipal(user, password));
            this.identity.setCallerPrincipal(caller);
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    private String getText(JPasswordField pwdField) {
        return String.valueOf(pwdField.getPassword()).trim();
    }
}

