/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui;

import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.ListValues;
import com.sap.engine.services.deploy.gui.common.ImageHolder;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class ListRenderer
extends JLabel
implements ListCellRenderer {
    public static final byte ALIAS = 1;
    public static final byte LOADER = 2;
    private byte type = 0;
    private Icon securityPermission;
    private Icon authMechanism;
    private Icon configProperty;
    private Icon identitySubject;
    private Icon alias;
    private Icon loader;

    public ListRenderer() {
        this.setOpaque(true);
        this.initImages();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (!(value instanceof ListValues) && !(value instanceof String)) {
            return this;
        }
        if (value instanceof String) {
            switch (this.type) {
                case 1: {
                    this.setIcon(this.alias);
                    break;
                }
                case 2: {
                    this.setIcon(this.loader);
                    break;
                }
                default: {
                    this.setIcon(this.alias);
                    break;
                }
            }
        } else {
            ListValues info = (ListValues)value;
            switch (info.getType()) {
                case 0: {
                    this.setIcon(this.securityPermission);
                    break;
                }
                case 1: {
                    this.setIcon(this.authMechanism);
                    break;
                }
                case 2: {
                    this.setIcon(this.configProperty);
                    break;
                }
                case 3: {
                    this.setIcon(this.identitySubject);
                }
            }
        }
        this.setText(value.toString());
        this.setBackground(isSelected ? UIManager.getColor("List.selectionBackground") : UIManager.getColor("Tree.textBackground"));
        this.setForeground(isSelected ? UIManager.getColor("List.selectionForeground") : UIManager.getColor("Tree.textForeground"));
        return this;
    }

    private void initImages() {
        try {
            this.securityPermission = ImageHolder.aSecPermission;
            this.authMechanism = ImageHolder.anAuthMechanism;
            this.configProperty = ImageHolder.aConfigProp;
            this.identitySubject = ImageHolder.anIdentSubject;
            this.alias = ImageHolder.anAlias;
            this.loader = ImageHolder.aLoader;
        }
        catch (Exception exc) {
            ConnectorServiceFrame.logException(exc);
        }
    }

    public void setType(byte _type) {
        this.type = _type;
    }
}

